/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * types.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/types.h,v 1.63 2006/01/19 05:57:06 mlink Exp $"
 */

#ifndef _NEXUS_INCLUDE_TYPES_H
#define _NEXUS_INCLUDE_TYPES_H


#ifdef NEXUS_ALIGN
#define NEXUS_SEGMENT_HEADER_SIZE \
    (sizeof(nexus_segment_t) \
     + ((NEXUS_ALIGN - (sizeof(nexus_segment_t) % NEXUS_ALIGN)) % NEXUS_ALIGN))
#else  /* NEXUS_ALIGN */
#define NEXUS_SEGMENT_HEADER_SIZE \
    sizeof(nexus_segment_t)
#endif /* NEXUS_ALIGN */


typedef struct _nexus_rdb_funcs_t nexus_rdb_funcs_t;

/* 
 * This is the function indirection table that gets loaded in
 * db_iface
 */
struct _nexus_rdb_funcs_t
{
    nexus_bool_t                (*init)(void);
    int                         (*new_params)(char *buf, int size);
    char *                      (*lookup)(char *node_name, char *key);
    void                        (*shutdown)(void);
};

typedef struct _nexus_rdb_hash_entry_t nexus_rdb_hash_entry_t;

/*
 * This is the hash table stuff for database/startup file lookup
 * values.
 */
struct _nexus_rdb_hash_entry_t
{
    char *				name;
    nexus_list_t *			attr;
    struct _nexus_rdb_hash_entry_t *	next;
};

/*
 * nexus_transform_funcs_t
 *
 * This is the function indirection table used by transform modules.
 */
typedef struct _nexus_transform_funcs_t
{
    int		(*transform_id)();
    void	(*init)(nexus_bool_t *modifies_data,
			unsigned long *transform_info_size,
			unsigned long *trailer_size);
    void	(*shutdown)(void);
    void	(*transformattr_init)(void *info,
				      nexus_transformattr_t **attr);
    void	(*transformattr_destroy)(nexus_transformattr_t *tattr);
    void	(*transformattr_get_info)(nexus_transformattr_t *attr,
					  void **info);
    void 	(*init_endpoint_state)(nexus_transformattr_t *attr,
				       nexus_transformstate_t **ep_state);
    void	(*destroy_endpoint_state)(nexus_transformstate_t *ep_state);
    void	(*update_endpoint_state)(nexus_transformstate_t *ep_state,
					 nexus_transformstate_t *sp_state);
    void	(*init_startpoint_state)(nexus_transformstate_t *ep_state,
					 nexus_transformstate_t **sp_state,
					 nexus_bool_t *copy_sp_locally,
					 nexus_bool_t *destroy_sp_locally);
    void 	(*copy_startpoint_state)(nexus_transformstate_t *sp_state,
				       nexus_transformstate_t **sp_state_copy);
    void	(*destroy_startpoint_state)(nexus_transformstate_t *sp_state);
    int		(*sizeof_state)(nexus_transformstate_t *s);
    void	(*put_state)(nexus_byte_t **buffer,
			     nexus_transformstate_t *state);
    void	(*get_state)(nexus_byte_t **buffer,
			     int format,
			     nexus_transformstate_t **state);
    int		(*transform)(nexus_transformstate_t *startpoint_state,
			     nexus_byte_t *storage_start,
			     unsigned long storage_size,
			     nexus_byte_t *data_start,
			     unsigned long *data_size,
			     nexus_bool_t must_alloc_new_buffer,
			     nexus_byte_t *transform_info_start,
			     nexus_byte_t **out_storage_start,
			     unsigned long *out_storage_size,
			     nexus_byte_t **out_data_start,
			     unsigned long *out_data_size);
    int		(*untransform)(nexus_transformstate_t *endpoint_state,
			       nexus_byte_t *data_start,
			       unsigned long *data_size,
			       nexus_byte_t *transform_info_start,
			       int format,
			       nexus_byte_t **destination_start,
			       unsigned long *destination_size);
    void        (*transformstate_get_info)(nexus_transformstate_t *state,
                                           void *info,
					   int flag);
} nexus_transform_funcs_t ;


/*
 * nexus_transform_table_t
 */
typedef struct _nexus_transform_table_t
{
    nexus_transform_funcs_t *		funcs;
    char *				name;
    nexus_bool_t			modifies_data;
    unsigned long			transform_info_size;
    unsigned long			trailer_size;
} nexus_transform_table_t;


#ifdef BUILD_RESOURCE

/*
 * Definitions of Overseer Functions
 */

typedef struct _nexus_overseer_funcs_t {
  void		(*init)(void);
  void		(*shutdown)(nexus_bool_t shutdown_others);
  int 		(*rusage)(nexus_rusage_obj*);
  void		(*flush)(void);
} nexus_overseer_funcs_t;


#endif /* BUILD_RESOURCE */


#endif /* _NEXUS_INCLUDE_TYPES_H */



