/*
 * gloo.c:
 *
 * Copyright (c) 2001 James McKenzie <james@fishsoup.dhs.org>,
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

static char rcsid[] =
    "$Id: gloo.c,v 1.6 2002/09/27 11:00:24 root Exp root $";

/*
 * $Log: gloo.c,v $
 * Revision 1.6  2002/09/27 11:00:24  root
 * #
 *
 * Revision 1.5  2002/09/27 10:58:34  root
 * #
 *
 * Revision 1.4  2002/09/27 10:51:16  root
 * *** empty log message ***
 *
 * Revision 1.3  2002/09/27 10:50:09  root
 * *** empty log message ***
 *
 * Revision 1.2  2001/10/25 16:53:47  root
 * *** empty log message ***
 *
 */

#include <signal.h>
#include <stdio.h>
#include <malloc.h>


static char **addarg(char **argv, char *val)
{
  char **cpp;


  if (argv == NULL) {
    /*
     * 10 entries, a leading length, and a null
     */
    argv = malloc(sizeof(*argv) * 22);
    bzero(argv, sizeof(*argv) * 22);
    if (argv == NULL)
      return NULL;
    *argv++ = (char *) 20;
    *argv = NULL;
  }

  for (cpp = argv; *cpp; cpp++);

/*
  if (cpp == &argv[(long) argv[-1]])
    {
      --argv;
      *argv = (char *) ((long) (argv[0]) + 10);
      argv = realloc (argv, (long) (argv[0]) + 2);
      if (argv == NULL)
        return NULL;
      argv++;
      cpp = &argv[(long) argv[-1] - 10];
    }
*/
  *cpp++ = val;
  *cpp = 0;
  return (argv);
}





void usage(char *name)
{
  fprintf(stderr, "Usage: %s prog1 [arg] .... -- prog2 [arg] ...\n", name);
  exit(1);
}

int s1[2], s2[2];
char **args1 = NULL;
char **args2 = NULL;
int pid1, pid2;


void launch_pid1(void)
{
  switch (pid1 = fork()) {
  case 0:
    dup2(s1[0], 0);
    dup2(s2[1], 1);
    execvp(args1[0], args1);
    perror("execvp");
    exit(1);
  case -1:
    perror("fork");
    exit(1);
  }

#if 0
  close(s1[0]);
  close(s2[1]);
#endif

  fprintf(stderr, "%s is pid %d\n", args1[0], pid1);
}


void launch_pid2(void)
{
  switch (pid2 = fork()) {
  case 0:
    dup2(s2[0], 0);
    dup2(s1[1], 1);
    execvp(args2[0], args2);
    perror("execvp");
    exit(1);
  case -1:
    perror("fork");
    exit(1);
  }

#if 0
  close(s2[0]);
  close(s1[1]);
#endif

  fprintf(stderr, "%s is pid %d\n", args2[0], pid2);
}


int main(int argc, char *argv[])
{
  int status;
  int pid;

  if (argc == 1)
    usage("gloo");

  argc--;
  argv++;



  while (argc) {
    if (!strcmp(*argv, "--"))
      break;

    args1 = addarg(args1, *argv);

    argc--;
    argv++;

  }

  if ((!argc) || (argc == 1))
    usage("gloo");

  argc--;
  argv++;

  while (argc) {
    if (!strcmp(*argv, "--"))
      break;

    args2 = addarg(args2, *argv);

    argc--;
    argv++;

  }

  pipe(s1);
  pipe(s2);

  launch_pid1();
  launch_pid2();

  while (1) {
    pid = wait(&status);
    if (pid == pid1) {
      pid1 = 0;
      fprintf(stderr, "%s exited\n", args1[0]);
      sleep(1);
      launch_pid1();
    } else if (pid == pid2) {
      pid2 = 0;
      fprintf(stderr, "%s exited\n", args2[0]);
      sleep(1);
      launch_pid2();
    } else {
      fprintf(stderr, "bad error\n");
      exit(1);
    }
  }

  if (pid1)
    kill(pid1, SIGTERM);
  if (pid2)
    kill(pid2, SIGTERM);
  exit(0);
}
