/*
 * Copyright (C) 2012-2014  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <QtGui>
#include <QIcon>

#include "conjuntpeces.h"
#include "constants.h"
#include "configuracio.h"
#include "funcions.h"
#include "comprovafigures.h"

ComprovaFigures::ComprovaFigures(Configuracio *configJoc, QWidget *parent)
        : QDialog(parent)
{

    configuracioJoc=configJoc;
    charPathSeparator=QDir().separator();

  //  setMinimumSize (QSize(1100,700));
    setMinimumSize (QSize(1100,750));
  //  setMinimumSize (QSize(1200,785));
    setMaximumSize(QSize(1100,750));


    labelFiguraPrograma= new QLabel("primer",this);
    labelFiguraPrograma->setGeometry(0,0,350,40);
   // labelFiguraPrograma->setGeometry(0,0,300,40);
    labelFiguraPrograma->move(QPoint(0,0));
    labelFiguraPrograma->setVisible(false);

    labelFiguresGenerades= new QLabel("segon",this);
    labelFiguresGenerades->setGeometry(0,0,300,40);
   // labelFiguresGenerades->setGeometry(0,0,350,40);
    labelFiguresGenerades->move(QPoint(850,0));
  //  labelFiguresGenerades->move(QPoint(900,0));
    labelFiguresGenerades->setVisible(false);


    //arbre de figures del programa
        arbreFiguresTreeWidget= new QTreeWidget(this);
        arbreFiguresTreeWidget->setGeometry(0,0,250,700);
       // arbreFiguresTreeWidget->setGeometry(0,0,300,730);
        arbreFiguresTreeWidget->move(QPoint(0,50));
        arbreFiguresTreeWidget->expandAll();
        connect(arbreFiguresTreeWidget,SIGNAL(itemSelectionChanged()),
                this,SLOT(seleccioFiguraJoc()));

   //arbre de figures noves
        arbreNovesFiguresTreeWidget= new QTreeWidget(this);
        arbreNovesFiguresTreeWidget->setGeometry(0,0,250,700);
        arbreNovesFiguresTreeWidget->move(QPoint(850,50));
      //  arbreNovesFiguresTreeWidget->setGeometry(0,0,300,730);
      //  arbreNovesFiguresTreeWidget->move(QPoint(900,50));
        arbreNovesFiguresTreeWidget->expandAll();
        connect(arbreNovesFiguresTreeWidget,SIGNAL(itemSelectionChanged()),
                this,SLOT(seleccioFiguraNova()));        
        connect(arbreNovesFiguresTreeWidget,SIGNAL(itemDoubleClicked ( QTreeWidgetItem *, int )),
                this,SLOT(seleccionFiguraItemDoubleClicked (QTreeWidgetItem * )));

   //frame dels botons
        botonsFrame=new QFrame(this);
        botonsFrame->setGeometry(0,0,600,850);
        botonsFrame->move(QPoint(250,0));
       // botonsFrame->move(QPoint(300,0));

        sceneFiguresPrograma=new QGraphicsScene(0, 0, 180, 180);
        viewFiguresPrograma = new QGraphicsView(sceneFiguresPrograma,botonsFrame);
        viewFiguresPrograma->move(QPoint(5,55));
        viewFiguresPrograma->setRenderHints(QPainter::Antialiasing
                                 | QPainter::TextAntialiasing);


        sceneFiguresNoves=new QGraphicsScene(0, 0, 180, 180);
        viewFiguresNoves = new QGraphicsView(sceneFiguresNoves,botonsFrame);
        viewFiguresNoves->move(QPoint(415,53));
        viewFiguresNoves->setRenderHints(QPainter::Antialiasing
                                 | QPainter::TextAntialiasing);

        sceneComparacio=new QGraphicsScene(0, 0, 590, 510);
       // sceneComparacio=new QGraphicsScene(0, 0, 590, 590);
        viewComparacio = new QGraphicsView(sceneComparacio,botonsFrame);
        viewComparacio->move(QPoint(5,235));;
       // viewComparacio->move(QPoint(5,188));
        viewComparacio->setRenderHints(QPainter::Antialiasing
                                 | QPainter::TextAntialiasing);

        //Cal situar els botons entre 190-400
        //i 0-140
        /*01/05/14 S'ha baixat tot 50 unitats per deixar més espai
        al missatge del temps aproximat */
        obreFiguresGenerades = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"obrecon.png"),"", botonsFrame);
        obreFiguresGenerades->setToolTip(configuracioJoc->tradueixCadena("figures.generades.ToolTip.Carrega"));
        connect(obreFiguresGenerades,SIGNAL(clicked()),this,SLOT(obreFiguresGeneradesSlot()));
        obreFiguresGenerades->setGeometry(0,0,40,40);
        obreFiguresGenerades->move(360,60);

        comparaFiguresPrograma = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"filefind.png"),"", botonsFrame);
        comparaFiguresPrograma->setToolTip(configuracioJoc->tradueixCadena("compara.figures.programa"));
        connect(comparaFiguresPrograma,SIGNAL(clicked()),this,SLOT(comparaFiguresProgramaSlot()));
        comparaFiguresPrograma->setGeometry(0,0,40,40);
        comparaFiguresPrograma->move(200,60);

        comparaFiguresGenerades = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"filefind.png"),"", botonsFrame);
        comparaFiguresGenerades->setToolTip(configuracioJoc->tradueixCadena("compara.figures.generades"));
        connect(comparaFiguresGenerades,SIGNAL(clicked()),this,SLOT(comparaFiguresGeneradesSlot()));
        comparaFiguresGenerades->setGeometry(0,0,40,40);
        comparaFiguresGenerades->move(320,60);



        figuraSeguentButton = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"edit-redo.png"),"", botonsFrame);
        figuraSeguentButton->setToolTip(configuracioJoc->tradueixCadena("seguent.figura"));
        connect(figuraSeguentButton,SIGNAL(clicked()),this,SLOT(figuraSeguentSlot()));
        figuraSeguentButton->setGeometry(0,0,40,40);
        figuraSeguentButton->move(360,147);
        figuraSeguentButton->setEnabled(false);




        figuraAnteriorButton = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"edit-undo.png"),"", botonsFrame);
        figuraAnteriorButton->setToolTip(configuracioJoc->tradueixCadena("anterior.figura"));
        connect(figuraAnteriorButton,SIGNAL(clicked()),this,SLOT(figuraAnteriorSlot()));
        figuraAnteriorButton->setGeometry(0,0,40,40);
        figuraAnteriorButton->move(320,147);
        figuraAnteriorButton->setEnabled(false);

        desaLlistaComparacio=new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"save.png"),"", botonsFrame);
        desaLlistaComparacio->setToolTip(configuracioJoc->tradueixCadena("desa.canvis.comprovacio"));
        connect(desaLlistaComparacio,SIGNAL(clicked()),this,SLOT(desaLlistaComparacioSlot()));
        desaLlistaComparacio->setGeometry(0,0,40,40);
        desaLlistaComparacio->move(QPoint(270,147));
        desaLlistaComparacio->setEnabled(false);

        figuresSemblantsList=new QStringList();
        indexLlistaFiguraSemblant=0;

        eliminaFigura = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"cross.png"),"", botonsFrame);
        eliminaFigura->setToolTip(configuracioJoc->tradueixCadena("marca.figura.eliminar"));
        connect(eliminaFigura,SIGNAL(clicked()),this,SLOT(eliminaFiguraSlot()));
        eliminaFigura->setGeometry(0,0,40,40);        
        eliminaFigura->move(320,105);

        canviaNumeracio = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"noms.png"),"", botonsFrame);
        canviaNumeracio->setToolTip(configuracioJoc->tradueixCadena("renomena.figures.generades"));
        connect(canviaNumeracio,SIGNAL(clicked()),this,SLOT(canviaNumeracioFiguresGeneradesSlot()));
        canviaNumeracio->setGeometry(0,0,40,40);
        canviaNumeracio->move(360,105);


        labelTemps= new QLabel("",botonsFrame);
        labelTemps->setGeometry(0,0,350,40);
        labelTemps->move(QPoint(200,0));
        labelTemps->setVisible(true);

        tanca = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"surt.png"),"", botonsFrame);
        tanca->setToolTip(configuracioJoc->tradueixCadena("Tanca"));
        connect(tanca,SIGNAL(clicked()),this,SLOT(close()));
        tanca->setGeometry(0,0,40,40);
        tanca->move(360,191);
        tanca->setDefault(true);

        desaCanvis = new QPushButton(
                QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"save.png"),"", botonsFrame);
        desaCanvis->setToolTip(configuracioJoc->tradueixCadena("desa.canvis.figures.generades"));
        connect(desaCanvis,SIGNAL(clicked()),this,SLOT(desaCanvisSlot()));
        desaCanvis->setGeometry(0,0,40,40);
        desaCanvis->move(320,191);


  tradueixGUI();

  //carregam els arbres
    //carregaArbreFigures( arbreFiguresTreeWidget,directoriLinux()+
      //                          charPathSeparator+"figures"+charPathSeparator+configuracioJoc->arxiuDadesFigures);
    carregaArbreFigures( arbreFiguresTreeWidget,configuracioJoc->directoriArxiuDadesFigures);
    //Carregam l'arxiu de dades predeterminat si existeix
    carregaArbreFigures( arbreNovesFiguresTreeWidget,
                         nomArxiuFiguresGeneradesPredeterminat(),false);

    generaConjunts(configuracioJoc->tipusTangram);
}


//Carrega les figures als arbres
void ComprovaFigures::carregaArbreFigures(QTreeWidget *arbre, QString nomArxiu,
                                          bool traduc){

QApplication::setOverrideCursor(Qt::WaitCursor);

//netejam
arbre->clear();
arbre->setColumnCount(5);
arbre->setColumnHidden(3,true);
arbre->setColumnHidden(4,true);
//columna per marcar les figures a eliminar
arbre->setColumnHidden(5,true);
//posam la capçalera de l'arbre
QTreeWidgetItem *item=new QTreeWidgetItem();
// 13/02/11 Canviat per eliminar icones de resources.qrc
item->setIcon(0,QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+configuracioJoc->nomIcone));
item->setText(0,configuracioJoc->tradueixCadena(configuracioJoc->nomJocArbreFigures));
arbre->setHeaderItem(item);

llegeixArxiuFigures(arbre,nomArxiu,traduc);

QApplication::setOverrideCursor(Qt::ArrowCursor);
}

void ComprovaFigures::llegeixArxiuFigures(QTreeWidget *arbre, QString nomArxiu, bool traduc){
  QTreeWidgetItem *arrel=new QTreeWidgetItem();
  //obrim l'arxiu de figures
  QFile arxiuFigures(nomArxiu);
  if(!nomArxiu.isEmpty()){
  arxiuFigures.open(QIODevice::ReadOnly | QIODevice::Text);
   /* if (!arxiuFigures.open(QIODevice::ReadOnly | QIODevice::Text)){
         return ;
    }
  */
  QSettings *controlArxiu;
  controlArxiu=new QSettings(QSettings::IniFormat, QSettings::UserScope,"De Marchi", "NomFigures");
  controlArxiu->clear();

     QTextStream entrada(&arxiuFigures);
     QString linia0 = entrada.readLine();
     QString linia1,linia2;

     int numFig, intPosDarrerPunt;
     while (!linia0.isNull()) {
         linia1=entrada.readLine();
         linia2=entrada.readLine();


         //Només es carreguen les figures del nivell
         //principiant (fins que no s'aconsegueixi generar
         //figures d'altre nivells
         //if (  linia2.mid(0,1).toInt()<=NIVELL_PRINCIPIANT ) {
            QTreeWidgetItem *item=new QTreeWidgetItem();
            intPosDarrerPunt=linia0.lastIndexOf(".");
            if (intPosDarrerPunt<=0){intPosDarrerPunt=linia0.length();}
            numFig=controlArxiu->value(linia0.mid(0,intPosDarrerPunt),"1").toInt();
          QString cadena;
          //Només cal fer la traducció dels noms de figura, quan es carrega
          //un arxiu de figures generadas no es fa la traducció
          //per permetre localitzar-les millor a l'arxiu
          if(traduc){
            //posam espais al principi per a què les cadenes tenguin
            //la mateixa longitud i quedin ben ordenades
            cadena=QString::number(numFig);
            while (cadena.length()<4){cadena=" "+cadena;}
            cadena=configuracioJoc->tradueixCadena(linia0.mid(0,intPosDarrerPunt))+" "+cadena;
             }//if de la traducció
          else {cadena=linia0;}
            item->setText(0,cadena);
            numFig++;
            controlArxiu->setValue(linia0.mid(0,intPosDarrerPunt),numFig);
            item->setText(1,linia1);
            item->setText(2,linia2);
            //controla si  la figura ja s'ha resolt
            item->setText(3,"0");
            item->setIcon(0,iconeFigura(linia2.mid(2,1).toInt()));
            //controla si cal eliminar la figura
            item->setText(4,"0");

           arrel->addChild(item);
         //}//if del nivell de les figures
         linia0 = entrada.readLine();
     }
controlArxiu->clear();
 }//Final del If de comprovació del nom de l'arxiu
arbre->addTopLevelItem(arrel);
arbre->sortItems(0,Qt::AscendingOrder);
//arbreFiguresTreeWidget->sortByColumn(0,Qt::AscendingOrder);
QString capcaleraArbre;
/*if (nomArxiu.contains(".fig")){
   capcaleraArbre=configuracioJoc->tradueixCadena("figures.programa");
}
else capcaleraArbre=configuracioJoc->tradueixCadena("figures.noves");*/
if (traduc){
   capcaleraArbre=configuracioJoc->tradueixCadena("figures.programa");
}
else capcaleraArbre=configuracioJoc->tradueixCadena("figures.noves");
arrel->setText(0,capcaleraArbre+" ("+QString::number(arrel->childCount()) +")");
arbre->expandAll();

}

/*
  Proces de comparació de les figures generades
  amb les figures del programa
  */
void ComprovaFigures::comparaFiguresProgramaSlot(){
    int totalFigures=arbreFiguresTreeWidget->topLevelItem(0)->childCount()*
                     arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount();

    //missatgeEstimacioTemps(totalFigures);
    progresCercaFigura=new QProgressDialog(
              configuracioJoc->tradueixCadena("Cercant.figura")+"...",
              configuracioJoc->tradueixCadena("Atura.cerca"), 0,totalFigures,this,0);
    progresCercaFigura->setWindowModality(Qt::WindowModal);
    progresCercaFigura->setVisible(true);
//QTime temps;
//temps.start();
//un 61 segons per figura

figuresSemblantsList->clear();
activaLabelsFiguresSemblants();
activaConjuntsFigures();
tempsComparacioFigures.start();
   for(int i=0;i<=arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
     /*  progresCercaFigura->setValue(progresCercaFigura->value()+1);
       progresCercaFigura->setLabelText(configuracioJoc->tradueixCadena("Cercant.figura")+
                                        QString("... %1/%2").arg(progresCercaFigura->value()+1)
                                        .arg(totalFigures));*/
    //   qApp->processEvents();
       conjuntComparacioOriginal->colocaPeces(
               arbreNovesFiguresTreeWidget->topLevelItem(0)->child(i)->text(1));
       conjuntComparacioOriginal->conjuntVisible(true);
       cercaFigura(i,0,arbreFiguresTreeWidget,0);

       //qDebug("segons: %d",temps.elapsed()/1000);
       //temps.elapsed();
       if (progresCercaFigura->wasCanceled()){
          // activaBotonsMovimentLlistaComparacioFigures();
           break;}
   }

progresCercaFigura->close();
activaBotonsMovimentLlistaComparacioFigures();
if (figuresSemblantsList->size()>0){
    desaDadesCercaFigures();}
}

/*
  Proces de comparació de les figures generades
  entre elles.
  */
void ComprovaFigures::comparaFiguresGeneradesSlot(){
    long int totalFigures=sumatori(arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount());    
    //missatgeEstimacioTemps(totalFigures);
    progresCercaFigura=new QProgressDialog(
              configuracioJoc->tradueixCadena("Cercant.figura")+"...",
              configuracioJoc->tradueixCadena("Atura.cerca"), 0,totalFigures,this,0);
    progresCercaFigura->setWindowModality(Qt::WindowModal);
    progresCercaFigura->setVisible(true);

    figuresSemblantsList->clear();
    activaLabelsFiguresSemblants();
    activaConjuntsFigures();
 // QTime temps;
 // temps.start();
arbreNovesFiguresTreeWidget->selectedItems().clear();
arbreFiguresTreeWidget->selectedItems().clear();

    tempsComparacioFigures.start();
    for(int i=0;i<=arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){        
       /* progresCercaFigura->setLabelText(configuracioJoc->tradueixCadena("Cercant.figura")+
                                    QString(".. %1/%2").arg(i+1)
                                   .arg(arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()));
                                   */
        conjuntComparacioOriginal->colocaPeces(
                arbreNovesFiguresTreeWidget->topLevelItem(0)->child(i)->text(1));
        conjuntComparacioOriginal->conjuntVisible(true);
       // sceneComparacio->update();
        cercaFigura(i,1,arbreNovesFiguresTreeWidget,i+1);
       // progresCercaFigura->setValue(progresCercaFigura->value()+1);

        if (progresCercaFigura->wasCanceled()){
           /* activaBotonsMovimentLlistaComparacioFigures();
            if (figuresSemblantsList->size()>0){
                desaDadesCercaFigures();}*/
            break;}
    }

//qDebug("milisegons: %d",temps.elapsed());
progresCercaFigura->close();
activaBotonsMovimentLlistaComparacioFigures();
if (figuresSemblantsList->size()>0){
    desaDadesCercaFigures();}
}


void ComprovaFigures::activaBotonsMovimentLlistaComparacioFigures(){
    if (figuresSemblantsList->size()>0){        
        indexLlistaFiguraSemblant=0;
        figuresSemblantsList->sort();
        figuraSeguentButton->setEnabled(true);
        figuraAnteriorButton->setEnabled(true);
        desaLlistaComparacio->setEnabled(true);
        mostraFiguraSemblant(0);
    }
    //això per eliminar les peces de l'scene
    //i mostrar un missatge
    else {
        figuraSeguentButton->setEnabled(false);
        figuraAnteriorButton->setEnabled(false);
        desaLlistaComparacio->setEnabled(false);
        mostraFiguraSemblant(-1);}
}

/*
  Proces de recerca de figures
  */
void ComprovaFigures::cercaFigura(int indexOriginal,int arbreComparacio,
                                  QTreeWidget *arbreCerca, int itemInici){

float percentatgeCoincidencia=(float)(97.9);//PERCENTATGE_COINCIDENCIA_BUSCAR_FIGURA+7.0;
    this->setFocus(Qt::OtherFocusReason);
    if (arbreCerca->topLevelItem(0)==0){ return;}

   float resultat;

   //Figura que es busca (de les figures generades)
       conjuntComparacioOriginal->centraFiguraScene();
       conjuntComparacioOriginal->colorPecesConjunt(Qt::green);
       //Figura amb la qual es compara
       //(pot ésser del programa o de les generades)
       conjuntComparacioComparada->conjuntDeMostra();
//QTime temps;
//temps.start();

       for(int i=itemInici;i<=arbreCerca->topLevelItem(0)->childCount()-1;i++){

         progresCercaFigura->setValue(progresCercaFigura->value()+1);
         progresCercaFigura->setLabelText(configuracioJoc->tradueixCadena("Cercant.figura")+
                                     QString(".. %1/%2").arg(progresCercaFigura->value()+1)
                                    .arg(progresCercaFigura->maximum()));
         qApp->processEvents();
         conjuntComparacioComparada->colocaPeces(arbreCerca->topLevelItem(0)->child(i)->text(1));         
         conjuntComparacioComparada->conjuntVisible(true);
       /*  qCritical("Comparant figures: %s",
                   qPrintable(QString("%1 -> %2\n").arg(arbreCerca->topLevelItem(0)->child(itemInici-1)->text(0))
                  .arg(arbreCerca->topLevelItem(0)->child(i)->text(0))));*/
         //això per evitar que quedin "rastres"
         sceneComparacio->update();
         qApp->processEvents();

  //Comprovació prèvia per fer més ràpida la comprovació
  //Tal vegada hauria que posar més de 13!
    if(comparacioLongitudSiluetesPercentatge(
            conjuntComparacioOriginal->longitudSilueta(),
            conjuntComparacioComparada->longitudSilueta())< 13.0){
         resultat=figuraSolucionada();
         if ( resultat>=percentatgeCoincidencia ){
             afegeixFiguraSemblant(indexOriginal,i,arbreComparacio,resultat);
         }
         else {
             conjuntComparacioComparada->simetriaHoritzontal();
             //això per evitar que quedin "rastres"
             sceneComparacio->update();
             qApp->processEvents();
             resultat=figuraSolucionada();
             if ( resultat>=percentatgeCoincidencia){
             //if ((resultat>=percentatgeCoincidencia) && (comparacioSiluetes())){
                 afegeixFiguraSemblant(indexOriginal,i,arbreComparacio,resultat);
             }
             else {
                 conjuntComparacioComparada->simetriaVertical();
                //això per evitar que quedin "rastres"
                sceneComparacio->update();
                qApp->processEvents();
                resultat=figuraSolucionada();
                 if (resultat>=percentatgeCoincidencia){
                 //if ((resultat>=percentatgeCoincidencia) && (comparacioSiluetes())){
                     afegeixFiguraSemblant(indexOriginal,i,arbreComparacio,resultat);
                 }
                 else {
                    conjuntComparacioComparada->simetriaHoritzontal();
                    //això per evitar que quedin "rastres"
                    sceneComparacio->update();
                    qApp->processEvents();
                    resultat=figuraSolucionada();
                     if (resultat>=percentatgeCoincidencia){
                     //if((resultat>=percentatgeCoincidencia) && (comparacioSiluetes())){
                         afegeixFiguraSemblant(indexOriginal,i,arbreComparacio,resultat);
                     }
                 }
             }
         }
  }//if de comprovació de longituds
     if (progresCercaFigura->wasCanceled()){
         activaBotonsMovimentLlistaComparacioFigures();
         break;}
     //Actualitzam la previsió del temps només cada 1000 comprovacions
     /* 08/06/14 i superi el 49% de les comprovacions. Així
      * la previsió del temps restant és més acurada*/
     if( ((progresCercaFigura->value() % 1000) ==0) &&
         (progresCercaFigura->value()>1) &&
         (progresCercaFigura->value()*100/progresCercaFigura->maximum()>49) ){
     missatgeEstimacioTemps(progresCercaFigura->value()+1,progresCercaFigura->maximum(),
                            tempsComparacioFigures.elapsed());

      }

  }//for

   sceneComparacio->update();

   qApp->processEvents();
}

float ComprovaFigures::figuraSolucionada(){
   //Fem la comprovació dels centres de les peces
    if (
      (!comprovaCentresFigures(conjuntComparacioOriginal,conjuntComparacioComparada)) ||
      (!comprovaCentresFigures(conjuntComparacioComparada,conjuntComparacioOriginal)) ){
        return 0.0;}

    if(comparacioSiluetes()){
        return 100.0;
    }


    int positiu,totals;
    positiu=0;
    totals=0;
    QVector<QPointF> pSolucio;

for(int i=0;i<=conjuntComparacioOriginal->arrayPeces.size()-1;i++){
   conjuntComparacioComparada->arrayPeces[i]->puntsSolucio(pSolucio,0.9);
   }

//ara fem la comprovació
totals=pSolucio.size();
if (totals<1){return 0.0;}
//bool bpositiu=false;
for(int j=0;j<=pSolucio.size()-1;j++){
    //bpositiu=false;
    for(int k=0;k<=conjuntComparacioOriginal->arrayPeces.size()-1;k++){
        if(conjuntComparacioOriginal->arrayPeces[k]->shape().contains(
                pSolucio.value(j)-conjuntComparacioOriginal->arrayPeces[k]->pos())){
            positiu=positiu+1;
            //aquest break evita que un mateix punt es comptabilitzi
            //més d'una vegada si hi ha peces superposades
            break;
        }
    }
}

bool interseccioSiluetes=siluetesIntersecten();
float coincidenciaPercentual=((float)((float)(positiu*100)/(float)totals));
qreal comparacioLongitud=comparacioLongitudSiluetesPercentatge(
        conjuntComparacioComparada->longitudSilueta(),
        conjuntComparacioOriginal->longitudSilueta());

if( ( coincidenciaPercentual >(float)(99.9)) &&
    (comparacioLongitud<=(float)(0.05)) &&
    (interseccioSiluetes) ){
    return 92.0;
    }

if( (coincidenciaPercentual >(float)(95.0)) &&
    (comparacioLongitud>(float)(8.0)) &&
    (interseccioSiluetes) ){
    return 99.0;
    }

if ( (coincidenciaPercentual >(float)(97.9)) &&
      interseccioSiluetes ){
    return 99.5;
}
return coincidenciaPercentual;
}

/*
  Gestió de la llista de figures semblants actual
  */

//Afegeix a la llista de figures semblants (creació de figures)
//les dades d'una figura
void ComprovaFigures::afegeixFiguraSemblant(int indexOriginal,int indexComparada,
                                            int arbreComparacio, float percentatge){


    QString Missatge;
    //figura amb la qual es compara
    //(que pot ésser del programa o be de les generades
    Missatge.append(QString("%1;").arg(indexOriginal));
    //figura a comparar (que sempre serà de les generades)
    Missatge.append(QString("%1;").arg(indexComparada));
    Missatge.append(QString("%1;").arg(arbreComparacio));
    if(percentatge != (float)(99.45)){
        Missatge.append(QString("%1;").arg(percentatge));}
    else Missatge.append("--");
    figuresSemblantsList->append(Missatge);
    labelFiguresGenerades->setVisible(true);
    labelFiguresGenerades->setText(
            configuracioJoc->tradueixCadena("semblances.trobades")
            .arg(figuresSemblantsList->count()));
    //Si la semblança és alta, marcam l'item per eliminar
    //El percentatge no és "igual" per a tots els jocs
    //Alguns, amb el 98% ja són idèntiques
    /*26/04/14 Aqui hi havia un error: enlloc de indexOriginal
     * posava indexComparada*/
    if ( (percentatge>=(float)(99.0)) &&
        (arbreNovesFiguresTreeWidget->topLevelItem(0)->child(indexOriginal)->text(4) !="1") ){
       // arbreNovesFiguresTreeWidget->topLevelItem(0)->child(indexComparada)->setText(4,"0");
        arbreNovesFiguresTreeWidget->topLevelItem(0)->child(indexOriginal)->setTextColor(0,Qt::blue);
    }
    if(percentatge>(float)(99.7)){
      arbreNovesFiguresTreeWidget->topLevelItem(0)->child(indexOriginal)->setText(4,"1");
      arbreNovesFiguresTreeWidget->topLevelItem(0)->child(indexOriginal)->setTextColor(0,Qt::red);
    }
}


/*
  Compara les siluetes dels conjunts per saber
  si poden ésser semblants
  */
bool ComprovaFigures::comparacioLongitudSiluetes(){
 /*qCritical("Comparacio siluetes: %s",
         qPrintable(QString("%1").arg(conjuntComparacioOriginal->longitudSilueta()-
                                      conjuntComparacioComparada->longitudSilueta())));*/
 //  return true;
   return ( fabs(
          conjuntComparacioOriginal->longitudSilueta()-
          conjuntComparacioComparada->longitudSilueta()) ) < 300;
}


bool ComprovaFigures::comparacioSiluetes(){
 return conjuntComparacioOriginal->siluetaFigura()==
           conjuntComparacioComparada->siluetaFigura();
}

bool ComprovaFigures::siluetesIntersecten(){
 return conjuntComparacioOriginal->siluetaFigura()
       .intersects(conjuntComparacioComparada->siluetaFigura());
 /*return conjuntMostraPrograma->siluetaFigura()==
           conjuntMostraNovesFigures->siluetaFigura();*/
}

void ComprovaFigures::figuraSeguentSlot(){
  if (indexLlistaFiguraSemblant<figuresSemblantsList->size()-1){
      indexLlistaFiguraSemblant=indexLlistaFiguraSemblant+1;
      mostraFiguraSemblant(indexLlistaFiguraSemblant);
      //això per evitar que quedin "rastres"
      sceneComparacio->update();
/*
      if(indexLlistaFiguraSemblant==figuresSemblantsList->count()-1){
          figuraSeguentButton->setEnabled(true);
      }
      else figuraSeguentButton->setEnabled(false);
      */
  }

}
void ComprovaFigures::figuraAnteriorSlot(){
  if (indexLlistaFiguraSemblant>0){
      indexLlistaFiguraSemblant=indexLlistaFiguraSemblant-1;
      mostraFiguraSemblant(indexLlistaFiguraSemblant);
      //això per evitar que quedin "rastres"
      sceneComparacio->update();
   /*
      if(indexLlistaFiguraSemblant==0){
          figuraAnteriorButton->setEnabled(false);
      }
      else figuraAnteriorButton->setEnabled(true);*/
  }
}

/*
  Marca la figura generada seleccionada per eliminar-la
  */
void ComprovaFigures::eliminaFiguraSlot(){ 
    if(arbreNovesFiguresTreeWidget->selectedItems().count()>0){
        QTreeWidgetItem *item;
        item=arbreNovesFiguresTreeWidget->selectedItems().first();
        if(item->childCount()==0){
            if(item->text(4)=="0"){
                item->setText(4,"1");
                item->setTextColor(0,Qt::red);
            }
            else{
                item->setText(4,"0");
                item->setTextColor(0,Qt::black);
            }
        }
    }

/*
int nivell=0;
int contadorDiferencies=0;
for(int i=0;i<=arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()-1;i++){
    conjuntComparacioOriginal->colocaPeces(
            arbreNovesFiguresTreeWidget->topLevelItem(0)->child(i)->text(1));
QTreeWidgetItem *item=arbreNovesFiguresTreeWidget->topLevelItem(0)->child(i);

    QPainterPath siluetaFigura;
    siluetaFigura=conjuntComparacioOriginal->siluetaFigura();

    contadorDiferencies=siluetaFigura.length()/siluetaFigura.elementCount();
   // qDebug("número de items %d",contadorDiferencies);

    qreal longitudTotalPeces;
    longitudTotalPeces=conjuntComparacioOriginal->longitudTotalPeces;
    qreal longitudSilueta=siluetaFigura.length();
    qreal percentatgeLongitud=(longitudSilueta*100)/longitudTotalPeces;
   // qCritical("Percentatge %s ", qPrintable(QString("%1").arg(percentatgeLongitud)));
    if( (2*longitudSilueta-longitudTotalPeces)<-40.0 ){
        nivell=3;
    }
    else if(longitudSilueta>(longitudTotalPeces-longitudSilueta)){
        nivell=1;
    }
    if( (2*longitudSilueta-longitudTotalPeces >= -40.0) &&
        (2*longitudSilueta-longitudTotalPeces <= 200.0) ){
        nivell=2;
    }

    if(percentatgeLongitud<(float)(50.0)){nivell=3;}
    else if ( (percentatgeLongitud>=(float)(50.0)) && (percentatgeLongitud<=(float)(60.0)) ){nivell=2;}
    else nivell=1;
    qCritical("%s", qPrintable(QString("Percentatge %1 Nivell %2").arg(percentatgeLongitud)
                               .arg(nivell)));
    //qDebug("nivell %d",nivell);

contadorDiferencies=0;
    if(item->text(2).mid(2,1).toInt() != nivell){
        contadorDiferencies++;
   switch (nivell){
    case 1:
      // qDebug("nivell %d",nivell);
       arbreNovesFiguresTreeWidget->topLevelItem(0)->child(i)->setTextColor(0,Qt::green);
     break;
   case 2:
      arbreNovesFiguresTreeWidget->topLevelItem(0)->child(i)->setTextColor(0,Qt::yellow);
    break;
   case 3:
    //qDebug("nivell %d",nivell);
      arbreNovesFiguresTreeWidget->topLevelItem(0)->child(i)->setTextColor(0,Qt::red);
    break;
       }
}
//qApp->processEvents();
}
qDebug("num. diferents %d",contadorDiferencies);*/

}

/*
  Desa els canvis realitzats en els figures generades
  */
void ComprovaFigures::desaCanvisSlot(){
    QString nomArxiuComplet = QFileDialog::getSaveFileName(this,
                       configuracioJoc->tradueixCadena("desa.canvis.figures.generades"),
                       directoriFiguresGeneradesAtzar(),
                       filtreArxiusFiguresGeneradesAtzar(configuracioJoc,1));
/* 20/02/12
   Això és necessari degut a què a Windows, nomArxiuComplet te / enlloc
   de \ i no funciona la resta de codi
  */
  nomArxiuComplet.replace(QString("/"),QString("%1").arg(QDir().separator())) ;

    if (!nomArxiuComplet.isEmpty()){
        QString nomArxiu=nomArxiuComplet.mid(
                nomArxiuComplet.lastIndexOf(QDir().separator())+1,
                nomArxiuComplet.length()-
                nomArxiuComplet.lastIndexOf(QDir().separator())+1);

        QString directoriComplet=nomArxiuComplet.mid(
                0,nomArxiuComplet.lastIndexOf(QDir().separator())+1);


       //Si el nom de l'arxiu NO va precedit pel nom del tipus de tangram
       //l'afagim automàticament
       QString prefixeNom=configuracioJoc->arxiuDadesFigures.mid(0,
                          configuracioJoc->arxiuDadesFigures.length()-4);//+"-";
       //25/12/11 Eliminat el "_" per permetre posar el nom sense res més
       /*25/04/14 el prefixe va seguit de - en tots els cassos
        * degut al canvi en el sistema de filtre dels noms d'arxius*/
       if(nomArxiu.left(prefixeNom.length()) != prefixeNom){
          nomArxiu= configuracioJoc->arxiuDadesFigures.mid(0,
                           configuracioJoc->arxiuDadesFigures.length()-4)+"-"+nomArxiu;
          }
       //I ara l'extensió
       if(nomArxiu.right(4) != ".fig"){
           nomArxiu=nomArxiu+".fig";
       }
          nomArxiu=directoriComplet+nomArxiu;

          QFile arxiu(nomArxiu);
          if (!arxiu.open(QIODevice::WriteOnly)){
              QMessageBox::information(this, configuracioJoc->tradueixCadena("desa.canvis.figures.generades"),
                                     configuracioJoc->tradueixCadena("concurs.error")+"\n"+
                                     configuracioJoc->tradueixCadena("arxiuNoCreat").arg(arxiu.fileName()) );
             }
          else {
             QTextStream entrada(&arxiu);
             for(int j=0;j<=arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()-1;j++){
                QTreeWidgetItem *item;
                item=arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j);
                if(item->text(4)=="0"){
                entrada<<(QString("%1\n").arg(item->text(0)));
                entrada<<(QString("%1\n").arg(item->text(1)));
                entrada<<(QString("%1\n").arg(item->text(2)));
                }
             }
          arxiu.close();
          }
        }
}

/*
  Canvia la numeració de les figures generades per tal de fer-la
  "uniforme"
  */
void ComprovaFigures::canviaNumeracioFiguresGeneradesSlot(){
   QString total=QString("%1").arg(arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()-1);
   QString darrerNomFigura;
   int contadorFigures=0;
   for(int j=0;j<=arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()-1;j++){
       if(darrerNomFigura != arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->text(0).
               mid(0,arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->text(0).lastIndexOf("."))){
         darrerNomFigura=arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->text(0).
                 mid(0,arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->text(0).lastIndexOf("."));
         contadorFigures=0;
       }
       //QTreeWidgetItem *item;
      // item=arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j);
       //QString codiNumero=QString("%1").arg(j);
       QString codiNumero=QString("%1").arg(contadorFigures);
       while (codiNumero.length()<total.length()){
          codiNumero="0"+codiNumero;
       }
       contadorFigures++;
       arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->setText(0,
                           QString("%1.%2").arg(darrerNomFigura).arg(codiNumero));
      // item->text(0)=QString("auto.%1").arg(codiNumero);
      /*20/04/14 mantenim la diferència de nom entre els dos sistemes de
       * generació de figures*/
      /* if(arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->text(0).contains("Auto-2")){
           arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->setText(0,
                               QString("Auto-2.%1").arg(codiNumero));
       }
       else if (arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->text(0).contains("Auto.")){
               arbreNovesFiguresTreeWidget->topLevelItem(0)->child(j)->setText(0,
                           QString("Auto.%1").arg(codiNumero));
       else
       }*/
   }
}

void ComprovaFigures::mostraFiguraSemblant(int index){

    labelFiguraPrograma->setVisible(false);
    labelFiguresGenerades->setVisible(false);
    labelTemps->setVisible(false);
    arbreNovesFiguresTreeWidget->selectedItems().clear();
    arbreFiguresTreeWidget->selectedItems().clear();

if (index>-1 && index<=figuresSemblantsList->size()-1) {

  QStringList list1 = figuresSemblantsList->value(index).split(";");

  QString nomFiguresGenerades;
  //Col·locam l'original
  conjuntComparacioOriginal->colocaPeces(
          arbreNovesFiguresTreeWidget->topLevelItem(0)->child(list1.value(0).toInt())->text(1));
  //arbreNovesFiguresTreeWidget->topLevelItem(0)->child(list1.value(0).toInt())->setSelected(true);
  nomFiguresGenerades.append(
          arbreNovesFiguresTreeWidget->topLevelItem(0)->child(list1.value(0).toInt())->text(0));
  //Col·locam la comparada

  if(list1.value(2)=="0"){
      conjuntComparacioComparada->colocaPeces(
                arbreFiguresTreeWidget->topLevelItem(0)->child(list1.value(1).toInt())->text(1));
      labelFiguraPrograma->setText(
              arbreFiguresTreeWidget->topLevelItem(0)->child(list1.value(1).toInt())->text(0));
      labelFiguraPrograma->setVisible(true);
  }
  else {
      conjuntComparacioComparada->colocaPeces(
          arbreNovesFiguresTreeWidget->topLevelItem(0)->child(list1.value(1).toInt())->text(1));
      nomFiguresGenerades.append("\n");
      nomFiguresGenerades.append(
              arbreNovesFiguresTreeWidget->topLevelItem(0)->child(list1.value(1).toInt())->text(0));
  }
  //nomFiguresGenerades.append("\n");
  nomFiguresGenerades.append(" ( "+list1.value(3)+" %)");
  nomFiguresGenerades.append(QString("  %1/%2").arg(index+1).arg(figuresSemblantsList->count()));
  labelFiguresGenerades->setText(nomFiguresGenerades);
  labelFiguresGenerades->setVisible(true);


  //colocam el conjunt al vertex sup.esq per a què es vegi millor
  //(enlloc de centrat);
  //conjuntComparacioComparada->conjuntSolucio();
  //conjuntComparacioOriginal->conjuntSolucio();
  conjuntComparacioComparada->recolocaPeces(QPointF(10,10));
  conjuntComparacioComparada->colorPecesConjunt(Qt::black);
  conjuntComparacioComparada->conjuntVisible(true);
  //missatgeStatusBar(list1.value(1));
 }
else{
   conjuntComparacioComparada->conjuntVisible(false);
   conjuntComparacioOriginal->conjuntVisible(false);
   labelFiguresGenerades->setText(
           configuracioJoc->tradueixCadena("semblances.trobades")
           .arg(0));
   labelFiguresGenerades->setVisible(true);
 }

}

/*
Gestiona la selecció d'una figura a l'arbre
(conectat amb arbreFiguresTreeWidget::itemSelectionChanged ()
*/
void ComprovaFigures::seleccioFiguraJoc(){
    QString dades=seleccioFigura(arbreFiguresTreeWidget);
    if (dades.length()>1){
        conjuntMostraPrograma->colocaPeces(dades);
        conjuntMostraPrograma->conjuntVisible(true);
    }
}

void ComprovaFigures::seleccioFiguraNova(){
    QString dades=seleccioFigura(arbreNovesFiguresTreeWidget);
    if (dades.length()>1){
        conjuntMostraNovesFigures->colocaPeces(dades);
        conjuntMostraNovesFigures->conjuntVisible(true);
    /* 01/06/14 Afegit per millorar la comprovació
     * de figures (veure millor si estan ben aferrades les peces*/
        conjuntComparacioComparada->colocaPeces(dades);
        conjuntComparacioComparada->conjuntVisible(true);
        conjuntComparacioOriginal->conjuntVisible(false);
    }
 }


/*marca per eliminar*/
void ComprovaFigures::seleccionFiguraItemDoubleClicked (QTreeWidgetItem * ){
 eliminaFiguraSlot();
}

/*
  Retorna la cadena de les dades
  per composar la figura
  */
QString ComprovaFigures::seleccioFigura(QTreeWidget *arbre){
QString dades;
if (!arbre->selectedItems().isEmpty()){
 QTreeWidgetItem *item;
 item=arbre->selectedItems().first();
 //S'ha clicat el nus arrel
 if (item->childCount()>0){
     dades.append("*");
 }
 else dades.append(item->text(1));
}
return dades;
}

void ComprovaFigures::obreFiguresGeneradesSlot(){
 QString directoriSeleccionat = QFileDialog::getOpenFileName(this,
                                    configuracioJoc->tradueixCadena("figures.generades.ToolTip.Carrega"),
                                    directoriFiguresGeneradesAtzar(),
                                    filtreArxiusFiguresGeneradesAtzar(configuracioJoc,1));
    if(!directoriSeleccionat.isEmpty()){
        carregaArbreFigures(arbreNovesFiguresTreeWidget,directoriSeleccionat,false);        
        figuresSemblantsList->clear();
        activaLabelsFiguresSemblants(false);
        activaConjuntsFigures();
       }
}

/*
  Retorna el nom de l'arxiu predeterminat (si existeix) de les
  figures generades
  */
QString ComprovaFigures::nomArxiuFiguresGeneradesPredeterminat(){
    QDir dirArxiu(directoriFiguresPersonals()+charPathSeparator+"auto");
    QString nomArxiuDades=configuracioJoc->arxiuDadesFigures;

    QFile arxiu(dirArxiu.filePath(nomArxiuDades));
    if(arxiu.exists()){
        return dirArxiu.filePath(nomArxiuDades);
    }
    else return "";
}

void ComprovaFigures::actualitzaTextItemArrel(){
arbreNovesFiguresTreeWidget->topLevelItem(0)->setText(0,
                                  configuracioJoc->tradueixCadena("figures.noves")
                                  +" ("+QString::number(arbreNovesFiguresTreeWidget->topLevelItem(0)->childCount()) +")");

arbreFiguresTreeWidget->topLevelItem(0)->setText(0,
                                configuracioJoc->tradueixCadena("figures.programa")
                                  +" ("+QString::number(arbreFiguresTreeWidget->topLevelItem(0)->childCount()) +")");
}

void ComprovaFigures::generaConjunts(int tipusTangram){
        //eliminam les peces actuals
        sceneFiguresPrograma->clear();
        sceneFiguresNoves->clear();
        sceneComparacio->clear();

        conjuntMostraPrograma=new ConjuntPeces(tipusTangram,ESCALA_MOSTRA);
        conjuntMostraPrograma->conjuntDeMostra();
        conjuntMostraPrograma->conjuntVisible(false);

        conjuntMostraNovesFigures=new ConjuntPeces(tipusTangram,ESCALA_MOSTRA);
        conjuntMostraNovesFigures->conjuntDeMostra();
        conjuntMostraNovesFigures->conjuntVisible(false);

        conjuntComparacioOriginal=new ConjuntPeces(tipusTangram,ESCALA_GENERAL);
        conjuntComparacioOriginal->conjuntDeMostra();
        conjuntComparacioOriginal->conjuntVisible(false);

        conjuntComparacioComparada=new ConjuntPeces(tipusTangram,ESCALA_GENERAL);
        conjuntComparacioComparada->conjuntDeMostra();
        conjuntComparacioComparada->conjuntVisible(false);


       //ara afegim les peces a l'scena
        for(int i=0;i<=conjuntMostraPrograma->arrayPeces.size()-1;i++){
            conjuntMostraPrograma->arrayPeces[i]->setZValue(0);
            sceneFiguresPrograma->addItem(conjuntMostraPrograma->arrayPeces[i]);

            conjuntMostraNovesFigures->arrayPeces[i]->setZValue(0);
            sceneFiguresNoves->addItem(conjuntMostraNovesFigures->arrayPeces[i]);

            conjuntComparacioOriginal->arrayPeces[i]->setZValue(0);
            sceneComparacio->addItem(conjuntComparacioOriginal->arrayPeces[i]);

            conjuntComparacioComparada->arrayPeces[i]->setZValue(0);
            sceneComparacio->addItem(conjuntComparacioComparada->arrayPeces[i]);
            }
}//final CreaConcurs::creaTangram(int tipusTangram)


void ComprovaFigures::tradueixGUI(){
setWindowTitle(configuracioJoc->tradueixCadena("comprova.figures"));
/*
  Si la traducció de totes les cadenes es posa aqui
  el programa no funciona
 */
}

void ComprovaFigures::activaLabelsFiguresSemblants(bool activa){
    labelFiguresGenerades->setVisible(activa);
    labelFiguraPrograma->setVisible(activa);
    activaBotonsMovimentLlistaComparacioFigures();
}

void ComprovaFigures::activaConjuntsFigures(bool activa){
   conjuntMostraPrograma->conjuntVisible(activa);
   conjuntMostraNovesFigures->conjuntVisible(activa);
   conjuntComparacioOriginal->conjuntVisible(activa);
   conjuntComparacioComparada->conjuntVisible(activa);
}

/*
  Mostra un missatge informant del temps estimat per
  fer la comprovació de figures semblants.
  Cada comprovació necessita uns 60 mseg.
  */
void ComprovaFigures::missatgeEstimacioTemps(int figuresFetes,int total, int temps){
 int hores,minuts,dies,segons;
 float tempsMitja=temps/figuresFetes;
 minuts=((total-figuresFetes)*tempsMitja)/(1000*60);
 segons=((total-figuresFetes)*tempsMitja)/(1000);
 //minuts=(figures*temps)/(1000*60);
 hores=minuts/60;
 dies=hores/24;
 segons=segons-minuts*60;
 minuts=minuts-hores*60; 
 hores=hores-dies*24;
 QString tempsFinal;

 if (dies>=1){
   tempsFinal=QString("%1 ").arg(dies)
              +configuracioJoc->tradueixCadena("dies");
   tempsFinal=tempsFinal+QString(" %1 h").arg(hores);
 }
 else if (hores>=1){
   tempsFinal=QString("%1 h %2'").arg(hores).arg(minuts);
 }
 else if (minuts>=1){
     tempsFinal=QString("%1' %2''").arg(minuts).arg(segons);
 }
 else tempsFinal=QString("%1''").arg(segons);

// qDebug("total %d figuresFetes %d temps %d",total,figuresFetes,temps);
/*
tempsFinal=QString("%1 ").arg(dies)
           +configuracioJoc->tradueixCadena("dies");
tempsFinal=tempsFinal+
           QString(" %1 h %2' %3''").arg(hores).arg(minuts).arg(segons);
           */
//qCritical("tempsFinal %s",qPrintable(tempsFinal) );
 tempsFinal=configuracioJoc->tradueixCadena("temps.estimat")+"\n"+tempsFinal;
 labelTemps->setText(tempsFinal);
 labelTemps->setVisible(true);
}

void ComprovaFigures::desaLlistaComparacioSlot(){
   desaDadesCercaFigures();
}

/*
  Desa les dades de la comprovació de les figures
  a un arxiu de text
  */
void ComprovaFigures::desaDadesCercaFigures(){
    QMessageBox missatgeBox;
    missatgeBox.setText(configuracioJoc->tradueixCadena("desar.dades.comprovacio"));
    missatgeBox.setIcon(QMessageBox::Question);
    missatgeBox.setStandardButtons(QMessageBox::Yes | QMessageBox::No);
    missatgeBox.setDefaultButton(QMessageBox::No);
    if(missatgeBox.exec()==QMessageBox::Yes){
        QString nomArxiuComplet = QFileDialog::getSaveFileName(this,
                           configuracioJoc->tradueixCadena("desar.dades.comprovacio"),
                           directoriFiguresPersonals(),"");

        if (!nomArxiuComplet.isEmpty()){
            QFile arxiu(nomArxiuComplet);
            if (!arxiu.open(QIODevice::WriteOnly)){
                QMessageBox::information(this, configuracioJoc->tradueixCadena("desar.dades.comprovacio"),
                                       configuracioJoc->tradueixCadena("concurs.error")+"\n"+
                                       configuracioJoc->tradueixCadena("arxiuNoCreat").arg(arxiu.fileName()) );
               }
            else {
                QTextStream entrada(&arxiu);
                entrada<<(QString("%1 items\n").arg(figuresSemblantsList->count()));
                entrada<<(QString("===========\n"));
                for(int j=0;j<figuresSemblantsList->count();j++){
                    QStringList list1 = figuresSemblantsList->value(j).split(";");
                    entrada<<(QString("%1 => %2\n")
                             .arg(configuracioJoc->tradueixCadena("figures.noves"))
                             .arg(
                            arbreNovesFiguresTreeWidget->topLevelItem(0)->child(list1.value(0).toInt())->text(0)));
                    if(list1.value(2)=="0"){
                        entrada<<(QString("%1 => %2\n")
                                 .arg(configuracioJoc->tradueixCadena("figures.programa"))
                                 .arg(
                                arbreFiguresTreeWidget->topLevelItem(0)->child(list1.value(1).toInt())->text(0)));
                     }
                    else {
                        entrada<<(QString("%1 => %2\n")
                                .arg(configuracioJoc->tradueixCadena("figures.noves"))
                                .arg(
                                arbreNovesFiguresTreeWidget->topLevelItem(0)->child(list1.value(1).toInt())->text(0)));
                    }
                entrada<<(QString("%1%\n").arg(list1.value(3)));
                entrada<<(QString("*****************\n"));
                }
            }
            arxiu.close();
        }
    }
}

void ComprovaFigures::tancaSlot() {
    close();
    }
