/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __GTK_MPANED_H__
#define __GTK_MPANED_H__


#include <gtk/gtkcontainer.h>


G_BEGIN_DECLS



#define GTK_TYPE_MPANED			(gtk_mpaned_get_type ())
#define GTK_MPANED(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MPANED, GtkMPaned))
#define GTK_MPANED_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MPANED, GtkMPanedClass))
#define GTK_IS_MPANED(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MPANED))
#define GTK_IS_MPANED_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MPANED))
#define GTK_MPANED_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MPANED, GtkMPanedClass))


typedef struct _GtkMPaned       GtkMPaned;
typedef struct _GtkMPanedClass  GtkMPanedClass;
typedef struct _GtkMPanedChild  GtkMPanedChild;
typedef struct _GtkMPanedGrip   GtkMPanedGrip;


struct _GtkMPaned
{
  GtkContainer container;

  GtkOrientation orientation;

  GList *children;
  GList *grips;


  gboolean in_drag;
  GList *orig_children;
  gint button_press_x;
  gint button_press_y;
};

struct _GtkMPanedClass
{
  GtkContainerClass parent_class;
};

struct _GtkMPanedChild
{
  GtkWidget *widget;

  guint	shrink : 1;
  guint	expand : 1;
  guint fill   : 1;

  guint auto_resize : 1;

  gint d1_min;
  gint d1_max;
  gint d1_fixed; /* XXX not yet */

  gint d1_len;
  gint d2_len;
  gint d1_len_req;
  gint d2_len_req;

  gint d1_pos;
  gint d2_pos;
};

struct _GtkMPanedGrip
{
  GtkWidget *widget;

  GtkMPaned *mpaned;
};


GType gtk_mpaned_get_type (void) G_GNUC_CONST;



G_END_DECLS


#endif /* __GTK_MPANED_H__ */
