/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include <gtk/gtk.h>

#include "gtktreecontainer.h"


#if 0
#  define SIMPLE
#endif


static gint
tree_node_expose (GtkWidget      *widget,
		  GdkEventExpose *event,
		  gpointer        user_data)
{
  if (GTK_WIDGET_DRAWABLE (widget))
    {
      gint x;
      gint y;
      gint width;
      gint height;

      x = widget->allocation.x;
      y = widget->allocation.y;
      width  = (widget->allocation.width  - 1);
      height = (widget->allocation.height - 1);


      gdk_gc_set_clip_rectangle (widget->style->black_gc, &event->area);
      gdk_gc_set_clip_rectangle (widget->style->white_gc, &event->area);

      gdk_draw_rectangle (widget->window,
			  widget->style->white_gc, TRUE,
			  x, y, width, height);

      gdk_draw_rectangle (widget->window,
			  widget->style->black_gc, FALSE,
			  x, y, width, height);

      gdk_gc_set_clip_rectangle (widget->style->black_gc, NULL);
      gdk_gc_set_clip_rectangle (widget->style->white_gc, NULL);
    }

  return FALSE;
}

static GtkWidget *
create_label (gchar *label_text)
{
  GtkWidget *label;

  label = gtk_label_new (label_text);
  gtk_misc_set_padding (GTK_MISC (label), 2, 1);


  return label;
}



#ifdef SIMPLE
static GtkWidget *
create_tree_node (gchar *label_text)
{
  GtkWidget *tree_node;

  tree_node = create_label (label_text);

  g_signal_connect (tree_node,
                    "expose_event",
                    G_CALLBACK (tree_node_expose),
                    NULL);

  return tree_node;
}
#else

static gboolean randomize_topology = FALSE;
static gboolean randomize_widget   = TRUE;
static gboolean randomize_size     = TRUE;
static gboolean paint_bg           = TRUE;


static GtkAdjustment*
get_adjustment (void)
{
  static GtkAdjustment *adjustment = NULL;

  if (adjustment == NULL)
    {
      adjustment = GTK_ADJUSTMENT (gtk_adjustment_new (0.5, 0.0, 0.1, 0.01, 0.1, 0.0));
      g_object_ref (adjustment);
      gtk_object_sink (GTK_OBJECT (adjustment));
    }

  return adjustment;
}

static GSList *
get_radio_group (void)
{
  static GtkRadioButton *radio_button = NULL;
  GSList *radio_group;

  if (radio_button == NULL)
    {
      radio_button = GTK_RADIO_BUTTON (gtk_radio_button_new (NULL));
    }

  radio_group = gtk_radio_button_get_group (radio_button);

  return radio_group;
}

static GtkWidget *
create_tree_node (gchar *label_text)
{
  GtkWidget *tree_node;

  if (randomize_widget == TRUE)
    {
      guint32 r;

      r = g_random_int ();

      switch (r % 9)
	{
	case 0:
	  tree_node = create_label ("GtkLabel");
	  break;

	case 1:
	  tree_node = gtk_button_new_with_label ("GtkButton");
	  break;

	case 2:
	  tree_node = gtk_toggle_button_new_with_label ("GtkToggleButton");
	  break;

	case 3:
	  tree_node = gtk_check_button_new_with_label ("GtkCheckButton");
	  break;

	case 4:
	  tree_node = gtk_radio_button_new_with_label (get_radio_group (),
						       "GtkRadioButton");
	  break;

	case 5:
	  {
	    tree_node = gtk_entry_new ();
	    gtk_entry_set_text (GTK_ENTRY (tree_node), "GtkEntry");
	  }
	  break;

	case 6:
	  {
	    tree_node = gtk_text_view_new ();
	    gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (tree_node)),
				      "GtkTextView", -1);
	  }
	  break;

	case 7:
	  {
	    tree_node = gtk_hscrollbar_new (get_adjustment ());
	  }
	  break;

	case 8:
	  {
	    tree_node = gtk_vscrollbar_new (get_adjustment ());
	  }
	  break;

	default:
	  g_assert_not_reached ();
	  break;
	}
    }
  else
    {
      tree_node = create_label (label_text);
    }

  if (paint_bg == TRUE)
    {
      g_signal_connect (tree_node,
			"expose_event",
			G_CALLBACK (tree_node_expose),
			NULL);
    }

  return tree_node;
}
#endif

static void
create_tree_1 (GtkTreeContainer *tree_container,
	       gint              n0,
	       gint              n1,
	       gint              n2,
	       gint              n3,
	       gint              n4)
{
  GtkWidget *root_node;
  GtkWidget *tmp_node1;
  GtkWidget *tmp_node2;
  GtkWidget *tmp_node3;
  GtkWidget *tmp_node4;
  gint i1;
  gint i2;
  gint i3;
  gint i4;
  
  {
    gchar *tmp;
    tmp = g_strdup_printf ("Root: %d", n0);
    root_node = create_tree_node (tmp);
    g_free (tmp);
  }
  gtk_tree_container_append_node_widget (tree_container, root_node, NULL);

  for (i1 = 0; i1 < n1; ++i1)
    {
      tmp_node1 = create_tree_node ("node");
      gtk_tree_container_append_node_widget (tree_container, tmp_node1, root_node);
      
      for (i2 = 0; i2 < n2; ++i2)
	{
	  tmp_node2 = create_tree_node ("node");
	  gtk_tree_container_append_node_widget (tree_container, tmp_node2, tmp_node1);
	  
	  for (i3 = 0; i3 < n3; ++i3)
	    {
	      tmp_node3 = create_tree_node ("node");
	      gtk_tree_container_append_node_widget (tree_container, tmp_node3, tmp_node2);

	      for (i4 = 0; i4 < n4; ++i4)
		{
		  tmp_node4 = create_tree_node ("node");
		  gtk_tree_container_append_node_widget (tree_container, tmp_node4, tmp_node3);
		}
	    }
	}
    }
}

#ifndef SIMPLE
static void
create_tree_2_recurse (GtkTreeContainer *tree_container,
		       GtkWidget        *parent,
		       gint              level)
{
  if (level < 7)
    {
      gint n_children;
      GtkWidget *child;
      gint i;

      if (level < 2)
	{
	  n_children = (3 + (g_random_int () % 3) - level);
	}
      else
	{
	  n_children = (g_random_int () % 7) - 2;
	}

      for (i = 0; i < n_children; ++i)
	{
	  child = create_tree_node ("node");
	  gtk_tree_container_append_node_widget (tree_container, child, parent);

	  create_tree_2_recurse (tree_container, child, (level + 1));
	}
    }
}
#endif





#ifdef SIMPLE

static void
update_tree_container (GtkTreeContainer *tree_container)
{
  gint i;

  gtk_container_foreach (GTK_CONTAINER (tree_container),
			 (GtkCallback)gtk_widget_destroy,
			 NULL);

#undef STRESS_TEST

#ifdef STRESS_TEST
  for (i = 0; i < 200; ++i)
    {
      create_tree_1 (tree_container, i, 1, 10, 5, 7);
    }
#else
  for (i = 0; i < 3; ++i)
    {
      create_tree_1 (tree_container, i, 1, 2, 5, 1);
    }
#endif
}

static void
create_widgets (void)
{
  GtkWidget *window;
  GtkWidget *tree_container;


  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size (GTK_WINDOW (window), 300, 400);

  tree_container = gtk_tree_container_new ();


  gtk_container_add (GTK_CONTAINER (window), tree_container);


  update_tree_container (GTK_TREE_CONTAINER (tree_container));


  gtk_widget_show_all (window);
}
#else

static void
randomize_size_request (GtkWidget *widget,
			gpointer   data)
{
  guint32 r;
  gint width;
  gint height;

  r = g_random_int ();

  width  = (10 + ((r&0x07f00000) >> 20));
  height = (10 + ((r&0x00007f00) >>  8));

  if (randomize_widget == FALSE)
    {
      width  = (width  / 3);
      height = (height / 3);
    }

  gtk_widget_set_size_request (widget, width, height);
}

static void
update_tree_container (GtkTreeContainer *tree_container)
{
  gtk_container_foreach (GTK_CONTAINER (tree_container),
			 (GtkCallback)gtk_widget_destroy,
			 NULL);


  if (randomize_topology == FALSE)
    {
      gint i;

      for (i = 0; i < 3; ++i)
	{
	  create_tree_1 (tree_container, i, 1, 2, 5, 1);
	}
    }
  else
    {
      create_tree_2_recurse (tree_container, NULL, 0);
    }



  if (randomize_size == TRUE)
    {
      gtk_container_foreach (GTK_CONTAINER (tree_container),
			     randomize_size_request,
			     NULL);
    }
}

static void
button_clicked (GtkButton *button,
		gpointer   user_data)
{
  GtkTreeContainer *tree_container;

  tree_container = GTK_TREE_CONTAINER (user_data);

  update_tree_container (tree_container);

  gtk_widget_show_all (GTK_WIDGET (tree_container));
}

static void
toggle_button_toggled (GtkToggleButton *toggle_button,
		       gpointer         user_data)
{
  gboolean *b;

  b = (gboolean *)user_data;

  *b = gtk_toggle_button_get_active (toggle_button);
}

static void
create_widgets (void)
{
  GtkWidget *window;
  GtkWidget *vbox;
  GtkWidget *scrolled_window;
  GtkWidget *tree_container;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size (GTK_WINDOW (window), 600, 400);


  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);


  scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  gtk_box_pack_end (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);

  tree_container = gtk_tree_container_new ();
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window),
					 tree_container);


  {
    GtkWidget *hbox;

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    
    {
      GtkWidget *button;

      button = gtk_button_new_with_label ("Rebuild Trees");
      gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
      g_signal_connect (button,
			"clicked",
			G_CALLBACK (button_clicked),
			tree_container);
    }

    {
      GtkWidget *toggle_button;

      toggle_button = gtk_check_button_new_with_label ("Randomize Topology");
      gtk_box_pack_start (GTK_BOX (hbox), toggle_button, FALSE, FALSE, 0);
      g_signal_connect (toggle_button,
			"toggled",
			G_CALLBACK (toggle_button_toggled),
			&randomize_topology);

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle_button), randomize_topology);
    }

    {
      GtkWidget *toggle_button;

      toggle_button = gtk_check_button_new_with_label ("Randomize Widget");
      gtk_box_pack_start (GTK_BOX (hbox), toggle_button, FALSE, FALSE, 0);
      g_signal_connect (toggle_button,
			"toggled",
			G_CALLBACK (toggle_button_toggled),
			&randomize_widget);

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle_button), randomize_widget);
    }

    {
      GtkWidget *toggle_button;

      toggle_button = gtk_check_button_new_with_label ("Randomize Size");
      gtk_box_pack_start (GTK_BOX (hbox), toggle_button, FALSE, FALSE, 0);
      g_signal_connect (toggle_button,
			"toggled",
			G_CALLBACK (toggle_button_toggled),
			&randomize_size);

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle_button), randomize_size);
    }

    {
      GtkWidget *toggle_button;

      toggle_button = gtk_check_button_new_with_label ("Paint BG");
      gtk_box_pack_start (GTK_BOX (hbox), toggle_button, FALSE, FALSE, 0);
      g_signal_connect (toggle_button,
			"toggled",
			G_CALLBACK (toggle_button_toggled),
			&paint_bg);

      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle_button), paint_bg);
    }
  }


  update_tree_container (GTK_TREE_CONTAINER (tree_container));


  gtk_widget_show_all (window);
}
#endif


int
main (int   argc,
      char *argv[])
{
  gtk_init (&argc, &argv);

  create_widgets ();


  gtk_main ();


  return 0;
}
