/*
 *    qsodata.h  --  QSO data area functions
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef	_QSODATA_H
#define	_QSODATA_H

extern void clear_qsodata(void);
extern void log_qsodata(void);

extern void set_qsotime(gboolean force);

extern void set_qsocall(char *str);
extern void set_qsoband(char *str);
extern void set_qsotxrst(char *str);
extern void set_qsorxrst(char *str);
extern void set_qsoname(char *str);
extern void set_qsoqth(char *str);
extern void set_qsoloc(char *str);
extern void set_qsonotes(char *str);

extern char *get_qsocall(void);
extern char *get_qsoband(void);
extern char *get_qsotxrst(void);
extern char *get_qsorxrst(void);
extern char *get_qsoname(void);
extern char *get_qsoqth(void);
extern char *get_qsoloc(void);
extern char *get_qsonotes(void);

#endif
