/*
  gmorgan - a ryhthm station software

  gmorgan.C  -  Most of the functions of the organ
  Copyright (C) 2003-2004 Josep Andreu (Holborn)
  Author: Josep Andreu

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License
(version2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/

/* Alsa sequencer functions  by Matthias Nagorni 
   modifies by Josep Andreu

*/

#include "GMorgan.h"


int l1, i, j, k, l, Pexitprogram, vum, vumvum, espera,
UndoCount,programa,vavi,pr,pr1,tum,cambialo;
char NombreAcorde[16];
char NombreSong[80];
int splash,splashcounter,clicksplash;
int count,ulcount,ponfin;
int actunex,ttnp,cambiapat,tocadrum,sde,sdec;
int TempoSong,SNomi,InvMode;
int veloplus[65];
const char *FilePreset;
const char *FileDrums;
song S[129];
int Edr[62][129];
int Ectrl[8][38][129];
int paraplay,canaledit,lastcasdr,cambiacasdr;
int lastcascr,cambiacascr;




GMO::GMO ()
{

  //inicio de variables
  cambiacascr = 0;
  cambiacasdr = 0;
  cambiaacorde = 0;
  MTempo = 0;
  cttemp = 0;
  valorctrl = 0;
  canaledit = 1;
  ctrledit = 0;
  MTlsb = 64;
  MTmsb = 64;
  DataLSB= 0;
  DataMSB=0;  
  Hay = 0;
  MasterVolume = 1;
  MasterON=0;
  StyleSelect = 0;
  PatternSelect = 1;
  SoundSelect = 0;
  MutesOnOff = 0;
  ultimotick = 0;
  paraplay = 0;
  grabaconta=0;
  reproduccion=0;
  grabacion=0;
  TresCinco=3;
  DosCuatro=2;
  bplay = 0;
  VeloMixer=0;
  anticipa=0;
  KeybON = 0;
  dredit = 0;
  InvMode = 1;
  inversion = 1;
  TempoSong = 120;
  SNomi = 4;
  BPW = 0;
  veloW= 0;
  ttnp = 0;
  finito = 0;
  ponfin = 0;
  stst = 0;
  vum = 0;
  vumvum= 0;
  bpm = 240;
  espera = 0;
  sd = 1;
  cdn = 36;
  sbar = 1;
  sp = 1;
  ss =1;
  st = 1;
  sposi = 0;
  semi = 0;
  selmix = 1;
  nextp = 0;
  tick = 0;
  negra = 0;
  ncompas = 0;
  count = 0;
  queue_id = 0;
  elbar = 1;
  HMode = 0;
  MiNominator = 4;
  MiBars = 1;
  MiBaseKey = 0;
  MiDrumsMCh= 10;
  MiBassMCh = 0;
  MiAcc1MCh = 0;
  MiAcc1MCh = 0;
  MiAcc2MCh = 0;
  MiAcc3MCh = 0;
  MiAcc4MCh = 0;
  MiAcc5MCh = 0;
  Mmodebass = 2;
  Mmodeacc2 = 2;
  Mmodeacc4 = 2;
  MiStart = 1;
  genwindow = 0;
  bzero(ElEstilo,sizeof(ElEstilo));
  strcpy(ElEstilo,"Empty");  
  GUIPlay=0;
  WGUIP = 0;
  ABOW = 0;
  PFEW= 0;
  DNNWE = 0;


for (i = 1; i <= 11; i++)
    {
      reverb[i] = 0;
      chorus[i] = 0;
      progch[i] = 0;
      BankMSB[i] = 0;
      BankLSB[i] = 0;
      pan[i] = 64;
      volume[i] = 100;
      Pon[i] = 0;
      Ptime[i] = 0;
      octa[i] = 0;
      OnOff[i] = 1;
      solo[i] = 0;
     }

BankMSB[8]=1;
BankLSB[8]=1;

memset(S, 0, sizeof S);

newsong();

memset(EG, 0, sizeof EG);
memset(GP, 0, sizeof GP);

strcpy (HM[0].Name, "Unison");
HM[0].notes = 0;
HM[0].dist = 0;
HM[0].nnu = 0;

strcpy (HM[1].Name, "Thirds");
HM[1].notes = 1;
HM[1].dist = -3;
HM[1].nnu = 0;

strcpy (HM[2].Name, "Sixths");
HM[2].notes = 1;
HM[2].dist = -7;
HM[2].nnu = 0;

strcpy (HM[3].Name, "Triad 1");
HM[3].notes = 2;
HM[3].dist = -1;
HM[3].nnu = 0;

strcpy (HM[4].Name, "Triad 2");
HM[4].notes = 2;
HM[4].dist = -3;
HM[4].nnu = 0;

strcpy (HM[5].Name, "Soli 1");
HM[5].notes = 3;
HM[5].dist = -1;
HM[5].nnu = 0;

strcpy (HM[6].Name, "Soli 2");
HM[6].notes = 3;
HM[6].dist = -3;
HM[6].nnu = 0;



TMch[1] = 0;
TMch[2] = 1;
TMch[3] = 2;
TMch[4] = 3;
TMch[5] = 4;
TMch[6] = 5;
TMch[7] = 6;
TMch[8] = 9;
TMch[9] = 7;
TMch[10] = 8;
TMch[11] = 10;
TMch[12] = 11;
TMch[13] = 12;
TMch[14] = 13;




memset(Prog , 0 , sizeof Prog);


for (i=1; i<=100; i++)
{
  strcpy(Prog[i].Nom,"Empty");

  
  Prog[i].pattern = 1;
  Prog[i].bpm = 120;
  Prog[i].transpose = 0;
  Prog[i].style = 1;

for (j=1; j<=4; j++)
{
     Prog[i].detune[j] = 0;
     Prog[i].reverb[j] = 0;
     Prog[i].chorus[j] = 0;
     Prog[i].progch[j] = 0;
     Prog[i].BankMSB[j] = 0;
     Prog[i].BankLSB[j] = 0;
     Prog[i].pan[j] = 64;
     Prog[i].volume[j] = 100;
     Prog[i].Pon[j] = 0;
     Prog[i].Ptime[j] = 0;
     Prog[i].octa[j] = 0;

}
}


memset(Styl , 0 , sizeof Styl);

for (i=1; i<=100; i++)

{

   strcpy(Styl[i].Nom,"Empty");

   Styl[i].Intro = 0;
   Styl[i].Var1 = 0;
   Styl[i].Var2 = 0;
   Styl[i].Fill1 = 0;
   Styl[i].Fill2 = 0;
   Styl[i].Ending = 0;
   Styl[i].bpm = 200;
   Styl[i].startP = 99;
   Styl[i].programa = 1;

}  



memset(Rt , 0 , sizeof Rt);


for (i = 0; i<500; i++) patternclear(i);


for (i=0; i<65; i++) veloplus[i] = 0;


strcpy(NC[0].Nom,"C");
strcpy(NC[1].Nom,"Db");
strcpy(NC[2].Nom,"D");
strcpy(NC[3].Nom,"Eb");
strcpy(NC[4].Nom,"E");
strcpy(NC[5].Nom,"F");
strcpy(NC[6].Nom,"Gb");
strcpy(NC[7].Nom,"G");
strcpy(NC[8].Nom,"Ab");
strcpy(NC[9].Nom,"A");
strcpy(NC[10].Nom,"Bb");
strcpy(NC[11].Nom,"B");


strcpy(NCE[0].Nom,"C");
NCE[0].note = 0;
strcpy(NCE[1].Nom,"Db");
NCE[1].note = 1;
strcpy(NCE[2].Nom,"D");
NCE[2].note = 2;
strcpy(NCE[3].Nom,"Eb");
NCE[3].note = 3;
strcpy(NCE[4].Nom,"E");
NCE[4].note = 4;
strcpy(NCE[5].Nom,"F");
NCE[5].note = 5;
strcpy(NCE[6].Nom,"Gb");
NCE[6].note = 6;
strcpy(NCE[7].Nom,"G");
NCE[7].note = -5;
strcpy(NCE[8].Nom,"Ab");
NCE[8].note = -4;
strcpy(NCE[9].Nom,"A");
NCE[9].note = -3;
strcpy(NCE[10].Nom,"Bb");
NCE[10].note = -2;
strcpy(NCE[11].Nom,"B");
NCE[11].note = -1;
strcpy(NCE[12].Nom,"C#");
NCE[12].note = 1;
strcpy(NCE[13].Nom,"D#");
NCE[13].note = 3;
strcpy(NCE[14].Nom,"E#");
NCE[14].note = 5;
strcpy(NCE[15].Nom,"F#");
NCE[15].note = 6;
strcpy(NCE[16].Nom,"G#");
NCE[16].note = -4;
strcpy(NCE[17].Nom,"A#");
NCE[17].note = -2;
strcpy(NCE[18].Nom,"B#");
NCE[18].note = 0;



// Inicia TipoChords


//Maj7

TCh[1].ter = 0;
TCh[1].qui = 0;
TCh[1].sep = 0;

//7

TCh[2].ter = 0;
TCh[2].qui = 0;
TCh[2].sep = -1;

//-7

TCh[3].ter = -1;
TCh[3].qui = 0;
TCh[3].sep = -1;

//-7(b5)

TCh[4].ter = -1;
TCh[4].qui = -1;
TCh[4].sep = -1;

//dis

TCh[5].ter = -1;
TCh[5].qui = -1;
TCh[5].sep = -2;

//aug7

TCh[6].ter = 0;
TCh[6].qui = +1;
TCh[6].sep = -1;


//7Sus4

TCh[7].ter = +1;
TCh[7].qui = 0;
TCh[7].sep = -1;


//Triad Maj

TCh[8].ter = 0;
TCh[8].qui = 0;
TCh[8].sep = +1;


// Triad Min

TCh[9].ter = -1;
TCh[9].qui = 0;
TCh[9].sep = +1;


// 6

TCh[10].ter = 0;
TCh[10].qui = 0;
TCh[10].sep = -2;

// Inicia Chords

Chord3[1].tipo = 8;
Chord3[1].fund = 1;
Chord3[1].di1  = 4;
Chord3[1].di2  = 3;
Chord3[1].inv2 = 3;
Chord3[1].inv3 = 2;
strcpy(Chord3[1].Nom,"");

Chord3[2].tipo = 8;
Chord3[2].fund = 3;
Chord3[2].di1  = 3;
Chord3[2].di2  = 5;
strcpy(Chord3[2].Nom,"");

Chord3[3].tipo = 8;
Chord3[3].fund = 2;
Chord3[3].di1  = 5;
Chord3[3].di2  = 4;
strcpy(Chord3[3].Nom,"");

Chord3[4].tipo = 9;
Chord3[4].fund = 1;
Chord3[4].di1  = 3;
Chord3[4].di2  = 4;
Chord3[4].inv2 = 6;
Chord3[4].inv3 = 5;
strcpy(Chord3[4].Nom,"m");

Chord3[5].tipo = 9;
Chord3[5].fund = 3;
Chord3[5].di1  = 4;
Chord3[5].di2  = 5;
strcpy(Chord3[5].Nom,"m");

Chord3[6].tipo = 9;
Chord3[6].fund = 2;
Chord3[6].di1  = 5;
Chord3[6].di2  = 3;
strcpy(Chord3[6].Nom,"m");

Chord3[7].tipo = 5;
Chord3[7].fund = 1;
Chord3[7].di1  = 3;
Chord3[7].di2  = 3;
Chord3[7].inv2 = 7;
Chord3[7].inv3 = 7;
strcpy(Chord3[7].Nom,"");

Chord3[8].tipo = 6;
Chord3[8].fund = 1;
Chord3[8].di1  = 4;
Chord3[8].di2  = 4;
strcpy(Chord3[8].Nom,"+");

Chord3[9].tipo = 1;
Chord3[9].fund = 1;
Chord3[9].di1  = 2;
Chord3[9].di2  = 5;
Chord3[9].inv2 = 9;
Chord3[9].inv3 = 9;
strcpy(Chord3[9].Nom,"2");

Chord3[10].tipo = 8;
Chord3[10].fund = 3;
Chord3[10].di1  = 3;
Chord3[10].di2  = 2;
strcpy(Chord3[10].Nom,"");



// Chords4

Chord4[1].tipo = 1;
Chord4[1].fund = 1;
Chord4[1].di1  = 4;
Chord4[1].di2  = 3;
Chord4[1].di3  = 4;
Chord4[1].inv2 = 14;
Chord4[1].inv3 = 21;
strcpy(Chord4[1].Nom,"Maj7");

Chord4[2].tipo = 3;
Chord4[2].fund = 1;
Chord4[2].di1  = 3;
Chord4[2].di2  = 4;
Chord4[2].di3  = 3;
Chord4[2].inv2 = 31;
Chord4[2].inv3 = 22;
strcpy(Chord4[2].Nom,"m7");

Chord4[3].tipo = 2;
Chord4[3].fund = 1;
Chord4[3].di1  = 4;
Chord4[3].di2  = 3;
Chord4[3].di3  = 3;
Chord4[3].inv2 = 15;
Chord4[3].inv3 = 23;
strcpy(Chord4[3].Nom,"7");

Chord4[4].tipo = 4;
Chord4[4].fund = 1;
Chord4[4].di1  = 3;
Chord4[4].di2  = 3;
Chord4[4].di3  = 4;
Chord4[5].inv2 = 32;
Chord4[5].inv3 = 24;
strcpy(Chord4[4].Nom,"m7(b5)");

Chord4[5].tipo = 5;
Chord4[5].fund = 1;
Chord4[5].di1  = 3;
Chord4[5].di2  = 3;
Chord4[5].di3  = 3;
Chord4[5].inv2 = 5;
Chord4[5].inv3 = 5;
strcpy(Chord4[5].Nom,"7");

Chord4[6].tipo = 6;
Chord4[6].fund = 1;
Chord4[6].di1  = 4;
Chord4[6].di2  = 4;
Chord4[6].di3  = 2;
Chord4[6].inv2 = 16;
Chord4[6].inv3 = 25;
strcpy(Chord4[6].Nom,"+7");

Chord4[7].tipo = 8;
Chord4[7].fund = 1;
Chord4[7].di1  = 4;
Chord4[7].di2  = 3;
Chord4[7].di3  = 5;
strcpy(Chord4[7].Nom,"");

Chord4[8].tipo = 10;
Chord4[8].fund = 1;
Chord4[8].di1  = 4;
Chord4[8].di2  = 3;
Chord4[8].di3  = 2;
Chord4[8].inv2 = 8;
Chord4[8].inv3 = 8;
strcpy(Chord4[8].Nom,"6");

Chord4[9].tipo = 7;
Chord4[9].fund = 1;
Chord4[9].di1  = 5;
Chord4[9].di2  = 2;
Chord4[9].di3  = 3;
Chord4[9].inv2 = 18;
Chord4[9].inv3 = 27;
strcpy(Chord4[9].Nom,"7(Sus4)");

Chord4[10].tipo = 3;
Chord4[10].fund = 1;
Chord4[10].di1  = 3;
Chord4[10].di2  = 4;
Chord4[10].di3  = 4;
Chord4[10].inv2 = 19;
Chord4[10].inv3 = 28;
strcpy(Chord4[10].Nom,"m(Maj7)");

Chord4[11].tipo = 3;
Chord4[11].fund = 1;
Chord4[11].di1  = 3;
Chord4[11].di2  = 4;
Chord4[11].di3  = 2;
Chord4[11].inv2 = 11;
Chord4[11].inv3 = 11;
strcpy(Chord4[11].Nom,"m6");

Chord4[12].tipo = 6;
Chord4[12].fund = 1;
Chord4[12].di1  = 4;
Chord4[12].di2  = 4;
Chord4[12].di3  = 4;
Chord4[12].inv2 = 20;
Chord4[12].inv3 = 29;
strcpy(Chord4[12].Nom,"+(Maj7)");

Chord4[13].tipo = 1;
Chord4[13].fund = 1;
Chord4[13].di1  = 2;
Chord4[13].di2  = 4;
Chord4[13].di3  = 3;
Chord4[13].inv2 = 13;
Chord4[13].inv3 = 13;
strcpy(Chord4[13].Nom,"lyd");

Chord4[14].tipo = 1;
Chord4[14].fund = 4;
Chord4[14].di1  = 3;
Chord4[14].di2  = 4;
Chord4[14].di3  = 1;
strcpy(Chord4[14].Nom,"Maj7");

Chord4[15].tipo = 1;
Chord4[15].fund = 4;
Chord4[15].di1  = 3;
Chord4[15].di2  = 3;
Chord4[15].di3  = 2;
strcpy(Chord4[15].Nom,"7");

Chord4[16].tipo = 6;
Chord4[16].fund = 4;
Chord4[16].di1  = 4;
Chord4[16].di2  = 2;
Chord4[16].di3  = 2;
strcpy(Chord4[16].Nom,"+7");

Chord4[17].tipo = 8;
Chord4[17].fund = 3;
Chord4[17].di1  = 3;
Chord4[17].di2  = 5;
Chord4[17].di3  = 4;
strcpy(Chord4[17].Nom,"");

Chord4[18].tipo = 7;
Chord4[18].fund = 4;
Chord4[18].di1  = 2;
Chord4[18].di2  = 3;
Chord4[18].di3  = 2;
strcpy(Chord4[18].Nom,"7(Sus4)");


Chord4[19].tipo = 3;
Chord4[19].fund = 4;
Chord4[19].di1  = 4;
Chord4[19].di2  = 4;
Chord4[19].di3  = 1;
strcpy(Chord4[19].Nom,"m(Maj7)");

Chord4[20].tipo = 6;
Chord4[20].fund = 4;
Chord4[20].di1  = 4;
Chord4[20].di2  = 4;
Chord4[20].di3  = 1;
strcpy(Chord4[20].Nom,"+(Maj7)");

Chord4[21].tipo = 1;
Chord4[21].fund = 3;
Chord4[21].di1  = 4;
Chord4[21].di2  = 1;
Chord4[21].di3  = 4;
strcpy(Chord4[21].Nom,"Maj7");

Chord4[22].tipo = 3;
Chord4[22].fund = 3;
Chord4[22].di1  = 3;
Chord4[22].di2  = 2;
Chord4[22].di3  = 3;
strcpy(Chord4[22].Nom,"m7");

Chord4[23].tipo = 2;
Chord4[23].fund = 3;
Chord4[23].di1  = 3;
Chord4[23].di2  = 2;
Chord4[23].di3  = 4;
strcpy(Chord4[23].Nom,"7");

Chord4[24].tipo = 4;
Chord4[24].fund = 3;
Chord4[24].di1  = 4;
Chord4[24].di2  = 2;
Chord4[24].di3  = 3;
strcpy(Chord4[24].Nom,"m7(b5)");

Chord4[26].tipo = 6;
Chord4[25].fund = 3;
Chord4[25].di1  = 2;
Chord4[25].di2  = 2;
Chord4[25].di3  = 4;
strcpy(Chord4[25].Nom,"+7");

Chord4[26].tipo = 8;
Chord4[26].fund = 2;
Chord4[26].di1  = 5;
Chord4[26].di2  = 4;
Chord4[26].di3  = 3;
strcpy(Chord4[26].Nom,"");

Chord4[27].tipo = 7;
Chord4[27].fund = 3;
Chord4[27].di1  = 3;
Chord4[27].di2  = 2;
Chord4[27].di3  = 5;
strcpy(Chord4[27].Nom,"7(Sus4)");

Chord4[28].tipo = 2;
Chord4[28].fund = 3;
Chord4[28].di1  = 4;
Chord4[28].di2  = 2;
Chord4[28].di3  = 3;
strcpy(Chord4[28].Nom,"m(Maj7)");

Chord4[29].tipo = 6;
Chord4[29].fund = 3;
Chord4[29].di1  = 3;
Chord4[29].di2  = 1;
Chord4[29].di3  = 4;
strcpy(Chord4[29].Nom,"+(Maj7)");

Chord4[30].tipo = 1;
Chord4[30].fund = 2;
Chord4[30].di1  = 1;
Chord4[30].di2  = 4;
Chord4[30].di3  = 3;
strcpy(Chord4[30].Nom,"Maj7");

Chord4[31].tipo = 3;
Chord4[31].fund = 2;
Chord4[31].di1  = 2;
Chord4[31].di2  = 3;
Chord4[31].di3  = 4;
strcpy(Chord4[31].Nom,"m7");

Chord4[32].tipo = 4;
Chord4[32].fund = 2;
Chord4[32].di1  = 2;
Chord4[32].di2  = 3;
Chord4[32].di3  = 3;
strcpy(Chord4[32].Nom,"m7(b5)");

Chord4[33].tipo = 6;
Chord4[33].fund = 2;
Chord4[33].di1  = 2;
Chord4[33].di2  = 4;
Chord4[33].di3  = 4;
strcpy(Chord4[33].Nom,"+7");

Chord4[34].tipo = 2;
Chord4[34].fund = 4;
Chord4[34].di1  = 6;
Chord4[34].di2  = 3;
Chord4[34].di3  = 5;
strcpy(Chord4[34].Nom,"7");

Chord4[35].tipo = 7;
Chord4[35].fund = 2;
Chord4[35].di1  = 2;
Chord4[35].di2  = 5;
Chord4[35].di3  = 2;
strcpy(Chord4[35].Nom,"7(Sus4");

Chord4[36].tipo = 3;
Chord4[36].fund = 2;
Chord4[36].di1  = 1;
Chord4[36].di2  = 3;
Chord4[36].di3  = 4;
strcpy(Chord4[36].Nom,"m(Maj7)");

Chord4[37].tipo = 6;
Chord4[37].fund = 2;
Chord4[37].di1  = 1;
Chord4[37].di2  = 4;
Chord4[37].di3  = 4;
strcpy(Chord4[37].Nom,"+(Maj7)");

Chord4[38].tipo = 9;
Chord4[38].fund = 1;
Chord4[38].di1  = 3;
Chord4[38].di2  = 4;
Chord4[38].di3  = 5;
strcpy(Chord4[38].Nom,"m");

Chord4[39].tipo = 9;
Chord4[39].fund = 3;
Chord4[39].di1  = 4;
Chord4[39].di2  = 5;
Chord4[39].di3  = 3;
strcpy(Chord4[39].Nom,"m");

Chord4[40].tipo = 9;
Chord4[40].fund = 2;
Chord4[40].di1  = 5;
Chord4[40].di2  = 3;
Chord4[40].di3  = 4;
strcpy(Chord4[40].Nom,"m");

Chord4[41].tipo = 1;
Chord4[41].fund = 1;
Chord4[41].di1  = 2;
Chord4[41].di2  = 2;
Chord4[41].di3  = 3;
strcpy(Chord4[41].Nom,"9");

Chord4[42].tipo = 1;
Chord4[42].fund = 4;
Chord4[42].di1  = 2;
Chord4[42].di2  = 3;
Chord4[42].di3  = 5;
strcpy(Chord4[42].Nom,"9");

Chord4[43].tipo = 1;
Chord4[43].fund = 3;
Chord4[43].di1  = 3;
Chord4[43].di2  = 5;
Chord4[43].di3  = 2;
strcpy(Chord4[43].Nom,"9");


Chord4[44].tipo = 1;
Chord4[44].fund = 2;
Chord4[44].di1  = 5;
Chord4[44].di2  = 2;
Chord4[44].di3  = 2;
strcpy(Chord4[44].Nom,"9");

Chord4[45].tipo = 4;
Chord4[45].fund = 1;
Chord4[45].di1  = 3;
Chord4[45].di2  = 3;
Chord4[45].di3  = 5;
strcpy(Chord4[45].Nom,"m(Maj7)(b5)");

Chord4[46].tipo = 3;
Chord4[46].fund = 1;
Chord4[46].di1  = 2;
Chord4[46].di2  = 1;
Chord4[46].di3  = 4;
strcpy(Chord4[46].Nom,"m7");



// Chord 5

Chord5[1].tipo = 1;
Chord5[1].fund = 1;
Chord5[1].di1  = 2;
Chord5[1].di2  = 2;
Chord5[1].di3  = 3;
Chord5[1].di4   = 4;
strcpy(Chord5[1].Nom,"Maj7/9");

Chord5[2].tipo = 7;
Chord5[2].fund = 3;
Chord5[2].di1  = 3;
Chord5[2].di2  = 2;
Chord5[2].di3  = 2;
Chord5[2].di4   = 3;
strcpy(Chord5[2].Nom,"7(Sus4)");

Chord5[3].tipo = 7;
Chord5[3].fund = 1;
Chord5[3].di1  = 5;
Chord5[3].di2  = 2;
Chord5[3].di3  = 3;
Chord5[3].di4   = 2;
strcpy(Chord5[3].Nom,"7(Sus4)");

Chord5[4].tipo = 2;
Chord5[4].fund = 3;
Chord5[4].di1  = 3;
Chord5[4].di2  = 2;
Chord5[4].di3  = 2;
Chord5[4].di4   = 2;
strcpy(Chord5[4].Nom,"7");

Chord5[5].tipo = 1;
Chord5[5].fund = 3;
Chord5[5].di1  = 4;
Chord5[5].di2  = 1;
Chord5[5].di3  = 2;
Chord5[5].di4   = 2;
strcpy(Chord5[5].Nom,"Maj7");

Chord5[6].tipo = 7;
Chord5[6].fund = 1;
Chord5[6].di1  = 2;
Chord5[6].di2  = 3;
Chord5[6].di3  = 2;
Chord5[6].di4   = 3;
strcpy(Chord5[6].Nom,"7(Sus4)");

Chord5[7].tipo = 7;
Chord5[7].fund = 1;
Chord5[7].di1  = 2;
Chord5[7].di2  = 3;
Chord5[7].di3  = 2;
Chord5[7].di4   = 5;
strcpy(Chord5[7].Nom,"7(Sus4)");

Chord5[8].tipo = 4;
Chord5[8].fund = 1;
Chord5[8].di1  = 3;
Chord5[8].di2  = 2;
Chord5[8].di3  = 1;
Chord5[8].di4   = 4;
strcpy(Chord5[8].Nom,"m7(b5)");

Chord5[9].tipo = 3;
Chord5[9].fund = 1;
Chord5[9].di1  = 2;
Chord5[9].di2  = 1;
Chord5[9].di3  = 4;
Chord5[9].di4   = 3;
strcpy(Chord5[9].Nom,"m7");


strcpy( INames[1].Name, gettext("Bass Drum"));
strcpy(INames[2].Name, gettext("Snares"));
strcpy(INames[3].Name, gettext("Cymballs"));
strcpy(INames[4].Name, gettext("Toms"));
strcpy(INames[5].Name, gettext("Percussion"));
strcpy(INames[6].Name, gettext("Bass Line"));
strcpy(INames[7].Name, gettext("Piano Soli"));
strcpy(INames[8].Name, gettext("Guitar Soli"));
strcpy(INames[9].Name, gettext("String Soli"));
strcpy(INames[10].Name, gettext("Brass  Soli"));
strcpy(INames[11].Name, gettext("Piano Melodic"));
strcpy(INames[12].Name, gettext("Guitar Melodic"));
strcpy(INames[13].Name, gettext("String Melodic"));
strcpy(INames[14].Name, gettext("Brass Melodic"));
strcpy(INames[15].Name, gettext("Piano Harmonic"));
strcpy(INames[16].Name, gettext("Guitar Harmonic"));
strcpy(INames[17].Name, gettext("String Harmonic"));
strcpy(INames[18].Name, gettext("Brass Harmonic"));


  //ALSA init


  snd_seq_open (&MidiOutPuerto[1].midi_out, "hw", SND_SEQ_OPEN_OUTPUT,0);
  snd_config_update_free_global();


  snd_seq_open (&MidiInPuerto[1].midi_in, "hw", SND_SEQ_OPEN_INPUT, 0);
  snd_config_update_free_global();

  char portname[50];

  sprintf (portname, "gmorgan IN");


  pmidi_in = snd_seq_create_simple_port (MidiInPuerto[1].midi_in, portname,
					 SND_SEQ_PORT_CAP_WRITE |
					 SND_SEQ_PORT_CAP_SUBS_WRITE,
					 SND_SEQ_PORT_TYPE_APPLICATION);


  sprintf (portname, "gmorgan OUT");


      pmidi_out =
	snd_seq_create_simple_port (MidiOutPuerto[1].midi_out, portname,
				    SND_SEQ_PORT_CAP_READ |
				    SND_SEQ_PORT_CAP_SUBS_READ,
				    SND_SEQ_PORT_TYPE_APPLICATION);


  FILE *fs;
  char temp[128];
  char nomfile[128];
  sprintf (nomfile, "%s%s", getenv ("HOME"), "/.gmorgan");
  if ((fs = fopen (nomfile, "r")) != NULL)
    {
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2)
      {
      for (i = 0; i <=(int) strlen(temp) - 2; i++)
      MidiInPuerto[1].SetMidiIn[i] = temp[i];
      MidiInPuerto[1].SMidiIn = MidiInPuerto[1].SetMidiIn;
      }
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2)
      {

      for (i = 0; i <= (int) strlen(temp) - 2; i++)
      MidiOutPuerto[1].SetMidiOut[i] = temp[i];
      MidiOutPuerto[1].SMidiOut = MidiOutPuerto[1].SetMidiOut;
      }
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2)  
      for (i = 0; i <= (int) strlen(temp) - 2; i++)
      SoundsFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2) for (i = 0; i <= (int)strlen(temp) - 2; i++)
      PatternsFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2) for (i = 0; i <= (int)strlen(temp) - 2; i++)
      StylesFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2) for (i = 0; i <= (int)strlen(temp) - 2; i++)
      PresetFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2) for (i = 0; i <= (int)strlen(temp) - 2; i++)
      DrumNoteFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2)for (i = 0; i <= (int)strlen(temp) - 2; i++)
      SkinFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2) for (i = 0; i <= (int)strlen(temp) - 2; i++)
      SkinNombre[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      sscanf(temp, "%d",&MutesOnOff);      
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2) for (i = 0; i <= (int)strlen(temp) - 2; i++)
      HelpFilename[i] = temp[i];
      bzero (temp, sizeof (temp));
      fgets (temp, sizeof temp, fs);
      if (strlen(temp)>2) for (i = 0; i <= (int)strlen(temp) - 2; i++)
      LibStylesFilename[i] = temp[i];


      fclose(fs);
      }

if (SoundsFilename[0] != '0')
{
              prime=1;
              ulti=100;
              loadfile(SoundsFilename);
}

if (PatternsFilename[0] != '0')
{
              prime=1;
              ulti=500;
              loadpatt(PatternsFilename);
}


if (StylesFilename[0] != '0')
{
              prime=1;
              ulti=100;
              loadstyl(StylesFilename);
}


if (PresetFilename[0] != '0')
{
              prime=1;
              ulti=100;
              loadpreset(PresetFilename);
}



if (DrumNoteFilename[0] != '0')
{
              prime=1;
              ulti=100;
              loaddrumset(DrumNoteFilename);
}



if (SkinFilename[0] != '0')
{
              BuscaSkindir();
}
  espera = 1;

};


GMO::~GMO ()
{
  snd_seq_close (MidiOutPuerto[1].midi_out);
  snd_seq_close (MidiInPuerto[1].midi_in);
};


void 

GMO::MiraChord()
{
int i,j;
int anote[POLY];
int onote[POLY];
int nnotes=0;
int posi = 0;
int baja,ubaja;
int busca=0;
char AName[16];

pafuera = 0;
chord = 0;

for (i=0; i<=POLY; i++) 
	{
	if (( note_active[i] == 1) && (rnote[i] < 60))
		{
                anote[nnotes] = rnote[i];
 		nnotes++;
		}
	}


if (nnotes == 1)

{
fundi = anote[0] % 12;
unasolo = 1;
return;
}
else
{
unasolo = 0;
}



if ((nnotes < 3) || (nnotes > 5) ) return;

while(posi<nnotes)
{
        baja=400;

	for (i=0; i<nnotes; i++)
	{
 	if (anote[i] <= baja)
		{ 
		onote[posi] = anote[i];
                ubaja=baja;	
        	baja = anote[i];
                pafuera = i;
                }
        }
        baja = ubaja;
        anote[pafuera]= 1000;
        posi++;
}


if (nnotes == 3)
   {

	di1=onote[1] - onote[0];
	di2=onote[2] - onote[1];

	j =0;

 	while(busca==0)

	{
	j++;
	if ((Chord3[j].di1 == di1) && (Chord3[j].di2 == di2))
		{ 
    			busca = 1;
    			chord = j;
                        ctipo = Chord3[j].tipo;                       
                        break;
		}    
 
        if (j > 10 ) break;
	}

	if (chord != 0)
	{
	
   	        int elke = onote[Chord3[chord].fund-1];
                fundi = elke % 12;
                if (ya==0)
                {
                   ya=1;
                   nfundi=fundi;
                   
                }
		sprintf(AName,"%s%s",NC[fundi].Nom,Chord3[chord].Nom);
                
                if (strcmp(AName, NombreAcorde) != 0)
                { 
                if (HMode != 0) ActuHar();
                strcpy(NombreAcorde,AName);
                cambialo = 1;
		}
	}
     return;
   }

if (nnotes == 4)
   {

        di1=onote[1] - onote[0];
        di2=onote[2] - onote[1];
        di3=onote[3] - onote[2];
        j =0;

        while(busca==0)

        {
        j++;
        if ((Chord4[j].di1 == di1) && (Chord4[j].di2 == di2) && (Chord4[j].di3 == di3))
                {
                        busca = 1;
                        chord = j;
                        ctipo = Chord4[j].tipo;
                        break;
                }

        if (j > 46 ) break;
        }

        if (chord != 0)
        {
                int elke = onote[Chord4[chord].fund-1];
                fundi = elke % 12;
                if (ya==0)
                {
                   ya=1;
                   nfundi=fundi;
                   
                }

                sprintf(AName,"%s%s",NC[fundi].Nom,Chord4[chord].Nom);
                if (strcmp(AName, NombreAcorde) != 0)
                {
                if (HMode != 0) ActuHar();
                strcpy(NombreAcorde,AName);
                cambialo = 1;
                }

                
        }
        return;

   }

if (nnotes == 5)
   {

        di1=onote[1] - onote[0];
        di2=onote[2] - onote[1];
        di3=onote[3] - onote[2];
        di4=onote[4] - onote[3];
        j =0;

        while(busca==0)

        {
        j++;
        if ((Chord5[j].di1 == di1) && (Chord5[j].di2 == di2) && (Chord5[j].di3 == di3) && (Chord5[j].di4 == di4))
                {
                        busca = 1;
                        chord = j;
                        ctipo = Chord5[j].tipo;
                        break;
                }

        if (j > 9 ) break;
        }

        if (chord != 0)
        {
                int elke = onote[Chord5[chord].fund-1];
                fundi = elke % 12;
                if (ya==0)
                {
                   ya=1;
                   nfundi=fundi;
                   
                }
                sprintf(AName,"%s%s",NC[fundi].Nom,Chord5[chord].Nom);
                if (strcmp(AName, NombreAcorde) != 0)
                {
                if (HMode != 0) ActuHar();
                strcpy(NombreAcorde,AName);
                cambialo = 1;
                }

                
        }

   }




};



void
GMO::organo()
{
if (stst==0) return;
tick = get_tick();
if ((tick - atick) >= 64) 

{       
        atick = tick;        
        semi++;
        if (semi==5)
	{
	semi=1;
	negra++;
	count++;
	if (count >= Rt[sp].blackn +1)
		{
		elbar++;
		if (elbar> Rt[sp].bars) elbar = 1;
		negra = 0;
		count = 1;
		ncompas++;
              	sprintf(elbart, "%d",ncompas+1);
	
                if ((bplay == 0) && (GUIPlay == 1)) MiraGuia();
		if (bplay)
		{
			nb++;
                        if (S[nb].fin == 1) finito = 1;
                        sprintf(elnb, "%d",nb);                   
                        nb = mirasaltos(nb);        
                        sprintf(elnb, "%d",nb);	
              	        if (S[nb].pattern != 0)
			      {
  			       sp = S[nb].pattern;
                               sposi = 0;
 			       cambiapat = 1;
                               MeteMixerMidi(sp);
			       }
        	}                 
		}
        if ((bplay) && (MTempo)) UsaTempoTrack();
	if (bplay) GeneraChord(); 
        if (KeybON) GeneraChord();
        if ((bplay == 0) && (KeybON == 0)) MiraChord();
	}

if ((bplay) && (S[nb].ar8 == 1) && (count == SNomi) && (semi == 3))
{
  anticipa =1;
  GeneraChord();
}
if ((bplay) && (S[nb].ar16 == 1) && (count == SNomi) && (semi == 4))
{
  anticipa =1;
  GeneraChord();
}

	accompaniment();

}
};

void

GMO::EPlay()
{

int i;
snd_seq_tick_time_t ptick;


ptick = get_tick();

if (ptick > ultimotick)  paraplay  = 1;

for (i=0; i<256; i++)
{

if (EG[cs].tipo == 0 ) cs++;

   if ((EG[cs].tick - ptick) < 1024)
         {
if (EG[cs].tipo != 0) 
             {
          PonPlay(EG[cs].tipo, EG[cs].tick, EG[cs].nota,EG[cs].canal,EG[cs].velocity,EG[cs].length);
	  cs++;
          if ((EG[cs].tick+EG[cs].length) > ultimotick) ultimotick = EG[cs].tick+EG[cs].length ;
             }
         }
   
}
};

void
GMO::PonPlay(int tipo, snd_seq_tick_time_t gtick, int gnota, int gcanal, int gvelocity, int glength)
{

snd_seq_event_t ev;
snd_seq_ev_clear(&ev);

switch(tipo)
       {
      case 1:
          snd_seq_ev_set_note(&ev, gcanal, gnota, gvelocity, glength);
          break;
      case 2:
          snd_seq_ev_set_note(&ev, gcanal, gnota, gvelocity, glength);
          break;
      case 3:
          snd_seq_ev_set_controller(&ev,gcanal,gnota,gvelocity);
          break;
      case 4:
          snd_seq_ev_set_pgmchange(&ev,gcanal,gnota);
          break;

        }

     if ((tipo>0) && (tipo<5))
          {
          snd_seq_ev_schedule_tick(&ev, queue_id,  0, gtick);
          snd_seq_ev_set_source(&ev, pmidi_in);
          snd_seq_ev_set_subs (&ev);
          snd_seq_event_output_direct(MidiOutPuerto[1].midi_out, &ev);
          } 

};

void 
GMO::PonGraba(int tipo, snd_seq_tick_time_t gtick, int gnota, int gcanal, int gvelocity, int
glength, int gcontrol, int gvalue, int gprograma)

{

int i;

grabaconta++;


if (grabaconta >= 64000) printf(gettext("Record Memory Full\n"));
if (grabaconta < 64000)

{
  switch(tipo)
    {
     case 1:  
        EG[grabaconta].tipo = tipo;
        EG[grabaconta].tick = gtick;
        EG[grabaconta].nota = gnota;
        EG[grabaconta].canal = gcanal;
        EG[grabaconta].velocity = gvelocity;
        EG[grabaconta].length = glength; 
        break;
     case 2:
        if (gvelocity != 0)         
        {
        EG[grabaconta].tipo = tipo;
        EG[grabaconta].tick = gtick;
        EG[grabaconta].nota = gnota;
        EG[grabaconta].canal = gcanal;
        EG[grabaconta].velocity = gvelocity;
        EG[grabaconta].length = glength;
        }
        if (gvelocity == 0)
        {
        for (i=grabaconta; i>=1; i--)
            {
             if ((EG[i].tipo == tipo) && (EG[i].canal == gcanal) && (EG[i].nota == gnota))
                     { 
                      EG[i].length = gtick - EG[i].tick;         
                      grabaconta--;
                        break;
                        
                     }
             }
         }
        break;

        case 3:
        EG[grabaconta].tipo = tipo;
        EG[grabaconta].tick = gtick;
        EG[grabaconta].canal = gcanal;
        EG[grabaconta].nota = gcontrol;
        EG[grabaconta].velocity = gvalue;
        break;

        case 4:
        EG[grabaconta].tipo = tipo;
        EG[grabaconta].tick = gtick;
        EG[grabaconta].canal = gcanal;
        EG[grabaconta].nota = gprograma;
        break;



    }     
}


};

void
GMO::miranota(int i)
{


        int k;
        if ((fundi != ulfundi) || (unasolo == 1))
        {
        lanota = 1;
        k = -1;
        ulfundi = fundi;
        }
        else
        {
        switch(i)
        {
        case 1:  
        lanota = Rt[sp].basn[0][sposi];
        break;
        case 2:
        lanota = Rt[sp].acc2n[0][sposi];
        break;
        case 3:
        lanota = Rt[sp].acc3n[0][sposi];
        break;
        case 4:
        lanota = Rt[sp].acc4n[0][sposi];
        break;
        case 5:
        lanota = Rt[sp].acc5n[0][sposi];
        break;

        }
        (lanota > 0 ) ? k=-1 : k=1;

       if (lanota > 0)
        {
        if ((lanota % 12 == 5) ||  (lanota == 5) ) lanota += TCh[ctipo].ter;
        if ((lanota % 12 == 8) ||  (lanota == 8) ) lanota += TCh[ctipo].qui;
        if ((lanota % 12 == 0) ||  (lanota == 12)) lanota += TCh[ctipo].sep;
        }
        else
        {
        if ((lanota == -9) || lanota % 12 == -9 ) lanota += TCh[ctipo].ter;
        if ((lanota == -6) || lanota % 12 == -6 ) lanota += TCh[ctipo].qui;
        if ((lanota == -2) || lanota % 12 == -2) lanota += TCh[ctipo].sep;
        }


        }
        notabajo = lanota + k + fundi + 24;

};

void
GMO::miranotam2(int i)
{

        int k;
        int afundi;
        int sino=0;
        if (ya==0) afundi = fundi; else afundi=nfundi;
        switch(i)
        {
           case 2:
        	lanota = Rt[sp].acc2n[0][sposi];
        	break;
           case 3:
        	lanota = Rt[sp].acc3n[0][sposi];
        	break;
           case 4:
        	lanota = Rt[sp].acc4n[0][sposi];
        	break;
           case 5:
        	lanota = Rt[sp].acc5n[0][sposi];
        	break;
        }
           
        (lanota > 0 ) ? k=-1 : k=1;
    

       if (lanota > 0)
        {
        if ((lanota % 12 == 5) ||  (lanota == 5) ) lanota += TCh[ctipo].ter;
        if ((lanota % 12 == 8) ||  (lanota == 8) ) lanota += TCh[ctipo].qui;
        if ((lanota % 12 == 0) ||  (lanota == 12)) lanota += TCh[ctipo].sep;
        }
        else
        {
        if ((lanota == -9) || lanota % 12 == -9 ) lanota += TCh[ctipo].ter;
        if ((lanota == -6) || lanota % 12 == -6 ) lanota += TCh[ctipo].qui;
        if ((lanota == -2) || lanota % 12 == -2) lanota += TCh[ctipo].sep;
        }

        notabajo = lanota + afundi + k + 24;
         
        if (fundi != afundi)
        { 
        if (notabajo ==  1 + k + fundi + 24) sino = 1;
        if (notabajo ==  13 + k + fundi + 24) sino = 1;
        if (notabajo ==  26 + k + fundi + 24) sino = 1;
        if (notabajo ==  -13 + k + fundi + 24) sino = 1;
        if (notabajo ==  -25 + k + fundi + 24) sino = 1; 
        if (notabajo ==  5 + k + fundi + TCh[ctipo].ter + 24) sino = 1;
        if (notabajo ==  17 + k + fundi + TCh[ctipo].ter + 24) sino = 1;
        if (notabajo ==  29 + k + fundi + TCh[ctipo].ter + 24) sino = 1;
        if (notabajo == -9 + k + fundi + TCh[ctipo].ter + 24) sino = 1;
        if (notabajo == -21 + k + fundi + TCh[ctipo].ter + 24) sino = 1;
        if (notabajo == -33 + k + fundi + TCh[ctipo].ter + 24) sino = 1;
        if (notabajo ==  8 + k + fundi + TCh[ctipo].qui  + 24) sino = 1;
        if (notabajo ==  20 + k + fundi + TCh[ctipo].qui  + 24) sino = 1;
        if (notabajo ==  32 + k + fundi + TCh[ctipo].qui  + 24) sino = 1;
        if (notabajo == -6 + k + fundi + TCh[ctipo].qui + 24) sino = 1;
        if (notabajo == -18 + k + fundi + TCh[ctipo].qui + 24) sino = 1;
        if (notabajo == -30 + k + fundi + TCh[ctipo].qui + 24) sino = 1;
        if (notabajo == 12 + k + fundi + TCh[ctipo].sep + 24) sino = 1;
        if (notabajo == 24 + k + fundi + TCh[ctipo].sep + 24) sino = 1;
        if (notabajo == 36 + k + fundi + TCh[ctipo].sep + 24) sino = 1; 
        if (notabajo == -2 + k + fundi + TCh[ctipo].sep + 24) sino = 1;        
        if (notabajo == -14 + k + fundi + TCh[ctipo].sep + 24) sino = 1;
        if (notabajo == -26 + k + fundi + TCh[ctipo].sep + 24) sino = 1; 

        if (sino ==0) notabajo = fundi + 24;
        }

};

void
GMO::miranotam3(int i)
{

        int k;
        switch(i)
        {
           case 2:
        	lanota = Rt[sp].acc2n[0][sposi];
        	break;
           case 3:
        	lanota = Rt[sp].acc3n[0][sposi];
        	break;
           case 4:
        	lanota = Rt[sp].acc4n[0][sposi];
        	break;
           case 5:
        	lanota = Rt[sp].acc5n[0][sposi];
        	break;
        
        }
           
        (lanota > 0 ) ? k=-1 : k=1;
        if (lanota > 12) lanota = lanota % 12;        
        if (lanota < -12) lanota = (lanota % 12) -12;
        switch(lanota)
        {
        case -12:
        lanota = 1;
        break;
        case -11:
        lanota = 1;
        break;
        case -10:
        lanota = -9;
        break;
        case -8:
        lanota = -9;
        break;
        case -7:
        lanota = -6;
        break;
        case -5:
        lanota = -6;
        break;
        case -4:
        lanota = -2;
        break;
        case -3:
        lanota = -2;   
        break;   
        case 2:
        lanota = 1;
        break;
        case 3:
        lanota = 1;
        break;
        case 4:
        lanota = 5;
        break;
        case 6:
        if ((ctipo == 3) || (ctipo == 4) || (ctipo == 9)) lanota = 6; else 
        lanota = 5;
        break;
        case 7:
        lanota = 8;
        break; 
        case 9:
        lanota = 8;
        break;
        case 10:
        if (( ctipo == 8) || (ctipo == 10) || (ctipo == 1)) lanota = 10; else
        lanota = 12;
        break;
        case 11:
        lanota = 12;
        case 0:
        lanota = 12;
        break;
        }
        switch(lanota)
        { 
        case -9:
        lanota += TCh[ctipo].ter;
        break;
        case -6:
        lanota += TCh[ctipo].qui;
        break;
        case -2:
        lanota += TCh[ctipo].sep;
        break;
        case 5:
        lanota += TCh[ctipo].ter;
        break;
        case 8:
        lanota += TCh[ctipo].qui;
        break;
        case 12:
        lanota += TCh[ctipo].sep;
        break;
        
        }
        notabajo = lanota + fundi + k + 24;
  
};




void 
GMO::accompaniment() {

  int i,j,altinoti;
  int parte = 0;
  int mcanal = 0;
  int elcontrol;
  int note;
  int maxposi;
  int fillposi;
  int la1;
  int la3;
  int la5;
  int la7;
  int conh=0;
  int lavelo = 0;
  int laresta = 0;

  sposi++;
  if (mezcla != 0)
  {
   maxposi = Rt[sp].bars*Rt[sp].blackn*4;
   fillposi= Rt[mezcla].bars*Rt[sp].blackn*4;
   
       if (sposi > (maxposi - fillposi))
          {
           sposi = sposi % (Rt[sp].blackn * 4);
           sp = mezcla;
           mezcla = 0;
          }
   }


  maxposi = Rt[sp].bars*Rt[sp].blackn*4;

   if (finito==1)
    {
     finito=0;
     stst = 0;
     ponfin = 1;
     return;
    }


  if (sposi>maxposi) 
  {  
    sposi = 1;
   if (nextp != 0)
    { 
      sp = nextp;
      elbar = 1;
      nextpm = nextp;
      nextp = 0;   
      actunex = 1;
      MeteMixerMidi(sp);
    }
   }


for (i=1; i<=31; i++)

 {

   elcontrol=200+i;
           
 for (j=1; j<=7; j++)
  {
     switch(j)
        {
          case 1:
             parte = 5;
             mcanal= 4;
             break;
          case 2:
             parte = 6;
             mcanal= 5;
             break;
          case 3:
             parte = 9;
             mcanal= 7;
             break;
          case 4:
             parte = 10;
             mcanal= 8;
             break;
          case 5:
             parte = 11;
             mcanal= 10;
             break;
          case 6:
             parte = 7;
             mcanal= 6;
             break;
          case 7:
             parte = 8;
             mcanal= 9;
             break;
        } 


   valorctrl = Ectrl[j][i][sposi];


        if (valorctrl != 0)
               { 
             if (OnOff[parte])
                  {
                    enviocontrol(parte,elcontrol,mcanal);
                  }
               } 
                   
     }
    }

  if (OnOff[8])
  {
  
  for (i=1; i<=61; i++)
  { 
    
    if (Edr[i][sposi] != 0)
         {
          lavelo = Edr[i][sposi] + veloplus[i];
          if (lavelo > 127) lavelo = 127;
          if (lavelo < 0 ) lavelo = 0;
          sacaev(9,i+26,lavelo,8);
         }
    
  }
  }



    if ((OnOff[5]) && (Rt[sp].acc1n[1][sposi] != 0))
   
    { 
      if (Rt[sp].acc1n[0][sposi] != 0 ) duracion = (int) (TICKS4+Rt[sp].acc1stlt)/Rt[sp].acc1n[0][sposi];
      for (i=0; i<POLY; i++)
      {
       if ((note_active[i]) || (gate[i])) 
         { note =rnote[i]+12; 
           note += (12 * Rt[sp].acc1octa);
          sacaev(4,note+transpose,Rt[sp].acc1n[1][sposi],duracion);
         }                   
      }
    }

       if ((OnOff[6]) && (Rt[sp].acc2n[0][sposi] != 0))
       {

        if (Rt[sp].terceras) laresta = -3;
        if (Rt[sp].sextas) laresta = -7;  


        switch(Rt[sp].acc2mode)
        {
         case 0:
         miranota(2);
         break;
         case 1:
         miranotam2(2);
         break;
         case 2:
         miranotam3(2);
         break;
        }
        if (Rt[sp].acc2n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc2stlt)/Rt[sp].acc2n[2][sposi];
        notabajo += (12 * Rt[sp].acc2octa);
        sacaev(5,notabajo+48+transpose,Rt[sp].acc2n[1][sposi],duracion);
        if (Rt[sp].octavate) sacaev(5,notabajo+36+transpose,Rt[sp].acc2n[1][sposi],duracion);
        if ((Rt[sp].terceras) || (Rt[sp].sextas))
         {

         la1 = fundi + 0;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;

      for (i = notabajo+laresta+48+transpose; i>=notabajo+36+transpose; i--)
        {
                if ((i % 12 == la1 ) || (i % 12 == la3) || (i % 12 == la5) || ( i % 12 == la7 ))
                   {
                     sacaev(5,i,Rt[sp].acc2n[1][sposi],duracion);
                     break;
                   }
         }

         }


       }


     if ((OnOff[7]) && (Rt[sp].basn[0][sposi] != 0))
       {
        if ((bplay == 0) && (KeybON == 0))  MiraChord();
        miranota(1);
        notabajo += (12 * Rt[sp].bassocta);
        if (Rt[sp].basn[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].bassstlt)/Rt[sp].basn[2][sposi];
        sacaev(6,notabajo+transpose,Rt[sp].basn[1][sposi],duracion);
        
       }

      if ((OnOff[9]) && (Rt[sp].acc3n[0][sposi] != 0))
       {
        switch(Rt[sp].acc3mode)
        {
         case 0:
         miranota(3);
         break;
         case 1:
         miranotam2(3);
         break;
         case 2:
         miranotam3(3);
         break;
        }
        if (Rt[sp].acc3n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc3stlt)/Rt[sp].acc3n[2][sposi];
        notabajo += (12 * Rt[sp].acc3octa);
        sacaev(7,notabajo+36+transpose,Rt[sp].acc3n[1][sposi],duracion);
      
         la1 = fundi + 0;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;          

      for (i = notabajo-2+36; i>=notabajo -14+36; i--)
        {
           
          if ((i % 12 == la3 ) || (i % 12 == la7) || (i % 12 == la5) || (i % 12 ==la1))
                   {
                    conh++;
                    if (i>=40) altinoti = i; else altinoti = i + 12;
                    sacaev(7,altinoti+transpose,Rt[sp].acc3n[1][sposi],duracion);   
                    if (conh == 3) break; 
                   }
                
         if (conh == 3) break;
        }

   }    

       if ((OnOff[10]) && (Rt[sp].acc4n[0][sposi] != 0))
       {

        if (Rt[sp].terceras4) laresta = -3;
        if (Rt[sp].sextas4) laresta = -7;  


        switch(Rt[sp].acc4mode)
        {
         case 0:
         miranota(4);
         break;
         case 1:
         miranotam2(4);
         break;
         case 2:
         miranotam3(4);
         break;
        }
        if (Rt[sp].acc4n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc4stlt)/Rt[sp].acc4n[2][sposi];
        notabajo += (12 * Rt[sp].acc4octa);
        sacaev(8,notabajo+48+transpose,Rt[sp].acc4n[1][sposi],duracion);
        if (Rt[sp].octavate4) sacaev(8,notabajo+36+transpose,Rt[sp].acc4n[1][sposi],duracion);
        if ((Rt[sp].terceras4) || (Rt[sp].sextas4))
         {

         la1 = fundi + 0;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;

      for (i = notabajo+laresta+48+transpose; i>=notabajo+36+transpose; i--)
        {
                if ((i % 12 == la1 ) || (i % 12 == la3) || (i % 12 == la5) || ( i % 12 == la7 ))
                   {
                     sacaev(8,i,Rt[sp].acc4n[1][sposi],duracion);
                     break;
                   }
         }

         }


       }

      if ((OnOff[11]) && (Rt[sp].acc5n[0][sposi] != 0))
       {
        switch(Rt[sp].acc5mode)
        {
         case 0:
         miranota(5);
         break;
         case 1:
         miranotam2(5);
         break;
         case 2:
         miranotam3(5);
         break;
        }
        if (Rt[sp].acc5n[2][sposi] != 0) duracion = (int) (TICKS4+Rt[sp].acc5stlt)/Rt[sp].acc5n[2][sposi];
        notabajo += (12 * Rt[sp].acc5octa);
        sacaev(10,notabajo+36+transpose,Rt[sp].acc5n[1][sposi],duracion);
      
         la1 = fundi + 0;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;          

      for (i = notabajo-2+36; i>=notabajo -14+36; i--)
        {
           
          if ((i % 12 == la3 ) || (i % 12 == la7) || (i % 12 == la5) || (i % 12 ==la1))
                   {
                    conh++;
                    if (i >= 40 ) altinoti = i; else altinoti = i+12;
                    sacaev(10,altinoti+transpose,Rt[sp].acc5n[1][sposi],duracion);   
                    if (conh == 3) break; 
                   }
                
         if (conh == 3) break;
        }

   }    



};


void 
GMO::ActuHar()
{

int j,i;

if (HMode == 0) return;

for (j=60; j<=108; j++)

{

      if ((OnOff[3] == 1) && ( HarOFF[0][j].estado == 1))
           {
               for (i=1; i<=HarOFF[0][j].nnotas; i++) suenaev(2,HarOFF[0][j].notas[i]+transpose,0);
               harmonize(HMode,0,2, j,HarOFF[0][j].velo, 0);
           }
      if ((OnOff[4] == 1 ) && (HarOFF[1][j].estado == 1))
           {
               for (i=1; i<=HarOFF[1][j].nnotas; i++) suenaev(3,HarOFF[1][j].notas[i]+transpose,0);
               harmonize(HMode,0,3, j,HarOFF[0][j].velo, 0);
           }


    
}

};





 void 
GMO::harmonize(int hm, int sons, int channel, int note, int velo, int dur)

{

int i;
int contanota = 0; 
int la1;
int la3;
int la5;
int la7;


if (velo == 0)
{
 HarOFF[channel-2][note].estado = 0;
 for (i=1; i<=HarOFF[channel-2][note].nnotas; i++)
 
    suenaev(channel, HarOFF[channel-2][note].notas[i]+transpose,0);

 return;
}


for (i=0; i<=5; i++) hnotes[i]=0;

         la1 = fundi + 0;
         la3 = fundi + 4 + TCh[ctipo].ter;
         la5 = fundi + 7 + TCh[ctipo].qui;
         la7 = fundi + 11 + TCh[ctipo].sep;


for (i = note+HM[hm].dist; i>=note+HM[hm].dist-12; i--)
        {
                if ((i % 12 == la1 ) || (i % 12 == la3) || (i % 12 == la5) || ( i % 12 == la7 ))
                   {
                     contanota++;
                     hnotes[contanota] = i;
                     if (contanota == HM[hm].notes) break;
                   }

         }

HarOFF[channel-2][note].estado = 1;
HarOFF[channel-2][note].nnotas = contanota;
HarOFF[channel-2][note].velo = velo-20;

for (i=1; i<=contanota; i++)

{

  if (sons) sacaev(channel, hnotes[i]+transpose, velo-20, dur); 
 
 else 

	{
  	 HarOFF[channel-2][note].notas[i] = hnotes[i];
    	suenaev(channel, hnotes[i]+transpose, velo-20);
	}
}



};


void
GMO::GeneraChord()
{
int i,nn,qfundi,labase;
int aocta=4;
int qc = 0;
char elacorde[32];
char prefundi[8];
char sufijo[16];

nn=0;
bzero(elacorde,sizeof(elacorde));
bzero(prefundi,sizeof(prefundi));
bzero(sufijo,sizeof(sufijo));


if (KeybON) 
{
nn = 4;
strcpy(elacorde,NombreAcorde);
}


if (bplay)
{
switch(count)
   {
    case 1:
    strcpy(elacorde,S[nb].ch1);
    break;
    case 2:
    strcpy(elacorde,S[nb].ch2);
    break;
    case 3:
    strcpy(elacorde,S[nb].ch3);
    break;
    case 4:
    strcpy(elacorde,S[nb].ch4);
    break;
   }
}


if ((bplay) && (anticipa))
{
 anticipa = 0;
 strcpy(elacorde,S[nb+1].ch1);
}



if (strlen(elacorde) == 0) return;

strcpy(Delacorde,elacorde);
cambiaacorde = 1;   
 
if (( elacorde[1] == 'b')  || (elacorde[1] == '#')) 
	{
	for (i=0; i<=1; i++) prefundi[i] = elacorde[i];
	for (i=2; i<=(int) strlen(elacorde); i++) sufijo[i-2]=elacorde[i];
	}
else 
	{
	prefundi[0] = elacorde[0];
        for(i=1; i<=(int) strlen(elacorde); i++) sufijo[i-1]=elacorde[i];
        }

for (i=0; i<=18; i++)
{
  if (strcmp(NCE[i].Nom,prefundi) == 0) 
     { 
          lfundi = fundi;
          if (bplay) fundi = NCE[i].note;
          qfundi = fundi;
          break;
     }
}


if (ya==0)

{
 nfundi = fundi;
 ya = 1;
}


chord = 0;



for(i=1; i<=10; i++)

{
  if ((strcmp(Chord3[i].Nom,sufijo) == 0) && (Chord3[i].fund == 1))

       {
        chord = i;
        ctipo = Chord3[i].tipo;
        nn = 3;
        break;
       }
}


if (chord == 0)
{

for(i=1; i<=46; i++)
{
  if ((strcmp(Chord4[i].Nom,sufijo) == 0) && (Chord4[i].fund == 1))

       {
        chord = i;
        ctipo = Chord4[i].tipo;
        nn = 4;
        break;
       }
} 
}

if (chord == 0)
{

for(i=1; i<=9; i++)
{
  if ((strcmp(Chord5[i].Nom,sufijo) == 0) && (Chord5[i].fund == 1))

       {
        chord = i;
        ctipo = Chord5[i].tipo;
        nn = 5;
        break;
       }
}
}

if (chord == 0) return;


for (i=0; i<=POLY; i++)  note_active[i] = 0;


if (abs (fundi - lfundi) > 3 ) 
{
if (inversion == 3) inversion = 1; 
else 
{
inversion=3;   
qc = 1;
}
}


if (inversion == 3)
{
    
    switch(nn)
        {
         case 3:
         if (chord == Chord3[chord].inv3)
         { 
         inversion = 1;
         break;
         }
         else
         { 
         chord = Chord3[chord].inv3;
         break;
         }
         case 4:
         if (chord == Chord4[chord].inv3)
         { 
         inversion = 1;
         break;
         }
         else
         {
         chord = Chord4[chord].inv3;
         break;
         }
         case 5:
         if (chord == Chord5[chord].inv3)
         { 
         inversion = 1;
         break;
         }
         else
         {
         chord = Chord5[chord].inv3;
         break;
         }
        }

}


if (nn==3)
{
   d1 = Chord3[chord].di1;
   d2 = Chord3[chord].di2;
}

if (nn==4)
{
   d1 = Chord4[chord].di1;
   d2 = Chord4[chord].di2;
   d3 = Chord4[chord].di3;
}

if (nn==5)
{
   d1 = Chord5[chord].di1;
   d2 = Chord5[chord].di2;
   d3 = Chord5[chord].di3;
   d4 = Chord5[chord].di4;
}


if (inversion == 3) qfundi = fundi -d1 -d2; else qfundi = fundi;



if (((qfundi - lfundi) < -8) && (qc == 1)) aocta++;

labase = (aocta*12) + qfundi;


note_active[0]=1;
rnote[0]=labase;
note_active[1]=1;
rnote[1]=labase+d1;
note_active[2]=1;
rnote[2]=labase+d1+d2;

if (nn>3)
 {
  note_active[3]=1;
  rnote[3]=labase+d1+d2+d3;
 }
if (nn>4) 
{
note_active[4]=1;
rnote[4]=labase+d1+d2+d3+d4;
}

};


void
GMO::BuscaRepes()
{

int i;

for (i=1; i<=128; i++)
{

  if (S[i].times != 0) Repe[i].times = S[i].times; else Repe[i].times = 0;
  if (S[i].atimes !=0) Salta[i].times = S[i].atimes; else Salta[i].times = 0;
  Salta[i].pasa = 0;
}

};

int
GMO::mirasaltos(int nb)
{

                if (strlen(S[nb].go_to) != 0)
                        {
                elchardm = S[nb].go_to[0];
                if (elchardm > 90) elchardm -= 32; 
			switch(elchardm)
				{
                                case 'A':
                                if (Repe[nb].times > 0) 
                                {
                                Repe[nb].times--;
                                nb = BuscaM(1);
                                }
                                break;
       				case 'B':
                                if (Repe[nb].times > 0) 
                                {
                                Repe[nb].times--;
                                nb = BuscaM(2);
       				}
                                break;
       				case 'C':
                                if (Repe[nb].times > 0)
                                {
                                Repe[nb].times--;
       				nb = BuscaM(3);
                                }
       				break;
       				case 'D':
                                if (Repe[nb].times > 0)
                                {
                                Repe[nb].times--;
       				nb = BuscaM(4);
                                }
       				break;
                                case 'E':
                                if (Repe[nb].times > 0) 
                                {
                                Repe[nb].times--;
                                nb = BuscaM(5);
                                }
       				break;
       				case 'F':
                                if (Repe[nb].times > 0) 
                                {
                                Repe[nb].times--;
                                nb = BuscaM(6);
       				}
                                break;
       				case 'G':
                                if (Repe[nb].times > 0)
                                {
                                Repe[nb].times--;
       				nb = BuscaM(7);
                                }
       				break;
       				case 'H':
                                if (Repe[nb].times > 0)
                                {
                                Repe[nb].times--;
       				nb = BuscaM(8);
                                }
       				break;
                                }  
			  sprintf(elnb, "%d",nb);
                          if (Repe[nb].times == 0) Repe[nb].times = S[nb].times;	
                           }
			
                   if (strlen(S[nb].go_af) != 0)
                        {
                     elchardm = S[nb].go_af[0];
                     if (elchardm > 90) elchardm -= 32;
			switch(elchardm)
				{
                                case 'A':
                                if (Salta[nb].times > 0) 
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times) 
                                {
                                nb = BuscaM(1);
                                Salta[nb].pasa = 0;
                                }
                                }
              			break;
       				case 'B':
                                if (Salta[nb].times > 0) 
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times)
                                {
                                nb = BuscaM(2);
                                Salta[nb].pasa = 0;
                                }
       				}
                                break;
       				case 'C':
                                if (Salta[nb].times > 0)
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times)
                                {
       				nb = BuscaM(3);
                                Salta[nb].pasa = 0;
                                }
                                }
       				break;
       				case 'D':
                                if (Salta[nb].times > 0)
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times)
                                {
       				nb = BuscaM(4);
                                Salta[nb].pasa = 0;
                                }
                                }
       				break;
                                case 'E':
                                if (Salta[nb].times > 0) 
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times)
                                {
                                nb = BuscaM(5);
                                Salta[nb].pasa = 0;
                                }
                                }
       				break;
       				case 'F':
                                if (Salta[nb].times > 0) 
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times)
                                {
                                nb = BuscaM(6);
                                Salta[nb].pasa = 0;
                                }
       				}
                                break;
       				case 'G':
                                if (Salta[nb].times > 0)
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times)
                                {
       				nb = BuscaM(7);
                                Salta[nb].pasa = 0;
                                }
                                }
       				break;
       				case 'H':
                                if (Salta[nb].times > 0)
                                {
                                Salta[nb].pasa++;
                                if (Salta[nb].pasa == Salta[nb].times)
                                {
       				nb = BuscaM(8);
                                Salta[nb].pasa = 0;
                                }
                                }
       				break;
				}
                                
			  sprintf(elnb, "%d",nb);
                          }

return(nb);

};



