close all;
clear all;

%% l2 [Order][Mesh]

%% f = [Sin(10x),  Sin(10y)]

h = [1, 1/2, 1/4, 1/8, 1/16];
p = [1:5];

l2 = ...
    [...
        +9.645400e-01 , +7.342356e-01 , +1.986197e-01 , +5.400477e-02 , +1.330963e-02 ; ...
        +8.820920e-01 , +2.701048e-01 , +5.313349e-02 , +7.105430e-03 , +9.375183e-04 ; ...
        +8.444977e-01 , +1.141940e-01 , +6.927607e-03 , +4.322385e-04 , +2.521169e-05 ; ...
        +2.973276e-01 , +2.314744e-02 , +1.089428e-03 , +3.711183e-05 , +1.170054e-06 ; ...
        +2.562984e-01 , +6.602275e-03 , +9.652240e-05 , +1.451008e-06 , +2.512155e-08 ; ...
    ];

P = size(p, 2);
H = size(h, 2);

delta = zeros(P, H - 1);

for i = 1:H-1
    delta(:, i) = ...
        (log10(l2(:, i + 1)) - log10(l2(:, i))) / ...
        (log10(1/h(i + 1))   - log10(1/h(i)));
end

delta

figure;
loglog(1./h, l2', '-*');
grid;
