#!/bin/sh
#
#	$Id: do_examples.sh,v 1.4 2004/04/29 04:15:26 pwessel Exp $
#
# Bourne script to test all GMT examples (sh versions).
# If one argument is given it is used as the bin path
# If a second arguemnt is used it is added to the library path

# Temporary change LANG to C
if [ "X$LANG" = "X" ]; then
	OLDLANG=
else
	OLDLANG=$LANG
fi
LANG=C

# First determine if awk is buggy:

result=`echo 1 | awk '{print sin($1)}'`
if [ $result = 1 ]; then
	answer=`which nawk`
	if [ $#answer = 1 ]; then
		export AWK=nawk
	else
		export AWK=gawk
	fi
else
	export AWK=awk
fi

if [ $# -ge 1 ]; then
	cd ..
	top=`pwd`
	cd examples
	OLDPATH=$PATH
	OLDGMTHOME=${GMTHOME:-$top}
	export PATH=$1:$OLDPATH
	if [ $# = 2 ]; then
		OLDLD=${LD_LIBRARY_PATH:-/usr/lib}
		export LD_LIBRARY_PATH=$2:$OLDLD
	fi
	export GMTHOME=$top
fi

# Loop over all examples and run each job

for dir in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25
do
	if [ -e ex${dir}/job${dir}.sh ]; then
		echo -n "Doing example ${dir}..."
		cd ex${dir}
		sh job${dir}.sh
		cd ..
		echo "done"
	fi
done
if [ $# -ge 1 ]; then
	export PATH=$OLDPATH
	export GMTHOME=$OLDGMTHOME
	if [ $# = 2 ]; then
		export LD_LIBRARY_PATH=$OLDLD
	fi
fi
LANG=$OLDLANG

echo "Completed all examples"
