.TH GMTCONVERT l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
gmtconvert \- Converts, Pastes, and/or Extracts columns from ASCII and binary 1-D tables
.SH SYNOPSIS
\fBgmtconvert\fP [ \fIinputfiles\fP] [ \fB\-A\fP ] [ \fB\-E\fP ] [\fB\-F\fIcols\fP ] [ \fB\-H\fP[\fInrec\fP] ]
[ \fB\-L\fP ] [ \fB\-I\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-S\fP\fI"search string"\fP ] [ \fB\-V\fP ]
[ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP]\fIn\fP ] [ \fB\-bo\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgmtconvert\fP reads its standard input [or inputfiles] and writes out
the desired information to standard output. It can do a combination of
three things: (1) convert between binary and ASCII data tables, (2) paste
corresponding records from multiple files into a single file, (3)
extract a subset of the columns, (4) only extract segments whose header
matches a text pattern search, (5) just list all multisegment headers and no data
records, and (6) extract first and last data record for each segment. Input (and hence output) may have multiple
subheaders if \fB\-M\fP is selected, and ascii tables may have regular headers as well.
.TP
\fIdatafile(s)\fP
ASCII (or binary, see \fB\-bi\fP) file(s) holding a number of data columns.
.SH OPTIONS
.TP
.B \-A
The records from the input files should be paSted horizontally, not appended vertically. [Default
processes one file at the time]. Note for binary input, all the files you want to paste must
have the same number of columns (as set with -bi).
TP
.B \-E
Only extract the first and last record for each segment of interest [Default extracts
all records].
.TP
.B \-F
Give a comma-separated list of desired columns or ranges (0 is first column) [Default outputs all columns].
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Invert the order of rows, i.e., output the final records in reverse order, starting with the last and ending
up with the first input row [Default goes forward].
.TP
.B \-L
Only output a listing of all multisegment header records and no data records (requires \fB\-M\fP and ascii data).
.TP
.B \-M
Multiple segment file(s). Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-bo[s]\fP\fIn\fP must
set the number of output columns explicitly.
.TP
.B \-S
Only output those segments whose header record contains the specified text string [Default output all segments].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output. [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only. [Default affects both].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
To convert the binary file test.b (single precision) with 4 columns to ASCII:
.br
.sp
\fBgmtconvert\fP test.b \fB\-bis\fP4 > test.dat
.br
.sp
To convert the multiple segment ASCII table test.d to a double precision binary file:
.br
.sp
\fBgmtconvert\fP test.d \fB\-M \-bo\fP > test.b
.br
.sp
You have an ASCII table with 6 columns and you want to plot column 5 versus column 0. Try
.br
.sp
\fBgmtconvert\fP table.d \fB\-F\fP5,0 | psxy ...
.br
.sp
If the file instead is the binary file results.b which has 9 single-precision values per record,
we extract the last column and columns 4-6 and write ASCII with the command
.br
.sp
\fBgmtconvert\fP results.b \fB\-F\fP8,4-6 -bi9s | psxy ...
.br
.sp
You want to plot the 2nd column of the file left.d versus the first column of file right.d:
.br
.sp
\fBgmtconvert\fP left.d right.d \fB\-S \-F\fP1,2 | psxy ...
.br
To extract all segments in the file big_file.d whose headers contain the string "RIDGE AXIS", try
.br
.sp
\fBgmtconvert\fP big_file.d \fB\-S\fP"RIDGE AXIS" > subset.d
.br
.SH "SEE ALSO"
.IR gmt (l),
.IR minmax (l)
