.TH GRDPROJECT l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grdproject \- Forward and Inverse map transformation of 2-D grd files
.SH SYNOPSIS
\fBgrdproject\fP \fIin_grdfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
[ \fB\-A\fP[\fBk|m|n|i|c|p\fP] ] [ \fB\-C\fP[\fIdx/dy\fP] ] [ \fB\-D\fP\fIdx\fP[\fBm|c\fP][/\fIdy\fP[\fBm|c\fP]] ]
[ \fB\-E\fP\fIdpi\fP ] [ \fB\-F\fP ] [ \fB\-G\fP\fIout_grdfile\fP ] [ \fB\-I\fP ]
[ \fB\-Mc|i|m|p\fP ] [ \fB\-N\fP\fInx/ny\fP ] [ \fB\-S\fP\fIsearch_radius\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdproject\fP will do one of two things depending whether \fB\-I\fP has been set. If set, it
will transform a gridded data set from a rectangular coordinate system onto a geographical
system by resampling the surface at the new nodes. If not set, it will project a geographical
gridded data set onto a rectangular grid. The new nodes are filled based on a simple weighted
average of nearby points. Aliasing is avoided by using sensible values for the \fIsearch_radius\fP.
The new node spacing may be determined in one of several ways by specifying the grid spacing,
number of nodes, or resolution. Nodes not constrained by input data are set to NaN.
.br
        No space between the option flag and the associated arguments. Use upper case for the
option flags and lower case for modifiers.
.TP
\fIin_grdfile\fP
2-D binary grd file to be transformed.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.SH OPTIONS
.TP
.B \-A
Force 1:1 scaling, i.e., output (or input, see \fB\-I\fP) data are in actual projected meters. To specify other units,
append \fBk\fP (km), \fBm\fP (mile),\fBn\fP (nautical mile), \fBi\fP (inch), \fBc\fP (cm), or \fBp\fP (points).
Without \fB\-A\fP, the output (or input, see \fB\-I\fP) are in the units specified by MEASURE_UNIT (but see \fB\-M\fP).
.TP
.B \-C
Let projected coordinates be relative to projection center [Default is relative to lower left corner].
Optionally, add offsets in the projected units to be added (or subtracted when \fB\-I\fP is set) to (from)
the projected coordinates, such as false eastings and northings for particular projection zones [0/0].
.TP
.B \-D
Set the grid spacing for the new grid. Append \fBm\fP for minutes, \fBc\fP for seconds.
.TP
.B \-E
Set the resolution for the new grid in dots per inch.
.TP
.B \-F
Toggle between pixel and gridline registration [Default is same as input].
.TP
.B \-G
Specify the name of the output netCDF grd file.
.TP
.B \-I
Do the Inverse transformation, from rectangular to geographical.
.TP
.B \-M
Append \fBc\fP, \fBi\fP, or \fBm\fP to indicate that cm, inch, or meter should be the projected measure unit
[Default is set by MEASURE_UNIT in \.gmtdefaults4]. Cannot be used with \fB\-A\fP.
.TP
.B \-N
Set the number of grid nodes in the new grid.
.TP
.B \-S
Set the search radius for the averaging procedure [Default avoids aliasing].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To transform the geographical grid dbdb5.grd onto a pixel Mercator grid at 300 dpi, run
.br
.sp
\fBgrdproject\fP dbdb5.grd \fB\-R\fP20/50/12/25 \fB\-Jm\fP0.25\fBi\fP \fB\-E\fP300 \fB\-F\fP
\fB\-G\fPdbdb5_merc.grd
.br
.sp
To inversely transform the file topo_tm.grd back onto a geographical grid, use
.br
.sp
\fBgrdproject\fP topo_tm.grd \fB\-R\fP-80/-70/20/40 \fB\-Jt\fP-75/1:500000 \fB\-I\fP \fB\-D\fP5\fBm \-V\fP \fB\-G\fPtopo.grd
.br
.sp
This assumes, of course, that the coordinates in topo_tm.grd were created with the same projection parameters.
.br
To inversely transform the file topo_utm.grd (which is in UTM meters) back to a geographical grid we
specify a one-to-one mapping with meter as the measure unit:
.br
.sp
\fBgrdproject\fP topo_utm.grd \fB\-R\fP203/205/60/65 \fB\-Ju\fP5/1:1 \fB\-I\fP \fB\-Mm \-V \-G\fPtopo.grd
.br
.SH RESTRICTIONS
The boundaries of a projected (rectangular) data set will not necessarily give rectangular
geographical boundaries (Mercator is one exception). In those cases some nodes may be unconstrained (set to NaN).
To get a full grid back, your input grid may have to cover a larger area than you are interrested in.
.SH "SEE ALSO"
.IR gmt (l),
.IR gmtdefaults (l),
.IR mapproject (l)
