.TH GRDREFORMAT l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
grdreformat \- Converting between different grdfile formats.
.SH SYNOPSIS
\fBgrdreformat\fP \fIingrdfile\fP[\fI=id\fP[\fI/scale/offset\fP[\fI/NaNvalue\fP]]] \fIoutgrdfile\fP[\fI=id\fP[\fI/scale/offset\fP[\fI/NaNvalue\fP]]]
 [ \fB\-N\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgrdreformat\fP reads a grdfile in one format and writes it out using another format. As an option the
user may select a subset of the data to be written and to specify scaling, translation, and NaN-value.
.TP
\fIingrdfile\fP
The grdfile to be read. Append format =\fIid\fP number if not a standard \fBGMT\fP netCDF-based grdfile.
If \fIid\fP is set, you may optionally append \fIscale\fP and \fIoffset\fP to scale the data and then add an offset. If \fIscale\fP and \fIoffset\fP
are supplied you may also append a value that represent 'not-a-number' (for floating-point grids this
is unnecessary since the IEEE NaN is used; however short integers need a value which means no data available.)
.TP
\fIoutgrdfile\fP
The grdfile to be written. Append format =\fIid\fP number if not a standard \fBGMT\fP netCDF-based grdfile.
If \fIid\fP is set, you may optionally append \fIscale\fP and \fIoffset\fP to scale the data and then add an offset. If \fIscale\fP and \fIoffset\fP
are supplied you may also append a value that represent 'not-a-number' (for floating-point grids this
is unnecessary since the IEEE NaN is used; however short integers need a value which means no data available.)
For format =\fIid\fP > 0 the size of the \fBGMT\fP grdheader block is \fIhsize\fP = 896 bytes, and the total size of the file
is \fIhsize\fP + \fInx\fP * \fIny\fP * \fIitem_size\fP, where \fIitem_size\fP is the size in bytes of each element (1, 2, 4). Bit grids
are stored using 4-byte integers, each holding 32 bits, so for these files the size equation is modified by
using ceil (\fInx\fP / 32) * 4 instead of \fInx\fP. For header and grid details, see Appendix B.
.SH OPTIONS
.TP
.B \-N
Suppress the writing of the GMT header structure. This is useful when you want to write a native grid to
be used by \fBgrdraster\fP. It only applies to native grids and is skipped for netCDF output.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To create a 4-byte raw floating point grid from the netCDF file data.grd:
.br
.sp
\fBgrdreformat\fP data.grd ras_data.b4=1 \fB\-V\fP
.br
.sp
To make a 2-byte short integer file, scale it by 10, subtract 32000, setting
NaNs to -9999, do
.br
.sp
\fBgrdreformat\fP values.grd shorts.i2=2/10/-32000/-9999 \fB\-V\fP
.br
.sp
To create a Sun standard 8-bit rasterfile for a subset of the data file image.grd,
assuming the range in image.grd is 0-1 and we need 0-255, run
.br
.sp
\fBgrdreformat\fP image.grd \fB\-R\fP-60/-40/-40/-30 image.ras8=3/255/0 \fB\-V\fP
.br
.sp
To convert etopo2.grd to etopo2.i2 that can be used by \fBgrdraster\fP, try
.br
.sp
\fBgrdreformat\fP etopo2.grd etopo2.i2=2 \fB\-N \-V\fP
.SH "SEE ALSO"
.IR gmt (l),
.IR grdmath (l)
