.TH PSHISTOGRAM l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
pshistogram \- Bin data and plot histograms
.SH SYNOPSIS
\fBpshistogram\fB \fIfile\fP \fB\-Jx\fP\fIxscale[/yscale]\fP \fB\-W\fP\fIbin_width\fP [ \fB\-2\fP ] [ \fB\-A\fP ] [ \fB\-B\fP\fItickinfo\fP ]
[ \fB\-C\fP ] [ \fB\-E\fP\fIazimuth/elevation\fP ] [ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP[\fBo\fP] ]
[ \fB\-K\fP ] [ \fB\-L\fP\fIpen\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP ]
[ \fB\-R\fIwest/east/south/north\fP[\fBr\fP] ] [ \fB\-S\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ]
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fItype\fP ] [ \fB\-c\fP\fIcopies\fP ]
[ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBpshistogram\fP reads the first column from \fIfile\fP [or standard input] and
calculates histogram parameters based on the bin-width provided. Using these parameters,
scaling, and optional range parameters it will generate \fIPostScript\fP code that plots a histogram.
A cumulative histogram may also be specified.
.TP
\fIfile\fP
ASCII [or binary, see \fB\-b\fP] datafile. If no file is given, \fBpshistogram\fP will read standard input.
.TP
.B \-Jx
\fIxscale[/yscale]\fP (Linear scale(s) in distance unit/data unit).
.TP
.B \-W
Sets the bin width used for histogram calculations.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-2
Read second rather than first column.
.TP
.B \-A
Plot the histogram horizontally from x = 0 [Default is vertically from y = 0].
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Center bin on each value. [Default is left edge].
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90].\"'
.TP
.B \-G
Select filling of bars. [Default is no fill].
Specify the shade (0\-255) or color (r/g/b, each in 0\-255, h/s/v, with
h in 0\-360, s, and v in 0\-1, and set \fBCOLOR_MODEL\fP = hsv, or
c/m/y/k, each in 0\-100 %).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIr/g/b\fP[\fBB\fP[\fIr/g/b\fP]] to specify fore- and background
colors (use \fIr/g/b\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Inquire about min/max x and y after binning. No plotting is done. Append \fBo\fP
to output an ASCII table of the resulting x,y data.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Draw bar outline using the specified pen thickness. [Default is no outline].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Q
Draw a cumulative histogram.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
If not given, \fBpshistogram\fP will automatically find reasonable values for the region.
.TP
.B \-S
Draws a stairs-step diagram instead of histogram.
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The \fBGMT\fP parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-Z
Choose between 6 types of histograms: 0 = counts [Default], 1 = frequency_percent,
2 = log (1.0 + count), 3 = log (1.0 + frequency_percent),
4 = log10 (1.0 + count), 5 = log10 (1.0 + frequency_percent).
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
[Default is 2 input columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
To draw a histogram of the data v3206.t containing seafloor depths, using a 250 meter
bin width, center bars, and draw bar outline, use:
.br
.sp
\fBpshistogram\fP v3206.t \fB\-JX\fPh \fB\-W\fP250 \fB\-C \-L\fP0.5\fBp\fP \fB\-V\fP > plot.ps
.br
.sp
If you know the distribution of your data, you may explicitly specify range and scales. E.g.,
to plot a histogram of the y-values (2nd column) in the file errors.xy using a 1 meter
bin width, plot from -10 to +10 meters @ 0.75 cm/m, annotate every 2 m and 100 counts,
and use black bars, run:
.br
.sp
cut -f2 errors.xy | \fBpshistogram\fP \fB\-W\fP1 \fB\-R\fP-10/10/0/0 \fB\-Jx\fP0.75\fBc\fP/0.01\fBc\fP
\fB\-B\fP2:Error:/100:Counts: \fB\-G\fP0 \fB\-V\fP > plot.ps
.br
.sp
Since no y-range was specified, pshistogram will calculate ymax in even increments of 100.
.SH "SEE ALSO"
.IR gmt (l),
.IR psbasemap (l),
.IR psrose (l),
.IR psxy (l)
