.TH PSXY l "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
psxy \- Plot lines, polygons, and symbols on maps
.SH SYNOPSIS
\fBpsxy\fP \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP]
[ \fB\-A\fP ] [ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIcptfile\fP ] [ \fB\-D\fP\fIdx/dy\fP ] [ \fB\-E\fP[\fBx|y|X|Y\fP][\fIcap\fP][\fP/pen\fP] ]
[ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-K\fP ] [ \fB\-L\fP ]
[ \fB\-N\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-S\fP[\fIsymbol\fP][\fIsize\fP] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ]
[ \fB\-V\fP ] [ \fB\-W\fP[\fIpen\fP] ]
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-:\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-f\fP[\fBi|o\fP]\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBpsxy\fP reads (x,y) pairs from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot lines, polygons, or symbols at those locations on a map.
If a symbol is selected and no symbol size given, then \fBpsxy\fP will interpret the third column of the
input data as symbol size. Symbols whose size is <= 0 are skipped. If no symbols are specified then the symbol code (see \fB\-S\fP below)
must be present as last column in the input. Multiple segment files may be plotted using the \fB\-M\fP option.
If \fB\-S\fP is not selected, a line connecting the data points will be drawn instead. To
explicitly close polygons, use \fB\-L\fP. Select a shade with \fB\-G\fP. If \fB\-G\fP is set, \fB\-W\fP
will control whether the polygon outline is drawn or not. If a symbol is selected, \fB\-G\fP and
\fB\-W\fP determines the fill color and outline/no outline, respectively.
The \fIPostScript\fP code is written to standard output.
.TP
\fIfiles\fP
List one or more file-names. If no files are given, \fBpsxy\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]][\fBd\fP] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Suppress drawing line segments as great circle Arcs. [Default draws great circle arcs].
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Give a color palette file. When used with \fB\-S\fP, lets symbol fill color be determined by the z-value in the
third column. Additional fields are
shifted over by one column (optional size would be 4th rather than 3rd field, etc.).
If \fB\-S\fP is not set, \fBpsxy\fP expects the user to supply a multisegment line or polygon file
(requires \fB\-M\fP) and will look for \fB\-Z\fP\fIval\fP strings in each multisegment header. The \fIval\fP
will control the color of the line or polygon (use \fB\-L\fP) via the cpt file.
.TP
.B \-D
Offset the plot symbol locations by the given amounts \fIdx/dy\fP [Default is no offset]. Only applies to symbols.
.TP
.B \-E
Draw error bars. Append \fBx\fP and/or \fBy\fP to indicate which bars you want to draw (Default is both x and y). The x and/or
y errors must be stored in the columns after the (x,y) pair [or (x,y,size) triplet]. The
\fIcap\fP parameter indicates the length of the end-cap on the error bars [0.25c (or 0.1i)]. Pen
attributes for error bars may also be set. [Defaults: width = 1, color = 0/0/0, texture = solid]. If upper case
\fBX\fP and/or \fBY\fP is used we will instead draw "box-and-whisker" (or "stem-and-leaf") symbols. The x (or y)
coordinate is then taken as the median value, and 4 more columns are expected to contain the minimum (0% quartile), the 25%
quartile, the 75% quartile, and the maximum (100% quartile) values. The 25-75% box may be filled by using \fB\-G\fP.
.TP
.B \-G
Select filling of polygons and symbols.
Append the shade (0\-255), color (r/g/b), or \fBP\fP|\fBp\fP\fIdpi\fP/\fIpattern\fP (polygons only) [Default is no fill].
Note when \fB\-M\fP is chosen, \fBpsxy\fP will search for \fB\-G\fP and \fB\-W\fP strings in all the subheaders and let any found values over-ride the command line settings.
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Force closed polygons: connect the endpoints of the line-segment(s) and draw polygons.
.TP
.B \-M
Multiple segment file. Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Do NOT skip symbols that fall outside map border [Default plots points inside border only]. The
option does not apply to lines and polygons which are always clipped to the map region.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Plot symbols. If present, size is symbol size in the
unit set in \.gmtdefaults4 (unless c, i, m, or p is
appended). If the symbol code (see below) is not given
it will be read from the last column in the input data;
this cannot be used in conjunction with \fB\-b\fP. Optionally, append
c, i, m, p to indicate that the size information in the
input data is in units of cm, inch, meter, or point,
respectively. [Default is MEASURE_UNIT].
.br
The uppercase symbols \fBA\fP, \fBC\fP, \fBD\fP, \fBG\fP, \fBH\fP, \fBI\fP, \fBN\fP, \fBS\fP, \fBT\fP are normalized
to have the same area as a circle with diameter \fIsize\fP, while
the corresponding lowercase symbols all are circumscribed
by the circle. Choose between these symbol codes:
.TP
.B \-S-
x-dash. \fIsize\fP is the length of a short horizontal line segment.
.TP
.B \-Sa
st\fBa\fPr. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sb
\fBb\fPar extending from \fIbase\fP to y. \fIsize\fP is bar width. Append \fBu\fP
if \fIsize\fP is in x-units [Default is plot-distance units]. By default,
\fIbase\fP = 0. Append \fBb\fP\fIbase\fP to change this value.
.TP
.B \-Sc
\fBc\fPircle. \fIsize\fP is diameter of circle.
.TP
.B \-Sd
\fBd\fPiamond. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Se
\fBe\fPllipse. Direction (in degrees counter-clockwise from horizontal), major_axis, and minor_axis must be found in columns 3, 4, and 5.
.TP
.B \-SE
Same as \fB\-Se\fP, except azimuth (in degrees east of north) should be given instead of direction. The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Se\fP leaves the directions
unchanged.) Furthermore, the axes lengths must be given in km instead of plot-distance units. An exception occurs for
a linear projection if which we assume the ellipse axes are given in the same units as \fB\-R\fP.
.TP
.B \-Sf
\fBf\fPront. \fB\-Sf\fP\fIgap/size\fP[\fIdir\fP][\fItype\fP][:\fIoffset\fP]. Supply distance gap between symbols and symbol size.
If \fIgap\fP is negative, it is interpreted to mean the number of symbols along the front instead. Append \fIdir\fP to plot symbols
on the \fBl\fPeft or \fBr\fPight side of the front [Default is centered]. Append \fItype\fP to specify which symbol
to plot: \fBb\fPox, \fBc\fPircle, \fBf\fPault, \fBs\fPlip, or \fBt\fPriangle. [Default is fault].
Slip means left-lateral or right-lateral strike-slip arrows (centered is not an option). Append :\fIoffset\fP to offset
the first symbol from the beginning of the front by that amount [Default is 0].
.TP
.B \-Sh
\fBh\fPexagon. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Si
\fBi\fPnverted triangle. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sk
\fBk\fPustom symbol. Append <name>/\fIsize\fP, and we will look for a definition file called
<name>.def in (1) the current directory or (2) in $GMTHOME/share/custom. The symbol as defined
in that file is of size 1.0 by default; the appended \fIsize\fP will scale symbol accordingly.
Users may add their own custom *.def files; see CUSTOM SYMBOLS below.
.TP
.B \-Sl
\fBl\fPetter or text string (less than 64 characters). Give size, and append /\fIstring\fP after the size. Note that
the size is only approximate; no individual scaling
is done for different characters. Remember to escape special characters like *. Optionally, you may append %\fIfont\fP
to select a particular font [Default is ANNOT_FONT_PRIMARY].
.TP
.B \-Sg
octa\fBg\fPon. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sn
pe\fBn\fPtagon. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sp
\fBp\fPoint. No size needs to be specified (1 pixel is used).
.TP
.B \-Sq
\fBq\fPuoted line, i.e., lines with annotations such as contours. Append [\fBd|f|n|l|x\fP]\fIinfo\fP[:\fIlabelinfo\fP].
The required argument controls the placement of labels along the lines. Choose among four controlling mechanisms:
.br
Controls the placement of labels along the quoted lines. Choose among five controlling algorithms:
.br
\fBd\fP\fIdist\fP[c|i|m|p] or \fBD\fP\fIdist\fP[d|e|k|m|n].
For lower case \fBd\fP, give distances between labels on the plot in your preferred measurement unit
\fBc\fP (cm), \fBi\fP (inch), \fBm\fP (meter), or \fBp\fP (points), while for upper case \fBD\fP, specify
distances in map units and append the unit; choose among \fBe\fP (m), \fBk\fP (km), \fBm\fP (mile), \fBn\fP
(nautical mile), or \fBd\fP (spherical degree). [Default is 10\fBc\fP or 4\fBi\fP].
.br
\fBf\fP\fIffile.d\fP reads the ascii file \fIffile.d\fP and places labels at locations in the file
that matches locations along the quoted lines. Inexact mathces and points outside the region are skipped.
.br
\fBl|L\fP\fIline1\fP[,\fIline2\fP,...] Give \fIstart\fP and \fIstop\fP coordinates for one or
more comma-separated straight line segments. Labels will be placed where these lines intersect the
quoted lines. The format of each \fIline\fP specification is \fIstart/stop\fP, where \fIstart\fP and \fIstop\fP
are either a specified point \fIlon/lat\fP or a 2-character \fBXY\fP key that uses the justification
format employed in \fBpstext\fP to indicate a point on the map, given as [LCR][BMT].
\fBL\fP will interpret the point pairs as defining great circles [Default is straight line].
.br
\fBn\fP\fIn_label\fP specifies the number of equidistant labels for quoted lines line [1].
Upper case \fBN\fP starts labeling exactly at the start of the line [Default centers them along the line].
\fBN\fP-1 places one justified label at start, while \fBN\fP+1 places one justified label at the end of quoted lines.
Optionally, append /\fImin_dist\fP[c|i|m|p] to enforce that a minimum distance separation between successive labels is enforced.
.br
\fBx|X\fP\fIxfile.d\fP reads the multi-segment file \fIxfile.d\fP and places labels at the intersections
between the quoted lines and the lines in\fIxfile.d\fP. \fBX\fP will resample the lines first along
great-circle arcs.
.br
The optional \fIlabelinfo\fP controls the specifics of the label formatting and consists of a concatenated string
made up of any of the following control arguments:
.br
.br
\fB+a\fP\fIangle\fP for annotations at a fixed angle, \fB+an\fP for line-normal, or \fB+ap\fP for line-parallel [Default].
.br
\fB+c\fP\fIdx\fP[/\fIdy\fP] sets the clearance between label and optional text box. Append \fBc|i|m|p\fP to specify
the unit or % to indicate a percentage of the label font size [15%].
.br
\fB+f\fP\fIfont\fP sets the desired font [Default \fBANNOT_FONT_PRIMARY\fP].
.br
\fB+g\fP[\fIcolor\fP] selects opaque text boxes [Default is transparent]; optionally specify the color [Default is \fBPAGE_COLOR\fP].
.br
\fB+j\fP\fIjust\fP sets label justification [Default is CM].
.br
\fB+k\fP\fIcolor\fP sets color of text labels [Default is \fBCOLOR_BACKGROUND\fP].
.br
\fB+l\fP\fIlabel\fP sets the constant label text.
.br
\fB+L\fP\fIlflag\fP sets the label text according to the specified flag:
.br
\fIflag\fP is \fBh\fP: Take the label from the current multisegment header (first scan for an embedded
\fB\-L\fP\fIlabel\fP option, if not use the first word following the segment flag).
.br
\fIflag\fP is \fBd\fP: Take the Cartesian plot distances along the line as the label; append \fBc|i|m|p\fP
as the unit [Default is \fBMEASURE_UNIT\fP].
.br
\fIflag\fP is \fBD\fP: Calculate actual map distances; append \fBd|e|k|m|n\fP as the unit [Default is \fBd\fP(egrees),
unless label placement was based on map distances along the lines in which case we use the same unit specified for that algorithm].
Requires a map projection to be used.
.br
\fIflag\fP is \fBf\fP: Use text after the 2nd column in the fixed label location file as the label. Requires the fixed label
location setting.
.br
\fIflag\fP is \fBx\fP: As \fBh\fP but use the headers in the \fIxfile.d\fP instead. Requires the crossing file option.
.br
\fB+o\fP selects rounded rectangular text box [Default is rectangular]. Not applicable for curved text (\fB+v\fP) and
only makes sense for opaque text boxes.
.br
\fB+p\fP[\fIpen\fP] draws the outline of text boxsets [Default is no outline]; optionally specify pen for outline [Default is width = 0.25p, color = black, texture = solid].
.br
\fB+r\fP\fImin_rad\fP will not place labels where the line's radius of curvature is less than \fImin_rad\fP [Default is 0].\"'
.br
\fB+s\fP\fIsize\fP sets the desired font size in points [Default is 9].
.br
\fB+u\fP\fIunit\fP appends \fIunit\fP to all line labels. If \fIunit\fP starts with a leading hypen (-) then there will be no space
between label value and the unit.
[Default is no unit].
.br
\fB+v\fP specifies curved labels following the path [Default is straight labels].
.br
\fB+w\fP specifies how many (\fIx, y\fP) points will be used to estimate label angles [Default is 10].
.br
\fB+=\fP\fIprefix\fP prepends \fIprefix\fP to all line labels. If \fIprefix\fP starts with a leading hypen (-) then there will be no space
between label value and the prefix. [Default is no prefix].
.B \-Sr
\fBr\fPectangle. No size needs to be specified, but the x- and y-dimensions must be found in columns 3 and 4.
.TP
.B \-Ss
\fBs\fPquare. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-St
\fBt\fPriangle. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sv
\fBv\fPector. Direction (in degrees counter-clockwise from horizontal) and length must be found in columns 3 and 4. \fIsize\fP,
if present, will be interpreted as arrowwidth/headlength/headwidth [Default is 0.075\fBc\fP/0.3\fBc\fP/0.25\fBc\fP (or 0.03\fBi\fP/0.12\fBi\fP/0.1\fBi\fP)].
By default arrow attributes remains invariant to the length
of the arrow. To have the size of the vector scale down with decreasing size,
append \fBn\fP\fInorm\fP, where vectors shorter than \fInorm\fP will have their
attributes scaled by length/\fInorm\fP. To center vector on balance point, use \fB\-Svb\fP; to align point with the vector head,
use \fB\-Svh\fP; to align point with the vector tail, use \fB\-Svt\fP [Default]. To give the head point's coordinates\"'
instead of direction and length, use \fB\-Svs\fP. Upper case \fBB, H, T, S\fP will draw a double-headed vector [Default is single head].
.TP
.B \-SV
Same as \fB\-Sv\fP, except azimuth (in degrees east of north) should be given instead of direction. The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sv\fP leaves the directions
unchanged.)
.TP
.B \-Sw
pie \fBw\fPedge. Start and stop directions (in degrees counter-clockwise from horizontal) for pie slice
must be found in columns 3 and 4.
.TP
.B \-Sx
cross. \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sy
y-dash. \fIsize\fP is the length of a short vertical line segment.
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The \fBGMT\fP parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set pen attributes. [Defaults: width = 1, color = 0/0/0, texture = solid].
Implicitly draws the outline of symbols with selected pen.
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output. [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only. [Default affects both].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
[Default is the required number of columns given the chosen settings].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data)
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen TIME_EPOCH),
\fBx\fP (longitude), \fBy\fP (latitude), \fBg\fP (geographic coordinate), or
\fBf\fP (floating point) to each column or column range item.
.SH EXAMPLES
To plot solid red circles (diameter = 0.25 cm) at the positions listed in the file DSDP.xy on a
Mercator map at 5 cm/degree of the area 150E to 154E, 18N to 23N, with tickmarks every 1 degree
and gridlines every 15 minutes, use
.br
.sp
\fBpsxy\fP DSDP.xy \fB\-R\fP150/154/18/23 \fB\-Jm\fP5\fBc \-Sc\fP0.25\fBc\fP \fB\-G\fP255/0/0 \fB\-B\fP1\fBg\fP15\fBm\fP | lpr
.br
.sp
To plot the xyz values in the file quakes.xyzm as circles with size given by the magnitude in the
4th column and color based on the depth in the third using the color palette cpt on a linear map, use
.br
.sp
\fBpsxy\fP quakes.xyzm \fB\-R\fP0/1000/0/1000 \fB\-JX\fP6\fBi\fP \fB\-Sc\fP \fB\-C\fPcpt \fB\-B\fP200 > map.ps
.br
.sp
To plot the file trench.xy on a Mercator map, with white triangles with sides 0.25 inch on the left
side of the line, spaced every 0.8 inch, use
.br
.sp
\fBpsxy\fP trench.xy \fB\-R\fP150/200/20/50 \fB\-Jm\fP0.15\fBi \-Sf\fP0.8\fBi\fP/0.1\fBilt\fP \fB\-G\fP255 \fB\-W \-B\fP10 | lpr
br
.sp
To plot the data in the file misc.d as symbols determined by the code in the last column, and with size given
by the magnitude in the 4th column, and color based on the third column via the color palette cpt on a linear map, use
.br
.sp
\fBpsxy\fP misc.d \fB\-R\fP0/100/-50/100 \fB\-JX\fP6\fBi\fP \fB\-S\fP \fB\-C\fPcpt \fB\-B\fP20 > t.ps
.SH BUGS
The \fB\-N\fP option does not adjust the BoundingBox information so you may
have to post-process the PostScript outout with epstool or ps2epsi to obtain
a correct BoundingBox.
.br
\fBpsxy\fP cannot handle filling of polygons that contain the south or north pole. For such a polygon,
make a copy and split it into two and make each explicitly contain the polar point. The two polygons
will combine to give the desired effect when filled; to draw outline use the original polygon.
.SH CUSTOM SYMBOLS
\fBpsxy\fP and \fBpsxyz\fP allows users to define and plot their own custom symbols.
This is done by encoding the symbol using a simple plotting code described below. Put
all the plotting codes for your new symbol in a file whose extension must be .def; you may then address
the symbol without giving the extension (e.g., the symbol file tsunami.def is used by specifying \fB\-Sk\fP\fItsunami/size\fP.
The definition file can contain any number of plot code records, as well as blank lines and comment lines (starting with #).
\fBpsxy\fP and \fBpsxyz\fP will look for the definition files in (1) the current directory and (2) the $GMTHOME/share/custom,
in that order.
Freeform polygons (made up of straight line segments and arcs of circles) can be designed - these polygons can be
painted and filled with a pattern. Other standard geometric symbols can also be used. With the exception of the circle,
these can only be painted, not filled with a pattern (use the freeform polygons to include a triangle that can be filled
with a pattern). Generate freeform polygons by starting with an anchor point:
.br
        \fIx0 y0\fP \fBM\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
and draw a straight line from the current point to the next point with
.br
        \fIx y\fP \fBD\fP
.br
or add an arc by using
.br
        \fIxc yc r dir1 dir2\fP \fBA\fP
.br
When a record other than the \fBD\fP or \fBA\fP is encountered, the polygon is closed and considered complete.
The optional pen and fill setting hardwires particular values for this feature. If not present the polygon's\"'
characteristics are determined by the command line settings for pen and fill. To deactivate fill or outline
for any given polygon, give \fB\-G\-\fP or \fB\-W\-\fP. To add other geometric shapes
to your custom symbol, add any number of the following plot code records:
.sp
.br
        star: \fIx y size\fP \fBa\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        circle: \fIx y size\fP \fBc\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        cross: \fIx y size\fP \fBx\fP [ \fB\-W\fP\fIpen\fP ]
.br
        diamond: \fIx y size\fP \fBd\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        ellipse: \fIx y dir major minor\fP \fBe\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        hexagon: \fIx y size\fP \fBh\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        invtriangle: \fIx y size\fP \fBi\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        letter: \fIx y size string\fP \fBl\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        octagon: \fIx y size\fP \fBg\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        pentagon: \fIx y size\fP \fBn\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        rect: \fIx y xwidth ywidth\fP \fBr\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        square: \fIx y size\fP \fBs\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        triangle: \fIx y size\fP \fBt\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
        wedge: \fIx y radius dir1 dir2\fP \fBw\fP [ \fB\-W\fP\fIpen\fP ] [ \fB\-G\fP\fIfill\fP ]
.br
.sp
When designing your symbol, the \fIx, y\fP and other dimensions are relative to a symbol of size 1, and all the
dimensions will be scaled by the actual symbol size chosen at run-time. To design a symbol, make a grid paper
with \fBpsbasemap \-R\fP-0.5/0.5/-0.5/0.5 \fB\-JX\fP4\fBi\fP \fB\-Ba\fP0.1\gBg\gP0.05 \fB\-P\fP > grid.ps and
draw your symbol, centering it on (0,0). For examples of symbols, see the set supplied with GMT in $GMTHOME/share/custom.
.SH "SEE ALSO"
.IR gmt (l),
.IR psbasemap (l),
.IR psxyz (l)
