.TH IMG2MERCGRD GMTMANSECTION "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
img2mercgrd \- Extract region of img, preserving Mercator, save as grd
.SH SYNOPSIS
\fBimg2mercgrd\fP \fIimgfile\fP \fB\-G\fP\fIgrdfile\fP \fB\-R\fP\fIwest/east/south/north\fP
\fB\-T\fP\fItype\fP [ \fB\-N\fP\fInavg\fP ] [ \fB\-S\fP\fIscale\fP ] [ \fB\-V\fP ]
[ \fB\-m\fP\fIminutes\fP ] [ \fB\-x\fP\fImaxlon\fP ] [ \fB\-y\fP\fIminlat/maxlat\fP ]
.SH DESCRIPTION
\fBimg2mercgrd\fP reads an img format file and creates a grdfile. The Spherical Mercator
projection of the img file is preserved, so that the region \fB\-R\fP set by the user is
modified slightly; the modified region corresponds to the edges of pixels [or groups of
\fInavg\fP pixels]. The grdfile header is set so that the x and y axis
lengths represent distance from the west and south edges of the image, measured in user
default units, with \fB\-Jm1\fP and the adjusted \fB\-R\fP. By setting the \fBgmtdefaults\fP
ELLIPSOID = Sphere, the user can make overlays with the adjusted \fB\-R\fP so that they match.
See \fBEXAMPLES\fP below. The adjusted \fB\-R\fP is also written in the grdheader remark, so it
can be found later. The \fB\-T\fP\fItype\fP selects all data or only data at constrained
pixels, and can be used to create a grid of 1s and 0s indicating constraint locations. The
output grd file is pixel registered; it inherits this from the img file.
.TP
\fIimgfile\fP
An img format file such as the marine gravity or seafloor topography fields estimated from
satellite altimeter data by Sandwell and Smith. If the user has set an environment variable
GMT_IMGDIR, then \fBimg2mercgrd\fP will try to find \fIimgfile\fP in $GMT_IMGDIR; else it
will try to open \fIimgfile\fP directly.
.TP
.B \-G
\fIgrdfile\fP is the name of the output grdfile.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest. To specify boundaries
in degrees and minutes, use the dd:mm format.
.TP
.B \-T
\fItype\fP handles the encoding of constraint information. \fItype\fP = 0 indicates that no
such information is encoded in the img file (used for pre-1995 versions of the gravity data;
all more recent files do not support this choice)
and gets all data. \fItype\fP > 0 indicates that constraint information is encoded (1995 and
later (current) versions of the img files) so that one may produce a grd file as follows:
\fB\-T\fP\fI1\fP gets data values at all points, \fB\-T\fP\fI2\fP gets data values at
constrained points and NaN at interpolated points; \fB\-T\fP\fI3\fP gets 1 at constrained
points and 0 at interpolated points.
.SH OPTIONS
.sp
.TP
.B \-N
Average the values in the input img pixels into \fInavg\fP by \fInavg\fP squares, and
create one output pixel for each such square. If used with \fB\-T\fP\fI3\fP it will
report an average constraint between 0 and 1. If used with \fB\-T\fP\fI2\fP the output
will be average data value or NaN according to whether average constraint is > 0.5.
\fInavg\fP must evenly divide into the dimensions of the imgfile in pixels.
[Default \fI1\fP does no averaging].
.TP
.B \-S
Multiply the img file values by \fIscale\fP before storing in grd file. [Default is 1.0].
(img topo files are stored in (corrected) meters; gravity files in mGal*10; vertical
deflection files in microradians*10, vertical gravity gradient files in Eotvos*10. Use \fB\-S\fP0.1 for those files.)
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
Particularly recommended here, as it is helpful to see how the coordinates are adjusted.
.TP
.B \-m
Indicate \fIminutes\fP as the width of an input img pixel in minutes of longitude.
[Default is 2.0].
.TP
.B \-x
Indicate \fImaxlon\fP as the maximum longitude extent of the input img file. Versions
since 1995 have had \fImaxlon\fP = 360.0, while some earlier files had \fImaxlon\fP =
390.0. [Default is 360.0].
.TP
.B \-y
Indicate \fIminlat/maxlat\fP as the latitude extent of the input img file. All versions
to date have used -72.006/72.006. [Default is -72.006/72.006].
.SH EXAMPLES
To extract data in the region \fB\-R\fP-40/40/-70/-30 from \fIworld_grav.img.7.2\fP, run
.br
.sp
\fBimg2mercgrd\fP world_grav.img.7.2 \fB\-G\fPmerc_grav.grd \fB\-R\fP-40/40/-70/-30 \fB\-T\fP1 \fB\-V\fP
.br
.sp
Note that the \fB\-V\fP option tells us that the range was adjusted to
\fB\-R\fP-40/40/-70.0004681551/-29.9945810754. We can also use \fBgrdinfo\fP to find that the
grd file header shows its region to be \fB\-R\fP0/80/0/67.9666667 This is the range of x,y we
will get from a Spherical Mercator projection using \fB\-R\fP-40/40/-70.0004681551/-29.9945810754
and \fB\-Jm\fP1. Thus, to take ship.lonlatgrav and use it to sample the merc_grav.grd, we
can do this:
.br
.sp
\fBgmtset\fP ELLIPSOID Sphere
.br
\fBmapproject\fP \fB\-R\fP-40/40/-70.0004681551/-29.9945810754 \fB\-Jm\fP1 ship.lonlatgrav | \fBgrdtrack\fP
\fB\-G\fPmerc_grav.grd | \fBmapproject\fP \fB\-R\fP-40/40/-70.0004681551/-29.9945810754 \fB\-Jm\fP1
\fB\-I\fP > ship.lonlatgravsat
.br
.sp
It is recommended to use the above method of projecting and unprojecting the data in such an
application, because then there is only one interpolation step (in \fBgrdtrack\fP). If one first
tries to convert the grd file to lon,lat and then sample it, there are two interpolation steps
(in conversion and in sampling).
.br
.sp
To make a lon,lat grid from the above grid we can use
.br
.sp
\fBgrdproject\fP merc_grav.grd \fB\-R\fP-40/40/-70.0004681551/-29.9945810754 \fB\-Jm\fP1 \fB\-I\fP
\fB\-F\fP \fB\-D\fP2m \fB\-G\fPgrav.grd
.br
.sp
In some cases this will not be easy as the \fB\-R\fP in the two coordinate systems may not align well.
When this happens, we can also use (in fact, it may be always better to use)
.br
.sp
\fBgrd2xyz\fP merc_grav.grd | \fBmapproject\fP \fB\-R\fP-40/40/-70.0004681551/-29.994581075 \fB\-Jm\fP1
\fB\-I\fP | \fBsurface\fP \fB\-R\fP-40/40/-70/70 \fB\-I\fP2m \fB\-G\fPgrav.grd
.br
.sp
To make a Mercator map of the above region, suppose our \.gmtdefaults4 MEASURE_UNIT is inch. Then
since the above merc_grav.grd file is projected with \fB\-Jm\fP1 it is 80 inches wide. We can
make a map 8 inches wide by using \fB\-Jx\fP0.1 on any map programs applied to this grid (e.g.,
\fBgrdcontour\fP, \fBgrdimage\fP, \fBgrdview\fP), and then for overlays which work in lon,lat (e.g., \fBpsxy\fP, \fBpscoast\fP)
we can use the above adjusted \fB\-R\fP and \fB\-Jm\fP0.1 to get the two systems to match up.
.br
.sp
However, we can be smarter than this. Realizing that the input img file had pixels 2.0 minutes
wide (or checking the nx and ny with grdinfo merc_grav.grd) we realize that merc_grav.grd used
the full resolution of the img file and it has 2400 by 2039 pixels, and at 8 inches wide this
is 300 pixels per inch. We decide we don't need that many and we will be satisfied with 100\"'
pixels per inch, so we want to average the data into 3 by 3 squares. (If we want a contour plot
we will probably choose to average the data much more (e.g. 6 by 6) to get smooth contours.)
Since 2039 isn't divisible by 3 we will get a different adjusted \fB\-R\fP this time:\"'
.br
.sp
\fBimg2mercgrd\fP world_grav.img.7.2 \fB\-G\fPmerc_grav_2.grd \fB\-R\fP-40/40/-70/-30 \fB\-T\fP1 \fB\-N\fP3
\fB\-V\fP
.br
.sp
This time we find the adjusted region is \fB\-R\fP-40/40/-70.023256525/-29.9368261101 and the output
is 800 by 601 pixels, a better size for us. Now we can create an artificial illumination file for
this using \fBgrdgradient\fP:
.br
.sp
\fBgrdgradient\fP merc_grav_2.grd \fB\-G\fPillum.grd \fB\-A\fP0/270 \fB\-N\fPe0.6
.br
.sp
and if we also have a cpt file called "grav.cpt" we can create a color shaded relief map like this:
.br
.sp
\fBgrdimage\fP merc_grav_2.grd \fB\-I\fPillum.grd \fB\-C\fPgrav.cpt \fB\-Jx\fP0.1 \fB\-K\fP > map.ps
.br
\fBpsbasemap\fP \fB\-R\fP-40/40/-70.023256525/-29.9368261101 \fB\-Jm\fP0.1 \fB\-B\fPa10 \fB\-O\fP >> map.ps
.br
.sp
Suppose you want to obtain only the constrained data values from an img file, in lat/lon coordinates.
Then run \fBimg2mercgrd\fP with the \fB\-T\fP2 option, use \fBgrd2xyz\fP to dump the values, pipe through grep -v
NaN to eliminate NaNs, and pipe through \fBmapproject\fP with the inverse projection as above.
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR grdproject (GMTMANSECTION),
.IR mapproject (GMTMANSECTION)
