.TH GMTLEGS GMTMANSECTION "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
gmtlegs \- Find cruises in a given region
.SH SYNOPSIS
\fBgmtlegs \-R\fP\fIwest/east/south/north \fR[ \fB\-G\fP ] [ \fB\-M\fP ] [ \fB\-T\fP ]
[ \fB\-L\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBgmtlegs\fP will report the name of all the cruises that happened to be wholly or partially inside the
specified region. As an option, only those cruises that collected a certain type of data can be
reported.
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.SH OPTIONS
No space between the option flag and the associated arguments
.TP
.B \-G
Report cruises that collected Gravity data. [Default is any data].
.TP
.B \-M
Report cruises that collected Magnetics. [Default is any data].
.TP
.B \-T
Report cruises that collected Topography. [Default is any data].
.TP
.B \-L
Long output, i.e. cruisenames and data types available. [Default is cruisenames only].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To find all cruises around Hawaii that collected gravity and topography:
.br
.sp
\fBgmtlegs\fP \fB\-R\fR-162/-152/18/25 \fB\-G \-T\fP > hawaii_gt.legs
.br
.sp
To find all cruises with magnetics:
.br
.sp
\fBgmtlegs\fP \fB\-R\fR0/360/-90/90 \fB\-M\fP > all_m.legs
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR gmt2bin (GMTMANSECTION),
.IR binlegs (GMTMANSECTION)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2004, The Generic Mapping Tools (GMT) version
4 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http:
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
