.TH X2SYS_GET GMTMANSECTION "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
x2sys_get \- Get track listing from track index databases
.SH SYNOPSIS
\fBx2sys_get\fP \fB\-T\fP\fITAG\fP [ \fB\-F\fP\fIflags\fP ]
[ \fB\-R\fIwest/east/south/north\fP ] [ \fB\-S\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBx2sys_get\fP will return the track data files that match the given
requirements. You may choose a geographic region and optionally ask
only for tracks that meet certain data criteria.
.TP
\fITAG\fP
The unique name of this data type system.
.SH OPTIONS
No space between the option flag and the associated arguments
.TP
.B \-F
Give a comma-separated list of column names as defined in the definition
file. [Default is all data columns].
.TP
.B \-R
\fIxmin, xmax, ymin,\fP and \fIymax\fP specify the Region of interest. For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn. The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected TIME_EPOCH and in the selected TIME_UNIT; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT[\fP\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP). At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required. The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx]. The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible).
.TP
.B \-S
Strip off the filename suffix when reporting.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To find all the tracks associated with the tag MGD77, restricted to occupy
a certain region in the south Pacific, and have at least free air anomalies
and bathymetry, try
.br
.sp
\fBx2sys_get\fP \fB\-V \-T\fPMGD77 \fB\-R\fP180/240/-60/-30 \fB\-F\fPfaa,top
.SH "SEE ALSO"
.IR x2sys_binlist (GMTMANSECTION)
.IR x2sys_put (GMTMANSECTION)
