.TH MGD77LIST GMTMANSECTION "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
mgd77list \- A data-extractor for MGD77[+] files
.SH SYNOPSIS
\fBmgd77list\fP \fINGDC-ids\fP \fB\-F\fP\fIcolumns\fP[,\fIlogic\fP][:\fIbittests\fP] 
[ \fB\-Ac\fP|\fBd\fP|\fBf\fP|\fBm\fP\fIcode\fP ] [ \fB\-C\fP\fBf\fP|\fBg\fP|\fBe\fP ] 
[ \fB\-Da\fP\fIstartdate\fP ] [ \fB\-Db\fP\fIstopdate\fP ] [ \fB\-E\fP ] 
[ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP\fIignore\fP ] [ \fB\-X\fP[\fIcorrtable\fP] ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-Nd\fP|\fBs\fP\fIunit\fP ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-Sa\fP\fIstartdist\fP[unit] ] 
[ \fB\-Sb\fP\fIstopdist\fP[unit] ] [ \fB\-T\fP[\fBm\fP|\fBe\fP] ]  [ \fB\-V\fP ] 
[ \fB\-W\fP\fIweight\fP ] [ \fB\-Z\fP\fI+\fP|\fB-\fP ] [ \fB\-bo\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBmgd77list\fP reads <NGDC-id>.[mgd77|nc] files and produces an ASCII [or binary] table.
The <NGDC-id>.[mgd77|nc] files contain track information such as leg-id, time and position,
geophysical observables such as gravity, magnetics, and bathymetry, and control codes and
corrections such as Eotvos and diurnal corrections.  The MGD77+ extended netCDF files may
also contain additional user columns (for a listing of available columns, use \fBmgd77info
\-C\fP, and to learn how to add your own custom columns, see \fBmgd77manage\fP).  The
user may extract any combination of these parameters, any of six computed quantities (distance,
heading, velocity, Carter correction, and gravity and magnetic global reference fields),
calendar sub-units of time (year, month, day, hour, min, sec), the NGDC id, and finally a
preset weight (see \fB\-W\fP).  A sub-section can be specified by passing time- or
distance-intervals along track or by selecting a geographical region.  Finally, each output
record may be required to pass any number of logical tests involving data values or bit flags.
.TP
\fINGDC-ids\fP
Can be one or more of five kinds of specifiers:
.br
1) 8-character NGDC IDs, e.g., 01010083, JA010010etc., etc.
.br
2) 2-character <agency> codes which will return all cruises from each agency.
.br
3) 4-character <agency><vessel> codes, which will return all cruises from those vessels.
.br
4) =<list>, where <list> is a table with NGDC IDs, one per line.
.br
5) If nothing is specified we return all cruises in the data base.
.br
(See mgd77info \fB\-F\fP for agency and vessel codes).
The ".mgd77" or ".nc" extensions will automatically be appended, if needed (use \fB\-I\fP
to ignore certain file types).  Cruise files will be looked for first in the current directory
and second in all directories listed in \fB$MGD77_HOME\fP/mgd77_paths.txt [If \fB$MGD77_HOME\fP
is not set it will default to \fB$GMTHOME\fP/share/mgd77].
.br
NOTE: Under Windows, only (1) and (4) are currently supported.
.TP
.B \-F
The required \fIcolumns\fP string must be a comma-separated list of parameter abbreviations
given in the desired output order.  Any parameters given in UPPER case must not be NaN in
a record for output to occur.  Unless specified separately, the output format (if ASCII) is
controlled by the GMT parameter \fBD_FORMAT\fP.  The available abbreviations are:
.TP
.B drt
The digital record type, usually 3 or 5 (for Y2K-compliant cruises).
.TP
.B id
The survey ID string (leg name).
.TP
.B ngdcid
The 8-character NGDC cruise ID string (usually the file prefix).
.TP
.B time
Choose between Absolute calendar time (\fBatime\fP, the default) in the format dictated by the GMT
parameters  \fBOUTPUT_DATE_FORMAT\fP and \fBOUTPUT_CLOCK_FORMAT\fP, or Relative time (\fBrtime\fP)
in the format dictated by the GMT parameters  \fBD_FORMAT\fP and \fBTIME_SYSTEM\fP (or
\fBTIME_EPOCH\fP and \fBTIME_UNIT\fP).
.TP
.B lon
Longitude in the format dictated by the GMT parameter \fBOUTPUT_DEGREE_FORMAT\fP.
.TP
.B lat
Longitude in the format dictated by the GMT parameter \fBOUTPUT_DEGREE_FORMAT\fP.
.TP
.B twt
Two-Way Travel time (in s).
.TP
.B depth
Corrected bathymetry (in m, positive below sealevel).
.TP
.B mtf1
Magnetic Total Field intensity from sensor 1 (in nTesla).
.TP
.B mtf2
Magnetic Total Field intensity from sensor 2 (in nTesla).
.TP
.B mag
Residual magnetic anomaly (in nTesla).
.TP
.B gobs
Observed gravity (in mGal).
.TP
.B faa
Free-air gravity anomaly (in mGal).
.TP
.B ptc
Position Type Code (1 = fix, 3 = interpolated, 9 = unspecified).
.TP
.B bcc
Bathymetric Correction Code, indicating the procedure used to convert travel time to depth.
(01-55 = Matthews' zone used to correct the depth,\"'
59 = Matthews' corrections used but the zones is unspecified in the data record, 60 = S. Kuwahara formula\"'
for T-S, 61 = Wilson formula for T-S, 62 = Del Grosso formula for T-S, 63 = Carter's tables,\"'
88 = Other, described in header sections, 99 = unspecified).
.TP
.B btc
Bathymetric Type Code, indicating how the bathymetry value was obtained (1 = observed,
3 = interpolated, 9 = unspecified).
.TP
.B msens
Magnetic sensor for used to evaluate the residual field (1 = 1st or leading sensor, 2 = 2nd or trailing sensor, 9 = unspecified).
.TP
.B msd
Depth (or altitude) of the magnetic sensor (in m, positive below sealevel).
.TP
.B diur
Magnetic diurnal correction (in nTesla).
.TP
.B eot
Eotvos correction (in mGal).
.TP
.B sln
Seismic Line Number string.
.TP
.B sspn
Seismic Shot Point Number string.
.TP
.B nqc
Navigation Quality Code (5 = suspected, by source institution, 6 = suspected, by NGDC, 9 = no problems identified).
.br
.sp
In addition, the following derived quantities can be requested:
.TP
.B year
The year of each record.
.TP
.B month
The month of each record.
.TP
.B day
The day of the month of each record.
.TP
.B hour
The hour of each record.
.TP
.B min
The minutes of each record.
.TP
.B sec
The decimal seconds of each record.
.TP
.B dist
Along-track distance from start of leg.  For method of calculation, see \fB\-C\fP [spherical great circle distances], and
for distance units, see \fB\-N\fP [km].
.TP
.B az
Ship azimuth (heading) measured clockwise from north (in degrees).
.TP
.B vel
Ship speed; see \fB\-N\fP for units [m/s]. 
.TP
.B weight
Weight assigned to this data set (see \fB\-W\fP).
.TP
.B carter
Carter depth correction, if \fBtwt\fP is present in file (in m).  Sign: Correction
is to be subtracted from uncorrected depths to yield a corrected depth.
.TP
.B igrf
International geomagnetic reference field (total field) (in nTesla).
.TP
.B ngrav
International Gravity reference Field ("normal gravity") (in mGal).
Field is selected based on the parameter Gravity Theoretical
Formula Code in the cruise's MGD77 header.  If this is not set or is invalid we default to the IGF 1980.\"'
Alternatively, specify the field directly using \fB\-Af\fP (see that option for more details).
.br
.sp
The following short-hand flags are also recognized:
.TP
.B all
This returns all data columns in the file.
.TP
.B mgd77
This results in all 27 MGD77 fields being written out in the offical MGD77 order.
.TP
.B geo
This limits the output to 10 fields (\fBtime\fP, \fBlon\fP, \fBlat\fP plus the seven geophysical observations
\fBtwt\fP, \fBdepth\fP, \fBmtf1\fP, \fBmtf2\fP, \fBmag\fP, \fBgobs\fP, and \fBfaa\fP).
By appending \fB+\fP to either of these set we will also append \fBdist\fP, \fBazim\fP, \fBvel\fP, and
\fBweight\fP as listed above.
.br
.sp
As an option, logical tests may be added for any of the parameters by appending ,\fIlogic\fP,
which is itself composed of one or more comma-separated instructions
of the form \fIpar\fP\fBOP\fP\fIvalue\fP, where \fIpar\fP is one of the parameters listed above, \fBOP\fP is
a logical operator (<, <=, =, !=, >=, >, |), and \fIvalue\fP is a constant used in the comparison.  Floating point
parameters are compared numerically; character parameters are compared lexically (after leading and trailing
blanks have been removed).  The bit comparison (|) means that at least one of the bits in \fIvalue\fP
must be turned on in \fIpar\fP.  At least one of the tests must be true for the record to be output, except for
tests using UPPER case parameters which all must be true for output to occur.  Note that
specifying a test does not imply that the corresponding column will be included in the output stream;
it must be present in \fIcolumns\fP for that to occur. Note: some of the operators are special UNIX characters
and you are advised to place quotes around the entire argument to \fB\-F\fP.
.br
.sp
Finally, for MGD77+ files you may optionally append :\fIbittests\fP which is : (a colon) followed by one or more comma-separated
+-\fIcol\fP terms.  This compares specific bitflags only for each listed column.  Here, + means the chosen bit must
be 1 (ON) whereas - means it must be 0 (OFF).  All bit tests given must be passed.  By default, MGD77+
files that have the special \fBMGD77_flags\fP column present will use those flags, and observations associated with
ON-bits (meaning they are flagged as bad) will be set to NaN; append : with no trailing information
to turn this behavior off (i.e., no bit flags will be consulted).
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
By default, corrected depth (\fBdepth\fP),
magnetic residual anomaly (\fBmag\fP), free-air gravity anomaly (\fBfaa\fP),
and the derived quantity Carter depth correction (\fBcarter\fP) are all
output as is (if selected in \fB\-F\fP); this option adjusts that behavior.
For each of these columns there are 2\-4 ways to adjust the data.  Append
\fBc\fP(arter), \fBd\fP(epth), \fBf\fP(aa), or \fBm\fP(ag) and select the
\fIcode\fP for the procedure you want applied.  You may select more than
one procedure for a data column by summing their numerical \fIcode\fPs
(1, 2, 4, and 8). E.g., \fB\-Ac\fP3 will first try method \fB\-Ac\fP1 to
estimate a Carter correction but if \fBdepth\fP is NaN we will next try
\fB\-Ac\fP2 which only uses \fBtwt\fP.  In all cases, if any of the values
required by an adjustment procedure is NaN then the result will be NaN.
.TP
.B \-Ac
Determines how the \fBcarter\fP correction term is calculated.  Below, 
C(\fBtwt\fP) stands for the Carter-corrected depth (it also depends on
\fBlon\fP, \fBlat\fP), U(\fBtwt\fP, \fIv\fP) is the uncorrected depth
(= \fBtwt\fP * \fIv\fP / 2) using as \fIv\fP the "Assumed Sound Velocity"
parameter in the MGD77 header (if it is a valid velocity, otherwise we default to
1500 m/s); alternatively, append your preferred velocity \fIv\fP in m/s,
TU(\fBdepth\fP, \fIv\fP) is the 2-way travel time estimated from the
(presumably) uncorrected \fBdepth\fP, and TC(\fBdepth\fP) is the
2-way travel time obtained by inverting the (presumably) corrected \fBdepth\fP
using the Carter correction formula.
Select from
.br
\fB\-Ac1\fP[,\fIv\fP]
returns difference between U(\fBtwt\fP, \fIv\fP) and \fBdepth\fP [Default].
.br
\fB\-Ac2\fP[,\fIv\fP]
returns difference between U(\fBtwt\fP, \fIv\fP) and Carter (\fBtwt\fP).
.br
\fB\-Ac4\fP[,\fIv\fP]
returns difference between (assumed uncorrected) \fBdepth\fP and Carter (TU(\fBdepth\fP)).
.br
\fB\-Ac8\fP[,\fIv\fP]
returns difference between U(TC(\fBdepth\fP), \fIv\fP) and \fBdepth\fP.
.TP
.B \-Ad
Determines how the \fBdepth\fP column output is obtained:
.br
\fB\-Ad1\fP
returns \fBdepth\fP as stored in the data set [Default].
.br
\fB\-Ad2\fP[,\fIv\fP]
returns calculated uncorrected depth U(\fBtwt\fP, \fIv\fP).
.br
\fB\-Ad4\fP
returns calculated corrected depth C(\fBtwt\fP).
.TP
.B \-Af
Determines how the \fBfaa\fP column output is obtained. If \fBngrav\fP (i.e., the International
Gravity reference Field (IGF), or "normal gravity") is required
it is selected based on the MGD77 header parameter "Theoretical Gravity Formula Code";
if this code is not present or is invalid we default to 4.  Alternatively, append the preferred \fIfield\fP
(1\-4) to select 1 (Heiskanen 1924), 2 (IGF 1930), 3 (IGF 1967) or 4 (IGF 1980).  Select from
.br
\fB\-Af1\fP[,\fIfield\fP]
returns \fBfaa\fP as stored in the data set [Default]. Optionally, sets the IGF \fIfield\fP
to use if you also have requested \fBngrav\fP as an output column in \fB\-F\fP.
.br
\fB\-Af2\fP[,\fIfield\fP]
returns the difference between \fBgobs\fP and \fBngrav\fP (with optional \fIfield\fP directive).
.TP
.B \-Am
Determines how the \fBmag\fP column output is obtained.  There may be one or two
total field measurements in the file (\fBmtf1\fP and \fBmtf2\fP), and the column \fBmsens\fP
may state which one is the leading sensor (1 or 2; it may also be undefined).  Select from
.br
\fB\-Am1\fP
returns \fBmag\fP as stored in the data set [Default].
.br
\fB\-Am2\fP
returns the difference between \fBmgfx\fP and \fBigrf\fP, where
\fBx\fP is the leading sensor (\fB1\fP or \fB2\fP) indicated by the \fBmsens\fP data field
(defaults to \fB1\fP if unspecified).
.br
\fB\-Am4\fP
returns the difference between \fBmgfx\fP and \fBigrf\fP, where
\fBx\fP is the sensor (\fB2\fP or \fB1\fP) \fInot\fP indicated by the \fBmsens\fP data field
(defaults to \fB2\fP if unspecified).
.TP
.B \-C
Append a one-letter code to select the procedure for along-track distance
calculation (see \fB\-N\fP for selecting units):
.br
	\fBf\fP Flat Earth distances.
.br
	\fBg\fP Great circle distances [Default].
.br
	\fBe\fP Geodesic distances on current GMT ellipsoid.
.TP
.B \-Da
Do not list data collected before \fIstartdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss])  [Default is start of cruise].
.TP
.B \-Db
Do not list data collected after \fIstopdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss]). [Default is end of cruise].
.TP
.B \-E
Exact match: Only output records that match all the requested geophysical columns
[Default outputs records that matches at least one of the observed columns].
.TP
.B \-H
Issue a header record with names for each data field.
.TP
.B \-I
Ignore certain data file formats from consideration. Append \fBa|c|t\fP to ignore
MGD77 ASCII, MGD77+ netCDF, or plain tab-separated ASCII table files, respectively. The option may
be repreated to ignore more than one format.  [Default ignores none].
.TP
.B \-L
Apply optimal corrections to columns where such corrections are available.  Append the correction
table to use [Default uses the correction table mgd77_corrections.d in the \fB$MGD77_HOME\fP directory].
For the format of this file, see CORRECTIONS below.
.TP
.B \-M
Issue a multi-segment header record with cruise ID for each cruise.
.TP
.B \-N
Append \fBd\fP for distance or \fBs\fP for speed, then give the desired \fIunit\fP as
\fBe\fP (meter or m/s), \fBk\fP (km or km/hr), \fBm\fP (miles or miles/hr), or
\fBn\fP (nautical miles or knots).  [Default is \fB\-Ndk \-Nse\fP (km and m/s)].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.TP
.B \-Sa
Do not list data that are less than \fIstartdist\fP meter along track from port of departure.
Append \fBk\fP for km, \fBm\fP for miles, or \fBn\fP for nautical miles [Default is 0 meters].
.TP
.B \-Sb
Do not list data that are more than \fIstopdist\fP meters along track from port of departure.
Append \fBk\fP for km, \fBm\fP for miles, or \fBn\fP for nautical miles [Default is end of track].
.TP
.B \-T
Turns OFF the otherwise automatic adjustment of values based on correction terms that are
stored in the MGD77+ file and used to counteract such things as wrong units used by the source
institution when creating the original MGD77 file from which the MGD77+ file derives (the
option has no effect on plain MGD77 ASCII files).  Append \fBm\fP or \fBe\fP to limit the
option to the MGD77 or extended columns set only [Default applies to both].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set the weight for these data.  Weight output option must be set in \fB\-F\fP.  This is
useful if the data are to be processed with the weighted averaging techniques offered by
\fBblockmean\fP, \fBblockmedian\fP, and \fBblockmode\fP [1].
.TP
.B \-Z
Append the sign you want for \fBdepth\fP, \fBcarter\fP, and \fBmsd\fP values below sea level
(\fB\-Z-\fP gives negative bathymetry) [Default is positive down].
.TP
.B \-bo
Selects binary output mode (single precision; append \fBd\fP for double precision, or use \fBS\fP|\fBD\fP
to swap bytes on output) [Default is ASCII].
\fB\-H\fP is ignored if \fB\-bo\fP is selected.  Likewise, string-fields cannot be selected.
.SH EXAMPLES
To get a (distance, heading, gravity, bathymetry) listing from 01010047.mgd77,
starting at June 3 1971 20:45 and ending at distance = 5000 km, use the following command:
.br
.sp
\fBmgd77list\fP 01010047 \fB\-Da\fP1971-06-03T20:45 \fB\-Sb\fP5000 \fB\-F\fPdist,azim,faa,depth > myfile.d
.br
.sp
To make input for \fBblockmean\fP and \fBsurface\fP using free-air anomalies from all the cruises listed in the file cruises.lis,
but only the data that are inside the specified area, and make the output binary:
.br
.sp
\fBmgd77list\fP `cat cruises.lis` \fB\-F\fPlon,lat,faa \fB\-R\fP-40/-30/25/35 \fB\-bo\fP > allgrav.b
.br
.sp
To extract the locations of depths exceeding 9000 meter that were not interpolated (\fBbtc\fP != 1)
from all the cruises listed in the file cruises.lis:
.br
.sp
\fBmgd77list\fP `cat cruises.lis` \fB\-F\fP"depth,DEPTH>9000,BTC!=1" > really_deep.d
.br
.sp
To extract dist, faa, and grav12_2 from records whose depths are shallower than 3 km
and where none of the requested fields are NaN, from all the MGD77+ netCDF files whose
cruise ids are listed in the file cruises.lis, we try
.br
.sp
\fBmgd77list\fP `cat cruises.lis` \fB\-E \-Ia \-F\fP"dist,faa,grav12_2,depth<3000" > shallow_grav.d
.br
.sp
To extract dist, faa, and grav12_2 from all the MGD77+ netCDF files whose
cruise ids are listed in the file cruises.lis, but only retrieve records
whose bitflag for faa indicates BAD values, we try
.br
.sp
\fBmgd77list\fP `cat cruises.lis` \fB\-E \-Ia \-F\fP"dist,faa,grav12_2:+faa" > bad_grav.d
.br
.sp
To output lon, lat, mag, and faa from all the cruises listed in the file cruises.lis,
but recalculate the two residuals based on the latest reference fields, try:
.br
.sp
\fBmgd77list\fP `cat cruises.lis` \fB\-F\fPlon,lat,mag,faa \fB\-Af\fP2,4 \fB\-Am\fP2 > data.d
.SH IGRF
The IGRF calculations are based on a Fortran program written by Susan Macmillan,
British Geological Survey, translated to C via f2c by Joaquim Luis, U Algarve, and adapted to
GMT-style by Paul Wessel.
.SH IGF
The equations used are reproduced here using coefficients extracted directly from the source code (let us know if you find errors):
.br
(1) g = 978052.0 * [1 + 0.005285 * sin^2(lat) - 7e-6 * sin^2(2*lat) + 27e-6 * cos^2(lat) * cos^2(lon-18)]
.br
(2) g = 978049.0 * [1 + 0.0052884 * sin^2(lat) - 0.0000059 * sin^2(2*lat)]
.br
(3) g = 978031.846 * [1 + 0.0053024 * sin^2(lat) - 0.0000058 * sin^2(2*lat)]
.br
(4) g = 978032.67714 * [(1 + 0.00193185138639 * sin^2(lat)) / sqrt (1 - 0.00669437999013 * sin^2(lat))]
.SH CORRECTIONS
The correction table is an ASCII file with coefficients and parameters needed to carry out corrections.
Comment records beginning with # are allowed.  All correction records are of the form
.br
.sp
\fIcruiseID observation correction\fP
.br
.sp
where \fIcruiseID\fP is a NGDC prefix, \fIobservation\fP is one of the abbreviations for geophysical observations
listed under \fB\-F\fP above, and \fIcorrection\fP consists of one or more \fIterm\fPs that will be summed up and
then \fBsubtracted\fP from the observation before output.  Each \fIterm\fP must have this exact syntax:
.br
.sp
\fIfactor\fP[*[\fIfunction\fP]([\fIscale\fP](\fIabbrev\fP[-\fIorigin\fP]))[^\fIpower\fP]]
.br
.sp
where terms in brackets are optional (the brackets themselves are not used but regular parentheses must
be used as indicated).  No spaces are allowed except between \fIterm\fPs. The \fIfactor\fP is the amplitude
of the basis function, while the optional \fIfunction\fP can be one of sin, cos, or exp. The
optional \fIscale\fP and \fIorigin\fP can be used to translate the argument (before giving it to the optional
function).  The argument \fIabbrev\fP is one of the abbreviations for observations listed above.  If \fIorigin\fP is
given as \fBT\fP it means that we should replace it with the value of \fIabbrev\fP for the very
first record in the file (this is usually only done for \fItime\fP).  If the first record entry is
NaN we revert \fIorigin\fP to zero.  Optionally, raise the entire expression to the given \fIpower\fP,
before multiplying by the amplitude.  The following is an example of ficticious corrections to the
cruise 99999999, implying the \fBdepth\fP should have the Carter correction removed, \fBfaa\fP should have a linear
trend removed, the magnetic anomaly (\fBmag\fP) should be corrected by a strange dependency on ship heading and latitude, and
\fBgob\fPs needs to have 10 mGal added (hence given as -10):
.br
.sp
99999999 depth	1.0*((carter))
.br
99999999 faa	14.1	1e-5*((time-T))
.br
99999999 mag	0.5*cos(0.5*(azim-19))^2	1.0*exp(-1e-3(lat))^1.5
.br
99999999 gobs	-10
.SH "SEE ALSO"
.IR mgd77convert (GMTMANSECTION),
.IR mgd77info (GMTMANSECTION),
.IR mgd77manage (GMTMANSECTION),
.IR mgd77track (GMTMANSECTION)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2005, The Generic Mapping Tools (GMT) version
4.1 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
The Marine Geophysical Data Exchange Format - "MGD77", see
\fIhttp://www.ngdc.noaa.gov/mgg/dat/geodas/docs/mgd77.txt\fP
.br
IGRF, see \fIhttp://www.ngdc.noaa.gov/IAGA/vmod/igrf.html\fP
.br
