.TH BLOCKMODE l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
blockmode \- filter to block average (\fIx,y,z\fP) data by mode estimation.
.SH SYNOPSIS
\fBblockmode\fP [ \fIxyz[w]file(s)\fP ] \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] \fB\-R\fP\fIxmin\fP/\fIxmax\fP/\fIymin\fP/\fIymax\fP[\fBr\fP] 
[ \fB\-C\fP ] [ \fB\-E\fP ] [ \fB\-F\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-Q\fP ] [ \fB\-V\fP ] 
[ \fB\-W\fP[\fBio\fP] ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBblockmode\fP reads arbitrarily located (\fIx,y,z\fP) triples [or optionally weighted
quadruples (\fIx,y,z,w\fP)] from standard input [or \fIxyz[w]file(s)\fP] and writes to
standard output mode estimates of position and value for every non-empty block in a grid
region defined by the \fB\-R\fP and \fB\-I\fP arguments.  Either \fBblockmean\fP, \fBblockmedian\fP,
or \fBblockmode\fP should be used as a pre-processor before running \fBsurface\fP to avoid
aliasing short wavelengths.  These routines are also generally useful for decimating or
averaging (\fIx,y,z\fP) data.  You can modify the precision of the output format by editing
the \fBD_FORMAT\fP parameter in your .gmtdefaults4 file, or you may choose binary input
and/or output using single or double precision storage.
.TP
\fIxyz[w]file(s)\fP
3 [or 4] column ASCII file(s) [or binary, see \fB\-b\fP] holding (\fIx,y,z\fP[,\fIw\fP])
data values.  [\fIw\fP] is an optional weight for the data.  If no file is specified,
\fBblockmode\fP will read from standard input.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
.sp
.TP
.B \-C
Use the center of the block as the output location [Default uses the modal xy location
(but see \fB\-Q\fP)].  \fB\-C\fP overrides \fB\-Q\fP.
.TP
.B \-E
Provide Extended report which includes \fBs\fP (the L1 scale of the mode),
\fBl\fP, the lowest value, and \fBh\fP, the high value for each block. Output order
becomes \fIx,y,z,s,l,h\fP[,\fIw\fP]. [Default outputs \fIx,y,z\fP[,\fIw\fP].
See \fB\-W\fP for \fIw\fP output.
.TP
.B \-F
Block centers have pixel registration. [Default:  grid registration.]  (Registrations
are defined in  \fBGMT\fP Cookbook Appendix B on grid file formats.)  Each block is the
locus of points nearest the grid value location.  For example, with \fB\-R\fP10/15/10/15
and and \fB\-I\fP1:  with the \fB\-F\fP option 10 <= (\fIx,y\fP) < 11 is one of 25 blocks;
without it 9.5 <= (\fIx,y\fP) < 10.5 is one of 36 blocks.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
Not used with binary data.
.TP
.B \-Q
(Quicker) Finds mode \fIz\fP and mean (\fIx, y\fP) [Default finds mode \fIx\fP,
mode \fIy\fP, mode \fIz\fP].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Weighted modifier[s].  Unweighted input and output has 3 columns \fIx,y,z\fP; Weighted
i/o has 4 columns \fIx,y,z,w\fP.  Weights can be used in input to construct weighted
mean values in blocks.  Weight sums can be reported in output for later combining several
runs, etc.  Use \fB\-W\fP for weighted i/o, \fB\-Wi\fP for weighted inputonly, \fB\-Wo\fP for
weighted output only.  [Default uses unweighted i/o].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 3 (or 4 if \fB\-Wi\fP is set)].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is 3 (or 4 if \fB\-Wo\fP is set)]. \fB\-E\fP adds 3 additional columns.
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH EXAMPLES
To find 5 by 5 minute block mode estimates from the double precision binary data in
hawaii_b.xyg and output an ASCII table, run:
.sp
\fBblockmode\fP hawaii_b.xyg \fB\-R\fP198/208/18/25 \fB\-I\fP5\fBm \-bi\fP3 > hawaii_5x5.xyg
.SH "SEE ALSO"
.IR blockmean (l),
.IR blockmedian (l),
.IR GMT (l),
.IR gmtdefaults (l),
.IR nearneighbor (l),
.IR surface (l),
.IR triangulate (l)
