.TH GRDSAMPLE l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
grdsample \- Resample a grd file onto a new grid
.SH SYNOPSIS
\fBgrdsample\fP \fIin_grdfile\fP \fB\-G\fP\fIout_grdfile\fP [ \fB\-F\fP ] [ \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] ] 
[ \fB\-L\fP\fIflag\fP ] [ \fB\-Q\fP[\fIvalue\fP] ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-T\fP ] [ \fB\-V\fP ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdsample\fP reads a grdfile and interpolates it to create a new grdfile with either:  a different registration 
(\fB\-F\fP or \fB\-T\fP); or, a new grid-spacing or number of nodes (\fB\-I\fP), and perhaps also a new sub-region 
(\fB\-R\fP).  Interpolation is bicubic [Default] or bilinear (\fB\-Q\fP) and uses boundary conditions (\fB\-L\fP).  
Note that using \fB\-R\fP only is equivalent to \fBgrdcut\fP or \fBgrdedit \-S\fP.  \fBgrdsample\fP safely 
creates a fine mesh from a coarse one; the converse may suffer aliasing unless the data are filtered using
\fBgrdfft\fP or \fBgrdfilter\fP.
.br
.sp
When \fB\-R\fP is omitted, the output grid will cover the same region as the input grid.
When \fB\-I\fP is omitted, the grid spacing of the output grid will be the same as the input grid.
Either \fB\-F\fP or \fB\-T\fP can be used to change the grid registration. When omitted, the output grid will
have the same registration as the input grid.
.TP
\fIin_grdfile\fP
The name of the input 2-D binary grd file.
.TP
.B \-G
The name of the output grd file.
.SH OPTIONS
.TP
.B \-F
Force pixel registration on output grid.  [Default is same registration as input grid].
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-L
Boundary condition \fIflag\fP may be \fIx\fP or \fIy\fP or \fIxy\fP indicating data is periodic in range of 
x or y or both set by \fB\-R\fP, or \fIflag\fP may be \fIg\fP indicating geographical conditions (x and y are 
lon and lat).  [Default uses "natural" conditions (second partial derivative normal to edge is zero).]  
.TP
.B \-Q
Quick mode, use bilinear rather than bicubic interpolation [Default].  Optionally, append \fIvalue\fP in the
0 <= \fIvalue\fP <= 1 range.  This parameter controls how close to nodes with NaN values the
interpolation will go.  E.g., a \fIvalue\fP of 0.5 will interpolate about 1/2-way from a non-NaN to a
NaN node, whereas 0.1 will go about 90% of the way, etc. [Default is 1, which means none of the four nearby
nodes may be NaN].  A \fIvalue\fP of 0 will just return the value of the nearest node instead of interpolating.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.TP
.B \-T
Translate between grid and pixel registration;  if the input is 
grid-registered, the output will be pixel-registered and vice-versa.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH GRID VALUES PRECISION
Regardless of the precision of the input data, GMT programs that create
gridded files will internally hold the grids in 4-byte floating point
arrays.  This is done to conserve memory and futhermore most if not all
real data can be stored using 4-byte floating point values.  Data with
higher precision (i.e., double precision values) will loose that precision
once GMT operates on the grid or writes out new grids.  To limit loss
of precision when processing data you should always consider normalizing
the data prior to processing.
.SH HINTS
If an interpolation point is not on a node of the input grid, then a NaN at any node in the neighborhood 
surrounding the point will yield an interpolated NaN.  Bicubic interpolation [default] yields continuous 
first derivatives but requires a neighborhood of 4 nodes by 4 nodes.  Bilinear interpolation [\fB\-Q\fP]
uses only a 2 by 2 neighborhood, but yields only zeroth-order continuity.  Use bicubic when smoothness is 
important.  Use bilinear to minimize the propagation of NaNs.
.SH EXAMPLES
To resample the 5 x 5 minute grid in hawaii_5by5_topo.grd onto a 1 minute grid:
.br
.sp
\fBgrdsample\fP hawaii_5by5_topo.grd \fB\-I\fP1\fBm \-G\fPhawaii_1by1_topo.grd
.br
.sp
To translate the gridline-registered file surface.grd to pixel registration while
keeping the same region and grid interval:
.br
.sp
\fBgrdsample\fP surface.grd \fB\-T \-G\fPpixel.grd
.SH "SEE ALSO"
.IR GMT (l),
.IR grdedit (l),
.IR grdfft (l),
.IR grdfilter (l)
