.TH GRDRASTER GMTMANSECTION "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
grdraster \- extract subregion from a binary raster and write a grd file
.SH SYNOPSIS
\fBgrdraster\fP [ \fIfilenumber\fP | \fI"text pattern"\fP ] \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-G\fP\fIgrdfilename\fP ] [ \fB\-I\fP\fIxinc\fP[\fBm\fP|\fBc\fP][/\fIyinc\fP[\fBm\fP|\fBc\fP]] ] [ \fB\-J\fP\fIparameters\fP ] [ \fB\-V\fP ] 
[ \fB\-bo\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] 
.SH DESCRIPTION
\fBgrdraster\fP reads a file called \fIgrdraster.info\fP from the current
working directory, the directories pointed to by the environment variables
\fB$GMT_USERDIR\fP and \fB$GMT_GRIDDIR\fP, or in \fB$GMTHOME\fP/share/dbase
(in that order).  The file \fIgrdraster.info\fP defines binary
arrays of data stored in scan-line format in data files.  Each file is given
a \fIfilenumber\fP in the info file.  \fBgrdraster\fP figures out how to
load the raster data into a grd file spanning a region defined by \fB\-R\fP.
By default the grid spacing equals the raster spacing.  The \fB\-I\fP option
may be used to sub-sample the raster data.  No filtering or interpolating is
done, however; the \fIx_inc\fP and \fIy_inc\fP of the grd file must be
multiples of the increments of the raster file and \fBgrdraster\fP simply 
takes every n'th point.  The output of \fBgrdraster\fP is either grid or\"'
pixel registered depending on the registration of the raster used.  It is up
to the \fBGMT\fP system person to maintain the \fIgrdraster.info\fP file in
accordance with the available rasters at each site.  Raster data sets are
not supplied with \fBGMT\fP but can be obtained by anonymous ftp and on 
CD-ROM (see README page in dbase directory).  \fBgrdraster\fP will list the
available files if no arguments are given.  Finally, \fBgrdraster\fP will
write xyz-triplets to stdout if no output gridfile name is given
.TP
\fIfilenumber\fP
If an integer matching one of the files listed in the \fIgrdraster.info\fP file
is given we will use that data set, else we will match the given text pattern
with the data set description in order to determine the data set.
.sp
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
If \fBr\fP is appended, you may also specify a map projection to define the shape of
your region.  The output region will be rounded off to the nearest whole grid-step
in both dimensions.
.SH OPTIONS
.TP
.B \-G
Name of output grid file.  If not set, the grid will be written as ASCII
(or binary; see \fB\-bo\fP xyz-triplets to stdout instead.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
This option applies only if no \fB\-G\fP option has been set.
.SH EXAMPLES
.sp
To extract data from raster 1, taking one point every 30 minutes, in an 
area extended beyond 360 degrees to allow later filtering, run
.br
.sp
\fBgrdraster\fP 1 \fB\-R\fP-4/364/-62/62 \fB\-I\fP30\fBm \-G\fPdata.grd
.br
.sp
To obtain data for an oblique Mercator projection we need to extract more data
that is actually used.  This is necessary because the output of \fBgrdraster\fP has edges defined by
parallels and meridians, while the oblique map in general does not.  Hence, to
get all the data from the ETOPO2 data needed to make a contour map for the region defined by its
lower left and upper right corners and the desired projection, use
.br
.sp
\fBgrdraster\fP ETOPO2 \fB\-R\fP160/20/220/30\fBr\fP \fB\-Joc\fP190/25.5/292/69/1 \fB\-G\fPdata.grd
.br
.sp
To extract data from the 2 min Geoware relief blend and write it as binary double precision xyz-triplets to
standard output:
.br
.sp
\fBgrdraster\fP "2 min Geoware" \fB\-R\fP20/25/-10/5  \fB\-bo\fP >! triplets.b
.br
.sp
.SH "SEE ALSO"
.IR gmtdefaults (GMTMANSECTION),
.IR GMT (GMTMANSECTION),
.IR grdsample (GMTMANSECTION),
.IR grdfilter (GMTMANSECTION)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2005, The Generic Mapping Tools (GMT) version
4.1 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
