.TH NC2XY GMTMANSECTION "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
nc2xy \- Converting netCDF column file(s) to ASCII xy data
.SH SYNOPSIS
\fBnc2xy\fP \fIfiles\fP [ \fB\-F\fP\fIvar1/var2/...\fP ] [ \fB\-S\fP[\fBr\fP] ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBnc2xy\fP reads one or more netCDF files with column data and writes out those columns in ASCII format
to standard output, so that they can be used by \fBpsxy\fP, \fBpsxyz\fP, or \fBxyz2grd\fP.
Modify the precision of the ASCII output format by editing the \fBD_FORMAT\fP parameter in your \.gmtdefaults4 file
or use \fB\-\-D_FORMAT=\fP\fIformat\fP on the command line.
.TP
\fIfiles\fP
Names of netCDF files to be converted.
.SH OPTIONS
.TP
.B \-F
Specify up to 10 names of the variables (separated by slashes) to be printed out. All variables need to have
only one dimension of equal length. When omited, the first two variables in the netCDF file will be printed.
.TP
.B \-S
Suppress output for records with one or more NaN values [Default outputs all nodes].
Append \fBr\fP to reverse the suppression, i.e., only output the records with at least one NaN value.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To print out latitude, longitude and height in a netCDF file as ASCII records, while suppressing all NaN values:
.br
.sp
\fBnc2xy\fP \fB\-F\fPlat/lon/height \fB\-S\fP trackfile.nc > trackfile.xy
.SH "SEE ALSO"
.IR gmtdefaults (GMTMANSECTION),
.IR GMT (GMTMANSECTION),
.IR grdedit (GMTMANSECTION),
.IR psxy (GMTMANSECTION),
.IR psxyz (GMTMANSECTION),
.IR xyz2grd (GMTMANSECTION)
