.TH X2SYS_BINLIST GMTMANSECTION "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
x2sys_binlist \- Create bin-index files from track data files
.SH SYNOPSIS
\fBx2sys_binlist\fP \fItrack(s)\fP [ \fB\-T\fP\fITAG\fP ] [ \fB\-Cc\fP|\fBf\fP|\fBg\fP|\fBe\fP ] 
[ \fB\-D\fP ] [ \fB\-N\fP\fIunit\fP ] [ \fB\-V\fP ]
.SH DESCRIPTION
\fBx2sys_binlist\fP reads one or more track data files and produces a
multi-segment ASCII track bin-index file (tbf) with the track id in the header and
one data record per bin crossed; these records contain \fIlon, lat, index, flags\fP[, \fIdist\fP],
where \fIlon, lat\fP is the coordinates of the center of the bin, the \fIindex\fP is
the 1-D number of the bin, and \fIflags\fP is a bitflag that describes which data
fields were available in each bin.  The optional \fIdist\fP requires \fB\-D\fP.
The input files can be of any format, which must be described and passed with the
\fB\-T\fP option.  The bin-index listing is a crude representation of where
the track goes and is used by the data archivist to build a track data base for
track queries such as to determine which tracks
need to be compared for crossover analysis.  You must run \fBx2ys_init\fP
to initialize the tag before you can run the indexing.
.TP
\fItracks\fP
Can be one or more binary or ASCII data files. To give a list of names,
use `cat tracks.lis`.  If the names are missing the suffix we will
append the suffix that goes with this \fITAG\fP.  Track files will be looked
for first in the current directory and second in all directories listed in
\fB$X2SYS_HOME\fP/\fITAG\fP_paths.txt (if it exists). [If \fB$X2SYS_HOME\fP
is not set it will default to \fB$GMTHOME\fP/share/x2sys].
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-C
Append a one-letter code to select the procedure for along-track distance
calculation selected with \fB\-D\fP (see \fB\-N\fP for selecting units):
.br
	\fBc\fP Cartesian distances in user units [Default].
.br
	\fBf\fP Flat Earth distances.
.br
	\fBg\fP Great circle distances.
.br
	\fBe\fP Geodesic distances on current \fBGMT\fP ellipsoid.
.TP
.B \-D
Calculate the length of trackline segments per bin [Default skips this step].
See \fB\-C\fP for method and \fB\-N\fP for units.  The length fragments are
given as the 5th output column (after the \fIflags\fP).
.TP
.B \-N
Append the desired distance \fIunit\fP as \fBe\fP (meter), \fBk\fP (km),
\fBm\fP (miles), or \fBn\fP (nautical miles).  [Default is \fB\-Nk\fP (km)].
Requires \fB\-D\fP.
.TP
.B \-T
Sets the data set \fITAG\fP which among other things sets the definition file.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To create a bin index table from the MGD77 file 01030061.mgd77 using a global, 1x1 degree bin system, do
.br
.sp
\fBx2sys_binlist\fP 01030061.mgd77 \fB\-T\fPMGD77 > 01030061.tbf
.br
.sp
To create a track bin index file of all MGD77+ files residing in the current directory at a bin resolution
of 30 x 30 minutes, calculating the geodesic distance lengths for each bin in km, run
.br
.sp
\fBx2sys_binlist\fP *.nc \fB\-T\fPMGD77+ \fB\-Ce \-D\fP > all.tbf
.SH "SEE ALSO"
.IR gmtdefaults (GMTMANSECTION)
.IR x2sys_init (GMTMANSECTION)
