.TH GMTSELECT l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
gmtselect \- Select data subsets based on multiple spatial criteria 
.SH SYNOPSIS
\fBgmtselect\fP [ \fIinfiles\fP ] [ \fB\-A\fP\fImin_area\fP[/\fImin_level/max_level\fP] ] 
[ \fB\-C\fP[\fBf\fP]\fIdist/ptfile\fP ] [ \fB\-D\fP\fIresolution\fP ] [ \fB\-F\fP\fIpolygonfile\fP ] 
[ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP[\fBcflrs\fP] ] [ \fB\-J\fP\fIparameters\fP ] [ \fB\-L\fP\fIdist/linefile\fP ] [ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] 
[ \fB\-N\fP\fImaskvalues\fP[\fBo\fP] ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-V\fP ] [ \fB\-Z\fP\fImin/max\fP] ] 
[ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgmtselect\fP is a filter that reads (longitude, latitude) positions from the first 2 columns of
\fIinfiles\fP [or standard input] and uses a combination of 1-6 criteria to pass or reject the records.
Records can be selected based on whether or not they are 1) inside a rectangular region (\fB\-R\fP
[and \fB\-J\fP]), 2) within \fIdist\fP km of any point in \fIptfile\fP, 3) within \fIdist\fP km of
any line in \fIlinefile\fP, 4) inside one of the polygons in the \fIpolygonfile\fP, 5) inside
geographical features (based on coastlines), or 6) has z-values within a given range.
The sense of the tests can be reversed for each of these 6 criteria by using the \fB\-I\fP option.
See option \fB\-:\fP on how to read (latitude,longitude) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfiles\fP
ASCII (or binary, see \fB\-b\fP) data file(s) to be operated on.  If not given, standard input is read.
.SH OPTIONS
.TP
.B \-A
Ignored unless \fB\-N\fP is set.  Geographical features with an area smaller than \fImin_area\fP
in km^2 or of hierarchical level that is lower than \fImin_level\fP or higher than \fImax_level\fP
will be ignored [Default is 0/4 (all features)]. See DATABASE INFORMATION in the \fBpscoast\fP man-pages for more details.
.TP
.B \-C
Pass all records whose location is within \fIdist\fP of any of the points in the file \fIptfile\fP.  If \fIdist\fP
is zero then the 3rd column of \fIptfile\fP must have each point's\"'
individual radius of influence.  Distances are in user units; specify
\fB\-fg\fP or a map projection to indicate distances in km.  Prepend \fBf\fP to indicate you want approximate flat
earth distance calculations (faster) rather than exact geodesic distances (slower).  However, if the current \fBELLIPSOID\fP
is set to Sphere then spherical great circle calculations are used.  Note that \fIptfile\fP must be in ASCII regardless
of whether \fB\-b\fP is used.
.TP
.B \-D
Ignored unless \fB\-N\fP is set.  Selects the resolution of the coastline data set to use ((\fBf\fP)ull, (\fBh\fP)igh, (\fBi\fP)ntermediate, (\fBl\fP)ow, or (\fBc\fP)rude).  The
resolution drops off by ~80% between data sets. [Default is \fBl\fP].  Note that because the coastlines differ in details it is not guaranteed that a point will remain inside [or outside] when a different resolution is selected.
.TP
.B \-F
Pass all records whose location is within one of the closed polygons in the multiple-segment
file \fIpolygonfile\fP.  For spherical polygons (lon, lat), make sure no consecutive points
are separated by 180 degrees or more in longitude.  Note that \fIpolygonfile\fP must be in ASCII regardless
of whether \fB\-b\fP is used.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Reverses the sense of the test for each of the criteria specified:
.br
	\fBc\fP  select records NOT inside any point's circle of influence.\"'
.br
	\fBf\fP  select records NOT inside any of the polygons.
.br
	\fBl\fP  select records NOT within the specified distance of any line.
.br
	\fBr\fP  select records NOT inside the specified rectangular region.
.br
	\fBs\fP  select records NOT considered inside as specified by \fB\-A, \-D, \-N\fP.
.br
	\fBz\fP  select records NOT within the range specified by \fB\-Z\fP.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-L
Pass all records whose location is within \fIdist\fP of any of the line segments in the multiple-segment
file \fIlinefile\fP.  If \fIdist\fP is zero then the 2nd column of each
sub-header in the \fIptfile\fP must have each lines's individual distance value.\"'
Distances are in user units; specify \fB\-fg\fP or a map projection to indicate distances in km.
Note that \fIlinefile\fP must be in ASCII regardless of whether \fB\-b\fP is used.
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-N
Pass all records whose location is inside specified geographical features.
Specify if records should be skipped (s) or kept (k) using 1 of 2 formats:
.br
	\fB\-N\fP\fIwet/dry\fP.
.br
	\fB\-N\fP\fIocean/land/lake/island/pond\fP.
.br
Append \fBo\fP to let points exactly on feature boundaries be considered outside the feature [Default is inside]. [Default is s/k/s/k/s (i.e., s/k), which passes all points on dry land].
.TP
.B \-Z
Pass all records whose 3rd colum (z) lies within the given range.  Input file must have at least
three columns.  To indicate no limit on min or max, specify a hyphen (-).
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to
\fB\-JX\fP|\fBx\fP), or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP]
(append \fBT\fP to \fB\-JX\fP|\fBx\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
If no map projection is supplied we implicitly set \fB\-Jx\fP1.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH NOTE
This program has evolved over the years.  Originally, the \fB\-R\fP and \fB\-J\fP were mandatory in order
to handle geographic data, but now there is full support for spherical calculations.  Thus, \fB\-J\fP
should only be used if you want the tests to be applied on projected data and not the original
coordinates.  If \fB\-J\fP is used the distances given via \fB\-C\fP and \fB\-L\fP are projected distances.
.SH EXAMPLES
To extract the subset of data set that is within 300 km of any of the points in pts.d but more than
100 km away from the lines in lines.d, run
.br
.sp
\fBgmtselect\fP lonlatfile \fB\-Jd\fP1d \fB\-C\fP300/pts.d \fB\-L\fP100/lines.d \fB\-Il\fP > subset
.br
.sp
Here, you must specify a map projection so that knows you are giving it geographical data (otherwise
300 would be interpreted as Cartesian distance in x-y units instead of km).
.br
.sp
To keep all points in data.d within the specified region, except the points on land (as determined by the high-resolution
coastlines), use
.br
.sp
\fBgmtselect\fP data.d \fB\-R\fP120/121/22/24 \fB\-Dh\fP \fB\-Ns\fP/\fBk\fP > subset
.br
.sp
To return all points in quakes.d that are inside the spherical polygon lonlatpath.d, try
.br
.sp
\fBgmtselect\fP quakes.d \fB\-F\fPlonlatpath.d \fB\-fg\fP > subset
.br
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR GMT (l),
.IR grdlandmask (l),
.IR pscoast (l)
