.TH MGD77TRACK l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
mgd77track \- A shiptrack plotting program
.SH SYNOPSIS
\fBmgd77track\fP \fINGDC-ids\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] \fB\-J\fP\fIparameters\fP 
[ \fB\-A\fP[\fBc\fP][\fIsize\fP] ]  [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-C\fP|\fBg\fP|\fBe\fP ] [ \fB\-Da\fP\fIstartdate\fP ] [ \fB\-Db\fP\fIstopdate\fP ] 
[ \fB\-I\fP\fIignore\fP ] [ \fB\-K\fP ] [ \fB\-L\fP\fItrackticks\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Sa\fP\fIstartdist\fP[\fBu\fP] ] 
[ \fB\-Sb\fP\fIstopdist\fP[\fBu\fP] ] [ \fB\-TT\fP|\fBt\fP|\fBd\fP\fIms,mc,mfs,mf,mfc\fP ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBmgd77track\fP reads NGDC MGD77 cruises and creates \fIPostScript\fP code that will plot one or more ship tracks on a
map using the specified projection.  The \fIPostScript\fP code is written to standard output.
.TP
\fINGDC-ids\fP
Can be one or more of five kinds of specifiers:
.br
1) 8-character NGDC IDs, e.g., 01010083, JA010010etc., etc.
.br
2) 2-character <agency> codes which will return all cruises from each agency.
.br
3) 4-character <agency><vessel> codes, which will return all cruises from those vessels.
.br
4) =<list>, where <list> is a table with NGDC IDs, one per line.
.br
5) If nothing is specified we return all cruises in the data base.
.br
(See mgd77info \fB\-F\fP for agency and vessel codes).
The ".mgd77" or ".nc" extensions will automatically be appended, if needed (use \fB\-I\fP
to ignore certain file types).  Cruise files will be looked for first in the current directory
and second in all directories listed in \fB$MGD77_HOME\fP/mgd77_paths.txt [If \fB$MGD77_HOME\fP
is not set it will default to \fB$GMT_SHAREDIR\fP/mgd77].
.br
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-A
Annotate each leg every time it enters the plot. Append \fBc\fP to annotate using the MGD77 cruise ID [Default
uses the filename prefix].  Optional \fIsize\fP is the font size in points.
The leg annotation font is controlled by \fBLABEL_FONT\fP.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Select procedure for along-track distance calculation:
.br
	\fBf\fP Flat Earth distances.
.br
	\fBg\fP Great circle distances [Default].
.br
	\fBe\fP Geodesic distances on current GMT ellipsoid.
.TP
.B \-Da
Do not plot data collected before \fIstartdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss])  [Default is first day].
.TP
.B \-Db
Do not plot data collected after \fIstopdate\fP (yyyy-mm-dd\fBT\fP[hh:mm:ss]). [Default is last day].
.TP
.B \-I
Ignore certain data file formats from consideration. Append \fBa|c|t\fP to ignore
MGD77 ASCII, MGD77+ netCDF, or plain table files, respectively. The option may
be repreated to ignore more than one format.  [Default ignores none].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
To put time/distance log-marks on the track. E.g. \fBa\fP500\fBka\fP24\fBht\fP6\fBh\fP means (\fBa\fP)nnotate
every 500 km (\fBk\fP) and 24 \fBh\fP(ours), with (\fBt\fP)ickmarks every 500 km and 6 hours.
Alternatively you may use the modifiers \fBd\fP (days) and \fBn\fP (nautical miles).
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Sa
Do not plot data that are less than \fIstartdist\fP meter along track from port of departure.
Append \fBk\fP for km, \fBm\fP for miles, or \fBn\fP for nautical miles [Default is 0 meters].
.TP
.B \-Sb
Do not plot data that are more than \fIstopdist\fP meter along track from port of departure.
Append \fBk\fP for km, \fBm\fP for miles, or \fBn\fP for nautical miles [Default is end of track].
.TP
.B \-T
Controlls the attributes of the three kinds of markers (\fBT\fP for the first time marker in a new
day, \fBt\fP for additional time markers in the same day, and \fBd\fP for distance markers).  For each
of these you can specify the 5 comma-separated attributes \fImarkersize\fP, \fImarkercolor\fP,
\fImarkerfontsize\fP, \fImarkerfont\fP, and \fImarkerfontcolor\fP.  Repeat the \fB\-T\fP option for
each marker type.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-W
Append \fIpen\fP used for the trackline. [Default is 0.25p,black]. 
[Default is solid].
.TP
.B \-X \-Y
Shift plot origin relative to the current origin by (\fIx-shift,y-shift\fP) and
optionally append the length unit (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
You can prepend \fBa\fP to shift the origin back to the original position after plotting,
or prepend  \fBr\fP [Default] to reset the current origin to the new location.
If \fB\-O\fP is used then the default (\fIx-shift,y-shift\fP) is (0,0), otherwise it is
(r1i, r1i) or (r2.5c, r2.5c).
Alternatively, give \fBc\fP to align the center coordinate (x or y) of the plot with the center of the page
based on current page size.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To generate a Mercator plot of the track of the cruise 01010007 in the area 70W to
20E, 40S to 20N, using a Mercator scale of 0.1inch/degree, label the tracks with 10 points characters, annotate
the boundaries every 10 degrees, draw gridlines every 5 degrees, and mark the track every day and 1000 km,
with ticks every 6 hours and 250 km, and send the plot to the default printer,
enter the following command:
.br
.sp
\fBmgd77track\fP 01010007 \fB\-R\fP70W/20E/40S/20N \fB\-Jm\fP0.1 \fB\-B\fP10\fBg\fP5 \fB\-A\fP10 \fB\-L\fPa1da1000kf6hf250k | lpr
.SH "SEE ALSO"
.IR mgd77info (l),
.IR psbasemap (l)
.IR mgd77list (l)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2005, The Generic Mapping Tools (GMT) version
4.1 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
The Marine Geophysical Data Exchange Format - "MGD77", see
\fIhttp://www.ngdc.noaa.gov/mgg/dat/geodas/docs/mgd77.txt\fP
.br
