.TH X2SYS_GET l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
x2sys_get \- Get track listing from track index databases
.SH SYNOPSIS
\fBx2sys_get\fP \fB\-T\fP\fITAG\fP [ \fB\-C\fP ] [ \fB\-F\fP\fIflags\fP ] 
[ \fB\-L\fP[\fIlist\fP] [ \fB\-N\fP\fIflags\fP ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-V\fP ] ] 
.SH DESCRIPTION
\fBx2sys_get\fP will return the names of the track data files that match the given
requirements.  You may choose a geographic region and optionally ask
only for tracks that meet certain data criteria.  Finally, you may
select an option to list all possible pairs that might generate crossovers.
.TP
\fITAG\fP
The unique tag name of this data type system.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-C
Instead of reporting the track names, just output the coordinates of the
center of each bin that has at least one track with the specified data.
.TP
.B \-F
Give a comma-separated list of column names (as described in the definition
file) that should be present. [Default selects all data columns].
.TP
.B \-L
Crossover mode.  Return a list of track pairs that should be checked for possible
crossovers.  The list is determined from the bin-index data base on the assumption
that tracks occupying the same bin are very likely to intersect.  By default we
return all possible pairs in the data base.  Append the name of a file with a
list of tracks if you want to limit the output to those pairs that involve
at least one of the track names in your list.  The output is suitable for the \fB\-K\fP
option in \fBx2sys_cross\fP.
.TP
.B \-N
Give a comma-separated list of column names (as described in the definition
file) that must be absent.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To find all the tracks associated with the tag mgd77, restricted to occupy
a certain region in the south Pacific, and have at least free air anomalies
and bathymetry, try
.br
.sp
\fBx2sys_get\fP \fB\-V \-T\fPmgd77 \fB\-R\fP180/240/-60/-30 \fB\-F\fPfaa,depth 
.br
.sp
To find all the tracks associated with the tag mgd77 that have depth but not
twt, try
.br
.sp
\fBx2sys_get\fP \fB\-V \-T\fPmgd77 \fB\-F\fPdepth \fB\-N\fPtwt
.br
.sp
To find all the pairs associated with the tag mgd77 that might intersect each
other, but only those pairs which involves tracks in your list new.lis, try
.br
.sp
\fBx2sys_get\fP \fB\-V \-T\fPmgd77 \fB\-L\fPnew.lis > xpairs.lis 
.SH "SEE ALSO"
.IR x2sys_binlist (l)
.IR x2sys_cross (l)
.IR x2sys_datalist (l)
.IR x2sys_init (l)
.IR x2sys_put (l)
