#!/bin/sh
#
#	$Id: do_examples.sh,v 1.8 2007/03/28 03:02:12 pwessel Exp $
#
# Bourne script to test all GMT examples (sh versions).
# If one argument is given it is used as the bin path
# If a second arguemnt is used it is added to the library path

# Temporary change LANG to C
LANG=C

# First determine if awk is buggy:

result=`echo 1 | awk '{print sin($1)}'`
if [ $result = 1 ]; then
	answer=`which nawk`
	if [ $#answer = 1 ]; then
		export AWK=nawk
	else
		export AWK=gawk
	fi
else
	export AWK=awk
fi

# Extend executable and library path if requested

if [ $# -ge 1 ]; then
	cd ..
	top=`pwd`
	cd examples
	export PATH=$1:$PATH
	if [ $# = 2 ]; then
		export LD_LIBRARY_PATH=$2:${LD_LIBRARY_PATH:-/usr/lib}
	fi
fi

# Loop over all examples and run each job

for dir in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26
do
	if [ -e ex${dir}/job${dir}.sh ]; then
		echo -n "Doing example ${dir}..."
		cd ex${dir}
		\cp -f ../.gmtdefaults4.doc .gmtdefaults4
		sh job${dir}.sh
		\rm -f .gmtdefaults4
		cd ..
		echo "done"
	fi
done

echo "Completed all examples"
