#include "GtkMult.h"
#include "GtkMultTable.h"
#include "config.h"
#include "gettext.h"

#include <gtkmm/icontheme.h>

GtkMult::GtkMult (void)
	: puzzle (NULL), table (NULL)
{
	Gtk::MenuBar *menuBar;
	Gtk::Menu *menuGame, *menuHelp;
	Gtk::Menu::MenuList *menuList;
	Gtk::VBox *vb;
	Gtk::HBox *hb;
	Gtk::Menu_Helpers::Element menu_elem;
	Gtk::EventBox *eb;
	Glib::RefPtr <Gdk::Pixbuf> icon;
	Gdk::Geometry geometry;
	
	vb = manage (new Gtk::VBox ());
	hb = manage (new Gtk::HBox ());
	eb = manage (new Gtk::EventBox ());
	this->vbox = manage (new Gtk::VBox ());
	this->status = manage (new Gtk::Statusbar ());
	this->score = manage (new Gtk::Label ());
	menuBar = manage (new Gtk::MenuBar ());
	menuGame = manage (new Gtk::Menu ());
	menuHelp = manage (new Gtk::Menu ());
	
	menuBar->items ().push_back (Gtk::Menu_Helpers::MenuElem (_("_Game"), *menuGame));
	menuBar->items ().push_back (Gtk::Menu_Helpers::MenuElem (_("_Help"), *menuHelp));
	
	menuList = &menuGame->items ();
	menu_elem = Gtk::Menu_Helpers::StockMenuElem (
		Gtk::Stock::NEW,
		Gtk::AccelKey ("<control>n"),
		sigc::mem_fun (*this, &GtkMult::on_menu_game_new));
	menu_elem.get_child ()->signal_deselect ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_deselect));
	menu_elem.get_child ()->signal_select ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_select_new));
	menuList->push_back (menu_elem);
	menuList->push_back (Gtk::Menu_Helpers::SeparatorElem ());
	
	menu_elem = Gtk::Menu_Helpers::MenuElem (
		_("_Solve"),
		sigc::mem_fun (*this, &GtkMult::on_menu_game_solve));
	menu_elem.get_child ()->signal_deselect ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_deselect));
	menu_elem.get_child ()->signal_select ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_select_solve));
	menuList->push_back (menu_elem);
	menuList->push_back (Gtk::Menu_Helpers::SeparatorElem ());
	menu_elem = Gtk::Menu_Helpers::StockMenuElem (
		Gtk::Stock::QUIT,
		Gtk::AccelKey ("<control>q"),
		sigc::mem_fun (*this, &GtkMult::on_menu_game_quit));
	menu_elem.get_child ()->signal_deselect ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_deselect));
	menu_elem.get_child ()->signal_select ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_select_quit));
	menuList->push_back (menu_elem);
	
	menuList = &menuHelp->items ();
	menu_elem = Gtk::Menu_Helpers::StockMenuElem (
		Gtk::Stock::ABOUT,
		sigc::mem_fun (*this, &GtkMult::on_menu_help_about));
	menu_elem.get_child ()->signal_deselect ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_deselect));
	menu_elem.get_child ()->signal_select ().connect (sigc::mem_fun (*this, &GtkMult::on_menu_select_about));
	menuList->push_back (menu_elem);
	
	vb->pack_start (*menuBar, Gtk::PACK_SHRINK);
	vb->pack_start (*this->vbox, Gtk::PACK_EXPAND_WIDGET);
	vb->pack_start (*hb, Gtk::PACK_SHRINK);
	hb->pack_start (*this->status, Gtk::PACK_EXPAND_WIDGET);
	hb->pack_start (*eb, Gtk::PACK_SHRINK);
	eb->add (*this->score);
	eb->set_border_width (5);
	add (*vb);
	
	set_title (_("Multiplication Puzzle"));
	
	icon = Gtk::IconTheme::get_default ()->load_icon (PACKAGE, 48, (Gtk::IconLookupFlags)0);
	if (icon)
		set_icon (icon);
	
	status->set_has_resize_grip (false);
	
	geometry.min_aspect = 1.0;
	geometry.max_aspect = 1.0;
	set_geometry_hints (*this, geometry, Gdk::HINT_ASPECT);
	
	new_puzzle ();
	
	puzzle->signal_guessed ().connect (sigc::mem_fun (*this, &GtkMult::on_puzzle_guess));
	
	show_all ();
}

GtkMult::~GtkMult (void)
{
	delete puzzle;
}

void GtkMult::new_puzzle (void)
{
	if (puzzle)	delete puzzle;
	if (table)	vbox->remove (*table);
	
	this->puzzle = new MultPuzzle (3, 2);
	
	this->table = manage (new GtkMultTable (this->puzzle));
	
	this->vbox->add (*this->table);
	
	this->cheated = false;
	
	update_score ();
	
	puzzle->signal_guessed ().connect (sigc::mem_fun (*this, &GtkMult::on_puzzle_guess));
}

void GtkMult::update_score (void)
{
	int wrong = puzzle->getWrongGuesses ();
	char *text;
	
	// make room for string, numbers, and *
	text = (char *) malloc (strlen (_("%i Wrong")) + 12);
	sprintf (text, _("%i Wrong"), wrong);
	
	if (cheated)
		sprintf (text, "%s*", text);
	
	score->set_text (text);
	
	free (text);
}

void GtkMult::on_menu_deselect (void)
{
	status->pop ();
}

void GtkMult::on_menu_select_new (void)
{
	status->push (_("Start a new game"));
}

void GtkMult::on_menu_select_solve (void)
{
	status->push (_("Solve this game"));
}

void GtkMult::on_menu_select_quit (void)
{
	status->push (_("Quit Multiplication Puzzle"));
}

void GtkMult::on_menu_select_about (void)
{
	status->push (_("About Multiplication Puzzle"));
}

void GtkMult::on_puzzle_guess (char digit, char letter, int response)
{
	update_score ();
	
	if (puzzle->isDone ())
	{
		status->push (_("Congratulations!"));
	}
	else
	{
		char *message_pattern = NULL;
		
		switch (response)
		{
		case MultPuzzle::WRONG:
			message_pattern = _("Incorrect; %1$c is not %2$c");
			break;
		case MultPuzzle::CORRECT:
			message_pattern = _("Correct; %1$c is %2$c");
			break;
		default:
		case MultPuzzle::ALREADY_KNOWN:
		case MultPuzzle::INVALID_INPUT:
			// shouldn't happen
			break;
		}
		
		if (message_pattern) {
			// make room for string and characters
			char *text = (char *) malloc (strlen (message_pattern) + 3);
			sprintf (text, message_pattern, letter, digit);
			status->push (text);
			free (text);
		}
	}
}

void GtkMult::on_menu_game_quit (void)
{
	hide ();
}

void GtkMult::on_menu_game_solve (void)
{
	cheated = true;
	
	puzzle->solve ();
	
	status->push (_("Puzzle solved"));
	
	update_score ();
}

void GtkMult::on_menu_game_new (void)
{
	new_puzzle ();
	
	status->push ("");
}

void GtkMult::on_menu_help_about (void)
{
	Gtk::AboutDialog *about;
	std::list <Glib::ustring> artists;
	std::list <Glib::ustring> authors;
	Glib::RefPtr <Gdk::Pixbuf> icon;
	
	artists.push_back ("Eugenia Loli-Queru <eloli@hotmail.com>");
	authors.push_back ("Michael Terry <mike@mterry.name>");
	
	about = new Gtk::AboutDialog ();
	
	icon = Gtk::IconTheme::get_default ()->load_icon (PACKAGE, 48, (Gtk::IconLookupFlags)0);
	if (icon)
		about->set_icon (icon);
	
	about->set_artists (artists);
	about->set_authors (authors);
	about->set_copyright ("© 2003-2005 Michael Terry");
	about->set_license ("This program is free software; you can redistribute it and/or\n"
"modify it under the terms of the GNU General Public License\n"
"as published by the Free Software Foundation; either version 2\n"
"of the License, or (at your option) any later version.\n"
"\n"
"This program is distributed in the hope that it will be useful,\n"
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"GNU General Public License for more details.\n"
"\n"
"You should have received a copy of the GNU General Public License\n"
"along with this program; if not, write to the Free Software\n"
"Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.");
	about->set_logo_icon_name (PACKAGE);
	about->set_translator_credits (_("translator-credits"));
	about->set_version (VERSION);
	about->set_website ("http://mterry.name/gmult/");
	about->show_all ();
	
	status->push ("");
}
