-----------------------------------------------------------------------
--                          G L I D E  I I                           --
--                                                                   --
--                     Copyright (C) 2001-2002                       --
--                            ACT-Europe                             --
--                                                                   --
-- GLIDE is free software; you can redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this library; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Projects;

package Src_Info.ALI is

   type ALI_Handler_Record is new LI_Handler_Record with null record;
   type ALI_Handler is access all ALI_Handler_Record'Class;

   procedure Create_Or_Complete_LI
     (Handler                : access ALI_Handler_Record;
      File                   : in out LI_File_Ptr;
      Source_Filename        : VFS.Virtual_File;
      List                   : LI_File_List;
      Project                : Projects.Project_Type;
      Check_Timestamp        : Boolean := True);

   function Case_Insensitive_Identifiers (Handler : access ALI_Handler_Record)
      return Boolean;
   pragma Inline (Case_Insensitive_Identifiers);

   procedure Parse_All_LI_Information
     (Handler                : access ALI_Handler_Record;
      List                   : LI_File_List;
      In_Directory           : String;
      Project                : Projects.Project_Type);

   function LI_Filename_From_Source
     (Handler                : access ALI_Handler_Record;
      Source_Filename        : VFS.Virtual_File;
      Project                : Projects.Project_Type)
      return VFS.Virtual_File;
   --  Converts the given Source Filename into the corresponding ALI filename
   --  using the Project and Predefined Source Path information. Return the
   --  empty string when the given Source_Filename can not be found in the
   --  project exception lists and when the extension does not follow the
   --  project naming scheme.
   --
   --  Source_Filename should be the name of the file as stored in the LI
   --  structure (ie the base file name for Ada files, possibly including
   --  directory name for other languages).
   --
   --  Side_Effects:
   --  This function destroys the contents of the Namet buffer. Save it before
   --  calling this function if it needs to be preserved.
   --
   --  Limitations:
   --  This function does *not* support separates. This limitation would be
   --  hard to lift with the current parameter profile, because we would need
   --  to compute the associated unit name in order to deduce the name of
   --  non-separate source file. Unfortunately, the function
   --              Source_Filename = f (Unit_Filename)
   --  is not bijective...
   --  ??? Add a function that computes the "Significant source filename"
   --  from a given unit name that would be a separate. The result of
   --  this function could then be used to call ALI_Filename_From_Source
   --  to get the associated ALI filename.

   type ALI_Handler_Iterator is new LI_Handler_Iterator with private;

   function Generate_LI_For_Source
     (Handler       : access ALI_Handler_Record;
      Root_Project  : Projects.Project_Type;
      File_Project  : Projects.Project_Type;
      Full_Filename : VFS.Virtual_File) return LI_Handler_Iterator'Class;

   function Generate_LI_For_Project
     (Handler       : access ALI_Handler_Record;
      Root_Project  : Projects.Project_Type;
      Project       : Projects.Project_Type;
      Recursive     : Boolean := False)
      return LI_Handler_Iterator'Class;

   procedure Continue
     (Iterator : in out ALI_Handler_Iterator;
      Finished : out Boolean);

private
   type ALI_Handler_Iterator is new LI_Handler_Iterator with null record;

end Src_Info.ALI;
