
with Traces; use Traces;
with System.Assertions; use System.Assertions;

procedure Test_Debug is
   Me : Debug_Handle := Create ("Test_debug");
   Foo : Debug_Handle := Create ("Foo");
   A : Integer;
begin
   Trace (Me, "Beginning");
   A := 1;
   delay 0.05;
   Trace (Foo, "A set to 1");
   Assert (Me, A = 1, "A should be 1", "A is indeed 1");

   Local :
   begin
      Assert (Me, A = 2, "A should be 2", "A is indeed 2");
   exception
      when Assert_Failure =>
         null;
   end Local;

   Trace (Me, "Multi" & ASCII.LF & "line" & ASCII.LF & "Message");
end Test_Debug;
