with Ada.Command_Line;  use Ada.Command_Line;
with Ada.Text_IO;       use Ada.Text_IO;
with GNAT.OS_Lib;       use GNAT.OS_Lib;

with Projects.Registry; use Projects, Projects.Registry;
with GNAT.OS_Lib;       use GNAT.OS_Lib;
with Src_Info;          use Src_Info;
with Language_Handlers.Glide; use Language_Handlers.Glide;
with Test_Utils;        use Test_Utils;

procedure Generate_DB is

   Prj_Filename     : String_Access;
   Project          : Project_Type;
   Registry         : aliased Project_Registry;
   Handler          : Glide_Language_Handler;
   Finished         : Boolean;

begin

   Handler := Glide_Language_Handler
     (Create_Lang_Handler (Registry'Unrestricted_Access));

   if Argument_Count < 1 then
      Put_Line ("Invalid number of arguments.");
      Put_Line ("Usage: " & Command_Name
        & " <project_file>");
      return;
   end if;

   Prj_Filename := new String'(Argument (1));
   if not Is_Regular_File (Prj_Filename.all) then
      Put_Line ("No such file: '" & Prj_Filename.all & "'");
      return;
   end if;

   Load_Project (Prj_Filename.all, Handler, Registry, Project);
   declare
      LI_Iterator : LI_Handler_Iterator'Class
         := Generate_LI_For_Project
           (Get_LI_Handler_By_Name (Handler, "c/c++"),
            Project,
            Project,
            True); -- recursive
   begin
      loop
         Continue (LI_Iterator, Finished);
         exit when Finished;
         delay 0.01;
      end loop;
      Destroy (LI_Iterator);
   end;

end Generate_DB;
