with Ada.Command_Line; use Ada.Command_Line;
with GNAT.Directory_Operations; use GNAT.Directory_Operations;
with Ada.Text_IO;      use Ada.Text_IO;
with GNAT.OS_Lib;      use GNAT.OS_Lib;

with Src_Info;             use Src_Info;
with Src_Info.Debug;       use Src_Info.Debug;
with Projects.Registry;    use Projects, Projects.Registry;

with Test_Utils;           use Test_Utils;
with Language_Handlers;    use Language_Handlers;
with VFS;                  use VFS;

procedure Read_ALI is

   Prj_Filename     : String_Access;
   Source_Filename  : Virtual_File;
   Project          : Project_Type;
   Source_Info_List : Src_Info.LI_File_List;
   LI_Unit          : LI_File_Ptr;
   Handler          : Language_Handler;
   Registry         : aliased Project_Registry;

begin
   Handler := Create_Lang_Handler (Registry'Unchecked_Access);

   --  ??? We should enhance this test driver in the future in order
   --      to be able to test cases where the parser should fail.
   --      One way to do this is use command-line options, which will
   --      specify that a failure is expected, and even maybe an exception
   --      (with the exception name).

   if Argument_Count /= 2 then
      Put_Line ("Invalid number of arguments.");
      Put_Line
        ("Usage: " & Command_Name & " <project_file> <source_filename>");
      return;
   end if;

   Prj_Filename := new String'(Argument (1));
   if not Is_Regular_File (Prj_Filename.all) then
      Put_Line ("No such file: '" & Prj_Filename.all & "'");
      return;
   end if;

   Source_Filename := Create
     (Normalize_Pathname (Argument (2), Get_Current_Dir));
   if not Is_Regular_File (Source_Filename) then
      Put_Line ("No such file: '" & Full_Name (Source_Filename).all & "'");
      return;
   end if;

   Reset (Source_Info_List);
   Load_Project (Prj_Filename.all, Handler, Registry, Project);
   Load_LI_File
     (Source_Info_List, Handler, Registry, Source_Filename, LI_Unit);

   Src_Info.Debug.Dump_LI_File_Ptr (LI_Unit);
end Read_ALI;
