#! /bin/sh

tmp_ext="`whoami`_$$"
test_output='output'
ref_output='test.out'
build_script='build'
test_script='test.cmd'
verbose='no'

## Add read_ali to the path
PATH=`pwd`/../standalone_obj/:$PATH
export PATH

### Some global files...
build_output=`pwd`/build.out.$tmp_ext
touch $build_output

if type dbimp >/dev/null; then
   true;
else
   echo "dbimp not found in the path"
   exit
fi

tests=$1
if [ "$tests " = " " ]; then
   tests=*
fi

for current_dir in $tests
do
   current_dir=`basename $current_dir`
   if [ -d $current_dir -a $current_dir != '.' -a $current_dir != 'CVS' ]
   then
      
      (
         echo "---------  $current_dir"
         copy_dir=${current_dir}_${tmp_ext}

         if [ -f $current_dir/$build_script -a -f $current_dir/$test_script ]
         then 
            cp -R $current_dir $copy_dir
            cd $copy_dir
            rm -rf .gpssnprj/

            echo "" >> $build_output
            echo "--  Building in $current_dir:" >> $build_output
            sh ./$build_script >> $build_output 2>&1

            sh ./$test_script > $test_output 2>&1
            if [ -f $ref_output ]; then
               diff -c $ref_output $test_output
            else
               cat $test_output
            fi

            cd ..
            rm -rf $copy_dir
         else
            echo "$current_dir: build or test.cmd missing, test skipped." \
              > $messages_output
         fi
      )
   fi
done

if [ "$verbose" = "yes" ]; then
   echo "==========   Build output  ============"
   cat $build_output
fi

rm $build_output
