-----------------------------------------------------------------------
--                               G P S                               --
--                                                                   --
--                     Copyright (C) 2000-2005                       --
--                             AdaCore                               --
--                                                                   --
-- GPS is free  software;  you can redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this library; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Default_Preferences; use Default_Preferences;
with Items;               use Items;
with Debugger.Gdb;        use Debugger.Gdb;
with Debugger.Gdb.C;      use Debugger.Gdb.C;
with GNAT.Expect;         use GNAT.Expect;
with GNAT.IO;             use GNAT.IO;
with Ada.Calendar;        use Ada.Calendar;
with Process_Proxies;     use Process_Proxies;
with GNAT.OS_Lib;         use GNAT.OS_Lib;
with Debugger;            use Debugger;
with GVD.Types;           use GVD.Types;
with Gtk.Main;            use Gtk.Main;
with GVD.Preferences;     use GVD.Preferences;
with Traces;              use Traces;

procedure Test_Parse_C is

   Gdb_Record : aliased Gdb_Debugger;
   Gdb        : Debugger_Access := Gdb_Record'Unchecked_Access;
   Language   : aliased Gdb_C_Language;

   ---------------
   -- Print_Var --
   ---------------

   procedure Print_Var (Var : String) is
      V : Generic_Type_Access;
      T     : Time;
      Durat : Duration;
      Found : Boolean;
   begin
      Put_Line ("------------------------------");
      Put_Line ("PRINT " & Var);
      T := Clock;
      V := Parse_Type (Gdb, Var);
      Durat := Clock - T;
--      Put_Line ("Parsing type, time=" & Durat'Img);
      if V /= null then
         T := Clock;
         Parse_Value (Gdb, Var, V, Default_Format, Found);
         Durat := Clock - T;
--         Put_Line ("Parsing value, time=" & Durat'Img);
         Print (V.all);
      end if;

      New_Line;
   end Print_Var;

   GVD_Prefs : Preferences_Manager;
   List : Argument_List (1 .. 0);
begin
   Parse_Config_File (".gnatdebug");
   Init;
   GVD_Prefs := new Preferences_Manager_Record;
   Register_Default_Preferences (GVD_Prefs);
   Load_Preferences (GVD_Prefs, "./preferences");

   Set_Language (Gdb, Language'Unchecked_Access);
   Set_Debugger (Language'Access, Gdb);

   Spawn (Gdb, "", List, "", new Process_Proxy, null);

--     Add_Filter
--       (Get_Descriptor (Get_Process (Gdb)).all, Trace_Filter'Access);
--     Add_Filter
--       (Get_Descriptor (Get_Process (Gdb)).all, Trace_Filter'Access, Input);

   Initialize (Gdb);
   Set_Executable (Gdb, "parse_c");
   Break_Subprogram (Gdb, "foo");

   Run (Gdb);

   Print_Var ("Parse::Non_Existant_Variable");
   --  Check there is no error in that case.

   Print_Var ("main::A");
   Print_Var ("main::B");
   Print_Var ("main::C");
   Print_Var ("main::Sh");
   Print_Var ("main::L");
   Print_Var ("main::Uns");
   Print_Var ("main::CC");
   Print_Var ("main::UL");
   Print_Var ("main::S");
   Print_Var ("main::S2");
   Print_Var ("main::S3");
   Print_Var ("main::Act");
   Print_Var ("main::My_Enum_Variable");
   Print_Var ("main::T");
   Print_Var ("main::Ea");
   Print_Var ("main::Aoa");
   Print_Var ("main::U");
   Print_Var ("main::A3d");
   Print_Var ("main::Iaa");
   Print_Var ("main::V");
   Print_Var ("main::Anonymous_Var");
   Print_Var ("main::V2");
   Print_Var ("main::Mror");
   Print_Var ("main::Mror2");
   Print_Var ("main::mrou");
   Print_Var ("main::mroe");
   Print_Var ("main::Mrora");
   Print_Var ("main::Mrorpa");
   Print_Var ("main::Uni");
   Print_Var ("main::Uni2");
   Print_Var ("main::Uni3");
   Print_Var ("main::Mrwu");
   Print_Var ("main::as");
   Print_Var ("main::asa");
   Print_Var ("main::Mrws");
   Print_Var ("main::Mrws2");
   Print_Var ("main::tv");
   Print_Var ("main::list");
   Close (Gdb);

exception
   when others =>
      Close (Gdb);
      raise;

end Test_Parse_C;
