-----------------------------------------------------------------------
--                               G P S                               --
--                                                                   --
--                     Copyright (C) 2000-2005                       --
--                             AdaCore                               --
--                                                                   --
-- GPS is free  software;  you can redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this library; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Default_Preferences; use Default_Preferences;
with Items;               use Items;
with Debugger.Gdb;        use Debugger.Gdb;
with Debugger.Gdb.Cpp;    use Debugger.Gdb.Cpp;
with GNAT.Expect;         use GNAT.Expect;
with GNAT.IO;             use GNAT.IO;
with Ada.Calendar;        use Ada.Calendar;
with Process_Proxies;     use Process_Proxies;
with GNAT.OS_Lib;         use GNAT.OS_Lib;
with Debugger;            use Debugger;
with GVD.Types;           use GVD.Types;
with Gtk.Main;            use Gtk.Main;
with GVD.Preferences;     use GVD.Preferences;
with Traces;              use Traces;

procedure Test_Parse_Cpp is

   Gdb_Record : aliased Gdb_Debugger;
   Gdb        : Debugger_Access := Gdb_Record'Unchecked_Access;
   Language   : aliased Gdb_Cpp_Language;

   ---------------
   -- Print_Var --
   ---------------

   procedure Print_Var (Var : String) is
      V : Generic_Type_Access;
      T     : Time;
      Durat : Duration;
      Found : Boolean;
   begin
      Put_Line ("------------------------------");
      Put_Line ("PRINT " & Var);
      T := Clock;
      V := Parse_Type (Gdb, Var);
      Durat := Clock - T;
--      Put_Line ("Parsing type, time=" & Durat'Img);
      if V /= null then
         T := Clock;
         Parse_Value (Gdb, Var, V, Default_Format, Found);
         Durat := Clock - T;
--         Put_Line ("Parsing value, time=" & Durat'Img);
         Print (V.all);
      end if;

      New_Line;
   end Print_Var;

   GVD_Prefs : Preferences_Manager;
   List : Argument_List (1 .. 0);

begin
   Parse_Config_File (".gnatdebug");
   Init;
   Parse_Config_File (".gnatdebug");
   GVD_Prefs := new Preferences_Manager_Record;
   Register_Default_Preferences (GVD_Prefs);
   Load_Preferences (GVD_Prefs, "./preferences");

   Set_Language (Gdb, Language'Unchecked_Access);
   Set_Debugger (Language'Access, Gdb);

   Spawn (Gdb, "", List, "", new Process_Proxy, null);

--     Add_Filter
--       (Get_Descriptor (Get_Process (Gdb)).all, Trace_Filter'Access);
--     Add_Filter
--       (Get_Descriptor (Get_Process (Gdb)).all, Trace_Filter'Access, Input);

   Initialize (Gdb);
   Set_Executable (Gdb, "parse_cpp");
   Break_Subprogram (Gdb, "foo");

   Run (Gdb);
   Stack_Up (Gdb);

   Print_Var ("Parse::Non_Existant_Variable");
   --  Check there is no error in that case.

   Print_Var ("A");
   Print_Var ("B");
   Print_Var ("C");
   Print_Var ("Sh");
   Print_Var ("L");
   Print_Var ("Uns");
   Print_Var ("UL");
   Print_Var ("S");
   Print_Var ("S2");
   Print_Var ("S3");
   Print_Var ("Act");
   Print_Var ("My_Enum_Variable");
   Print_Var ("T");
   Print_Var ("Ea");
   Print_Var ("Aoa");
   Print_Var ("U");
   Print_Var ("A3d");
   Print_Var ("Iaa");
   Print_Var ("V");
   Print_Var ("Anonymous_Var");
   Print_Var ("V2");
   Print_Var ("cl1");
   Print_Var ("cl2");
   Print_Var ("cl3");
   Print_Var ("cl4");
   Print_Var ("Mror");
   Print_Var ("Mrora");
   Print_Var ("Mrorpa");
   Print_Var ("Uni");
   Print_Var ("Uni2");
   Print_Var ("Uni3");
   Print_Var ("Mrwu");
   Print_Var ("as");
   Print_Var ("asa");
   Print_Var ("Mrws");
   Print_Var ("Mrws2");
   Print_Var ("tv");
   Print_Var ("list");
   Print_Var ("FC");
   Print_Var ("SC");
   Print_Var ("SAC");
   Print_Var ("MI");
   Print_Var ("NF");
   Close (Gdb);

exception
   when others =>
      Close (Gdb);
      raise;

end Test_Parse_Cpp;
