/*

Copyright (c) 2000, Red Hat, Inc.

This file is part of Source-Navigator.

Source-Navigator is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your option)
any later version.

Source-Navigator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with Source-Navigator; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.



*/

#define rbool		char
#define rtrue		1
#define rfalse		0
#define StdIn		0

#include "Scanner.h"

#ifdef __cplusplus
extern "C" {
#include "Source.h"
#include "rSystem.h"
#include "General.h"
#include "DynArray.h"
#include "Position.h"
}
#else
#include "Source.h"
#include "rSystem.h"
#include "General.h"
#include "DynArray.h"
#include "Position.h"
#endif

#include <stdio.h>
#if defined __STDC__ | defined __cplusplus
#include <stdlib.h>
#endif

#define yyStart(State)	{ yyPreviousStart = yyStartState; yyStartState = State;}
#define yyPrevious	{ yyStateRange s = yyStartState; \
			yyStartState = yyPreviousStart; yyPreviousStart = s; }
#define yyEcho		{ (void) fwrite (TokenPtr, 1, \
			TokenLength, stdout); }
#define yyEol(Column)	{ yyLineCount ++; \
			yyLineStart = (unsigned char *) TokenPtr + \
			TokenLength - 1 - (Column); }
#define output(c)	(void) putchar ((int) c)
#define yyColumn(Ptr)	((int) ((Ptr) - (char *) yyLineStart))
#define yyOffset(Ptr)	(yyFileOffset + ((Ptr) - yyChBufferStart2))

#define yyDNoState		0
#define yyFirstCh	(unsigned char) '\0'
#define yyLastCh	(unsigned char) '\377'
#define yyEolCh	(unsigned char) '\12'
#define yyEobCh	(unsigned char) '\177'
#define yyDStateCount	317
#define yyTableSize	1982
#define yyEobState	43
#define yyDefaultState	44
#define STD	1
#define COMMENT	3

static void yyExit ARGS ((void))
{ rExit (1); }

typedef unsigned short	yyStateRange;
typedef struct { yyStateRange yyCheck, yyNext; } yyCombType;

	char *		TokenPtr	;
	int		TokenLength	;
	tScanAttribute	Attribute	;
	void		(* Scanner_Exit)	ARGS ((void)) = yyExit;

static	void		yyErrorMessage	ARGS ((int yyErrorCode));
#ifdef xxinput
static	char		input		ARGS ((void));
#endif
static	void		unput		ARGS ((char));
static	void		yyLess		ARGS ((int));

static	yyCombType	yyComb		[yyTableSize   + 1] = {
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   1,   46}, 
{   1,   45}, {   6,   22}, {   1,    9}, {   1,    6}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   1,    9}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   1,   48}, {   1,  216}, {   1,   10}, 
{   0,    0}, {   0,    0}, {   1,  207}, {   1,  193}, {   1,   33}, 
{   1,  241}, {   1,  240}, {   1,  210}, {   1,  205}, {   1,  286}, 
{   1,  203}, {   1,   23}, {   1,   29}, {   1,   26}, {   1,    7}, 
{   1,    7}, {   1,    7}, {   1,    7}, {   1,    7}, {   1,    7}, 
{   1,    7}, {   1,    7}, {   1,    7}, {   1,  212}, {   1,  309}, 
{   1,  200}, {   1,  218}, {   1,  195}, {   1,  213}, {   5,  316}, 
{  34,   35}, {  34,   35}, {  34,   35}, {  34,   35}, {  34,   35}, 
{  34,   35}, {  34,   35}, {  34,   35}, {   3,   47}, {   3,   45}, 
{  35,   18}, {  37,   32}, {   3,    6}, {  37,   32}, {   7,   14}, 
{ 191,  192}, {   7,    7}, {   7,    7}, {   7,    7}, {   7,    7}, 
{   7,    7}, {   7,    7}, {   7,    7}, {   7,    7}, {   7,    7}, 
{   7,    7}, {   1,  256}, { 197,  198}, {   1,  255}, {   1,  191}, 
{ 201,  202}, {   3,   49}, {   1,  157}, {   1,   90}, {   1,   65}, 
{   1,  100}, {   1,   53}, {   1,   50}, {  55,   56}, {  60,   61}, 
{   1,   57}, {   3,    5}, {  15,   16}, {   1,  274}, {   7,   20}, 
{   1,  151}, {  26,   31}, {   1,  170}, {  59,   60}, {   1,   77}, 
{   1,  110}, {   1,   70}, {   8,    8}, {   1,  125}, {   1,   95}, 
{  51,   52}, {  54,   55}, {  61,   62}, {   1,  285}, {   1,  189}, 
{   1,  233}, {   1,  230}, {   9,   43}, {  42,   43}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {  15,   16}, 
{  28,   27}, {   7,   20}, {  28,   13}, {  26,   31}, {  62,   63}, 
{  63,   64}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {  28,   27}, {  67,   68}, {  28,   13}, 
{  68,   69}, {   8,    8}, {  74,   75}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, 
{   8,    8}, {   8,    8}, {   8,    8}, {   8,    8}, {  10,   10}, 
{  11,   11}, {  11,   11}, {  11,   11}, {  11,   11}, {  11,   11}, 
{  11,   11}, {  11,   11}, {  11,   11}, {  11,   41}, {  11,   41}, 
{  14,   27}, {  14,   37}, {  14,   13}, {  23,   14}, {  23,   14}, 
{  23,   14}, {  23,   14}, {  23,   14}, {  23,   14}, {  23,   14}, 
{  23,   14}, {  23,   14}, {  23,   14}, {  10,   19}, {  66,  108}, 
{  66,   67}, {  29,  317}, {  75,   76}, {  11,   12}, {  76,  124}, 
{  77,   78}, {  29,   17}, {  32,   28}, {  32,   28}, {  32,   28}, 
{  32,   28}, {  32,   28}, {  32,   28}, {  32,   28}, {  32,   28}, 
{  32,   28}, {  32,   28}, {  14,   27}, {  14,   37}, {  14,   13}, 
{  29,  209}, {  38,   34}, {  38,   34}, {  38,   34}, {  38,   34}, 
{  38,   34}, {  38,   34}, {  38,   34}, {  38,   34}, {  53,   54}, 
{  57,   58}, {  73,  242}, {  70,   73}, {  78,   79}, {  79,   80}, 
{  11,   12}, {  80,   81}, {  57,  287}, {  57,  116}, {  81,   82}, 
{  73,   74}, {  53,  296}, {  70,   71}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  83,   84}, {  17,   17}, 
{  17,   17}, {  10,   25}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  84,   85}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  85,   86}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, 
{  17,   17}, {  17,   17}, {  17,   17}, {  17,   17}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  86,   87}, 
{  21,   21}, {  21,   21}, {  87,   88}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  88,   89}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  91,   92}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, {  21,   21}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  92,   93}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   38}, {  24,   38}, 
{  24,   38}, {  24,   38}, {  24,   34}, {  24,   34}, {  24,   34}, 
{  24,   34}, {  93,   94}, {  95,   96}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  96,   97}, {  97,   98}, {  98,   99}, { 101,  263}, { 102,  103}, 
{ 103,  104}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, { 104,  105}, { 105,  106}, { 106,  107}, 
{ 108,  109}, { 111,  112}, { 112,  113}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   40}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, { 113,  114}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, {  24,   35}, 
{  24,   35}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, { 114,  115}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, { 117,  118}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, {  25,   10}, 
{  25,   10}, {  25,   10}, {  30,   35}, {  30,   35}, {  30,   35}, 
{  30,   35}, {  30,   35}, {  30,   35}, {  30,   35}, {  30,   35}, 
{  30,   35}, {  30,   35}, { 116,  220}, { 116,  117}, { 118,  119}, 
{  71,  133}, { 119,  120}, { 120,  121}, { 121,  122}, {  30,   35}, 
{  30,   35}, {  30,   35}, {  30,   35}, {  30,   35}, {  30,   35}, 
{  31,   15}, {  31,   15}, {  31,   15}, {  31,   15}, {  31,   15}, 
{  31,   15}, {  31,   15}, {  31,   15}, {  31,   15}, {  31,   15}, 
{  71,  251}, { 122,  123}, { 125,  126}, {  90,  257}, {  71,   72}, 
{ 100,  102}, {  90,   91}, {  31,   15}, {  31,   15}, {  31,   15}, 
{  31,   15}, {  31,   15}, {  31,   15}, {  90,  282}, {  50,  247}, 
{ 100,  101}, {  30,   35}, {  30,   35}, {  30,   35}, {  30,   35}, 
{  30,   35}, {  30,   35}, {  50,   59}, {  65,   66}, { 126,  253}, 
{  50,  267}, { 127,  128}, { 126,  127}, {  50,   51}, { 128,  129}, 
{  65,  271}, { 129,  130}, { 130,  131}, { 131,  132}, {  65,  302}, 
{ 133,  134}, { 134,  135}, {  65,   83}, { 135,  136}, {  31,   15}, 
{  31,   15}, {  31,   15}, {  31,   15}, {  31,   15}, {  31,   15}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, { 136,  137}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  36,   39}, {  36,   39}, 
{  36,   39}, {  36,   39}, {  36,   39}, {  36,   39}, {  36,   39}, 
{  36,   39}, {  36,   39}, {  36,   39}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  36,   39}, {  36,   39}, {  36,   39}, {  36,   39}, {  36,   39}, 
{  36,   39}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   24}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  36,   39}, {  36,   39}, {  36,   39}, 
{  36,   39}, {  36,   39}, {  36,   39}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, { 137,  138}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, {  33,   35}, 
{  33,   35}, {  39,   30}, {  39,   30}, {  39,   30}, {  39,   30}, 
{  39,   30}, {  39,   30}, {  39,   30}, {  39,   30}, {  39,   30}, 
{  39,   30}, { 138,  139}, { 140,  141}, { 141,  142}, { 142,  143}, 
{ 143,  144}, { 144,  145}, { 145,  146}, {  39,   30}, {  39,   30}, 
{  39,   30}, {  39,   30}, {  39,   30}, {  39,   30}, {  40,   36}, 
{  40,   36}, {  40,   36}, {  40,   36}, {  40,   36}, {  40,   36}, 
{  40,   36}, {  40,   36}, {  40,   36}, {  40,   36}, { 146,  147}, 
{ 147,  148}, { 148,  149}, { 149,  150}, { 152,  153}, { 153,  154}, 
{ 154,  155}, {  40,   36}, {  40,   36}, {  40,   36}, {  40,   36}, 
{  40,   36}, {  40,   36}, { 155,  156}, { 157,  158}, { 158,  159}, 
{  39,   30}, {  39,   30}, {  39,   30}, {  39,   30}, {  39,   30}, 
{  39,   30}, { 159,  160}, {  41,   14}, { 160,  161}, {  41,   41}, 
{  41,   41}, {  41,   41}, {  41,   41}, {  41,   41}, {  41,   41}, 
{  41,   41}, {  41,   41}, {  41,   41}, {  41,   41}, { 161,  162}, 
{ 110,  278}, { 162,  163}, { 163,  164}, {  40,   36}, {  40,   36}, 
{  40,   36}, {  40,   36}, {  40,   36}, {  40,   36}, {  41,   27}, 
{  41,   37}, {  41,   13}, { 110,  165}, { 110,  234}, { 151,  152}, 
{ 110,  111}, { 165,  166}, { 110,  140}, { 151,  238}, { 166,  167}, 
{ 167,  168}, { 168,  169}, { 171,  172}, { 172,  173}, { 173,  174}, 
{ 174,  175}, { 175,  176}, { 170,  310}, { 171,  177}, { 177,  178}, 
{ 178,  179}, { 179,  180}, { 180,  181}, { 181,  182}, { 151,  244}, 
{ 182,  183}, { 184,  185}, { 185,  186}, { 186,  187}, { 187,  188}, 
{ 189,  190}, {  41,   27}, {  41,   37}, {  41,   13}, { 170,  171}, 
{ 193,  215}, { 203,  231}, { 170,  184}, { 195,  228}, { 195,  196}, 
{ 196,  199}, { 196,  197}, { 200,  201}, { 200,  229}, { 205,  232}, 
{ 207,  208}, { 210,  211}, { 216,  217}, { 218,  219}, { 220,  221}, 
{ 221,  222}, { 222,  223}, { 203,  204}, { 223,  224}, { 224,  225}, 
{ 225,  226}, { 226,  227}, { 234,  235}, { 193,  194}, { 235,  236}, 
{ 236,  237}, { 238,  239}, { 205,  206}, { 242,  243}, { 244,  245}, 
{ 245,  246}, { 247,  248}, { 248,  249}, { 249,  250}, { 251,  252}, 
{ 253,  254}, { 257,  258}, { 258,  259}, { 259,  260}, { 260,  261}, 
{ 261,  262}, { 263,  264}, { 264,  265}, { 265,  266}, { 267,  268}, 
{ 268,  269}, { 269,  270}, { 271,  272}, { 272,  273}, { 274,  275}, 
{ 275,  276}, { 276,  277}, { 278,  279}, { 279,  280}, { 280,  281}, 
{ 282,  283}, { 283,  284}, { 287,  288}, { 189,  214}, { 288,  289}, 
{ 289,  290}, { 290,  291}, { 288,  306}, { 291,  292}, { 292,  293}, 
{ 293,  294}, { 294,  295}, { 296,  297}, { 297,  298}, { 298,  299}, 
{ 299,  300}, { 300,  301}, { 302,  303}, { 303,  304}, { 304,  305}, 
{ 306,  307}, { 307,  308}, { 310,  311}, { 311,  312}, { 312,  313}, 
{ 313,  314}, { 314,  315}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, {   0,    0}, 
{   0,    0}, {   0,    0}, {   0,    0}, 
};
static	yyCombType *	yyBasePtr	[yyDStateCount + 1] = { 0,
& yyComb [   0], & yyComb [   0], & yyComb [  64], & yyComb [   0], 
& yyComb [  17], & yyComb [   1], & yyComb [  33], & yyComb [  81], 
& yyComb [   0], & yyComb [ 194], & yyComb [ 157], & yyComb [   0], 
& yyComb [   0], & yyComb [ 147], & yyComb [  31], & yyComb [   0], 
& yyComb [ 273], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [ 529], & yyComb [   0], & yyComb [ 170], & yyComb [ 785], 
& yyComb [1041], & yyComb [  23], & yyComb [   0], & yyComb [  72], 
& yyComb [ 189], & yyComb [1249], & yyComb [1272], & yyComb [ 189], 
& yyComb [1375], & yyComb [  17], & yyComb [  36], & yyComb [1375], 
& yyComb [  33], & yyComb [ 203], & yyComb [1583], & yyComb [1606], 
& yyComb [1641], & yyComb [   1], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [1247], & yyComb [   6], & yyComb [   0], 
& yyComb [ 151], & yyComb [   6], & yyComb [   2], & yyComb [   0], 
& yyComb [ 158], & yyComb [   0], & yyComb [   3], & yyComb [   7], 
& yyComb [  14], & yyComb [  36], & yyComb [  24], & yyComb [   0], 
& yyComb [1256], & yyComb [ 114], & yyComb [  74], & yyComb [  71], 
& yyComb [   0], & yyComb [ 158], & yyComb [1213], & yyComb [   0], 
& yyComb [ 156], & yyComb [  66], & yyComb [ 113], & yyComb [ 119], 
& yyComb [ 134], & yyComb [ 147], & yyComb [ 147], & yyComb [ 152], 
& yyComb [ 159], & yyComb [   0], & yyComb [ 173], & yyComb [ 204], 
& yyComb [ 295], & yyComb [ 429], & yyComb [ 425], & yyComb [ 470], 
& yyComb [   0], & yyComb [1222], & yyComb [ 555], & yyComb [ 698], 
& yyComb [ 734], & yyComb [   0], & yyComb [ 738], & yyComb [ 745], 
& yyComb [ 743], & yyComb [ 751], & yyComb [   0], & yyComb [1234], 
& yyComb [ 736], & yyComb [ 752], & yyComb [ 758], & yyComb [ 765], 
& yyComb [ 775], & yyComb [ 768], & yyComb [   0], & yyComb [ 784], 
& yyComb [   0], & yyComb [1596], & yyComb [ 781], & yyComb [ 771], 
& yyComb [ 813], & yyComb [ 947], & yyComb [   0], & yyComb [1192], 
& yyComb [1067], & yyComb [1195], & yyComb [1209], & yyComb [1215], 
& yyComb [1214], & yyComb [1230], & yyComb [   0], & yyComb [   0], 
& yyComb [1221], & yyComb [1249], & yyComb [1259], & yyComb [1243], 
& yyComb [1256], & yyComb [1254], & yyComb [1262], & yyComb [   0], 
& yyComb [1255], & yyComb [1251], & yyComb [1263], & yyComb [1313], 
& yyComb [1392], & yyComb [1525], & yyComb [   0], & yyComb [1532], 
& yyComb [1544], & yyComb [1540], & yyComb [1531], & yyComb [1535], 
& yyComb [1537], & yyComb [1559], & yyComb [1543], & yyComb [1565], 
& yyComb [1567], & yyComb [   0], & yyComb [1617], & yyComb [1552], 
& yyComb [1564], & yyComb [1552], & yyComb [1576], & yyComb [   0], 
& yyComb [1580], & yyComb [1564], & yyComb [1570], & yyComb [1574], 
& yyComb [1602], & yyComb [1602], & yyComb [1586], & yyComb [   0], 
& yyComb [1619], & yyComb [1603], & yyComb [1615], & yyComb [1622], 
& yyComb [   0], & yyComb [1630], & yyComb [1617], & yyComb [1605], 
& yyComb [1627], & yyComb [1609], & yyComb [1625], & yyComb [   0], 
& yyComb [1613], & yyComb [1629], & yyComb [1632], & yyComb [1616], 
& yyComb [1632], & yyComb [1635], & yyComb [   0], & yyComb [1638], 
& yyComb [1629], & yyComb [1633], & yyComb [1640], & yyComb [   0], 
& yyComb [1679], & yyComb [   0], & yyComb [  19], & yyComb [   0], 
& yyComb [1707], & yyComb [   0], & yyComb [1687], & yyComb [1689], 
& yyComb [  31], & yyComb [   0], & yyComb [   0], & yyComb [1692], 
& yyComb [  34], & yyComb [   0], & yyComb [1701], & yyComb [   0], 
& yyComb [1711], & yyComb [   0], & yyComb [1694], & yyComb [   0], 
& yyComb [   0], & yyComb [1695], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [1696], 
& yyComb [   0], & yyComb [1697], & yyComb [   0], & yyComb [1643], 
& yyComb [1663], & yyComb [1651], & yyComb [1664], & yyComb [1663], 
& yyComb [1654], & yyComb [1664], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [1655], & yyComb [1668], & yyComb [1656], 
& yyComb [   0], & yyComb [1652], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], & yyComb [1658], & yyComb [   0], & yyComb [1666], 
& yyComb [1667], & yyComb [   0], & yyComb [1668], & yyComb [1662], 
& yyComb [1677], & yyComb [   0], & yyComb [1678], & yyComb [   0], 
& yyComb [1680], & yyComb [   0], & yyComb [   0], & yyComb [   0], 
& yyComb [1670], & yyComb [1674], & yyComb [1682], & yyComb [1687], 
& yyComb [1675], & yyComb [   0], & yyComb [1688], & yyComb [1679], 
& yyComb [1687], & yyComb [   0], & yyComb [1678], & yyComb [1693], 
& yyComb [1675], & yyComb [   0], & yyComb [1695], & yyComb [1679], 
& yyComb [   0], & yyComb [1683], & yyComb [1685], & yyComb [1693], 
& yyComb [   0], & yyComb [1686], & yyComb [1684], & yyComb [1683], 
& yyComb [   0], & yyComb [1684], & yyComb [1700], & yyComb [   0], 
& yyComb [   0], & yyComb [   0], & yyComb [1690], & yyComb [1696], 
& yyComb [1704], & yyComb [1697], & yyComb [1707], & yyComb [1699], 
& yyComb [1694], & yyComb [1696], & yyComb [   0], & yyComb [1696], 
& yyComb [1712], & yyComb [1704], & yyComb [1715], & yyComb [1701], 
& yyComb [   0], & yyComb [1720], & yyComb [1703], & yyComb [1704], 
& yyComb [   0], & yyComb [1706], & yyComb [1705], & yyComb [   0], 
& yyComb [   0], & yyComb [1723], & yyComb [1716], & yyComb [1727], 
& yyComb [1722], & yyComb [1725], & yyComb [   0], & yyComb [   0], 
& yyComb [   0], 
};
static	yyStateRange	yyDefault	[yyDStateCount + 1] = { 0,
    8,     1,    21,     3,     9,     9,    14,     9,     0,    25, 
    7,     0,     0,    23,    31,     0,    29,     0,     0,     0, 
    9,     9,     9,    30,     9,    11,     0,    32,     9,     9, 
    9,     9,    30,    35,     9,     9,    32,    35,     9,    35, 
   42,     0,     0,     0,    22,     9,    21,     0,    21,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,    42,     0, 
   42,     0,    42,     0,    42,    42,    42,     0,     0,    42, 
   42,     0,    42,     0,    42,     0,    42,     0,     0,    42, 
    0,     0,     0,     0,     0,    42,     0,    42,     0,     8, 
    8,     8,     8,     8,     8,     8,     8,     0,     0,     0, 
    0,     0,     0,     8,     8,     8,     8,     8,     8,     0, 
    0,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     0,     0,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     0,     0,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     8,     8, 
    8,     8,     8,     8,     8,     8,     8,     8,     0,     8, 
    8,     8,     8,     8,     8,     0,     0, 
};
static	yyStateRange	yyEobTrans	[yyDStateCount + 1] = { 0,
    0,     0,    21,    21,     0,     0,     0,     0,     0,    10, 
    0,     0,     0,     0,     0,     0,    17,     0,     0,     0, 
   21,     0,     0,    35,    10,     0,     0,     0,     0,     0, 
    0,     0,    35,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,    21,     0,    21,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0, 
    0,     0,     0,     0,     0,     0,     0, 
};

static	yyStateRange	yyStartState	= STD;
static	yyStateRange	yyPreviousStart	= STD;
static	short		yySourceFile	= StdIn;
static	rbool		yyBufferIsUsed	= rfalse;
static	rbool		yyEof		= rfalse;
static	long		yyBytesRead	= 0;
static	long		yyFileOffset	= 0;
static	unsigned int	yyLineCount	= 1;
static	unsigned char *	yyLineStart	;
static	char *		yyChBufferStart2;

					/* Start State Stack: StStSt	*/

#if defined xxyyPush | defined xxyyPop
#define		yyInitStStStackSize	16

CreateArray1 (yyStStStackPtr, yyInitStStStack, yyStateRange,
   yyInitStStStackSize, {0})
static	unsigned long	yyStStStackSize	= yyInitStStStackSize;
static	unsigned int	yyStStStackIdx	= 0;
#endif

#ifdef xxyyPush
static void yyPush
#if defined __STDC__ | defined __cplusplus
   (yyStateRange yyState)
#else
   (yyState) yyStateRange yyState;
#endif
{
   if (yyStStStackIdx == yyStStStackSize) {
      ExtendArray ((char * *) & yyStStStackPtr, & yyStStStackSize,
			(unsigned long) sizeof (yyStateRange));
      if (yyStStStackPtr == NULL) yyErrorMessage (1);
   }
   yyStStStackPtr [yyStStStackIdx ++] = yyStartState;
   yyStart (yyState);
}
#endif

#ifdef xxyyPop
static void yyPop ARGS ((void))
{
   yyPreviousStart = yyStartState;
   if (yyStStStackIdx > 0)
      yyStartState = yyStStStackPtr [-- yyStStStackIdx];
   else
      yyErrorMessage (4);
}
#endif

#ifdef xxGetLower
static	unsigned char	yyToLower	[] = {
'\0', '\1', '\2', '\3', '\4', '\5', '\6', '\7',
'\10', '\11', '\12', '\13', '\14', '\15', '\16', '\17',
'\20', '\21', '\22', '\23', '\24', '\25', '\26', '\27',
'\30', '\31', '\32', '\33', '\34', '\35', '\36', '\37',
' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/',
'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
'@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_',
'`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}','~','\177',
'\200', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
'\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217',
'\220', '\221', '\222', '\223', '\224', '\225', '\226', '\227',
'\230', '\231', '\232', '\233', '\234', '\235', '\236', '\237',
'\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247',
'\250', '\251', '\252', '\253', '\254', '\255', '\256', '\257',
'\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
'\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
'\300', '\301', '\302', '\303', '\304', '\305', '\306', '\307',
'\310', '\311', '\312', '\313', '\314', '\315', '\316', '\317',
'\320', '\321', '\322', '\323', '\324', '\325', '\326', '\327',
'\330', '\331', '\332', '\333', '\334', '\335', '\336', '\337',
'\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
'\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
'\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
'\370', '\371', '\372', '\373', '\374', '\375', '\376', '\377',
};
#endif

#ifdef xxGetUpper
static	unsigned char	yyToUpper	[] = {
'\0', '\1', '\2', '\3', '\4', '\5', '\6', '\7',
'\10', '\11', '\12', '\13', '\14', '\15', '\16', '\17',
'\20', '\21', '\22', '\23', '\24', '\25', '\26', '\27',
'\30', '\31', '\32', '\33', '\34', '\35', '\36', '\37',
' ', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/',
'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_',
'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}','~','\177',
'\200', '\201', '\202', '\203', '\204', '\205', '\206', '\207',
'\210', '\211', '\212', '\213', '\214', '\215', '\216', '\217',
'\220', '\221', '\222', '\223', '\224', '\225', '\226', '\227',
'\230', '\231', '\232', '\233', '\234', '\235', '\236', '\237',
'\240', '\241', '\242', '\243', '\244', '\245', '\246', '\247',
'\250', '\251', '\252', '\253', '\254', '\255', '\256', '\257',
'\260', '\261', '\262', '\263', '\264', '\265', '\266', '\267',
'\270', '\271', '\272', '\273', '\274', '\275', '\276', '\277',
'\300', '\301', '\302', '\303', '\304', '\305', '\306', '\307',
'\310', '\311', '\312', '\313', '\314', '\315', '\316', '\317',
'\320', '\321', '\322', '\323', '\324', '\325', '\326', '\327',
'\330', '\331', '\332', '\333', '\334', '\335', '\336', '\337',
'\340', '\341', '\342', '\343', '\344', '\345', '\346', '\347',
'\350', '\351', '\352', '\353', '\354', '\355', '\356', '\357',
'\360', '\361', '\362', '\363', '\364', '\365', '\366', '\367',
'\370', '\371', '\372', '\373', '\374', '\375', '\376', '\377',
};
#endif

static void yyTab1	ARGS ((int yya));

#define yyTab		yyTab1 (0)
#define yyTab2(a,b)	yyTab1 (a)

/* line 35 "java.rex" */

#include <ctype.h>
#include "Errors.h"
#include "Parser.h"
#if HAVE_STDLIB_H | defined _MSC_VER
#include <stdlib.h>
#endif
#include "sn.h"

#define HIGHLIGHT if (hl && isalpha (* TokenPtr)) { \
	(void) fprintf (hlfp, "%d key %d.%d %d.%d\n", PAF_HIGH, \
	Attribute.Position.Line, Attribute.Position.Column - 1, \
	Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1); }

static	tPosition	StartPosition;

void ErrorAttribute
#if defined __STDC__ | defined __cplusplus
 (int Token, tScanAttribute * pAttribute)
#else
 (Token, pAttribute) int Token; tScanAttribute * pAttribute;
#endif
{
 pAttribute->Position = Attribute.Position;
 switch (Token) {
 case /* Identifier */ 1: 
 pAttribute->Identifier.ident = NoIdent		;
 ;
 break;
 case /* IntegerLiteral */ 2: 
 pAttribute->IntegerLiteral.value = 0			;
 ;
 break;
 case /* LongLiteral */ 3: 
 pAttribute->LongLiteral.value = 0			;
 ;
 break;
 case /* FloatingPointLiteral */ 4: 
 pAttribute->FloatingPointLiteral.value = PutString ("", 0)	;
 ;
 break;
 case /* DoubleLiteral */ 5: 
 pAttribute->DoubleLiteral.value = PutString ("", 0)	;
 ;
 break;
 case /* CharacterLiteral */ 6: 
 pAttribute->CharacterLiteral.value = PutString ("", 0)	;
 ;
 break;
 case /* StringLiteral */ 7: 
 pAttribute->StringLiteral.value = PutString ("", 0)	;
 ;
 break;
 }
}



#ifndef yySetPosition
#define yySetPosition Attribute.Position.Line   = yyLineCount; \
Attribute.Position.Column = (int) ((unsigned char *) TokenPtr - yyLineStart);
#endif

#undef yyTab
#undef yyTab2

#ifndef yyInitBufferSize
#define yyInitBufferSize	1024 * 8 + 256
#endif
#ifndef yyInitFileStackSize
#define yyInitFileStackSize	8
#endif
#ifndef yyTabSpace
#define yyTabSpace		8
#endif

static void yyTab1
#if defined __STDC__ | defined __cplusplus
   (int yya)
#else
   (yya) int yya;
#endif
   { yyLineStart -= (yyTabSpace - 1 - ((unsigned char *) TokenPtr -
	yyLineStart + yya - 1)) & (yyTabSpace - 1); }

#define yyTab		yyLineStart -= (yyTabSpace - 1 - \
((unsigned char *) TokenPtr - yyLineStart - 1)) & (yyTabSpace - 1)
#define yyTab1(a)	yyLineStart -= (yyTabSpace - 1 - \
((unsigned char *) TokenPtr - yyLineStart + (a) - 1)) & (yyTabSpace - 1)
#define yyTab2(a,b)	yyLineStart -= (yyTabSpace - 1 - \
((unsigned char *) TokenPtr - yyLineStart + (a) - 1)) & (yyTabSpace - 1)

CreateArray1 (yyStateStack, yyInitStateStack, yyStateRange, yyInitBufferSize,
   {yyDefaultState})
static	unsigned long	yyStateStackSize= yyInitBufferSize;

CreateArray1a (yyChBufferPtr, yyInitChBuffer, unsigned char, yyInitBufferSize) =
{ 0.0, { '\0', '\0', '\0', '\0', '\0', '\0', '\0', '\0',
	 '\0', '\0', '\0', '\0', '\0', '\0', '\0', yyEolCh, yyEobCh, '\0', }};
CreateArray1b (yyChBufferPtr, yyInitChBuffer, unsigned char, yyInitBufferSize)

static	unsigned char *	yyChBufferStart	= & yyInitChBuffer.yyArray [16];
static	unsigned long	yyChBufferSize	= yyInitBufferSize;
static	unsigned char *	yyChBufferIndex	= & yyInitChBuffer.yyArray [16];

typedef	struct {
	short		yySourceFile	;
	rbool		yyEof		;
	unsigned char *	yyChBufferPtr	;
	unsigned char *	yyChBufferStart	;
	unsigned long	yyChBufferSize	;
	unsigned char *	yyChBufferIndex	;
	long		yyBytesRead	;
	long		yyFileOffset	;
	unsigned int	yyLineCount	;
	unsigned char *	yyLineStart	;
	}		yytFileStack	;

CreateArray2 (yyFileStack, yyInitFileStack, yytFileStack,
   yyInitFileStackSize, {{0}})
static	unsigned long	yyFileStackSize	= yyInitFileStackSize;
static	yytFileStack *	yyFileStackPtr	= & yyInitFileStack.yyArray [1];

int GetToken ARGS ((void))
{
   register	yyStateRange	yyState;
   register	yyStateRange *	yyStatePtr;
   register	unsigned char * yyChBufferIndexReg;
   register	yyCombType * *	yyBasePtrReg = yyBasePtr;

yyBegin:
   yyState		= yyStartState;		/* initialize */
   yyStatePtr		= & yyStateStack [1];
   yyChBufferIndexReg	= yyChBufferIndex;
   TokenPtr		= (char *) yyChBufferIndexReg;

   /* ASSERT yyChBuffer [yyChBufferIndex] == first character */

yyContinue:		/* continue after sentinel or skipping blanks */
   for (;;) {		/* execute as many state transitions as possible */
			/* determine next state and get next character */
      register yyCombType * yyTablePtr =
			(yyBasePtrReg [yyState] + * yyChBufferIndexReg ++);
      if (yyTablePtr->yyCheck == yyState) {
	 yyState = yyTablePtr->yyNext;
	 * yyStatePtr ++ = yyState;		/* push state */
	 goto yyContinue;
      }
      yyChBufferIndexReg --;			/* reconsider character */
      if ((yyState = yyDefault [yyState]) == yyDNoState) break;
   }

   for (;;) {				/* search for last final state */
      TokenLength =
	    (int) (yyChBufferIndexReg - (unsigned char *) TokenPtr);
      yyChBufferIndex = yyChBufferIndexReg;
switch (* -- yyStatePtr) {
case 317:;
yySetPosition
/* line 131 "java.rex" */
{ yyStart (COMMENT); StartPosition = Attribute.Position; 
} yyy1: goto yyBegin;
case 5:;
case 21:;
case 47:;
case 49:;
/* line 132 "java.rex" */
{
} yyy2: goto yyBegin;
case 316:;
yySetPosition
/* line 133 "java.rex" */
{ yyPrevious; if (hl) {
	(void) fprintf (hlfp, "%d rem %d.%d %d.%d\n", PAF_HIGH,
	StartPosition.Line, StartPosition.Column - 1,
	Attribute.Position.Line, Attribute.Position.Column + 1); } 
} yyy3: goto yyBegin;
case 17:;
yySetPosition
/* line 138 "java.rex" */
{ if (hl) {
	(void) fprintf (hlfp, "%d rem %d.%d %d.%d\n", PAF_HIGH,
	Attribute.Position.Line, Attribute.Position.Column - 1,
	Attribute.Position.Line, Attribute.Position.Column + TokenLength - 1); } 
} yyy4: goto yyBegin;
case 9:;
case 46:;
/* line 143 "java.rex" */
{
} yyy5: goto yyBegin;
case 6:;
case 22:;
case 45:;
/* line 145 "java.rex" */
{ yyEol (0); 
} yyy6: goto yyBegin;
case 315:;
yySetPosition
/* line 147 "java.rex" */
{  HIGHLIGHT; return 8; 
} yyy7: goto yyBegin;
case 23:;
yySetPosition
/* line 148 "java.rex" */
{  HIGHLIGHT; return 9; 
} yyy8: goto yyBegin;
case 309:;
yySetPosition
/* line 149 "java.rex" */
{  HIGHLIGHT; return 10; 
} yyy9: goto yyBegin;
case 308:;
yySetPosition
/* line 150 "java.rex" */
{  HIGHLIGHT; return 11; 
} yyy10: goto yyBegin;
case 210:;
yySetPosition
/* line 151 "java.rex" */
{  HIGHLIGHT; return 12; 
} yyy11: goto yyBegin;
case 305:;
yySetPosition
/* line 152 "java.rex" */
{  HIGHLIGHT; return 13; 
} yyy12: goto yyBegin;
case 301:;
yySetPosition
/* line 153 "java.rex" */
{  HIGHLIGHT; return 14; 
} yyy13: goto yyBegin;
case 295:;
yySetPosition
/* line 154 "java.rex" */
{  HIGHLIGHT; return 15; 
} yyy14: goto yyBegin;
case 286:;
yySetPosition
/* line 155 "java.rex" */
{  HIGHLIGHT; return 16; 
} yyy15: goto yyBegin;
case 285:;
yySetPosition
/* line 156 "java.rex" */
{  HIGHLIGHT; return 17; 
} yyy16: goto yyBegin;
case 284:;
yySetPosition
/* line 157 "java.rex" */
{  HIGHLIGHT; return 18; 
} yyy17: goto yyBegin;
case 281:;
yySetPosition
/* line 158 "java.rex" */
{  HIGHLIGHT; return 19; 
} yyy18: goto yyBegin;
case 117:;
yySetPosition
/* line 159 "java.rex" */
{  HIGHLIGHT; return 20; 
} yyy19: goto yyBegin;
case 277:;
yySetPosition
/* line 160 "java.rex" */
{  HIGHLIGHT; return 21; 
} yyy20: goto yyBegin;
case 273:;
yySetPosition
/* line 161 "java.rex" */
{  HIGHLIGHT; return 22; 
} yyy21: goto yyBegin;
case 270:;
yySetPosition
/* line 162 "java.rex" */
{  HIGHLIGHT; return 23; 
} yyy22: goto yyBegin;
case 266:;
yySetPosition
/* line 163 "java.rex" */
{  HIGHLIGHT; return 24; 
} yyy23: goto yyBegin;
case 262:;
yySetPosition
/* line 164 "java.rex" */
{  HIGHLIGHT; return 25; 
} yyy24: goto yyBegin;
case 256:;
yySetPosition
/* line 165 "java.rex" */
{  HIGHLIGHT; return 26; 
} yyy25: goto yyBegin;
case 255:;
yySetPosition
/* line 166 "java.rex" */
{  HIGHLIGHT; return 27; 
} yyy26: goto yyBegin;
case 254:;
yySetPosition
/* line 167 "java.rex" */
{  HIGHLIGHT; return 28; 
} yyy27: goto yyBegin;
case 218:;
yySetPosition
/* line 168 "java.rex" */
{  HIGHLIGHT; return 29; 
} yyy28: goto yyBegin;
case 252:;
yySetPosition
/* line 169 "java.rex" */
{  HIGHLIGHT; return 30; 
} yyy29: goto yyBegin;
case 250:;
yySetPosition
/* line 170 "java.rex" */
{  HIGHLIGHT; return 31; 
} yyy30: goto yyBegin;
case 246:;
yySetPosition
/* line 171 "java.rex" */
{  HIGHLIGHT; return 32; 
} yyy31: goto yyBegin;
case 243:;
yySetPosition
/* line 172 "java.rex" */
{  HIGHLIGHT; return 33; 
} yyy32: goto yyBegin;
case 241:;
yySetPosition
/* line 173 "java.rex" */
{  HIGHLIGHT; return 34; 
} yyy33: goto yyBegin;
case 240:;
yySetPosition
/* line 174 "java.rex" */
{  HIGHLIGHT; return 35; 
} yyy34: goto yyBegin;
case 239:;
yySetPosition
/* line 175 "java.rex" */
{  HIGHLIGHT; return 36; 
} yyy35: goto yyBegin;
case 237:;
yySetPosition
/* line 176 "java.rex" */
{  HIGHLIGHT; return 37; 
} yyy36: goto yyBegin;
case 233:;
yySetPosition
/* line 177 "java.rex" */
{  HIGHLIGHT; return 38; 
} yyy37: goto yyBegin;
case 232:;
yySetPosition
/* line 178 "java.rex" */
{  HIGHLIGHT; return 39; 
} yyy38: goto yyBegin;
case 231:;
yySetPosition
/* line 179 "java.rex" */
{  HIGHLIGHT; return 40; 
} yyy39: goto yyBegin;
case 205:;
yySetPosition
/* line 180 "java.rex" */
{  HIGHLIGHT; return 41; 
} yyy40: goto yyBegin;
case 203:;
yySetPosition
/* line 181 "java.rex" */
{  HIGHLIGHT; return 42; 
} yyy41: goto yyBegin;
case 230:;
yySetPosition
/* line 182 "java.rex" */
{  HIGHLIGHT; return 43; 
} yyy42: goto yyBegin;
case 216:;
yySetPosition
/* line 183 "java.rex" */
{  HIGHLIGHT; return 44; 
} yyy43: goto yyBegin;
case 29:;
yySetPosition
/* line 184 "java.rex" */
{  HIGHLIGHT; return 45; 
} yyy44: goto yyBegin;
case 207:;
yySetPosition
/* line 185 "java.rex" */
{  HIGHLIGHT; return 46; 
} yyy45: goto yyBegin;
case 201:;
yySetPosition
/* line 186 "java.rex" */
{  HIGHLIGHT; return 47; 
} yyy46: goto yyBegin;
case 196:;
yySetPosition
/* line 187 "java.rex" */
{  HIGHLIGHT; return 48; 
} yyy47: goto yyBegin;
case 197:;
yySetPosition
/* line 188 "java.rex" */
{  HIGHLIGHT; return 49; 
} yyy48: goto yyBegin;
case 200:;
yySetPosition
/* line 189 "java.rex" */
{  HIGHLIGHT; return 50; 
} yyy49: goto yyBegin;
case 195:;
yySetPosition
/* line 190 "java.rex" */
{  HIGHLIGHT; return 51; 
} yyy50: goto yyBegin;
case 229:;
yySetPosition
/* line 191 "java.rex" */
{  HIGHLIGHT; return 52; 
} yyy51: goto yyBegin;
case 228:;
yySetPosition
/* line 192 "java.rex" */
{  HIGHLIGHT; return 53; 
} yyy52: goto yyBegin;
case 227:;
yySetPosition
/* line 193 "java.rex" */
{  HIGHLIGHT; return 54; 
} yyy53: goto yyBegin;
case 219:;
yySetPosition
/* line 194 "java.rex" */
{  HIGHLIGHT; return 55; 
} yyy54: goto yyBegin;
case 217:;
yySetPosition
/* line 195 "java.rex" */
{  HIGHLIGHT; return 56; 
} yyy55: goto yyBegin;
case 193:;
yySetPosition
/* line 196 "java.rex" */
{  HIGHLIGHT; return 57; 
} yyy56: goto yyBegin;
case 191:;
yySetPosition
/* line 197 "java.rex" */
{  HIGHLIGHT; return 58; 
} yyy57: goto yyBegin;
case 189:;
yySetPosition
/* line 198 "java.rex" */
{  HIGHLIGHT; return 59; 
} yyy58: goto yyBegin;
case 215:;
yySetPosition
/* line 199 "java.rex" */
{  HIGHLIGHT; return 60; 
} yyy59: goto yyBegin;
case 214:;
yySetPosition
/* line 200 "java.rex" */
{  HIGHLIGHT; return 61; 
} yyy60: goto yyBegin;
case 213:;
yySetPosition
/* line 201 "java.rex" */
{  HIGHLIGHT; return 62; 
} yyy61: goto yyBegin;
case 212:;
yySetPosition
/* line 202 "java.rex" */
{  HIGHLIGHT; return 63; 
} yyy62: goto yyBegin;
case 211:;
yySetPosition
/* line 203 "java.rex" */
{  HIGHLIGHT; return 64; 
} yyy63: goto yyBegin;
case 209:;
yySetPosition
/* line 204 "java.rex" */
{  HIGHLIGHT; return 65; 
} yyy64: goto yyBegin;
case 208:;
yySetPosition
/* line 205 "java.rex" */
{  HIGHLIGHT; return 66; 
} yyy65: goto yyBegin;
case 206:;
yySetPosition
/* line 206 "java.rex" */
{  HIGHLIGHT; return 67; 
} yyy66: goto yyBegin;
case 204:;
yySetPosition
/* line 207 "java.rex" */
{  HIGHLIGHT; return 68; 
} yyy67: goto yyBegin;
case 202:;
yySetPosition
/* line 208 "java.rex" */
{  HIGHLIGHT; return 69; 
} yyy68: goto yyBegin;
case 199:;
yySetPosition
/* line 209 "java.rex" */
{  HIGHLIGHT; return 70; 
} yyy69: goto yyBegin;
case 198:;
yySetPosition
/* line 210 "java.rex" */
{  HIGHLIGHT; return 71; 
} yyy70: goto yyBegin;
case 194:;
yySetPosition
/* line 211 "java.rex" */
{  HIGHLIGHT; return 72; 
} yyy71: goto yyBegin;
case 192:;
yySetPosition
/* line 212 "java.rex" */
{  HIGHLIGHT; return 73; 
} yyy72: goto yyBegin;
case 190:;
yySetPosition
/* line 213 "java.rex" */
{  HIGHLIGHT; return 74; 
} yyy73: goto yyBegin;
case 188:;
yySetPosition
/* line 214 "java.rex" */
{  HIGHLIGHT; return 75; 
} yyy74: goto yyBegin;
case 183:;
yySetPosition
/* line 215 "java.rex" */
{  HIGHLIGHT; return 76; 
} yyy75: goto yyBegin;
case 176:;
yySetPosition
/* line 216 "java.rex" */
{  HIGHLIGHT; return 77; 
} yyy76: goto yyBegin;
case 169:;
yySetPosition
/* line 217 "java.rex" */
{  HIGHLIGHT; return 78; 
} yyy77: goto yyBegin;
case 164:;
yySetPosition
/* line 218 "java.rex" */
{  HIGHLIGHT; return 79; 
} yyy78: goto yyBegin;
case 62:;
yySetPosition
/* line 219 "java.rex" */
{  HIGHLIGHT; return 80; 
} yyy79: goto yyBegin;
case 156:;
yySetPosition
/* line 220 "java.rex" */
{  HIGHLIGHT; return 81; 
} yyy80: goto yyBegin;
case 150:;
yySetPosition
/* line 221 "java.rex" */
{  HIGHLIGHT; return 82; 
} yyy81: goto yyBegin;
case 139:;
yySetPosition
/* line 222 "java.rex" */
{  HIGHLIGHT; return 83; 
} yyy82: goto yyBegin;
case 132:;
yySetPosition
/* line 223 "java.rex" */
{  HIGHLIGHT; return 84; 
} yyy83: goto yyBegin;
case 124:;
yySetPosition
/* line 224 "java.rex" */
{  HIGHLIGHT; return 85; 
} yyy84: goto yyBegin;
case 123:;
yySetPosition
/* line 225 "java.rex" */
{  HIGHLIGHT; return 86; 
} yyy85: goto yyBegin;
case 115:;
yySetPosition
/* line 226 "java.rex" */
{  HIGHLIGHT; return 87; 
} yyy86: goto yyBegin;
case 109:;
yySetPosition
/* line 227 "java.rex" */
{  HIGHLIGHT; return 88; 
} yyy87: goto yyBegin;
case 107:;
yySetPosition
/* line 228 "java.rex" */
{  HIGHLIGHT; return 89; 
} yyy88: goto yyBegin;
case 101:;
yySetPosition
/* line 229 "java.rex" */
{  HIGHLIGHT; return 90; 
} yyy89: goto yyBegin;
case 99:;
yySetPosition
/* line 230 "java.rex" */
{  HIGHLIGHT; return 91; 
} yyy90: goto yyBegin;
case 94:;
yySetPosition
/* line 231 "java.rex" */
{  HIGHLIGHT; return 92; 
} yyy91: goto yyBegin;
case 89:;
yySetPosition
/* line 232 "java.rex" */
{  HIGHLIGHT; return 93; 
} yyy92: goto yyBegin;
case 82:;
yySetPosition
/* line 233 "java.rex" */
{  HIGHLIGHT; return 94; 
} yyy93: goto yyBegin;
case 76:;
yySetPosition
/* line 234 "java.rex" */
{  HIGHLIGHT; return 95; 
} yyy94: goto yyBegin;
case 72:;
yySetPosition
/* line 235 "java.rex" */
{  HIGHLIGHT; return 96; 
} yyy95: goto yyBegin;
case 69:;
yySetPosition
/* line 236 "java.rex" */
{  HIGHLIGHT; return 97; 
} yyy96: goto yyBegin;
case 64:;
yySetPosition
/* line 237 "java.rex" */
{  HIGHLIGHT; return 98; 
} yyy97: goto yyBegin;
case 58:;
yySetPosition
/* line 238 "java.rex" */
{  HIGHLIGHT; return 99; 
} yyy98: goto yyBegin;
case 56:;
yySetPosition
/* line 239 "java.rex" */
{  HIGHLIGHT; return 100; 
} yyy99: goto yyBegin;
case 52:;
yySetPosition
/* line 240 "java.rex" */
{  HIGHLIGHT; return 101; 
} yyy100: goto yyBegin;
case 20:;
yySetPosition
/* line 243 "java.rex" */
{ Attribute.LongLiteral.value = atol (TokenPtr);
		    return 3; 
} yyy101: goto yyBegin;
case 16:;
yySetPosition
/* line 245 "java.rex" */
{ (void) sscanf (TokenPtr, "%li", & Attribute.LongLiteral.value);
		    return 3; 
} yyy102: goto yyBegin;
case 12:;
yySetPosition
/* line 247 "java.rex" */
{ (void) sscanf (TokenPtr, "%li", & Attribute.LongLiteral.value);
		    return 3; 
} yyy103: goto yyBegin;
case 7:;
yySetPosition
/* line 249 "java.rex" */
{ Attribute.IntegerLiteral.value = atol (TokenPtr);
		    return 2; 
} yyy104: goto yyBegin;
case 15:;
yySetPosition
/* line 251 "java.rex" */
{ (void) sscanf (TokenPtr, "%li", & Attribute.IntegerLiteral.value);
		    return 2; 
} yyy105: goto yyBegin;
case 11:;
case 26:;
yySetPosition
/* line 253 "java.rex" */
{ (void) sscanf (TokenPtr, "%li", & Attribute.IntegerLiteral.value);
		    return 2; 
} yyy106: goto yyBegin;
case 18:;
yySetPosition
/* line 255 "java.rex" */
{ Attribute.CharacterLiteral.value = PutString (TokenPtr, TokenLength);
		    return 6; 
} yyy107: goto yyBegin;
case 13:;
yySetPosition
/* line 257 "java.rex" */
{ Attribute.FloatingPointLiteral.value = PutString (TokenPtr, TokenLength);
		    return 4; 
} yyy108: goto yyBegin;
case 14:;
case 27:;
case 28:;
yySetPosition
/* line 259 "java.rex" */
{ Attribute.DoubleLiteral.value = PutString (TokenPtr, TokenLength);
		    return 5; 
} yyy109: goto yyBegin;
case 19:;
yySetPosition
/* line 261 "java.rex" */
{ Attribute.StringLiteral.value = PutString (TokenPtr, TokenLength);
		    return 7; 
} yyy110: goto yyBegin;
case 8:;
case 50:;
case 51:;
case 53:;
case 54:;
case 55:;
case 57:;
case 59:;
case 60:;
case 61:;
case 63:;
case 65:;
case 66:;
case 67:;
case 68:;
case 70:;
case 71:;
case 73:;
case 74:;
case 75:;
case 77:;
case 78:;
case 79:;
case 80:;
case 81:;
case 83:;
case 84:;
case 85:;
case 86:;
case 87:;
case 88:;
case 90:;
case 91:;
case 92:;
case 93:;
case 95:;
case 96:;
case 97:;
case 98:;
case 100:;
case 102:;
case 103:;
case 104:;
case 105:;
case 106:;
case 108:;
case 110:;
case 111:;
case 112:;
case 113:;
case 114:;
case 116:;
case 118:;
case 119:;
case 120:;
case 121:;
case 122:;
case 125:;
case 126:;
case 127:;
case 128:;
case 129:;
case 130:;
case 131:;
case 133:;
case 134:;
case 135:;
case 136:;
case 137:;
case 138:;
case 140:;
case 141:;
case 142:;
case 143:;
case 144:;
case 145:;
case 146:;
case 147:;
case 148:;
case 149:;
case 151:;
case 152:;
case 153:;
case 154:;
case 155:;
case 157:;
case 158:;
case 159:;
case 160:;
case 161:;
case 162:;
case 163:;
case 165:;
case 166:;
case 167:;
case 168:;
case 170:;
case 171:;
case 172:;
case 173:;
case 174:;
case 175:;
case 177:;
case 178:;
case 179:;
case 180:;
case 181:;
case 182:;
case 184:;
case 185:;
case 186:;
case 187:;
case 220:;
case 221:;
case 222:;
case 223:;
case 224:;
case 225:;
case 226:;
case 234:;
case 235:;
case 236:;
case 238:;
case 242:;
case 244:;
case 245:;
case 247:;
case 248:;
case 249:;
case 251:;
case 253:;
case 257:;
case 258:;
case 259:;
case 260:;
case 261:;
case 263:;
case 264:;
case 265:;
case 267:;
case 268:;
case 269:;
case 271:;
case 272:;
case 274:;
case 275:;
case 276:;
case 278:;
case 279:;
case 280:;
case 282:;
case 283:;
case 287:;
case 288:;
case 289:;
case 290:;
case 291:;
case 292:;
case 293:;
case 294:;
case 296:;
case 297:;
case 298:;
case 299:;
case 300:;
case 302:;
case 303:;
case 304:;
case 306:;
case 307:;
case 310:;
case 311:;
case 312:;
case 313:;
case 314:;
yySetPosition
/* line 263 "java.rex" */
{ Attribute.Identifier.ident = MakeIdent (TokenPtr, TokenLength);
		    return 1; 
} yyy111: goto yyBegin;
case 48:;
{/* BlankAction */
while (* yyChBufferIndexReg ++ == ' ') ;
TokenPtr = (char *) -- yyChBufferIndexReg;
yyState = yyStartState;
yyStatePtr = & yyStateStack [1];
goto yyContinue;
} yyy112: goto yyBegin;
case 1:;
case 2:;
case 3:;
case 4:;
case 10:;
case 24:;
case 25:;
case 30:;
case 31:;
case 32:;
case 33:;
case 34:;
case 35:;
case 36:;
case 37:;
case 38:;
case 39:;
case 40:;
case 41:;
case 42:;
	 /* non final states */
	 yyChBufferIndexReg --;			/* return character */
	 break;

case 44:
	 yySetPosition
      /* TokenLength   = 1; */
	 yyChBufferIndex = ++ yyChBufferIndexReg;
	 {
/* line 93 "java.rex" */

   if (' ' < * TokenPtr && * TokenPtr <= '~') {
      MessageI ("illegal character", xxError, Attribute.Position,
	 xxCharacter, TokenPtr);
   } else {
      char s [5];
      (void) sprintf (s, "\\%03d", (unsigned char) * TokenPtr);
      MessageI ("illegal character", xxError, Attribute.Position,
	 xxString, s);
   }

	 }
	 goto yyBegin;

      case yyDNoState:
	 goto yyBegin;

case 43:
	 yyChBufferIndex = -- yyChBufferIndexReg; /* undo last state transit */
	 if (-- TokenLength == 0) {		/* get previous state */
	    yyState = yyStartState;
	 } else {
	    yyState = * (yyStatePtr - 1);
	 }

	 if (yyChBufferIndex != & yyChBufferStart [yyBytesRead]) {
					/* end of buffer sentinel in buffer */
	    if ((yyState = yyEobTrans [yyState]) == yyDNoState) continue;
	    yyChBufferIndexReg ++;
	    * yyStatePtr ++ = yyState;		/* push state */
	    goto yyContinue;
	 }
						/* end of buffer reached */
	 if (! yyEof) {
	    register char * yySource = TokenPtr - 1;
	    register char * yyTarget = (char *) & yyChBufferPtr
		[(yyMaxAlign - 1 - TokenLength) & (yyMaxAlign - 1)];
	    unsigned long yyChBufferFree = Exp2 (Log2 (yyChBufferSize - 4 -
		yyMaxAlign - TokenLength));
	    if (! yyBufferIsUsed) {
		yyLineStart	= & yyChBufferPtr [16 - 1];
		yyBufferIsUsed	= rtrue;
	    }
		/* copy initial part of token in front of the input buffer */
	    if (yySource > yyTarget) {
	       TokenPtr = yyTarget + 1;
	       do * yyTarget ++ = * yySource ++;
	       while (yySource < (char *) yyChBufferIndexReg);
	       yyLineStart += (unsigned char *) yyTarget - yyChBufferStart -
				yyBytesRead;
	       yyChBufferStart = (unsigned char *) yyTarget;
	    } else {
	       yyChBufferStart = yyChBufferIndexReg;
	    }
	    yyChBufferStart2 = (char *) yyChBufferStart;
						/* extend buffer if necessary */
	    if (yyChBufferFree < yyChBufferSize >> 3 /* / 8 */ ) {
	       register unsigned long yyDelta;
	       register unsigned char * yyOldChBufferPtr = yyChBufferPtr;
	       ExtendArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
				(unsigned long) sizeof (char));
	       if (yyChBufferPtr == NULL) yyErrorMessage (1);
	       yyDelta = yyChBufferPtr - yyOldChBufferPtr;
	       yyChBufferStart	+= yyDelta;
	       yyLineStart	+= yyDelta;
	       TokenPtr	+= yyDelta;
	       yyChBufferStart2	 = (char *) yyChBufferStart;
	       yyChBufferFree = Exp2 (Log2 (yyChBufferSize - 4 -
			yyMaxAlign - TokenLength));
	       if (yyStateStackSize < yyChBufferSize) {
		  yyStateRange * yyOldStateStack = yyStateStack;
		  ExtendArray ((char * *) & yyStateStack, & yyStateStackSize,
				   (unsigned long) sizeof (yyStateRange));
		  if (yyStateStack == NULL) yyErrorMessage (1);
		  yyStatePtr	+= yyStateStack - yyOldStateStack;
	       }
	    }
						/* read buffer and restart */
	    yyChBufferIndex = yyChBufferIndexReg = yyChBufferStart;
	    yyFileOffset += yyBytesRead;
	    yyBytesRead = GetLine (yySourceFile,
				(char *) yyChBufferIndex, (int) yyChBufferFree);
	    if (yyBytesRead <= 0) { yyBytesRead = 0; yyEof = rtrue; }
	    yyChBufferStart [yyBytesRead    ] = yyEobCh;
	    yyChBufferStart [yyBytesRead + 1] = '\0';
	    goto yyContinue;
	 }

	 if (TokenLength == 0) {		/* end of file reached */
	    yySetPosition
	    CloseFile ();
	    if (yyFileStackPtr == yyFileStack) {
	    }
	    if (yyFileStackPtr == yyFileStack) return EofToken;
	    goto yyBegin;
	 }
	 break;

      default:
	 yyErrorMessage (0);
      }
   }
}

static void yyInitialize ARGS ((void))
   {
      if (yyFileStackPtr >= yyFileStack + yyFileStackSize - 1) {
	 unsigned long yyyFileStackPtr = yyFileStackPtr - yyFileStack;
	 ExtendArray ((char * *) & yyFileStack, & yyFileStackSize,
			   (unsigned long) sizeof (yytFileStack));
	 if (yyFileStack == NULL) yyErrorMessage (1);
	 yyFileStackPtr = yyFileStack + yyyFileStackPtr;
      }
      yyFileStackPtr ++;			/* push file */
      yyFileStackPtr->yySourceFile	= yySourceFile		;
      yyFileStackPtr->yyEof		= yyEof			;
      yyFileStackPtr->yyChBufferPtr	= yyChBufferPtr		;
      yyFileStackPtr->yyChBufferStart	= yyChBufferStart	;
      yyFileStackPtr->yyChBufferSize	= yyChBufferSize	;
      yyFileStackPtr->yyChBufferIndex	= yyChBufferIndex	;
      yyFileStackPtr->yyBytesRead	= yyBytesRead		;
      yyFileStackPtr->yyFileOffset	= yyFileOffset		;
      yyFileStackPtr->yyLineCount	= yyLineCount		;
      yyFileStackPtr->yyLineStart	= yyLineStart		;
						/* initialize file state */
      yyChBufferSize	   = yyInitBufferSize;
      MakeArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
			(unsigned long) sizeof (char));
      if (yyChBufferPtr == NULL) yyErrorMessage (1);
      yyChBufferStart	   = & yyChBufferPtr [yyMaxAlign];
      yyChBufferStart2	   = (char *) yyChBufferStart;
      yyChBufferStart [-1] = yyEolCh;		/* begin of line indicator */
      yyChBufferStart [ 0] = yyEobCh;		/* end of buffer sentinel */
      yyChBufferStart [ 1] = '\0';
      yyChBufferIndex	   = yyChBufferStart;
      TokenPtr	   = (char *) yyChBufferStart;
      yyEof		   = rfalse;
      yyBytesRead	   = 0;
      yyFileOffset	   = 0;
      yyLineCount	   = 1;
      yyLineStart	   = & yyChBufferStart [-1];
   }

void BeginFile
#if defined __STDC__ | defined __cplusplus
   (char * yyFileName)
#else
   (yyFileName) char * yyFileName;
#endif
   {
      if (! yyBufferIsUsed) {
	 ReleaseArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
			   (unsigned long) sizeof (char));
	 yyFileStackPtr --;		
	 yyBufferIsUsed = rtrue;
      }
      yyInitialize ();
      yySourceFile = yyFileName == NULL ? StdIn : BeginSource (yyFileName);
      if (yySourceFile < 0) yyErrorMessage (3);
   }

void CloseFile ARGS ((void))
   {
      if (yyFileStackPtr == yyFileStack) yyErrorMessage (2);
      CloseSource (yySourceFile);
      ReleaseArray ((char * *) & yyChBufferPtr, & yyChBufferSize,
			(unsigned long) sizeof (char));
						/* pop file */
      yySourceFile	= yyFileStackPtr->yySourceFile		;
      yyEof		= yyFileStackPtr->yyEof			;
      yyChBufferPtr	= yyFileStackPtr->yyChBufferPtr		;
      yyChBufferStart	= yyFileStackPtr->yyChBufferStart	;
      yyChBufferStart2	= (char *) yyChBufferStart		;
      yyChBufferSize	= yyFileStackPtr->yyChBufferSize	;
      yyChBufferIndex	= yyFileStackPtr->yyChBufferIndex	;
      yyBytesRead	= yyFileStackPtr->yyBytesRead		;
      yyFileOffset	= yyFileStackPtr->yyFileOffset		;
      yyLineCount	= yyFileStackPtr->yyLineCount		;
      yyLineStart	= yyFileStackPtr->yyLineStart		;
      yyFileStackPtr --;		
   }

#ifdef xxGetWord
int GetWord
#if defined __STDC__ | defined __cplusplus
   (char * yyWord)
#else
   (yyWord) char * yyWord;
#endif
   {
      register char * yySource		= TokenPtr;
      register char * yyTarget			= yyWord;
      register char * yyChBufferIndexReg	= (char *) yyChBufferIndex;

      while (yySource < yyChBufferIndexReg)
	 * yyTarget ++ = * yySource ++;
      * yyTarget = '\0';
      return (int) (yyChBufferIndexReg - TokenPtr);
   }
#endif

#ifdef xxGetLower
int GetLower
#if defined __STDC__ | defined __cplusplus
   (char * yyWord)
#else
   (yyWord) char * yyWord;
#endif
   {
      register unsigned char * yySource	= (unsigned char *) TokenPtr;
      register unsigned char * yyTarget		= (unsigned char *) yyWord;
      register unsigned char * yyChBufferIndexReg = yyChBufferIndex;

      while (yySource < yyChBufferIndexReg)
	 * yyTarget ++ = yyToLower [* yySource ++];
      * yyTarget = '\0';
      return (int) (yyChBufferIndexReg - (unsigned char *) TokenPtr);
   }
#endif

#ifdef xxGetUpper
int GetUpper
#if defined __STDC__ | defined __cplusplus
   (char * yyWord)
#else
   (yyWord) char * yyWord;
#endif
   {
      register unsigned char * yySource	= (unsigned char *) TokenPtr;
      register unsigned char * yyTarget		= (unsigned char *) yyWord;
      register unsigned char * yyChBufferIndexReg = yyChBufferIndex;

      while (yySource < yyChBufferIndexReg)
	 * yyTarget ++ = yyToUpper [* yySource ++];
      * yyTarget = '\0';
      return (int) (yyChBufferIndexReg - (unsigned char *) TokenPtr);
   }
#endif

#ifdef xxinput
static char input ARGS ((void))
   {
      if (yyChBufferIndex == & yyChBufferStart [yyBytesRead]) {
	 if (! yyEof) {
	    yyLineStart -= yyBytesRead;
	    yyChBufferIndex = yyChBufferStart = yyChBufferPtr;
	    yyChBufferStart2 = (char *) yyChBufferStart;
	    yyFileOffset += yyBytesRead;
	    yyBytesRead = GetLine (yySourceFile, (char *) yyChBufferIndex,
	       (int) Exp2 (Log2 (yyChBufferSize)));
	    if (yyBytesRead <= 0) { yyBytesRead = 0; yyEof = rtrue; }
	    yyChBufferStart [yyBytesRead    ] = yyEobCh;
	    yyChBufferStart [yyBytesRead + 1] = '\0';
	 }
      }
      if (yyChBufferIndex == & yyChBufferStart [yyBytesRead]) return '\0';
      else return * yyChBufferIndex ++;
   }
#endif

static void unput
#if defined __STDC__ | defined __cplusplus
   (char yyc)
#else
   (yyc) char yyc;
#endif
   { * (-- yyChBufferIndex) = yyc; }

static void yyLess
#if defined __STDC__ | defined __cplusplus
   (int yyn)
#else
   (yyn) int yyn;
#endif
   { yyChBufferIndex -= TokenLength - yyn; TokenLength = yyn; }

void BeginScanner ARGS ((void))
   {
   }

void CloseScanner ARGS ((void))
   {
   }

static void yyErrorMessage
#if defined __STDC__ | defined __cplusplus
   (int yyErrorCode)
#else
   (yyErrorCode) int yyErrorCode;
#endif
   {
      WritePosition (stderr, Attribute.Position);
      switch (yyErrorCode) {
      case 0: (void) fprintf (stderr, ": Scanner: internal error\n"); break;
      case 1: (void) fprintf (stderr, ": Scanner: out of memory\n"); break;
      case 2: (void) fprintf (stderr,
      ": Scanner: file stack underflow (too many calls of CloseFile)\n");
	      break;
      case 3: (void) fprintf (stderr,
	      ": Scanner: cannot open input file\n"); break;
      case 4: (void) fprintf (stderr,
      ": Scanner: start stack underflow (too many calls of yyPop)\n"); break;
      }
      Scanner_Exit ();
   }

