/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//FILE: ScheduleGUI.h - makes the variables and functions in ScheduleGUI.cpp available to other files
//NOTE: this file requires GTK and various other headers to be declared first



#ifndef SCHEDULEGUI_H
#define SCHEDULEGUI_H


#define SCHEDULEGUI_SQUARESIZE 6
#define SCHEDULEGUI_GRAPHBOUNDARY 16
#define SCHEDULEGUI_GRIDY_MINSTEP  12
#define SCHEDULEGUI_GRIDY_MAXSTEP 32
#define SCHEDULEGUI_GRIDY_UNIT        1
#define SCHEDULEGUI_GRIDX_MINSTEP  32
#define SCHEDULEGUI_GRIDX_MAXSTEP 64
#define SCHEDULEGUI_GRIDX_UNIT        60
#define SCHEDULEGUI_FONTSIZE  6
//#define SCHEDULEGUI_XTEXTOFFSET (SCHEDULEGUI_FONTSIZE+2)
#define SCHEDULEGUI_XTEXTOFFSET 8
#define SCHEDULEGUI_SELECTED  1
#define SCHEDULEGUI_UNSELECTED  0


//DO NOT assume memory layout of DataPoint:
 extern struct DataPoint {
 double x;
 double y;
 double duration;
 double hz;
	int state; //masks: SCHEDULEGUI_SELECTED
 DataPoint *NextDataPoint;
 DataPoint *PrevDataPoint;	//this is needed only to contain x-axis of mouse movement
} * ScheduleGUI_FirstDataPoint, * ScheduleGUI_CurrentDataPoint, * ScheduleGUI_FirstBackupDataPoint;

 extern struct SelectionBox {
	int status; //live=1, dead=0
	int startX;
	int startY;
	int endX;
	int endY;
} ScheduleGUI_SelectionBox;
	
 extern struct CopyPaste {
	int count;
 int OrigWidth;
 int OrigHeight;
 double OrigScheduleGUI_TotalScheduleDuration;
 double OrigScheduleGUI_MaxScheduleBeatfrequency;
	DataPoint * data;
} ScheduleGUI_CopyPaste;

 extern  void ScheduleGUI_Cleanup();
 extern gboolean ScheduleGUI_delete_event(GtkWidget* window, GdkEvent* e, gpointer data);
 extern gboolean ScheduleGUI_button_release_event( GtkWidget  *widget, GdkEventButton *event);
 extern gboolean ScheduleGUI_button_press_event( GtkWidget *widget, GdkEventButton *event);
 extern gboolean ScheduleGUI_expose_event( GtkWidget *widget, GdkEventExpose *event);
 extern gboolean ScheduleGUI_configure_event( GtkWidget  *widget, GdkEventConfigure *event);
 extern gboolean ScheduleGUI_configure_event( GtkWidget  *widget, GdkEventConfigure *event);
 extern gboolean ScheduleGUI_motion_notify_event( GtkWidget *widget, GdkEventMotion *event);
 extern void ScheduleGUI_SetupDataPoints();
 extern void ScheduleGUI_DeselectDataPoints();
 extern void ScheduleGUI_SelectAllDataPoints();
 extern void ScheduleGUI_SelectIntervalAllDataPoints(int interval, gboolean deselectothers);
 extern void ScheduleGUI_InvertSelectionAllDataPoints();
 extern void ScheduleGUI_SelectDataPoints(int startX,int startY,int endX,int endY, gboolean deselect=FALSE);
 extern void ScheduleGUI_DrawGraph( GtkWidget *widget);
 extern void ScheduleGUI_CleanupDataPoints(DataPoint * firstDataPoint);
 extern void ScheduleGUI_ConvertDurHzToXY(GtkWidget *widget);//this recalibrates scale, finds totalscheduleduration, etc.
 extern DataPoint * ScheduleGUI_FindPreviousDataPoint(DataPoint * userDataPoint);
 extern void ScheduleGUI_GetScheduleLimits();//returns highest hz datapoint
 extern DataPoint * ScheduleGUI_AddNewDataPointToEnd(double  duration, double hz);
 extern DataPoint * ScheduleGUI_NewDataPoint(GtkWidget *widget, double  x, double  y); //this creates a point and puts it in the right llist order according to x
 extern void ScheduleGUI_ConvertXYToDurHZ(GtkWidget *widget,  DataPoint * currentDataPoint);
	extern void ScheduleGUI_ConvertXToDuration_AllPoints(GtkWidget *widget);
 extern	void ScheduleGUI_ConvertYToHz_AllPoints(GtkWidget *widget); 
 extern void	ScheduleGUI_MoveDataPoint(GtkWidget *widget, DataPoint * curDP, double newx, double newy);
 extern void ScheduleGUI_MoveSelectedDataPoints(GtkWidget * widget, double moveX, double moveY);
 extern gboolean ScheduleGUI_SwapLinks(DataPoint * curDP);//swaps datapoint with its left neighbor
 extern gboolean ScheduleGUI_SwapLinks(DataPoint * curDP1, DataPoint * curDP2); //swaps any two existing links
 extern void ScheduleGUI_DeleteSelectedPoints(GtkWidget *widget, gboolean deletettime);
 extern void ScheduleGUI_DeleteDataPoint(DataPoint * curDP);
 extern void ScheduleGUI_BackupDataPoints();
 extern void ScheduleGUI_RestoreDataPoints(GtkWidget * widget);
 extern void ScheduleGUI_CopySelectedDataPoints(GtkWidget * widget);
 extern void ScheduleGUI_PasteSelectedDataPoints(GtkWidget * widget, gboolean predeselect = TRUE);
 extern void ScheduleGUI_DeleteDuplicateDataPoints(GtkWidget * widget, double threshold);
 extern void ScheduleGUI_SelectNeighboringDataPoints(gboolean next, gboolean deselect);
 extern gboolean ScheduleGUI_key_press_event( GtkWidget * widget, GdkEventKey * event );


 extern double ScheduleGUI_TotalScheduleDuration;
 extern double ScheduleGUI_MaxScheduleBeatfrequency;
 extern gboolean ScheduleGUI_ProgressIndicatorFlag; //to disallow progress indication if graph has been modified (out of sync with BB)


//main drawing area:
 extern  GdkPixmap *ScheduleGUI_pixmap;
 extern GdkGC *ScheduleGUI_gc;
 extern PangoLayout * ScheduleGUI_layout;

#endif
