/******************************************************************************\
 gnofin/ui-record-editor.h   $Revision: 1.4 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef UI_RECORD_EDIT_H
#define UI_RECORD_EDIT_H

#include "ui-types.h"
#include "data-types.h"
#include <gtk/gtktable.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkcombo.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkcalendar.h>

GNOFIN_API_BEGIN

#define UI_RECORD_EDITOR(obj)		  (GTK_CHECK_CAST ((obj), ui_record_editor_get_type (), UI_RecordEditor))
#define UI_RECORD_EDITOR_CLASS(klass)	  (GTK_CHECK_CLASS_CAST ((klass), ui_record_editor_get_type (), UI_RecordEditorClass))
#define UI_IS_RECORD_EDITOR(obj)	  (GTK_CHECK_TYPE ((obj), ui_record_editor_get_type ())
#define UI_IS_RECORD_EDITOR_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), ui_record_editor_get_type ())

typedef struct
{
  GtkTableClass parent_class;

  void (* insert_record) (UI_RecordEditor *, const RecordInfo *);
  void (* update_record) (UI_RecordEditor *, const RecordInfo *);

} UI_RecordEditorClass;

GtkType    ui_record_editor_get_type                (void);
GtkWidget *ui_record_editor_new                     (void);

void       ui_record_editor_set_bankbook            (UI_RecordEditor *, Bankbook *);
void       ui_record_editor_set_record              (UI_RecordEditor *, Account *, Record *);

void       ui_record_editor_refresh_type_list       (UI_RecordEditor *);
void       ui_record_editor_refresh_category_list   (UI_RecordEditor *);
void       ui_record_editor_refresh_payee_list      (UI_RecordEditor *);
void       ui_record_editor_refresh_memo_list       (UI_RecordEditor *);
void       ui_record_editor_refresh_linked_acc_list (UI_RecordEditor *);

GNOFIN_API_END

#endif
