%define name gnokii
%define version 0.6.13
%define release 1

Summary: multisystem tool suite for the mobile phones
Name: %{name}
Version: %{version}
Release: %{release}
License: GNU GPL
Packager: Pavel Janik ml. <Pavel.Janik@linux.cz>, Jan Derfinak <ja@mail.upjs.sk>, Pawel Kot
Group: Applications/Communications
Source: htp://www.gnokii.org/download/gnokii/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
BuildRequires: gettext, gtk+-devel >= 1.2.0, flex, bluez-libs-devel
BuildRequires: mysql-devel, postgresql-devel, XFree86-devel
Requires: libgnokii = %{version}-%{release}

%description
Gnokii is a multisystem tool suite and (eventually) modem/fax driver for
the mobile phones, released under the GPL.

%package -n libgnokii
Summary: A gnokii shared library
Group: Libraries

%description -n libgnokii
Gnokii shared library

%package -n libgnokii-devel
Summary: libgnokii heades files
Group: Development/Libraries
Requires: libgnokii = %{version}-%{release}
Requires: XFree86-devel
Requires: bluez-libs-devel

%description -n libgnokii-devel
libgnokii header files.

%package -n xgnokii
Summary: Graphical gtk+ based tool suite for the mobile phones.
Group: X11/Applications

%description -n xgnokii
Xgnokii is a graphical gtk+ based tool suite for the mobile phones. It
allows you to edit your contacts book, send/read SMS's from/in your
computer and more.

%package -n gnokii-smsd
Summary:	Daemon for handling incoming and outgoing SMSes using libgnokii
Group:		Daemons
Requires:	gnokii = %{version}-%{release}

%description -n gnokii-smsd
The SMSD (SMS daemon) program is intended for receiving and sending
SMSes with plain file plugin

%package -n gnokii-smsd-mysql
Summary:	mysql plugin for gnokii-smsd
Group:		Daemons
Requires:	gnokii-smsd = %{version}-%{release}
Requires:	mysql-devel

%description -n gnokii-smsd-mysql
MySQL plugin for gnokii-smsd

%package -n gnokii-smsd-psql
Summary:	psql plugin for gnokii-smsd
Group:		Daemons
Requires:	gnokii-smsd = %{version}-%{release}
Requires:	postgresql-devel

%description -n gnokii-smsd-psql
PostgreSQL plugin for gnokii-smsd

%prep
%setup

%{__cat} <<EOF >gnokii.desktop
[Desktop Entry]
Name=Gnokii Mobile Manager
Comment=Access your mobile phone data
Icon=gnokii.png
Exec=xgnokii
Terminal=false
Type=Application
Categories=Application;Utility;
EOF

%build
%configure --prefix=/usr --with-xgnokiidir=/usr/X11R6 --enable-security
%{__make}

cd smsd
%{__make}
%{__make} libpq.la
%{__make} libmysql.la
%{__make} libfile.la
cd ..

%install
rm -rf ${RPM_BUILD_ROOT}

%{__make} DESTDIR=${RPM_BUILD_ROOT} install

cd smsd 
%{__make} DESTDIR=$RPM_BUILD_ROOT install
cd ..

mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}
sed 's#/usr/local/sbin/#%{_sbindir}#' <Docs/sample/gnokiirc >${RPM_BUILD_ROOT}%{_sysconfdir}/gnokiirc

install gnokii.desktop $RPM_BUILD_ROOT%{_desktopdir}

%pre
/usr/sbin/groupadd -r -f gnokii >/dev/null 2>&1

%post -n libgnokii
/sbin/ldconfig

%postun -n libgnokii
/sbin/ldconfig

%postun
/usr/sbin/groupdel gnokii >/dev/null 2>&1

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(644,root,root,755)
%doc Docs/{CREDITS,DataCalls-QuickStart,README*,Bugs,FAQ,*.txt,protocol,KNOWN_BUGS}
%doc Docs/{sample/{gnokiirc,ppp*,ringtone,vCalendar,vCard},gnokii-{ir-howto,IrDA-Linux}}
%doc TODO ChangeLog MAINTAINERS
%{_bindir}/gnokii
%{_bindir}/todologo
%{_bindir}/sendsms
%{_bindir}/ppm2nokia
%{_sbindir}/gnokiid
%config(noreplace) %verify(not size mtime md5) %{_sysconfdir}/gnokiirc
%{_mandir}/man1/[!x]*
%{_mandir}/man8/gnokiid.*
%{_mandir}/man8/mgnokiidev.*

%defattr(4750,root,gnokii,0750)
%{_sbindir}/mgnokiidev

%files -n xgnokii
%defattr(644,root,root,755)
%attr(755,root,root) %{_bindir}/xgnokii
%dir %{_datadir}/xgnokii
%{_libdir}/xgnokii
%{_datadir}/xgnokii/xpm
%{_datadir}/xgnokii/help
%{_desktopdir}/gnokii.desktop
%{_mandir}/man1/xgnokii.1x*

%files -n libgnokii
%defattr(644,root,root,755)
%attr(755,root,root) %{_libdir}/libgnokii.so.*.*

%files -n libgnokii-devel
%defattr(644,root,root,755)
%attr(755,root,root) %{_libdir}/libgnokii.so
%{_libdir}/libgnokii.la
%{_libdir}/libgnokii.a
%{_includedir}/*.h
%{_includedir}/gnokii
%{_pkgconfigdir}/*.pc

%files -n gnokii-smsd
%defattr(644,root,root,755)
%doc smsd/ChangeLog smsd/README smsd/README.MySQL smsd/README.Tru64 smsd/action smsd/*.sql
%{_sbindir}/smsd
%{_libdir}/smsd/libfile.la
%{_mandir}/man8/smsd.*

%files -n gnokii-smsd-mysql
%defattr(644,root,root,755)
%{_libdir}/smsd/libmysql.la

%files -n gnokii-smsd-psql
%defattr(644,root,root,755)
%{_libdir}/smsd/libpq.la

%changelog

* Mon Feb  6 2006 Pawel Kot
- merge gnokii-smsd and gnokii-smsd-file

* Thu Apr 30 2005 Pawel Kot
- split the package for gnokii, libgnokii, libgnokii-devel, xgnokii,
smsd, smsd-mysql, smsd-psql, smsd-file
- update requirements
- new url for the sources
Changes based on Dag Wieers and PLD spec files

* Thu Apr 28 2005 Pawel Kot
- minor updates: new Docs files, move todologo to the gnokii package

* Mon Feb 23 2004 BORBELY Zoltan <bozo@andrews.hu>
- require flex at build time (suggested by Olivier Kaloudoff)

* Fri Jan 30 2004 Pawel Kot <pkot@linuxnews.pl>
- gnokii is for mobile phones not only for Nokia mobile phones and also
  works with non unix systems

* Tue Jan 20 2004 Pawel Kot <pkot@linuxnews.pl>
- install *.a and *.la into -devel package

* Wed Apr  2 2003 Tom G. Christensen <tom.christensen@get2net.dk>
- add a -devel package
- add manpages to package 
- use proper %{_*dir} macros when referring to paths
- use make DESTDIR for install
- made sure that no files are left unpackaged

* Sat Jan  4 2003 Pawel Kot <pkot@linuxnews.pl>
- reflect changes in the file layout

* Thu Aug 15 2002 Pawel Kot <pkot@linuxnews.pl>
- misc path problems fixed

* Fri Apr 12 2002 Pawel Kot <pkot@linuxnews.pl>
- replace 'Copyright' with 'License' (submitted by Rui Miguel Silva Seabra)

* Fri Sep 28 2001 Pawel Kot <pkot@linuxnews.pl>
- last minute fixes

* Thu Sep 27 2001 Pawel Kot <pkot@linuxnews.pl>
- updates to 0.3.3 version - new docs, new ftp server

* Sun Sep  2 2001 Pawel Kot <pkot@linuxnews.pl>
- removes xlogos

* Thu Jan 11 2001 Pawel Kot <pkot@linuxnews.pl>
- misc updates

* Fri Oct 27 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- todologo added to the package

* Mon May 15 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- proper access rights for gnokiid, gnokii and mgnokiidev

* Sat May 13 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- new doc files added

* Tue Mar 21 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- permission on /usr/sbin fixed
- correct /etc/gnokiirc file

* Mon Mar 20 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- mkdir of directories in install removed
- xgnokii package should contain lib/xgnokii directory

* Mon Mar 20 2000 Jan Derfinak <ja@mail.upjs.sk>
- split package into gnokii and xgnokii
- added configure
- correct xgnokii installation
- installation with make install
- fixing paths

* Thu Aug  5 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- documentation files changed

* Thu Aug  5 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- xkeyb and xlogos added to RPM package

* Sat Jul 24 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- stripping of binaries

* Thu Jul 22 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- gnokii.nol added - nice example for logo uploading

* Sun Jul 18 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- mgnokiidev added to RPM package
- config file in /etc (it is not used now...)

* Sat Jul 10 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- use of ~/.gnokiirc so not magic model stuff
- new doc files

* Mon Jun 28 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- Nokia auth. protocol is there now
- xgnokii and gnokiid added to RPM

* Sun May  9 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- included 6110-patch updated to my prepatches

* Thu May  6 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- TODO-6110 file added to documentation files

* Sun Mar 28 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- upgraded to gnokii-0.2.4
- 6110 version of gnokii added

* Fri Mar  5 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- the first SPEC file for gnokii
