/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4:ts=4:
 *
 * Gnome Apt downloader class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2002, 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_ACQUIRESTATUS_H
#define GNOME_APT_ACQUIRESTATUS_H

#include <apt-pkg/acquire.h>
#include <gtk/gtkwidget.h>

class GAcqStatus : public pkgAcquireStatus
{
public:

  virtual bool MediaChange(string Media,string Drive);
  virtual void IMSHit(pkgAcquire::ItemDesc &Itm);
  virtual void Fetch(pkgAcquire::ItemDesc &Itm);
  virtual void Done(pkgAcquire::ItemDesc &Itm);
  virtual void Fail(pkgAcquire::ItemDesc &Itm);
  virtual void Start();
  virtual void Stop();
  
  virtual bool Pulse(pkgAcquire *Owner);

  GAcqStatus();
  virtual ~GAcqStatus() { if (dialog_) gtk_widget_destroy(dialog_); }

private:
  unsigned long ID;

  bool cancelled_;
  
  GtkWidget* dialog_;
  GtkWidget* itembar_;
  GtkWidget* overallbar_;
  GtkWidget* label_;
  GtkWidget* etalabel_;
  GtkWidget* errors_;

  static gboolean close_cb(GtkWidget* dialog, gpointer data);
	static gboolean response_cb (GtkWidget*, gint, gpointer);
};


#endif

