/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt package tree pane
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2002-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

using namespace std;

#include <map>

#include "drawtree.h"
#include "filterbar.h"
// FIXME for icky signal propagation code so Details does not need to now about ConfFile
#include "gaptdrawingarea.h"
#include "menus.h"
#include "pkglist.h"
#include "pkgtree.h"
#include "preferences.h"

static gulong sighide;

static void
selection_changed_cb (GtkWidget* wdg, GAptPkgList* pkglist) {
	pkgCache::Package* pkg = 0;
	if (pkglist->getView()->selected_node()) {
		pkg = pkglist->getView()->selected_node()->package();
	}

	pkglist->set_selection (pkg);
	gnome_apt_menus_selection_changed (pkglist->getView());
}

static void
detail_hidden (GtkWindow*, gpointer data) {
	guint sig = g_signal_lookup ("details-hidden", GAPT_DRAWING_AREA_TYPE);
	g_signal_emit (G_OBJECT (data), sig, 0);
}

static void
detail_shown (GtkWindow*, gpointer data) {
	guint sig = g_signal_lookup ("details-shown", GAPT_DRAWING_AREA_TYPE);
	g_signal_emit (G_OBJECT (data), sig, 0);
}

GAptPkgList::GAptPkgList (DrawTree* view, GnomeAppBar* bar, gboolean showdetails) :
      pl_treeview (view), selection_ (0) {
	pl_wdg = gtk_hbox_new (FALSE, GAPT_PAD);
	gtk_container_set_border_width (GTK_CONTAINER (pl_wdg), GAPT_PAD);

	GtkWidget* tbl = gtk_table_new (2, 3, FALSE);
	gtk_box_pack_start (GTK_BOX (pl_wdg), tbl, TRUE, TRUE, 0);

	GtkWidget* hbox = gtk_hbox_new (FALSE, 0);
	gtk_table_attach (GTK_TABLE (tbl), hbox, 0, 2, 1, 2,
	      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK),
	      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK), 0, 0);

	GtkWidget* trf = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (trf), GTK_SHADOW_IN);
	gtk_box_pack_start (GTK_BOX (hbox), trf, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (trf), pl_treeview->widget());

	/* Filter Bar */

	Filter* pkgfilter = new Filter();
	pl_treeview->getModel()->set_filter (pkgfilter);
	filterbar_ = new GAptFilterBar (pkgfilter);

	gtk_table_attach (GTK_TABLE (tbl), filterbar_->widget(), 0, 2, 0, 1,
	      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK),
	      (GtkAttachOptions) GTK_FILL, 0, 0);

  // Scroll bars

  GtkWidget* w;

#if 0  
	w = gtk_hscrollbar_new (NULL);
	gtk_table_attach (GTK_TABLE (tbl), w, 0, 1, 2, 3,
	      (GtkAttachOptions) GTK_FILL, (GtkAttachOptions) GTK_FILL, 0, 0);

	pl_treeview->set_hadjustment (GTK_RANGE (w)->adjustment);
#endif

  GtkAdjustment* vadj = GTK_ADJUSTMENT(gtk_adjustment_new(0.0, 0.0, 0.0, 
                                                          0.0, 0.0, 0.0));
  
  w = gtk_vscrollbar_new (vadj);
#if 0
	gtk_table_attach (GTK_TABLE (tbl), w, 1, 2, 1, 2, (GtkAttachOptions) 0,
	      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL | GTK_SHRINK), 0, 0);
#endif
	gtk_box_pack_end (GTK_BOX (hbox), w, FALSE, FALSE, 0);
	pl_treeview->set_vadjustment (GTK_RANGE (w)->adjustment);

  ////////////////////// Setup other stuff

	gnome_apt_cache_file()->add_view (pl_treeview->getModel());
	pl_cachectrl = GAPT_CACHE_CONTROL (gapt_cache_control_new (gnome_apt_cache_file()));

	gnome_apt_cache_file()->add_view (&details_);
	details (showdetails);

	sighide =
	g_signal_connect (G_OBJECT (details_.window_), "hide", G_CALLBACK (detail_hidden), view->widget());
	g_signal_connect (G_OBJECT (details_.window_), "show", G_CALLBACK (detail_shown), view->widget());

  gnome_apt_preferences()->set_pkglist(this);

	g_signal_connect (G_OBJECT (pl_treeview->widget()),
		"selection-changed", G_CALLBACK (selection_changed_cb), this);

	gtk_widget_show_all (pl_wdg);
}

GAptPkgList::~GAptPkgList (void) {
	/* Avoid nuking the right info_hidden setting */
	g_signal_handler_disconnect (G_OBJECT (details_.window_), sighide);
	delete filterbar_;
}

void
GAptPkgList::set_selection (pkgCache::Package* pkg) {
	selection_ = pkg;
	details_.set_selection (pkg);
}

static void no_selection()
{
	GtkWidget* dialog = gtk_message_dialog_new (
		NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR,
		GTK_BUTTONS_OK, _("No package selected."));
  gnome_apt_setup_dialog(dialog);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}

/* FIXME: remove? */
void
GAptPkgList::install (void) {
	if (!selection_) {
		no_selection();
	} else {
		if (gapt_cache_control_install_package (pl_cachectrl, selection_)) {
			pl_treeview->queue_recalc_rows (true);
			pl_treeview->getModel()->update_status();
		}
	}
}

void
GAptPkgList::remove (void) {
	if (!selection_) {
		no_selection();
	} else {
		gapt_cache_control_remove_package (pl_cachectrl, selection_);
		pl_treeview->queue_recalc_rows (true);
		pl_treeview->getModel()->update_status();
	}
}

void
GAptPkgList::keep (void) {
	if (!selection_) {
		no_selection();
	} else {
		pkgCache::PkgIterator i(*(pl_treeview->getModel()->cache()), selection_);
		pl_treeview->getModel()->cache()->MarkKeep (i);
		pl_treeview->queue_recalc_rows (true);
		pl_treeview->getModel()->update_status();
	}
}

void
GAptPkgList::details (bool show) {
	if (show) {
		details_.show();
	} else {
		details_.hide();
	}
}
