/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt package installation handler
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2002-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

using namespace std;

#include <iostream>
#include <cstdio>
#include <unistd.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#ifndef HAS_I18N
#define HAS_I18N
#endif
#include <vte/vte.h>

#include "childprocess.h"
/* From gnome-apt.h */
void gnome_apt_setup_dialog (GtkWidget*);

gint
ChildDialog::child_died (gint pid, gint ret) {
	GList* gl;

	if (pid != this->pid) {
		return -1;
	}
	res = ret;

	gl = gtk_container_get_children (GTK_CONTAINER (GTK_DIALOG (dialog_)->action_area));
	while (gl) {
		if (GTK_IS_BUTTON (gl->data)) {
			gtk_widget_set_sensitive (GTK_WIDGET (gl->data), TRUE);
		}
		gl = gl->next;
	}

	child_done_ = true;
	g_list_free (gl);
	return ret;
}

gint 
ChildDialog::close_cb(GtkWidget* w, gpointer data)
{
  ChildDialog* cd = static_cast<ChildDialog*>(data);
  
  return cd->close();
}

gint
ChildDialog::close (void) {
	if (child_done_) {
		return FALSE;
	}
	/* Block the close */
	return TRUE;
}

ChildDialog::ChildDialog (const gchar* title, const gchar* label)
  : we_are_parent_(false), child_done_(false), pid (0), res (0) {
	GList* gl;

	dialog_ = gtk_dialog_new_with_buttons (
		title, NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);
	gnome_apt_setup_dialog (dialog_);
	g_signal_connect (G_OBJECT (dialog_), "close", G_CALLBACK (close_cb), this);
	gl = gtk_container_get_children (GTK_CONTAINER (GTK_DIALOG (dialog_)->action_area));
	while (gl) {
		if (GTK_IS_BUTTON (gl->data)) {
			gtk_widget_set_sensitive (GTK_WIDGET (gl->data), FALSE);
		}
		gl = gl->next;
	}

	label_ = gtk_label_new (label);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_)->vbox),
		label_, FALSE, FALSE, 0);

	term_ = vte_terminal_new();
	vte_terminal_set_scrollback_lines (VTE_TERMINAL (term_), 10000);
	vte_terminal_set_scroll_on_keystroke (VTE_TERMINAL (term_), TRUE);
	vte_terminal_set_scroll_on_output (VTE_TERMINAL (term_), TRUE);
	vte_terminal_set_font_from_string (VTE_TERMINAL (term_), "monospace 9");

  gtk_widget_queue_draw (GTK_WIDGET (term_));

	GtkWidget* scrollbar = gtk_vscrollbar_new (GTK_ADJUSTMENT (VTE_TERMINAL (term_)->adjustment));
  GTK_WIDGET_UNSET_FLAGS (scrollbar, GTK_CAN_FOCUS);

  GtkWidget* hbox = gtk_hbox_new(FALSE,0);

  gtk_box_pack_start(GTK_BOX(hbox), term_, 
                     TRUE, TRUE, 0);
  gtk_box_pack_end(GTK_BOX(hbox), scrollbar,
                   FALSE, FALSE, 0);

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_)->vbox),
		hbox, TRUE, TRUE, 0);

  gtk_widget_realize(term_);
  gtk_widget_realize(dialog_);

  gtk_widget_show_all(dialog_);

  while (gtk_events_pending())
    gtk_main_iteration();

  gtk_widget_show_now(dialog_);

  while (gtk_events_pending())
    gtk_main_iteration();
}

ChildDialog::~ChildDialog (void) {
	if (we_are_parent_) {
		if (dialog_) {
			gtk_widget_destroy (dialog_);
		}
		dialog_ = NULL;
	}
}

int
ChildDialog::fork (void) {
	/* The Terminal *must* get a size_allocate before the child starts
	   sending output, or it will insert line breaks in the wrong place. */
	//gtk_widget_show_now (dialog_);

  // make sure we are all synced up here. weirdo paranoia.
  cout << flush;
  cerr << flush;
  fflush(stdout);
  fflush(stderr);

	int retval = vte_terminal_forkpty (VTE_TERMINAL (term_), NULL, "/", FALSE, FALSE, FALSE);
	if (retval == -1) {
		perror ("Error: unable to fork");
	} else if (retval == 0) {
      we_are_parent_ = false;
      // touching the GUI == flaming death in the child
      dialog_ = 0;
      term_ = 0;
      label_ = 0;
      // Close all file descriptors but first 3 - total paranoia kludge
      int open_max = sysconf (_SC_OPEN_MAX);
      for (int i = 3; i < open_max; i++){
        ::close (i);
      }
	} else {
		pid = retval;
		we_are_parent_ = true;
	}

  return retval;
}

gint
ChildDialog::run (void) {
	g_return_val_if_fail (we_are_parent_, FALSE);

	while (!child_done_) {
		gtk_dialog_run (GTK_DIALOG (dialog_));
	}

	return res;
}

void
ChildDialog::feed (const gchar* str) {
	vte_terminal_feed (VTE_TERMINAL (term_), str, strlen (str));
}
