/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/* gdm-pool.h
 *
 * Copyright (C) 2007 David Zeuthen
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#if !defined(GDM_POOL_H)
#define GDM_POOL_H

#include <gnome-device-manager/gdm-device.h>

#define GDM_TYPE_POOL             (gdm_pool_get_type ())
#define GDM_POOL(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDM_TYPE_POOL, GdmPool))
#define GDM_POOL_CLASS(obj)       (G_TYPE_CHECK_CLASS_CAST ((obj), GDM_POOL,  GdmPoolClass))
#define GDM_IS_POOL(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDM_TYPE_POOL))
#define GDM_IS_POOL_CLASS(obj)    (G_TYPE_CHECK_CLASS_TYPE ((obj), GDM_TYPE_POOL))
#define GDM_POOL_GET_CLASS        (G_TYPE_INSTANCE_GET_CLASS ((obj), GDM_TYPE_POOL, GdmPoolClass))


typedef struct _GdmPool            GdmPool;
typedef struct _GdmPoolClass       GdmPoolClass;

struct _GdmPoolPrivate;
typedef struct _GdmPoolPrivate     GdmPoolPrivate;

struct _GdmPool
{
        GObject parent;
        
        /* private */
        GdmPoolPrivate *priv;
};

struct _GdmPoolClass
{
        GObjectClass parent_class;

        /* signals */
        void (*device_added) (GdmPool *pool, GdmDevice *device);
        void (*device_removed) (GdmPool *pool, GdmDevice *device);
        void (*device_property_changed) (GdmPool *pool, GdmDevice *device, const char *key);
};

typedef void                         (*GdmPoolVisitorFunc)        (GdmPool           *pool, 
                                                                   GdmDevice         *device, 
                                                                   GdmDevice         *parent_device, 
                                                                   gpointer           user_data);

GType                                  gdm_pool_get_type          (void);
GdmPool                               *gdm_pool_new               (void);
LibHalContext                         *gdm_pool_get_hal_ctx       (GdmPool            *pool);
GdmDevice                             *gdm_pool_get_device_by_udi (GdmPool            *pool, 
                                                                   const char         *udi);
void                                   gdm_pool_visit             (GdmPool            *pool, 
                                                                   GdmPoolVisitorFunc  func, 
                                                                   gpointer            user_data);
GdmDevice                             *gdm_pool_get_parent_device (GdmPool            *pool, 
                                                                   GdmDevice          *device);

#endif /* GDM_POOL_H */
