//  
//  Copyright (C) 2009 GNOME Do
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Mono.Unix;

using Do.Universe;
using Do.Platform;
using Do.Platform.Linux;

namespace WeatherDocklet
{
	/// <summary>
	/// A <see cref="Do.Universe.ItemSource"/> for <see cref="WeatherItem"/>s.
	/// </summary>
	public class WeatherItemSource : ItemSource, IConfigurable
	{
		#region IConfigurable implementation
		
		public override string Name
		{
			get { return Catalog.GetString ("Weather Commands"); }
		}
		
		public override string Description
		{
			get { return Catalog.GetString ("Show radar, etc."); }
		}
		
		public override string Icon
		{
			get { return WeatherController.Weather.IsNight () ? "weather-few-clouds-night" : "weather-few-clouds"; }
		}
		
		public Gtk.Bin GetConfiguration () {
			return new WeatherConfiguration ();
		}
		
		#endregion
		
		public WeatherItemSource ()
		{
			WeatherController.ResetTimer (false);
		}
		
		public override IEnumerable<Type> SupportedItemTypes
		{
			get {
				yield return typeof (WeatherItem);
			}
		}
		
		public override IEnumerable<Item> Items
		{
			get {
				yield return new WeatherItem (
					Catalog.GetString ("Radar Map"),
					Catalog.GetString ("Shows the current weather radar in a browser."),
					WeatherController.Weather.Image,
					WeatherController.Weather.ShowRadar);
				
				for (int i = 0; i < WeatherController.Weather.ForecastDays; i++)
					if (WeatherController.Weather.Forecasts [i].dow != null)
						yield return new WeatherItem (
							Catalog.GetString (WeatherForecast.DayName (WeatherController.Weather.Forecasts [i].dow) + "'s Forecast"),
							Catalog.GetString ("Shows " + WeatherController.Weather.Forecasts [i].dow + "'s forecast in a browser."),
							WeatherController.Weather.Forecasts [i].image,
							i);
				
				yield return new WeatherItem (
					Catalog.GetString ("Reload Weather Data"),
					Catalog.GetString ("Reloads the current weather data."),
					Gtk.Stock.Refresh,
					WeatherController.ResetTimer);
			}
		}
	}
}
