/* RecordingReader.c generated by valac 0.16.0, the Vala compiler
 * generated from RecordingReader.vala, do not modify */

/*
 * Copyright (C) 2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>


#define DVB_IO_TYPE_RECORDING_READER (dvb_io_recording_reader_get_type ())
#define DVB_IO_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReader))
#define DVB_IO_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))
#define DVB_IO_IS_RECORDING_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_IS_RECORDING_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_READER))
#define DVB_IO_RECORDING_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderClass))

typedef struct _DVBioRecordingReader DVBioRecordingReader;
typedef struct _DVBioRecordingReaderClass DVBioRecordingReaderClass;
typedef struct _DVBioRecordingReaderPrivate DVBioRecordingReaderPrivate;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _DVBioRecordingReader {
	GObject parent_instance;
	DVBioRecordingReaderPrivate * priv;
};

struct _DVBioRecordingReaderClass {
	GObjectClass parent_class;
};

struct _DVBioRecordingReaderPrivate {
	GFile* _directory;
	DVBRecordingsStore* _store;
	gint _max_recursion;
};


static gpointer dvb_io_recording_reader_parent_class = NULL;
static DVBLoggingLogger* dvb_io_recording_reader_log;
static DVBLoggingLogger* dvb_io_recording_reader_log = NULL;

GType dvb_io_recording_reader_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
#define DVB_IO_RECORDING_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_RECORDING_READER, DVBioRecordingReaderPrivate))
enum  {
	DVB_IO_RECORDING_READER_DUMMY_PROPERTY,
	DVB_IO_RECORDING_READER_DIRECTORY,
	DVB_IO_RECORDING_READER_STORE,
	DVB_IO_RECORDING_READER_MAX_RECURSION
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_IO_RECORDING_READER_ATTRS G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN
DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore);
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore);
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self);
GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir, gint depth);
static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
gint dvb_io_recording_reader_get_max_recursion (DVBioRecordingReader* self);
GType dvb_recording_get_type (void) G_GNUC_CONST;
DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error);
DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self);
gboolean dvb_recordings_store_add_and_monitor (DVBRecordingsStore* self, DVBRecording* rec);
DVBRecording* dvb_recording_new (void);
DVBRecording* dvb_recording_construct (GType object_type);
void dvb_recording_set_Id (DVBRecording* self, guint32 value);
void dvb_recording_set_ChannelName (DVBRecording* self, const gchar* value);
void dvb_recording_set_Location (DVBRecording* self, GFile* value);
void dvb_utils_create_time (gint year, gint month, gint day, gint hour, gint minute, gint second, struct tm* result);
void dvb_recording_set_StartTime (DVBRecording* self, struct tm* value);
void dvb_recording_set_Length (DVBRecording* self, gint64 value);
void dvb_recording_set_Name (DVBRecording* self, const gchar* value);
void dvb_recording_set_Description (DVBRecording* self, const gchar* value);
static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value);
static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value);
void dvb_io_recording_reader_set_max_recursion (DVBioRecordingReader* self, gint value);
static void dvb_io_recording_reader_finalize (GObject* obj);
static void _vala_dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
         * @recordingsbasedir: The directory to search
         */
DVBioRecordingReader* dvb_io_recording_reader_construct (GType object_type, GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	DVBioRecordingReader * self = NULL;
	GFile* _tmp0_;
	DVBRecordingsStore* _tmp1_;
	g_return_val_if_fail (recordingsbasedir != NULL, NULL);
	g_return_val_if_fail (recstore != NULL, NULL);
	_tmp0_ = recordingsbasedir;
	_tmp1_ = recstore;
	self = (DVBioRecordingReader*) g_object_new (object_type, "directory", _tmp0_, "store", _tmp1_, NULL);
	return self;
}


DVBioRecordingReader* dvb_io_recording_reader_new (GFile* recordingsbasedir, DVBRecordingsStore* recstore) {
	return dvb_io_recording_reader_construct (DVB_IO_TYPE_RECORDING_READER, recordingsbasedir, recstore);
}


/**
         * Searches recursively in the given directory
         * for "info.rec" files, restores a new Recording
         * from that file and adds it to itsself.
         */
gboolean dvb_io_recording_reader_load_into (DVBioRecordingReader* self) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_directory;
	_tmp1_ = g_file_query_exists (_tmp0_, NULL);
	if (!_tmp1_) {
		DVBLoggingLogger* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = dvb_io_recording_reader_log;
		_tmp3_ = self->priv->_directory;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		dvb_logging_logger_debug (_tmp2_, "RecordingReader.vala:52: Directory %s does not exist", _tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->_directory;
	_tmp7_ = dvb_io_recording_reader_restore_from_dir (self, _tmp6_, 0);
	result = _tmp7_;
	return result;
}


static gboolean dvb_io_recording_reader_is_readable_dir (GFile* directory) {
	gboolean result = FALSE;
	GFileInfo* info = NULL;
	GFileInfo* _tmp6_;
	GFileType _tmp7_ = 0;
	GFileInfo* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (directory != NULL, FALSE);
	{
		GFile* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		_tmp0_ = directory;
		_tmp1_ = g_file_query_info (_tmp0_, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_g_object_unref0 (info);
		info = _tmp2_;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = dvb_io_recording_reader_log;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		dvb_logging_logger_error (_tmp3_, "RecordingReader.vala:64: Could not retrieve attributes: %s", _tmp5_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (info);
		return result;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = info;
	_tmp7_ = g_file_info_get_file_type (_tmp6_);
	if (_tmp7_ != G_FILE_TYPE_DIRECTORY) {
		DVBLoggingLogger* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp8_ = dvb_io_recording_reader_log;
		_tmp9_ = directory;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		dvb_logging_logger_error (_tmp8_, "RecordingReader.vala:69: %s is not a directory", _tmp11_);
		_g_free0 (_tmp11_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	_tmp12_ = info;
	_tmp13_ = g_file_info_get_attribute_boolean (_tmp12_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp13_) {
		DVBLoggingLogger* _tmp14_;
		GFile* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp14_ = dvb_io_recording_reader_log;
		_tmp15_ = directory;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		dvb_logging_logger_error (_tmp14_, "RecordingReader.vala:74: Cannot read %s", _tmp17_);
		_g_free0 (_tmp17_);
		result = FALSE;
		_g_object_unref0 (info);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (info);
	return result;
}


static gboolean dvb_io_recording_reader_restore_from_dir (DVBioRecordingReader* self, GFile* recordingsbasedir, gint depth) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFileEnumerator* files = NULL;
	gboolean success;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (recordingsbasedir != NULL, FALSE);
	_tmp0_ = depth;
	_tmp1_ = self->priv->_max_recursion;
	if (_tmp0_ >= _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = recordingsbasedir;
	_tmp3_ = dvb_io_recording_reader_is_readable_dir (_tmp2_);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	{
		GFile* _tmp4_;
		GFileEnumerator* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_;
		_tmp4_ = recordingsbasedir;
		_tmp5_ = g_file_enumerate_children (_tmp4_, DVB_IO_RECORDING_READER_ATTRS, 0, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_g_object_unref0 (files);
		files = _tmp6_;
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = dvb_io_recording_reader_log;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		dvb_logging_logger_error (_tmp7_, "RecordingReader.vala:92: Could not read directory: %s", _tmp9_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (files);
		return result;
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	success = TRUE;
	{
		GFileInfo* childinfo = NULL;
		while (TRUE) {
			GFileEnumerator* _tmp10_;
			GFileInfo* _tmp11_ = NULL;
			GFileInfo* _tmp12_;
			GFileInfo* _tmp13_;
			GFileInfo* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GFileInfo* _tmp16_;
			guint32 _tmp17_ = 0U;
			guint32 type;
			GFile* _tmp18_;
			GFileInfo* _tmp19_;
			const gchar* _tmp20_ = NULL;
			GFile* _tmp21_ = NULL;
			GFile* child;
			guint32 _tmp22_;
			_tmp10_ = files;
			_tmp11_ = g_file_enumerator_next_file (_tmp10_, NULL, &_inner_error_);
			_tmp12_ = _tmp11_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (childinfo);
				goto __catch11_g_error;
			}
			_g_object_unref0 (childinfo);
			childinfo = _tmp12_;
			_tmp13_ = childinfo;
			if (!(_tmp13_ != NULL)) {
				break;
			}
			_tmp14_ = childinfo;
			_tmp15_ = g_file_info_get_is_hidden (_tmp14_);
			if (_tmp15_) {
				continue;
			}
			_tmp16_ = childinfo;
			_tmp17_ = g_file_info_get_attribute_uint32 (_tmp16_, G_FILE_ATTRIBUTE_STANDARD_TYPE);
			type = _tmp17_;
			_tmp18_ = recordingsbasedir;
			_tmp19_ = childinfo;
			_tmp20_ = g_file_info_get_name (_tmp19_);
			_tmp21_ = g_file_get_child (_tmp18_, _tmp20_);
			child = _tmp21_;
			_tmp22_ = type;
			switch (_tmp22_) {
				case G_FILE_TYPE_DIRECTORY:
				{
					GFile* _tmp23_;
					gint _tmp24_;
					_tmp23_ = child;
					_tmp24_ = depth;
					dvb_io_recording_reader_restore_from_dir (self, _tmp23_, _tmp24_ + 1);
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					GFileInfo* _tmp25_;
					const gchar* _tmp26_ = NULL;
					_tmp25_ = childinfo;
					_tmp26_ = g_file_info_get_name (_tmp25_);
					if (g_strcmp0 (_tmp26_, "info.rec") == 0) {
						DVBRecording* rec;
						DVBRecording* _tmp33_;
						rec = NULL;
						{
							GFile* _tmp27_;
							DVBRecording* _tmp28_ = NULL;
							DVBRecording* _tmp29_;
							_tmp27_ = child;
							_tmp28_ = dvb_io_recording_reader_deserialize (self, _tmp27_, &_inner_error_);
							_tmp29_ = _tmp28_;
							if (_inner_error_ != NULL) {
								goto __catch12_g_error;
							}
							_g_object_unref0 (rec);
							rec = _tmp29_;
						}
						goto __finally12;
						__catch12_g_error:
						{
							GError* e = NULL;
							DVBLoggingLogger* _tmp30_;
							GError* _tmp31_;
							const gchar* _tmp32_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp30_ = dvb_io_recording_reader_log;
							_tmp31_ = e;
							_tmp32_ = _tmp31_->message;
							dvb_logging_logger_error (_tmp30_, "RecordingReader.vala:120: Could not deserialize recording: %s", _tmp32_);
							_g_error_free0 (e);
						}
						__finally12:
						if (_inner_error_ != NULL) {
							_g_object_unref0 (rec);
							_g_object_unref0 (child);
							_g_object_unref0 (childinfo);
							goto __catch11_g_error;
						}
						_tmp33_ = rec;
						if (_tmp33_ != NULL) {
							DVBLoggingLogger* _tmp34_;
							GFile* _tmp35_;
							gchar* _tmp36_ = NULL;
							gchar* _tmp37_;
							DVBRecordingsStore* _tmp38_;
							DVBRecording* _tmp39_;
							_tmp34_ = dvb_io_recording_reader_log;
							_tmp35_ = child;
							_tmp36_ = g_file_get_path (_tmp35_);
							_tmp37_ = _tmp36_;
							dvb_logging_logger_debug (_tmp34_, "RecordingReader.vala:125: Restored recording from %s", _tmp37_);
							_g_free0 (_tmp37_);
							_tmp38_ = self->priv->_store;
							_tmp39_ = rec;
							dvb_recordings_store_add_and_monitor (_tmp38_, _tmp39_);
						}
						_g_object_unref0 (rec);
					}
					break;
				}
				default:
				break;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (childinfo);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp40_;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp40_ = dvb_io_recording_reader_log;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		dvb_logging_logger_error (_tmp40_, "RecordingReader.vala:136: %s", _tmp42_);
		success = FALSE;
		_g_error_free0 (e);
	}
	__finally11:
	{
		{
			GFileEnumerator* _tmp43_;
			_tmp43_ = files;
			g_file_enumerator_close (_tmp43_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp44_;
			GError* _tmp45_;
			const gchar* _tmp46_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp44_ = dvb_io_recording_reader_log;
			_tmp45_ = e;
			_tmp46_ = _tmp45_->message;
			dvb_logging_logger_error (_tmp44_, "RecordingReader.vala:142: Could not close file: %s", _tmp46_);
			success = FALSE;
			_g_error_free0 (e);
		}
		__finally13:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (files);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_inner_error_ != NULL) {
		_g_object_unref0 (files);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = success;
	_g_object_unref0 (files);
	return result;
}


DVBRecording* dvb_io_recording_reader_deserialize (DVBioRecordingReader* self, GFile* file, GError** error) {
	DVBRecording* result = NULL;
	GFile* _tmp0_;
	GFileInputStream* _tmp1_ = NULL;
	GFileInputStream* _tmp2_;
	GFileInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	GDataInputStream* _tmp5_;
	GDataInputStream* reader;
	gchar* line;
	gsize len = 0UL;
	gint line_number;
	DVBRecording* _tmp6_;
	DVBRecording* rec;
	GString* _tmp7_;
	GString* description;
	GDataInputStream* _tmp57_;
	DVBRecording* _tmp58_;
	GString* _tmp59_;
	const gchar* _tmp60_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_read (_tmp0_, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp2_;
	_tmp4_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	reader = _tmp5_;
	line = NULL;
	line_number = 0;
	_tmp6_ = dvb_recording_new ();
	rec = _tmp6_;
	_tmp7_ = g_string_new ("");
	description = _tmp7_;
	while (TRUE) {
		GDataInputStream* _tmp8_;
		gsize _tmp9_ = 0UL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp56_;
		_tmp8_ = reader;
		_tmp10_ = g_data_input_stream_read_line (_tmp8_, &_tmp9_, NULL, &_inner_error_);
		len = _tmp9_;
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (description);
			_g_object_unref0 (rec);
			_g_free0 (line);
			_g_object_unref0 (reader);
			return NULL;
		}
		_g_free0 (line);
		line = _tmp11_;
		_tmp12_ = line;
		if (!(_tmp12_ != NULL)) {
			break;
		}
		_tmp13_ = line_number;
		switch (_tmp13_) {
			case 0:
			{
				DVBRecording* _tmp14_;
				const gchar* _tmp15_;
				gint _tmp16_ = 0;
				_tmp14_ = rec;
				_tmp15_ = line;
				_tmp16_ = atoi (_tmp15_);
				dvb_recording_set_Id (_tmp14_, (guint32) _tmp16_);
				break;
			}
			case 1:
			{
				DVBRecording* _tmp17_;
				const gchar* _tmp18_;
				_tmp17_ = rec;
				_tmp18_ = line;
				dvb_recording_set_ChannelName (_tmp17_, _tmp18_);
				break;
			}
			case 2:
			{
				GFile* _tmp19_ = NULL;
				gsize _tmp20_;
				DVBRecording* _tmp23_;
				GFile* _tmp24_;
				_tmp20_ = len;
				if (_tmp20_ == ((gsize) 0)) {
					_g_object_unref0 (_tmp19_);
					_tmp19_ = NULL;
				} else {
					const gchar* _tmp21_;
					GFile* _tmp22_ = NULL;
					_tmp21_ = line;
					_tmp22_ = g_file_new_for_path (_tmp21_);
					_g_object_unref0 (_tmp19_);
					_tmp19_ = _tmp22_;
				}
				_tmp23_ = rec;
				_tmp24_ = _tmp19_;
				dvb_recording_set_Location (_tmp23_, _tmp24_);
				_g_object_unref0 (_tmp19_);
				break;
			}
			case 3:
			{
				{
					gint year;
					gint month;
					gint day;
					gint hour;
					gint minute;
					const gchar* _tmp25_;
					gboolean _tmp26_ = FALSE;
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_ = FALSE;
					gboolean _tmp29_ = FALSE;
					gint _tmp30_;
					gboolean _tmp32_;
					gboolean _tmp34_;
					gboolean _tmp36_;
					gboolean _tmp38_;
					year = 0;
					month = 0;
					day = 0;
					hour = 0;
					minute = 0;
					_tmp25_ = line;
					sscanf (_tmp25_, "%d-%d-%d %d:%d", &year, &month, &day, &hour, &minute);
					_tmp30_ = year;
					if (_tmp30_ >= 1900) {
						gint _tmp31_;
						_tmp31_ = month;
						_tmp29_ = _tmp31_ >= 1;
					} else {
						_tmp29_ = FALSE;
					}
					_tmp32_ = _tmp29_;
					if (_tmp32_) {
						gint _tmp33_;
						_tmp33_ = day;
						_tmp28_ = _tmp33_ >= 1;
					} else {
						_tmp28_ = FALSE;
					}
					_tmp34_ = _tmp28_;
					if (_tmp34_) {
						gint _tmp35_;
						_tmp35_ = hour;
						_tmp27_ = _tmp35_ >= 0;
					} else {
						_tmp27_ = FALSE;
					}
					_tmp36_ = _tmp27_;
					if (_tmp36_) {
						gint _tmp37_;
						_tmp37_ = minute;
						_tmp26_ = _tmp37_ >= 0;
					} else {
						_tmp26_ = FALSE;
					}
					_tmp38_ = _tmp26_;
					if (_tmp38_) {
						DVBRecording* _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						gint _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						struct tm _tmp45_ = {0};
						_tmp39_ = rec;
						_tmp40_ = year;
						_tmp41_ = month;
						_tmp42_ = day;
						_tmp43_ = hour;
						_tmp44_ = minute;
						dvb_utils_create_time (_tmp40_, _tmp41_, _tmp42_, _tmp43_, _tmp44_, 0, &_tmp45_);
						dvb_recording_set_StartTime (_tmp39_, &_tmp45_);
					}
					break;
				}
			}
			case 4:
			{
				DVBRecording* _tmp46_;
				const gchar* _tmp47_;
				gint _tmp48_ = 0;
				_tmp46_ = rec;
				_tmp47_ = line;
				_tmp48_ = atoi (_tmp47_);
				dvb_recording_set_Length (_tmp46_, (gint64) _tmp48_);
				break;
			}
			case 5:
			{
				const gchar* _tmp49_ = NULL;
				gsize _tmp50_;
				DVBRecording* _tmp52_;
				const gchar* _tmp53_;
				_tmp50_ = len;
				if (_tmp50_ == ((gsize) 0)) {
					_tmp49_ = NULL;
				} else {
					const gchar* _tmp51_;
					_tmp51_ = line;
					_tmp49_ = _tmp51_;
				}
				_tmp52_ = rec;
				_tmp53_ = _tmp49_;
				dvb_recording_set_Name (_tmp52_, _tmp53_);
				break;
			}
			default:
			{
				GString* _tmp54_;
				const gchar* _tmp55_;
				_tmp54_ = description;
				_tmp55_ = line;
				g_string_append (_tmp54_, _tmp55_);
				break;
			}
		}
		_tmp56_ = line_number;
		line_number = _tmp56_ + 1;
	}
	_tmp57_ = reader;
	g_input_stream_close ((GInputStream*) _tmp57_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_string_free0 (description);
		_g_object_unref0 (rec);
		_g_free0 (line);
		_g_object_unref0 (reader);
		return NULL;
	}
	_tmp58_ = rec;
	_tmp59_ = description;
	_tmp60_ = _tmp59_->str;
	dvb_recording_set_Description (_tmp58_, _tmp60_);
	result = rec;
	_g_string_free0 (description);
	_g_free0 (line);
	_g_object_unref0 (reader);
	return result;
}


GFile* dvb_io_recording_reader_get_directory (DVBioRecordingReader* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_recording_reader_set_directory (DVBioRecordingReader* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_directory);
	self->priv->_directory = _tmp1_;
	g_object_notify ((GObject *) self, "directory");
}


DVBRecordingsStore* dvb_io_recording_reader_get_store (DVBioRecordingReader* self) {
	DVBRecordingsStore* result;
	DVBRecordingsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}


static void dvb_io_recording_reader_set_store (DVBioRecordingReader* self, DVBRecordingsStore* value) {
	DVBRecordingsStore* _tmp0_;
	DVBRecordingsStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp1_;
	g_object_notify ((GObject *) self, "store");
}


gint dvb_io_recording_reader_get_max_recursion (DVBioRecordingReader* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_max_recursion;
	result = _tmp0_;
	return result;
}


void dvb_io_recording_reader_set_max_recursion (DVBioRecordingReader* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_max_recursion = _tmp0_;
	g_object_notify ((GObject *) self, "max-recursion");
}


static void dvb_io_recording_reader_class_init (DVBioRecordingReaderClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_io_recording_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioRecordingReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_recording_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_recording_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_recording_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_DIRECTORY, g_param_spec_object ("directory", "directory", "directory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_STORE, g_param_spec_object ("store", "store", "store", DVB_TYPE_RECORDINGS_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_READER_MAX_RECURSION, g_param_spec_int ("max-recursion", "max-recursion", "max-recursion", G_MININT, G_MAXINT, 3, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_io_recording_reader_log = _tmp1_;
}


static void dvb_io_recording_reader_instance_init (DVBioRecordingReader * self) {
	self->priv = DVB_IO_RECORDING_READER_GET_PRIVATE (self);
	self->priv->_max_recursion = 3;
}


static void dvb_io_recording_reader_finalize (GObject* obj) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (obj);
	_g_object_unref0 (self->priv->_directory);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (dvb_io_recording_reader_parent_class)->finalize (obj);
}


GType dvb_io_recording_reader_get_type (void) {
	static volatile gsize dvb_io_recording_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_recording_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioRecordingReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_recording_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioRecordingReader), 0, (GInstanceInitFunc) dvb_io_recording_reader_instance_init, NULL };
		GType dvb_io_recording_reader_type_id;
		dvb_io_recording_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioRecordingReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_recording_reader_type_id__volatile, dvb_io_recording_reader_type_id);
	}
	return dvb_io_recording_reader_type_id__volatile;
}


static void _vala_dvb_io_recording_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		g_value_set_object (value, dvb_io_recording_reader_get_directory (self));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		g_value_set_object (value, dvb_io_recording_reader_get_store (self));
		break;
		case DVB_IO_RECORDING_READER_MAX_RECURSION:
		g_value_set_int (value, dvb_io_recording_reader_get_max_recursion (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_recording_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioRecordingReader * self;
	self = DVB_IO_RECORDING_READER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_READER_DIRECTORY:
		dvb_io_recording_reader_set_directory (self, g_value_get_object (value));
		break;
		case DVB_IO_RECORDING_READER_STORE:
		dvb_io_recording_reader_set_store (self, g_value_get_object (value));
		break;
		case DVB_IO_RECORDING_READER_MAX_RECURSION:
		dvb_io_recording_reader_set_max_recursion (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



