/*
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 */

/*
 * ensure this is a once-only header.
 */
#ifndef __GNOME_GMAIL_NOTIFIER_ATOM_FEED_H__
#define __GNOME_GMAIL_NOTIFIER_ATOM_FEED_H__

/*
 * our header is just beginning.
 */
G_BEGIN_DECLS

/*
 * xpath-ish definitions for parsing.
 */
#define GGN_ATOM_XPATH_ENTRY                "/feed/entry"
#define GGN_ATOM_XPATH_LINK                 "/feed/link"
#define GGN_ATOM_XPATH_COUNT                "/feed/fullcount/text"
#define GGN_ATOM_XPATH_MODIFIED             "/feed/modified/text"
#define GGN_ATOM_XPATH_ENTRY_LINK           "/feed/entry/link"
#define GGN_ATOM_XPATH_ENTRY_TITLE          "/feed/entry/title/text"
#define GGN_ATOM_XPATH_ENTRY_SUMMARY        "/feed/entry/summary/text"
#define GGN_ATOM_XPATH_ENTRY_MODIFIED       "/feed/entry/modified/text"
#define GGN_ATOM_XPATH_ENTRY_ISSUED         "/feed/entry/issued/text"
#define GGN_ATOM_XPATH_ENTRY_ID             "/feed/entry/id/text"
#define GGN_ATOM_XPATH_AUTHOR_NAME          "/feed/entry/author/name/text"
#define GGN_ATOM_XPATH_AUTHOR_EMAIL         "/feed/entry/author/email/text"

/*
 * constants for the GMail service.
 */
#define GGN_ATOM_FEED_GET           "GET"
#define GGN_ATOM_FEED_URL           "https://mail.google.com/mail/feed/atom"
#define GGN_ATOM_FEED_INBOX_URL     "http://mail.google.com/mail/"

/*
 * constants used for gnome-keyring lookups.
 */
#define GGN_ATOM_FEED_SERVER        "mail.google.com"
#define GGN_ATOM_FEED_OBJECT        "mail/feed/atom"
#define GGN_ATOM_FEED_PROTOCOL      "https"

/*
 * object function macros.
 */
#define GGN_TYPE_ATOM_FEED (ggn_atom_feed_get_type ())
#define GGN_ATOM_FEED(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GGN_TYPE_ATOM_FEED, GgnAtomFeed))
#define GGN_ATOM_FEED_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GGN_TYPE_ATOM_FEED, GgnAtomFeedClass))
#define GGN_IS_ATOM_FEED(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GGN_TYPE_ATOM_FEED))
#define GGN_IS_ATOM_FEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GGN_TYPE_ATOM_FEED))
#define GGN_ATOM_FEED_GET_CLASS(obj)  (G_TYPE_CHECK_CLASS_CAST ((obj), GGN_TYPE_ATOM_FEED, GgnAtomFeedClass))

/*
 * type macros.
 */
typedef struct _GgnAtomFeed GgnAtomFeed;
typedef struct _GgnAtomFeedClass GgnAtomFeedClass;
typedef struct _GgnAtomFeedPrivate GgnAtomFeedPrivate;

/*
 * object definition.
 */
struct _GgnAtomFeed {
    /* parent gobject class. */
    GObject parent_object;
    
    /* private instance members. */
    GgnAtomFeedPrivate* priv;
};

/*
 * class definition.
 */
struct _GgnAtomFeedClass {
    /* parent gobject class. */
    GObjectClass parent;
    
    /* the "updated" signal. */
    void (*updated) (GgnAtomFeed* feed, gboolean success);
};

/*
 * gobject-type definition.
 */
GType ggn_atom_feed_get_type (void);

/*
 * object creation functions.
 */
GgnAtomFeed* ggn_atom_feed_new (void);
void ggn_atom_feed_free (GgnAtomFeed* feed);

/*
 * parameter-setting functions.
 */
void ggn_atom_feed_set_name (GgnAtomFeed* feed, gchar* value);
void ggn_atom_feed_set_username (GgnAtomFeed* feed, gchar* value);
void ggn_atom_feed_set_password (GgnAtomFeed* feed, gchar* value);
void ggn_atom_feed_set_proxy (GgnAtomFeed* feed, gchar* value);
void ggn_atom_feed_set_enabled (GgnAtomFeed* feed, gboolean value);
void ggn_atom_feed_set_checked (GgnAtomFeed* feed, gboolean value);
void ggn_atom_feed_set_error (GgnAtomFeed* feed, gboolean value);

/*
 * parameter-getting functions.
 */
gchar* ggn_atom_feed_get_name (GgnAtomFeed* feed);
gchar* ggn_atom_feed_get_username (GgnAtomFeed* feed);
gchar* ggn_atom_feed_get_password (GgnAtomFeed* feed);
gchar* ggn_atom_feed_get_proxy (GgnAtomFeed* feed);
gboolean ggn_atom_feed_get_enabled (GgnAtomFeed* feed);
gboolean ggn_atom_feed_get_checked (GgnAtomFeed* feed);
gboolean ggn_atom_feed_get_error (GgnAtomFeed* feed);

/*
 * the update function.
 */
void ggn_atom_feed_update (GgnAtomFeed* feed);

/*
 * information-getting functions.
 */
gint ggn_atom_feed_get_count (GgnAtomFeed* feed);
gchar* ggn_atom_feed_get_modified (GgnAtomFeed* feed);
gchar* ggn_atom_feed_get_url (GgnAtomFeed* feed);
gchar* ggn_atom_feed_get_summary (GgnAtomFeed* feed, gint num);
gchar* ggn_atom_feed_get_title (GgnAtomFeed* feed, gint num);
gchar* ggn_atom_feed_get_sender_name (GgnAtomFeed* feed, gint num);
gchar* ggn_atom_feed_get_sender_email (GgnAtomFeed* feed, gint num);
gchar* ggn_atom_feed_get_msgmodified (GgnAtomFeed* feed, gint num);
gchar* ggn_atom_feed_get_issued (GgnAtomFeed* feed, gint num);
gchar* ggn_atom_feed_get_msgurl (GgnAtomFeed* feed, gint num);
gchar* ggn_atom_feed_get_msgid (GgnAtomFeed* feed, gint num);

/*
 * our header is at its end.
 */
G_END_DECLS

#endif /* __GNOME_GMAIL_NOTIFIER_ATOM_FEED_H__ */

