/*
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 */

/*
 * ensure this is a once-only header.
 */
#ifndef __GNOME_GMAIL_NOTIFIER_XML_PARSER_H__
#define __GNOME_GMAIL_NOTIFIER_XML_PARSER_H__

/*
 * our header is just beginning.
 */
G_BEGIN_DECLS

/*
 * object function macros.
 */
#define GGN_TYPE_XML_PARSER (ggn_xml_parser_get_type ())
#define GGN_XML_PARSER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GGN_TYPE_XML_PARSER, GgnXmlParser))
#define GGN_XML_PARSER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GGN_TYPE_XML_PARSER, GgnXmlParserClass))
#define GGN_IS_XML_PARSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GGN_TYPE_XML_PARSER))
#define GGN_IS_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GGN_TYPE_XML_PARSER))
#define GGN_XML_PARSER_GET_CLASS(obj)  (G_TYPE_CHECK_CLASS_CAST ((obj), GGN_TYPE_XML_PARSER, GgnXmlParserClass))

/*
 * type macros.
 */
typedef struct _GgnXmlParser GgnXmlParser;
typedef struct _GgnXmlParserClass GgnXmlParserClass;
typedef struct _GgnXmlParserPrivate GgnXmlParserPrivate;

/*
 * object definition.
 */
struct _GgnXmlParser {
    /* parent gobject class. */
    GObject parent_object;
    
    /* private instance members. */
    GgnXmlParserPrivate* priv;
};

/*
 * class definition.
 */
struct _GgnXmlParserClass {
    /* parent gobject class. */
    GObjectClass parent;
    
    /* "begin_element": called on opened tags. */
    void (*begin_element) (GgnXmlParser* parser,
                           gchar* element_path,
                           gchar* element_name,
                           GHashTable* attributes);
    
    /* "end_element": called on closed tags. */
    void (*end_element) (GgnXmlParser* parser,
                         gchar* element_path,
                         gchar* element_name);
    
    /* "text": called on text content. */
    void (*text) (GgnXmlParser* parser,
                  gchar* element_path,
                  gchar* element_name,
                  gchar* value);
};

/*
 * gobject-type definition.
 */
GType ggn_xml_parser_get_type (void);

/*
 * object creation functions.
 */
GgnXmlParser* ggn_xml_parser_new (void);
void ggn_xml_parser_free (GgnXmlParser* parser);

/*
 * functions to parse various forms of text.
 */
gboolean ggn_xml_parser_load_string (GgnXmlParser* parser, gchar* xml_str);
gboolean ggn_xml_parser_load_file (GgnXmlParser* parser, gchar* xml_file);

/*
 * our header is at its end.
 */
G_END_DECLS

#endif /* __GNOME_GMAIL_NOTIFIER_XML_PARSER_H__ */

