/*
 * gnome-gmail-notifier: the gnome gmail notifier.
 * Copyright (C) 2007 Bradley A. Worley.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * 
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
 */

/*
 * include our application header.
 */
#include "main.h"

/*
 * main:
 *
 * This function acts as the application's entry point,
 * starting the basic GTK/GThread/GObject framework
 * before punting to a newly created GgnManager.
 *
 * Return value: application exit status.
 */
int main (int argc, char** argv) {
#ifdef ENABLE_NLS
    /* setup gettext before anything else. */
    bindtextdomain (GETTEXT_PACKAGE, GGN_LOCALEDIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, GGN_UTIL_ENCODING);
    textdomain (GETTEXT_PACKAGE);
#endif /* ENABLE_NLS */
    
    /* start glib threads. */
    if (!g_thread_supported ()) {
        /* start it up! */
        g_thread_init (NULL);
    }
    
    /* start gdk threads. */
    gdk_threads_init ();
    
    /* lock and start gtk. */
    gtk_init (&argc, &argv);
    
    /* start gstreamer. */
    gst_init (&argc, &argv);
    
    /* create a manager object. */
    GgnManager* manager = ggn_manager_new ();
    
    /* punt control to the manager. */
    ggn_manager_main (manager);
    
    /* begin the main loop. */
    gtk_main ();
    
    /* exit the application. */
    return 0;
}
