using System;
using GnomeKeyring;
using Gtk;

public class MainClass {
	static void myCallback(Result result, GLib.List list) {
		GLib.List newlist = new GLib.List(list.Handle, typeof(Found));
		Console.WriteLine("Called back with " + newlist.Count + " results");
		for (int i = 0; i < newlist.Count; i++) {
			Found founditem = (Found)(newlist[i]);
			Console.WriteLine(founditem.Attributes.Length);
			foreach (GnomeKeyring.Attribute attrib in founditem.Attributes) {
				Console.WriteLine("(" + attrib.Type + ") " + attrib.Name + " : " + attrib.Value);
			}
			Console.WriteLine();
		};
		Application.Quit();
	}

	public static void Main (string[] args) {
		Application.Init();
		RequestKeys();
		Application.Run();
	}
	
	static void RequestKeys() {
		OperationGetListCallback theCallback = new OperationGetListCallback(myCallback);
		GnomeKeyring.Attribute[] attributes = new GnomeKeyring.Attribute[1];
		attributes[0] = new GnomeKeyring.Attribute();
		attributes[0].Name = "user";
		attributes[0].Type = AttributeType.String;
		attributes[0].Value = "gnome-keyring-user";
		GnomeKeyring.Global.FindItems(ItemType.NetworkPassword,
		 attributes,
		 theCallback
		);
	}
}
