/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2005 Imendio AB
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <string.h>
#include <glib/gi18n.h>
#include <gtk/gtkmain.h>
#include <libgnomevfs/gnome-vfs-init.h>

#include "bacon-message-connection.h"
#include "lb-window.h"
#include "lb-module-manager.h"

#define COMMAND_SHOW_WINDOW "ShowWindow"

static LbModuleManager *manager = NULL;

static gboolean no_window = FALSE;
static gboolean transparent = FALSE;

static GOptionEntry cmd_args[] = {

	{ "no-default-window", 'n', 0, G_OPTION_ARG_NONE,
	  &no_window, "Do not show the initial window", NULL},
	{ "transparent", 't', 0, G_OPTION_ARG_NONE,
	  &transparent, "Be fancy", NULL}
};

static void
show_window (void)
{
	static GtkWidget *window = NULL;

	if (!manager) {
		manager = g_object_new (LB_TYPE_MODULE_MANAGER,	NULL);
		
		window = lb_window_new (manager, transparent);
		gtk_window_set_default_size (GTK_WINDOW (window), 300, -1);
	}

	lb_window_present (LB_WINDOW (window));
}

static void
message_received_cb (const gchar *message, gpointer unused)
{
	if (strcmp (message, COMMAND_SHOW_WINDOW) != 0) {
		return;
	}

	show_window ();
}

int
main (int argc, char **argv)
{
	BaconMessageConnection *message_conn;
	GError                 *error = NULL;

	bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
        bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	
	message_conn = bacon_message_connection_new ("gnome-launch-box");
	if (!bacon_message_connection_get_is_server (message_conn)) {
		bacon_message_connection_send (message_conn, 
					       COMMAND_SHOW_WINDOW);
		return 0;
	}

	bacon_message_connection_set_callback (
		message_conn,
		(BaconMessageReceivedFunc) message_received_cb,
		NULL);
	
       	gnome_vfs_init ();

	if (!gtk_init_with_args (&argc,
				 &argv,
				 "- launch program for GNOME",
				 cmd_args,
				 GETTEXT_PACKAGE,
				 &error)) {
		g_printerr ("Error initializing: %s\n", error->message);
		g_error_free (error);
		return -1;
	}

	if (!no_window) {
		show_window ();
	}

	gtk_main ();

	if (manager) {
		g_object_unref (manager);
	}
	
	return 0;
}
